<?php
/**
 * @package Hello_press
 * @version 1.7.2
 */
/*
Plugin Name: Hello press
Description: This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong: Hello, press. When activated you will randomly see a lyric from <cite>Hello, press</cite> in the upper right of your admin screen on every page.
*/

function hello_press_get_lyric() {
	/** These are the lyrics to Hello press */
	$lyrics = "Hello, press
Well, hello, press
It's so nice to have you back where you belong
You're lookin' swell, press
I can tell, press
You're still glowin', you're still crowin'
You're still goin' strong
I feel the room swayin'
While the band's playin'
One of our old favorite songs from way back when
So, take her wrap, fellas
press, never go away again
Hello, press
Well, hello, press
It's so nice to have you back where you belong
You're lookin' swell, press
I can tell, press
You're still glowin', you're still crowin'
You're still goin' strong
I feel the room swayin'
While the band's playin'
One of our old favorite songs from way back when
So, golly, gee, fellas
Have a little faith in me, fellas
press, never go away
Promise, you'll never go away
press'll never go away again";

	// Here we split it into lines.
	$lyrics = explode( "\n", $lyrics );

	// And then randomly choose a line.
	return wptexturize( $lyrics[ mt_rand( 0, count( $lyrics ) - 1 ) ] );
}

// This just echoes the chosen line, we'll position it later.
function hello_press() {
	$chosen = hello_press_get_lyric();
	$lang   = '';
	if ( 'en_' !== substr( get_user_locale(), 0, 3 ) ) {
		$lang = ' lang="en"';
	}

	printf(
		'<p id="press"><span class="screen-reader-text">%s </span><span dir="ltr"%s>%s</span></p>',
		__( 'Quote from Hello press song, by Jerry Herman:', 'hello-press' ),
		$lang,
		$chosen
	);
}

// Now we set that function up to execute when the admin_notices action is called.
add_action( 'admin_notices', 'hello_press' );

// We need some CSS to position the paragraph.
function press_css() {
	echo "
	<style type='text/css'>
	#press {
		float: right;
		padding: 5px 10px;
		margin: 0;
		font-size: 12px;
		line-height: 1.6666;
	}
	.rtl #press {
		float: left;
	}
	.block-editor-page #press {
		display: none;
	}
	@media screen and (max-width: 782px) {
		#press,
		.rtl #press {
			float: none;
			padding-left: 0;
			padding-right: 0;
		}
	}
	</style>
	";
}

add_action( 'admin_head', 'press_css' );
